/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.connectionhandler.InternalCookie;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CookieList {
    private Hashtable existingCookies = new Hashtable();
    private long time = System.currentTimeMillis() / 1000L;
    private String encodedValue = "";
    private boolean hasBeenModified = false;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$connectionhandler$CookieList == null ? (class$com$sun$portal$rproxy$connectionhandler$CookieList = CookieList.class$("com.sun.portal.rproxy.connectionhandler.CookieList")) : class$com$sun$portal$rproxy$connectionhandler$CookieList));
    static /* synthetic */ Class class$com$sun$portal$rproxy$connectionhandler$CookieList;

    public CookieList() {
    }

    public CookieList(String encodedCookieList) {
        this();
        Object[] params0 = new Object[]{encodedCookieList};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR013", params0);
        this.encodedValue = encodedCookieList;
        StringTokenizer st = new StringTokenizer(encodedCookieList, "|");
        while (st.hasMoreTokens()) {
            String cookie = st.nextToken();
            Object[] params1 = new Object[]{cookie};
            logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR014", params1);
            InternalCookie internalCookie = new InternalCookie(cookie);
            if (internalCookie.shouldRemove()) {
                this.hasBeenModified = true;
                this.encodedValue = null;
                continue;
            }
            this.existingCookies.put(internalCookie.getName(), internalCookie);
        }
    }

    public void processCookie(String cookie, String host) {
        InternalCookie intCookie = new InternalCookie(cookie, host, this.time);
        String name = intCookie.getName();
        InternalCookie tableValue = (InternalCookie)this.existingCookies.get(name);
        if (tableValue == null) {
            if (intCookie.shouldRemove()) {
                return;
            }
        } else if (intCookie.shouldRemove()) {
            this.existingCookies.remove(name);
            this.hasBeenModified = true;
            this.encodedValue = null;
            return;
        }
        this.hasBeenModified = true;
        this.encodedValue = null;
        this.existingCookies.put(name, intCookie);
    }

    public boolean isModified() {
        return this.hasBeenModified;
    }

    public int length() {
        return this.existingCookies.size();
    }

    public Enumeration enumerate() {
        return this.existingCookies.elements();
    }

    public String getEncodedValue() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        Set keys = this.existingCookies.keySet();
        Iterator iter = keys.iterator();
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        while (iter.hasNext()) {
            String name = iter.next().toString();
            InternalCookie intCookie = (InternalCookie)this.existingCookies.get(name);
            if (isFirst) {
                sb.append(intCookie.getEncodedValue());
                isFirst = false;
                continue;
            }
            sb.append(" | ").append(intCookie.getEncodedValue());
        }
        this.encodedValue = sb.toString();
        Object[] params2 = new Object[]{this.encodedValue};
        logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR015", params2);
        return this.encodedValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

