/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CachedSocketFactory {
    private static final String BLOCKED_SOCKET_TIMEOUT = "BlockedSocketTimeout";
    private static final int DEFAULT_SOCKET_TIMEOUT = 200;
    public static int _timeout;
    private static Logger logger;
    static /* synthetic */ Class class$com$sun$portal$rproxy$connectionhandler$CachedSocketFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CachedSocket createSocket(String host, int port, String socketType, Integer logId) {
        CachedSocket cachedSocket;
        block17: {
            Socket socket;
            block16: {
                cachedSocket = null;
                socket = null;
                Object[] params0 = new Object[]{host, ":", port + ""};
                logger.log(Level.INFO, "PSSRRPROXY_CSPRCONHNDLR009", params0);
                try {
                    socket = new Socket(host, port);
                    MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_CREATED);
                }
                catch (Exception se) {
                    Object[] params1 = new Object[]{host, ":", port + "", se};
                    logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR010", params1);
                    String retryTimes = SystemProperties.get("gateway.sockretries");
                    if (retryTimes == null) {
                        return null;
                    }
                    int retries = Integer.parseInt(retryTimes);
                    for (int i = 1; i <= retries; ++i) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        try {
                            logger.warning("CachedSocketFactory: Open new socket; retry #" + i);
                            socket = new Socket(host, port);
                            MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_CREATED);
                            if (socket == null) continue;
                            break;
                        }
                        catch (Exception rse) {
                            Object[] params2 = new Object[]{host, ":", port + "", rse};
                            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR011", params2);
                        }
                    }
                    if (socket != null) break block16;
                    return null;
                }
            }
            if (GWLogManager.loggingEnabled) {
                GWLogManager.write("RProxy", GWLocale.getPFString("csf1", new Object[]{logId, host, new Integer(socket.getPort())}));
            }
            try {
                socket.setSoTimeout(_timeout);
                socket.setTcpNoDelay(true);
                cachedSocket = new CachedSocket(socket);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR012", e);
                if (socket == null) break block17;
                try {
                    socket.close();
                    MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
                }
                catch (IOException e1) {
                }
                finally {
                    socket = null;
                }
            }
        }
        return cachedSocket;
    }

    public static CachedSocket getCachedSocket(String host, int port, String socketType, Integer logId) {
        return CachedSocketFactory.createSocket(host, port, socketType, logId);
    }

    public static CachedSocket getNewCachedSocket(String host, int port, String socketType, Integer logId) {
        return CachedSocketFactory.createSocket(host, port, socketType, logId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$connectionhandler$CachedSocketFactory == null ? (class$com$sun$portal$rproxy$connectionhandler$CachedSocketFactory = CachedSocketFactory.class$("com.sun.portal.rproxy.connectionhandler.CachedSocketFactory")) : class$com$sun$portal$rproxy$connectionhandler$CachedSocketFactory));
        _timeout = GatewayProfile.getInt(BLOCKED_SOCKET_TIMEOUT, 200) * 1000;
    }
}

