/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.ServerCertApprovalCallback;
import com.sun.portal.util.SystemProperties;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;

public class CachedSSLSocketFactory {
    private static final String BLOCKED_SOCKET_TIMEOUT = "BlockedSocketTimeout";
    private static final int DEFAULT_SOCKET_TIMEOUT = 200;
    private static int _timeout;
    private static Logger logger;
    static /* synthetic */ Class class$com$sun$portal$rproxy$connectionhandler$CachedSSLSocketFactory;

    public static CachedSocket createSocket(String host, int port, String socketType, Integer logId, ServerCertApprovalCallback approvalCB) {
        SSLSocket sslSocket;
        CachedSocket cachedSocket;
        block11: {
            cachedSocket = null;
            sslSocket = null;
            try {
                sslSocket = approvalCB == null ? new SSLSocket(host, port) : new SSLSocket(InetAddress.getByName(host), port, null, 0, (SSLCertificateApprovalCallback)approvalCB, null);
            }
            catch (Exception se) {
                Object[] params0 = new Object[]{host, ":", port + "", se};
                logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR006", params0);
                String retryTimes = SystemProperties.get("gateway.sockretries");
                if (retryTimes == null) {
                    return null;
                }
                int retries = Integer.parseInt(retryTimes);
                for (int i = 1; i <= retries; ++i) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    try {
                        logger.warning("CachedSSLSocketFactory: Open new socket; retry #" + i);
                        sslSocket = approvalCB == null ? new SSLSocket(host, port) : new SSLSocket(InetAddress.getByName(host), port, null, 0, (SSLCertificateApprovalCallback)approvalCB, null);
                        if (sslSocket == null) continue;
                        break;
                    }
                    catch (Exception rse) {
                        Object[] params1 = new Object[]{host, ":", port + "", rse};
                        logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR007", params1);
                    }
                }
                if (sslSocket != null) break block11;
                return null;
            }
        }
        if (GWLogManager.loggingEnabled) {
            GWLogManager.write("RProxy", GWLocale.getPFString("csslsf1", new Object[]{logId, host, new Integer(sslSocket.getPort())}));
        }
        try {
            sslSocket.setUseClientMode(true);
            sslSocket.setSoTimeout(_timeout);
            sslSocket.enableSSL2(true);
            sslSocket.enableSSL3(true);
            cachedSocket = new CachedSocket((Socket)sslSocket);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSRRPROXY_CSPRCONHNDLR008", e);
        }
        return cachedSocket;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$connectionhandler$CachedSSLSocketFactory == null ? (class$com$sun$portal$rproxy$connectionhandler$CachedSSLSocketFactory = CachedSSLSocketFactory.class$("com.sun.portal.rproxy.connectionhandler.CachedSSLSocketFactory")) : class$com$sun$portal$rproxy$connectionhandler$CachedSSLSocketFactory));
        _timeout = GatewayProfile.getInt(BLOCKED_SOCKET_TIMEOUT, 200) * 1000;
    }
}

