/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.HostAvailabilityEvent;
import com.sun.portal.util.HostAvailabilityListener;
import com.sun.portal.util.HostChecker;
import com.sun.portal.util.ServiceConstants;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HostChooser
extends HostAvailabilityListener
implements ServiceConstants {
    private static List GATEWAY_DSAME_AGENTS = new ArrayList();
    private static String SERVLET_URL = "";
    private String path = null;
    private List portalServers = null;
    private Iterator roundRobin = null;
    private static int orginalSize = 0;
    private Map unavailableServers = new HashMap();
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$rproxy$configservlet$client$HostChooser == null ? (class$com$sun$portal$rproxy$configservlet$client$HostChooser = HostChooser.class$("com.sun.portal.rproxy.configservlet.client.HostChooser")) : class$com$sun$portal$rproxy$configservlet$client$HostChooser));
    static /* synthetic */ Class class$com$sun$portal$rproxy$configservlet$client$HostChooser;

    public HostChooser() {
        String dsameAgents = SystemProperties.get("gateway.dsame.agent");
        StringTokenizer tokenizer = new StringTokenizer(dsameAgents, ",");
        while (tokenizer.hasMoreElements()) {
            String agent = (String)tokenizer.nextElement();
            GATEWAY_DSAME_AGENTS.add(agent);
            try {
                URL url = new URL(agent);
                if (!this.isAvailable(url)) continue;
                this.path = url.getPath();
                SERVLET_URL = agent;
                this.addHostAvailabilityListener(this);
            }
            catch (MalformedURLException me) {
                logger.severe("PSSRRPROXY_CSPRCSERVLETC003");
            }
        }
    }

    private boolean isAvailable(URL url) {
        boolean ret = false;
        try {
            url.openConnection().connect();
            ret = true;
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Url " + url + " is not available.");
        }
        return ret;
    }

    private synchronized void initialize() {
        Iterator itr = GatewayProfile.getStringList("PortalServerList").iterator();
        this.portalServers = new ArrayList();
        while (itr.hasNext()) {
            this.portalServers.add(itr.next().toString().toLowerCase());
        }
        this.roundRobin = this.portalServers.iterator();
    }

    public synchronized String getHost() {
        int count = 0;
        if (this.portalServers == null) {
            try {
                this.initialize();
            }
            catch (NullPointerException ne) {
                return SERVLET_URL;
            }
            orginalSize = this.portalServers.size();
        }
        String retval = null;
        while (count < orginalSize) {
            String host = this.getHostImpl();
            if (this.isAvailable(host)) {
                retval = host;
                break;
            }
            ++count;
        }
        return retval;
    }

    private synchronized String getHostImpl() {
        if (this.portalServers.size() == 0 || this.portalServers.size() == this.unavailableServers.size()) {
            return null;
        }
        if (orginalSize < 2) {
            return SERVLET_URL;
        }
        if (this.roundRobin == null) {
            this.roundRobin = this.portalServers.iterator();
        }
        if (this.roundRobin.hasNext()) {
            return this.roundRobin.next().toString() + this.path;
        }
        this.roundRobin = this.portalServers.iterator();
        return this.roundRobin.next().toString() + this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(String host) {
        try {
            if (this.portalServers == null) {
                this.initialize();
            }
            URL tmpurl = new URL(host);
            StringBuffer portalHost = new StringBuffer();
            portalHost.append(tmpurl.getProtocol()).append("://").append(tmpurl.getHost()).append(":");
            int iPort = tmpurl.getPort();
            if (iPort == -1) {
                if (tmpurl.getProtocol().equalsIgnoreCase("http")) {
                    portalHost.append(80);
                } else if (tmpurl.getProtocol().equalsIgnoreCase("https")) {
                    portalHost.append(443);
                }
            } else {
                portalHost.append(iPort);
            }
            String requestedHost = portalHost.toString().toLowerCase();
            Map map = this.unavailableServers;
            synchronized (map) {
                if (!this.unavailableServers.isEmpty() && this.unavailableServers.get(requestedHost) != null) {
                    return false;
                }
            }
            URL url = new URL(requestedHost);
            return HostChecker.isHostAvailable(url, 2);
        }
        catch (MalformedURLException mue) {
            return false;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void hostAvailabilityChanged(HostAvailabilityEvent hae) {
        if (this.portalServers == null) {
            this.initialize();
        }
        if (hae.getHostType() == 2) {
            if (hae.getHostStatus() == 1) {
                this.removeHost(hae.getHost());
            } else if (hae.getHostStatus() == 2) {
                this.addHost(hae.getHost());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHost(String host) {
        Map map = this.unavailableServers;
        synchronized (map) {
            if (!this.unavailableServers.isEmpty() && this.unavailableServers.get(host) != null) {
                this.unavailableServers.remove(host);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHost(String host) {
        Map map = this.unavailableServers;
        synchronized (map) {
            if (this.unavailableServers.isEmpty() || this.unavailableServers.get(host) == null) {
                this.unavailableServers.put(host, new Long(System.currentTimeMillis()));
            }
        }
    }

    public static String getBootupPortalServer() {
        return SERVLET_URL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

