/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.SSOUtil;
import java.io.Serializable;

public class Request
implements Serializable {
    private String serviceName;
    private String ssoTokenId;
    private String requestType;
    private Object requestObject;
    private Object[] arguments;
    private String gatewaySessionID = null;
    private static int retryCount = 0;
    private static int MIN_RETRY_TIME = 60000;
    private static long prevRetryTime = 0L;

    public Request(String sessionId, String serviceName, String requestType, Object requestObject, Object[] arguments) {
        this.ssoTokenId = sessionId;
        this.serviceName = serviceName;
        this.requestType = requestType;
        this.requestObject = requestObject;
        this.arguments = arguments;
    }

    public Request(String sessionId, String serviceName, String requestType, Object requestObject) {
        this(sessionId, serviceName, requestType, requestObject, null);
    }

    public Request(String sessionId, String serviceName, String requestType) {
        this(sessionId, serviceName, requestType, null);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getSSOTokenId() {
        return this.ssoTokenId;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public Object getRequestObject() {
        return this.requestObject;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getGatewaySessionID() {
        return this.gatewaySessionID;
    }

    private static synchronized void retryAddGatewaySessionId(Request req) {
        if (retryCount > 5 || System.currentTimeMillis() - prevRetryTime < (long)MIN_RETRY_TIME) {
            boolean needTimeReset = retryCount > 5;
            retryCount = 0;
            if (needTimeReset) {
                prevRetryTime = System.currentTimeMillis();
            }
            req.gatewaySessionID = null;
            return;
        }
        GWLogManager.createNewAppSession();
        SSOToken appToken = Request.getToken(GWLogManager.appSession);
        if (appToken != null) {
            String sessId;
            req.gatewaySessionID = sessId = GWLogManager.appSession.getTokenID().toString();
            prevRetryTime = System.currentTimeMillis();
        } else {
            ++retryCount;
            Request.retryAddGatewaySessionId(req);
        }
    }

    public static SSOToken getToken(SSOToken tok) {
        if (tok == null) {
            return null;
        }
        String sessId = tok.getTokenID().toString();
        SSOToken appToken = null;
        try {
            SSOTokenManager tokManager = SSOTokenManager.getInstance();
            appToken = SSOUtil.getSSOTokenNoDecode((String)sessId);
            tok = null;
            if (tokManager.isValidToken(appToken)) {
                tok = appToken;
            }
        }
        catch (Exception ex) {
            tok = null;
        }
        return tok;
    }

    public void setGatewaySessionID() {
        SSOToken appToken = Request.getToken(GWLogManager.appSession);
        if (appToken != null) {
            String sessId;
            this.gatewaySessionID = sessId = GWLogManager.appSession.getTokenID().toString();
        } else {
            Request.retryAddGatewaySessionId(this);
        }
    }
}

