/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.util;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.portal.netlet.util.AttributeExtractor;
import com.sun.portal.netlet.util.NetletConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserAttributes
implements NetletConstants {
    private SSOToken ssoToken = null;
    private AMUser user = null;
    private Map userAttributes;
    private boolean applyDefault;

    public UserAttributes(SSOToken token) {
        try {
            this.ssoToken = token;
            AMStoreConnection connection = new AMStoreConnection(this.ssoToken);
            this.user = connection.getUser(token.getPrincipal().getName());
            this.userAttributes = this.user.getServiceAttributes("srapNetletService");
            this.applyDefault = false;
        }
        catch (SSOException ssoe) {
            this.applyDefault = true;
        }
        catch (AMException dpe) {
            this.applyDefault = true;
        }
    }

    public boolean isPolicyAssigned() {
        return true;
    }

    public boolean isServiceAssigned() {
        boolean serviceAssigned = false;
        try {
            Set vals = null;
            vals = this.user.getAssignedServices();
            if (vals == null || vals.isEmpty()) {
                serviceAssigned = false;
            }
            Iterator iter = vals.iterator();
            while (iter.hasNext()) {
                String serviceName = (String)iter.next();
                if (!"srapNetletService".equalsIgnoreCase(serviceName)) continue;
                serviceAssigned = true;
                break;
            }
        }
        catch (Exception ex) {
            serviceAssigned = false;
        }
        return serviceAssigned;
    }

    public boolean isAllowed() {
        return this.isServiceAssigned() && this.isPolicyAssigned();
    }

    public String getString(String name, String defaultValue) {
        return this.applyDefault ? defaultValue : AttributeExtractor.getString(this.userAttributes, name, defaultValue);
    }

    public String getString(String name) {
        return this.getString(name, "");
    }

    public void setString(String name, String value) {
        HashSet<String> hs = new HashSet<String>(1);
        hs.add(value);
        HashMap<String, HashSet<String>> changedMap = new HashMap<String, HashSet<String>>();
        changedMap.put(name, hs);
        try {
            this.user.setAttributes(changedMap);
            this.user.store();
        }
        catch (SSOException ssoe) {
        }
        catch (AMException ame) {
            // empty catch block
        }
    }

    public int getInt(String name, int defaultValue) {
        return this.applyDefault ? defaultValue : AttributeExtractor.getInt(this.userAttributes, name, defaultValue);
    }

    public int getInt(String name) {
        return this.getInt(name, -1);
    }

    public void setInt(String name, int value) {
        String val = "" + value;
        HashSet<String> hs = new HashSet<String>(1);
        hs.add(val);
        HashMap<String, HashSet<String>> changedMap = new HashMap<String, HashSet<String>>();
        changedMap.put(name, hs);
        try {
            this.user.setAttributes(changedMap);
            this.user.store();
        }
        catch (SSOException ssoe) {
        }
        catch (AMException ame) {
            // empty catch block
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.applyDefault ? defaultValue : AttributeExtractor.getBoolean(this.userAttributes, name, defaultValue);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public void setBoolean(String name, boolean value) {
        String val = "" + value;
        HashSet<String> hs = new HashSet<String>(1);
        hs.add(val);
        HashMap<String, HashSet<String>> changedMap = new HashMap<String, HashSet<String>>();
        changedMap.put(name, hs);
        try {
            this.user.setAttributes(changedMap);
            this.user.store();
        }
        catch (SSOException ssoe) {
        }
        catch (AMException ame) {
            // empty catch block
        }
    }

    public List getStringList(String name) {
        return this.applyDefault ? new ArrayList() : AttributeExtractor.getStringList(this.userAttributes, name);
    }

    public void setStringList(String name, List value) {
        HashSet hs = new HashSet(value);
        HashMap changedMap = new HashMap();
        changedMap.put(name, hs);
        try {
            this.user.setAttributes(changedMap);
            this.user.store();
        }
        catch (SSOException ssoe) {
        }
        catch (AMException ame) {
            // empty catch block
        }
    }

    public String getUserAttribute(String name, String defaultValue) {
        try {
            Set set = this.user.getAttribute(name);
            if (set != null) {
                Iterator it = set.iterator();
                return it.hasNext() ? (String)it.next() : defaultValue;
            }
        }
        catch (SSOException ssoe) {
            return defaultValue;
        }
        catch (AMException ame) {
            return defaultValue;
        }
        return defaultValue;
    }

    public String getUserAttribute(String name) {
        return this.getUserAttribute(name, "");
    }
}

