/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.monitoring.statistics;

import com.sun.portal.monitoring.statistics.StatisticImpl;
import com.sun.portal.netlet.eproxy.NetletGroup;
import com.sun.portal.netlet.eproxy.RWGroupCrypt;

public class NetletConnectionStatisticImpl
extends StatisticImpl {
    private String userId;
    private String netletRule;
    private RWGroupCrypt rwGroupcrypt;

    public NetletConnectionStatisticImpl(String user, RWGroupCrypt rwGroupCrypt) {
        this.userId = user;
        this.rwGroupcrypt = rwGroupCrypt;
        this.netletRule = NetletGroup.getRulenameForPort(new Integer(rwGroupCrypt.getAppletSrcPort()));
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDestination() {
        return this.rwGroupcrypt.getDestHost() + "_" + this.rwGroupcrypt.getDestPort();
    }

    public String getNetletRule() {
        return this.netletRule;
    }

    public long getBytesSent() {
        if (this.rwGroupcrypt.getReaderWriterEncrypt() == null) {
            return 0L;
        }
        return this.rwGroupcrypt.getReaderWriterEncrypt().getBytesTransferred();
    }

    public long getBytesReceived() {
        if (this.rwGroupcrypt.getReaderWriterDecrypt() == null) {
            return 0L;
        }
        return this.rwGroupcrypt.getReaderWriterDecrypt().getBytesTransferred();
    }

    public long getDuration() {
        return System.currentTimeMillis() - this.rwGroupcrypt.getStartTime();
    }

    public long getLastSampleTime() {
        return System.currentTimeMillis();
    }
}

