/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.monitoring;

import com.sun.portal.monitoring.Subsystem;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.NetletGroup;
import com.sun.portal.netlet.eproxy.RWGroupCrypt;
import com.sun.portal.netlet.monitoring.statistics.NetletConnectionStatisticImpl;
import com.sun.portal.netlet.monitoring.statistics.NetletConnectionStatisticWrapper;
import com.sun.portal.netlet.monitoring.util.EProxyEvent;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.SRAEventListener;
import java.util.HashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class NetletConnectionsStatistic
implements SRAEventListener {
    private Subsystem subsystem;
    private Map ssoTokenVsmbean = new HashMap();

    public NetletConnectionsStatistic(Subsystem subsystem) {
        this.subsystem = subsystem;
    }

    private ObjectName getObjectName(RWGroupCrypt rwGroupCrypt) throws MalformedObjectNameException {
        String destination = rwGroupCrypt.getDestHost() + "_" + rwGroupCrypt.getDestPort();
        String upThread = rwGroupCrypt.getReaderWriterDecrypt().getThreadName();
        String downThread = rwGroupCrypt.getReaderWriterEncrypt().getThreadName();
        return new ObjectName(this.subsystem.getNamingDomain() + ":type=NetletConnectionStatistic" + ",destination=" + destination + ",UpstreamThread=" + upThread + ",DownstreamThread=" + downThread);
    }

    public void removeServerStatistic(ObjectName name) {
        this.ssoTokenVsmbean.remove(name);
    }

    public void addNetlet(Object objects) {
        Object[] objArr = (Object[])objects;
        ReaderWriterLock readerWriterLock = null;
        NetletGroup netletGroup = null;
        if (!(objArr[0] instanceof ReaderWriterLock)) {
            return;
        }
        readerWriterLock = (ReaderWriterLock)objArr[0];
        if (!(objArr[1] instanceof NetletGroup)) {
            return;
        }
        netletGroup = (NetletGroup)objArr[1];
        if (readerWriterLock instanceof RWGroupCrypt) {
            RWGroupCrypt rwGroupCrypt = (RWGroupCrypt)readerWriterLock;
            NetletConnectionStatisticImpl statistic = new NetletConnectionStatisticImpl(netletGroup.getUserName(), rwGroupCrypt);
            NetletConnectionStatisticWrapper statisticWrapper = new NetletConnectionStatisticWrapper();
            statisticWrapper.setCompositeTypeName(this.getClass().getName() + statistic.getName());
            statisticWrapper.setResourceBundleBaseName("NetletConnectionStatistics");
            statisticWrapper.setStatisticImpl(statistic);
            try {
                this.subsystem.registerMBean((Object)statisticWrapper, this.getObjectName(rwGroupCrypt).toString());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void removeNetlet(Object o) {
        if (o instanceof RWGroupCrypt) {
            RWGroupCrypt rwGroupCrypt = (RWGroupCrypt)o;
            try {
                this.subsystem.unregisterMBean(this.getObjectName(rwGroupCrypt).toString());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void handleException(Exception e) {
        e.printStackTrace();
    }

    public void handleEvent(SRAEvent event, Object obj) {
        if (event == EProxyEvent.NETLET_ADDED) {
            this.addNetlet(obj);
            return;
        }
        if (event == EProxyEvent.NETLET_REMOVED) {
            this.removeNetlet(obj);
        }
    }

    public SRAEvent[] getInterestedEvents() {
        return new SRAEvent[]{EProxyEvent.NETLET_ADDED, EProxyEvent.NETLET_REMOVED};
    }
}

