/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.netlet.eproxy.NetletGroup;
import com.sun.portal.netlet.eproxy.NetletGroupManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionKeepAlive
implements Runnable {
    private long activateTime = 0L;
    private boolean status = true;
    private NetletGroupManager manager = null;
    private long maxIdleTime = 0L;
    private final long interval = 100L;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$SessionKeepAlive == null ? (class$com$sun$portal$netlet$eproxy$SessionKeepAlive = SessionKeepAlive.class$("com.sun.portal.netlet.eproxy.SessionKeepAlive")) : class$com$sun$portal$netlet$eproxy$SessionKeepAlive));
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$SessionKeepAlive;

    public SessionKeepAlive(NetletGroupManager ng, long idleTime) {
        this.maxIdleTime = idleTime;
        this.manager = ng;
        this.init();
    }

    private void init() {
        this.maxIdleTime *= 60000L;
        this.activateTime = this.maxIdleTime / 100L;
    }

    public void run() {
        long calculatedTime = 0L;
        NetletGroup userNetletTraffic = null;
        long checkTime = 2L * this.activateTime + 5L;
        SSOTokenManager ssoTokenManager = null;
        try {
            ssoTokenManager = SSOTokenManager.getInstance();
        }
        catch (SSOException se) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX111", se);
            this.status = false;
        }
        while (this.status) {
            try {
                String[] ssoTokenIDs = NetletGroupManager.getRegisteredSessions();
                for (int i = 0; i < ssoTokenIDs.length; ++i) {
                    String ssoTokenID = ssoTokenIDs[i];
                    if (ssoTokenID != null && ssoTokenID.trim().length() != 0) {
                        userNetletTraffic = NetletGroupManager.getNetletGroup(ssoTokenID);
                        if (System.currentTimeMillis() - userNetletTraffic.getUserLoginTime() >= userNetletTraffic.getMaxSessionTime()) {
                            NetletGroupManager.unregister(ssoTokenID);
                            continue;
                        }
                        calculatedTime = System.currentTimeMillis() - userNetletTraffic.getLastActivityTime();
                        if (calculatedTime < this.maxIdleTime) {
                            if (!userNetletTraffic.needToExtend()) continue;
                            SSOToken token = null;
                            try {
                                token = ssoTokenManager.createSSOToken(ssoTokenID);
                            }
                            catch (SSOException ssoe) {
                                token = null;
                            }
                            if (token != null && ssoTokenManager.isValidToken(token) || userNetletTraffic.getNetletRunUponLogout()) continue;
                            NetletGroupManager.unregister(ssoTokenID);
                            continue;
                        }
                        if (calculatedTime < this.maxIdleTime) continue;
                        NetletGroupManager.unregister(ssoTokenID);
                        continue;
                    }
                    NetletGroupManager.unregister(ssoTokenID);
                }
                Thread.sleep(this.activateTime);
            }
            catch (InterruptedException ie) {
                logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX112", ie);
                this.status = false;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

