/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CachedSSLSocketFactory;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.JSSProxyRunnable;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.LogInfoContainer;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.ServerCertApprovalCallback;
import com.sun.portal.util.ServiceReachabilityInfo;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;

class SConn {
    private static final String DEFAULT_SSL_PORT = "443";
    private static final String BLOCKED_SOCKET_TIMEOUT = "BlockedSocketTimeout";
    private static final int DEFAULT_SOCKET_TIMEOUT = 200000;
    private static String rpSubdomain;
    private static String rpDomain;
    private static Logger logger;
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$SConn;

    SConn() {
    }

    public static Socket connect(int p, String h) {
        Socket conn = null;
        try {
            conn = new Socket(h, p);
            conn.setTcpNoDelay(true);
            MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_CREATED);
        }
        catch (UnknownHostException e) {
            conn = null;
            Object[] params0 = new Object[]{h, ":", p + "", e};
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX095", params0);
        }
        catch (SocketException e) {
            conn = null;
            Object[] params1 = new Object[]{h, ":", p + "", e};
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX096", params1);
        }
        catch (IOException e) {
            conn = null;
            Object[] params2 = new Object[]{h, ":", p + "", e};
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX097", params2);
        }
        return conn;
    }

    public static Socket sslconnect(int p, String h) {
        SSLSocket sslSocket = null;
        ServerCertApprovalCallback serverCertApprovalCB = null;
        serverCertApprovalCB = ServerCertApprovalCallback.getInstance();
        try {
            sslSocket = new SSLSocket(InetAddress.getByName(h), p, null, 0, (SSLCertificateApprovalCallback)serverCertApprovalCB, null);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX098");
            return null;
        }
        if (sslSocket == null) {
            logger.warning("SConn: Null socket returned. Probably couldn't resolve host.");
            return null;
        }
        try {
            sslSocket.setUseClientMode(true);
            sslSocket.enableSSL2(true);
            sslSocket.enableSSL3(true);
            sslSocket.forceHandshake();
            sslSocket.setSoLinger(false, 0);
            int timeout = GatewayProfile.getInt(BLOCKED_SOCKET_TIMEOUT, 200000);
            sslSocket.setSoTimeout(timeout * 1000);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX099");
        }
        return sslSocket;
    }

    public static Socket connect(String p, String h) {
        Socket conn = null;
        StringTokenizer hosts = new StringTokenizer(h, "+");
        StringTokenizer portlist = new StringTokenizer(p, "-");
        int portlistLen = portlist.countTokens();
        if (hosts.countTokens() == portlistLen || portlistLen == 1) {
            while (hosts.hasMoreElements() && conn == null) {
                String strPorts = "";
                strPorts = portlistLen == 1 ? p : (String)portlist.nextElement();
                StringTokenizer ports = new StringTokenizer(strPorts, "+");
                String host = (String)hosts.nextElement();
                while (ports.hasMoreElements() && conn == null) {
                    Object[] param;
                    String strPort = (String)ports.nextElement();
                    int port = -999;
                    try {
                        port = Integer.parseInt(strPort);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                    try {
                        conn = new Socket(host, port);
                        conn.setTcpNoDelay(true);
                        MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_CREATED);
                    }
                    catch (UnknownHostException e) {
                        conn = null;
                        param = new Object[]{host, port + "", e};
                        logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX100", param);
                    }
                    catch (SocketException e) {
                        conn = null;
                        param = new Object[]{host, port + "", e};
                        logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX101");
                    }
                    catch (IOException e) {
                        conn = null;
                        param = new Object[]{host, port + "", e};
                        logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX102");
                    }
                }
            }
        } else {
            conn = null;
        }
        return conn;
    }

    public static Socket sslProxyConnect(String host, int port, String proxyHost, int proxyPort, int clientPort) {
        ServerSocket ss = null;
        CachedSocket s = null;
        Integer logId = null;
        Object tmp = GWLogManager.logIdMap.remove(new Integer(clientPort));
        if (tmp != null) {
            LogInfoContainer info = (LogInfoContainer)tmp;
            logId = info.getLogID();
        }
        int jssProxyPort = -1;
        try {
            ss = new ServerSocket(0, 50, InetAddress.getByName("127.0.0.1"));
            MonitoringSubsystem.handleEvent(SRAEvent.SERVER_SOCKET_CREATED);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX103");
            ss = null;
        }
        if (ss != null) {
            jssProxyPort = ss.getLocalPort();
            JSSProxyRunnable jssProxy = new JSSProxyRunnable(ss);
            Thread t = new Thread(jssProxy);
            t.start();
        }
        ServerCertApprovalCallback serverCertApprovalCB = new ServerCertApprovalCallback(host);
        s = CachedSSLSocketFactory.createSocket("127.0.0.1", jssProxyPort, "ssl", logId, serverCertApprovalCB);
        Integer localport = new Integer(s.getLocalPort());
        ServiceReachabilityInfo sInfo = new ServiceReachabilityInfo(host, port, proxyHost, proxyPort);
        JSSProxyRunnable.connectHashMap.put(localport, sInfo);
        Object[] params9 = new Object[]{proxyHost};
        logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX104", params9);
        if (s == null) {
            logger.warning("SConn: Null socket returned. Probably couldn't resolve host.");
            return null;
        }
        try {
            SConn.ForceSSLHandshake(host, s);
        }
        catch (IOException e) {
            s = null;
            Object[] params = new Object[]{host, port + "", e};
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX105", params);
            return null;
        }
        return s.getSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ForceSSLHandshake(String host, CachedSocket s) throws IOException {
        String string = DEFAULT_SSL_PORT;
        synchronized (DEFAULT_SSL_PORT) {
            StringTokenizer st;
            int tokenCount;
            String h = host;
            String currentReqHost = h != null ? ((tokenCount = (st = new StringTokenizer(h, ".")).countTokens()) == 1 ? h + "." + rpSubdomain + rpDomain : (tokenCount == 2 ? h + rpDomain : h)) : null;
            try {
                s.getOutputStream().write(new byte[0]);
            }
            catch (IOException ex) {
                currentReqHost = null;
                throw ex;
            }
            currentReqHost = null;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    public static Socket proxyConnect(String host, int port, String proxyHost, int proxyPort) {
        Object[] params;
        ServerSocket ss = null;
        Socket s = null;
        int jssProxyPort = -1;
        try {
            ss = new ServerSocket(0, 50, InetAddress.getByName("127.0.0.1"));
            MonitoringSubsystem.handleEvent(SRAEvent.SERVER_SOCKET_CREATED);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX106");
            ss = null;
        }
        if (ss != null) {
            jssProxyPort = ss.getLocalPort();
            JSSProxyRunnable jssProxy = new JSSProxyRunnable(ss);
            Thread t = new Thread(jssProxy);
            t.start();
        }
        try {
            s = new Socket("127.0.0.1", jssProxyPort);
            s.setTcpNoDelay(true);
            MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_CREATED);
        }
        catch (UnknownHostException e) {
            s = null;
            params = new Object[]{host, port + "", e};
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX107", params);
        }
        catch (SocketException e) {
            s = null;
            params = new Object[]{host, port + "", e};
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX108", params);
        }
        catch (IOException e) {
            s = null;
            params = new Object[]{host, port + "", e};
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX109", params);
        }
        Integer localport = new Integer(s.getLocalPort());
        ServiceReachabilityInfo sInfo = new ServiceReachabilityInfo(host, port, proxyHost, proxyPort);
        JSSProxyRunnable.connectHashMap.put(localport, sInfo);
        Object[] params15 = new Object[]{proxyHost};
        logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX110", params15);
        if (s == null) {
            logger.warning("SConn: Null socket returned. Probably couldn't resolve host.");
            return null;
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$SConn == null ? (class$com$sun$portal$netlet$eproxy$SConn = SConn.class$("com.sun.portal.netlet.eproxy.SConn")) : class$com$sun$portal$netlet$eproxy$SConn));
        String _host = SystemProperties.get("gateway.host", null);
        String rphost = "https://" + _host + "/";
        if (rphost != null) {
            int len = rphost.length();
            int index1 = rphost.indexOf(46);
            if (index1 != -1 && index1 + 1 < len) {
                int index2 = rphost.indexOf(46, index1 + 1);
                if (index2 == -1) {
                    rpSubdomain = rphost.substring(index1 + 1);
                } else {
                    rpSubdomain = rphost.substring(index1 + 1, index2);
                    rpDomain = rphost.substring(index2);
                }
            }
        }
    }
}

