/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.netlet.eproxy.SessionRequest;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Redirect {
    private String dstHost;
    private int dstPort = 0;
    private String dstPortList;
    private boolean found = false;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$Redirect == null ? (class$com$sun$portal$netlet$eproxy$Redirect = Redirect.class$("com.sun.portal.netlet.eproxy.Redirect")) : class$com$sun$portal$netlet$eproxy$Redirect));
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$Redirect;

    public Redirect(int port, SessionRequest sessReq) {
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(sessReq.getSessionID());
            manager.refreshSession(token);
            String val = token.getProperty(Integer.toString(port));
            if (val == null || val.compareTo("") == 0) {
                this.found = false;
                return;
            }
            this.found = true;
            this.parseRedirect(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public String getDstHost() {
        return this.dstHost;
    }

    public boolean doRedirect() {
        return this.found;
    }

    private void parseRedirect(String val) {
        StringTokenizer parser = new StringTokenizer(val, "^");
        try {
            while (parser.hasMoreTokens()) {
                if (this.dstHost == null) {
                    this.dstHost = parser.nextToken();
                }
                if (this.dstPort != 0) continue;
                this.dstPortList = parser.nextToken();
                this.dstPort = Integer.parseInt(this.dstPortList);
            }
        }
        catch (NoSuchElementException e) {
            logger.severe("PSSRNTLT_CSPNEPROX092");
        }
        catch (NumberFormatException e) {
            logger.severe("PSSRNTLT_CSPNEPROX093");
        }
        Object[] params2 = new Object[]{this.dstHost, " ", this.dstPortList};
        logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX094", params2);
    }

    public String getDstPortList() {
        return this.dstPortList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

