/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.netlet.econnection.ESessionMsg;
import com.sun.portal.netlet.econnection.KeyConstants;
import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterClear;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.econnection.SessionCipherMsg;
import com.sun.portal.netlet.econnection.SessionKey;
import com.sun.portal.netlet.eproxy.NetletRequestRouter;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.NetletLogMgr;
import com.sun.portal.util.SRAEvent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RWGroupForward
extends ReaderWriterLock
implements KeyConstants {
    public boolean done = false;
    private int npPort;
    private String npHost;
    private Socket fromClient;
    private Socket toNP;
    private ReaderWriterClear src_to_dst;
    private ReaderWriterClear dst_to_src;
    private boolean src_to_dst_clean = false;
    private boolean dst_to_src_clean = false;
    private Integer netletLogId;
    private String dynamicAlgo = "SSL_RSA_WITH_RC4_128_MD5";
    private long startTime;
    private boolean stopLogged = false;
    private String sessID = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$RWGroupForward == null ? (class$com$sun$portal$netlet$eproxy$RWGroupForward = RWGroupForward.class$("com.sun.portal.netlet.eproxy.RWGroupForward")) : class$com$sun$portal$netlet$eproxy$RWGroupForward));
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$RWGroupForward;

    public RWGroupForward(Socket in, String nphost, int npport, String sessionId) {
        this.fromClient = in;
        this.npPort = npport;
        this.npHost = nphost;
        this.sessID = sessionId;
        NetletRequestRouter netletrouter = new NetletRequestRouter(in.getPort());
        this.toNP = netletrouter.getConnection(this.npHost, this.npPort);
        if (this.toNP == null) {
            logger.severe("PSSRNTLT_CSPNEPROX081");
            this.cleanup();
            return;
        }
        logger.info("PSSRNTLT_CSPNEPROX082");
        try {
            DataOutputStream out = new DataOutputStream(this.toNP.getOutputStream());
            ESessionMsg eMsg = new ESessionMsg("RP1.0".getBytes());
            if (eMsg.writeMsg(out) != 0) {
                this.cleanup();
                return;
            }
            if (this.encryptSessionId(sessionId.getBytes(), sessionId.getBytes().length, out) != 0) {
                this.cleanup();
                return;
            }
            out.flush();
            out = null;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX083");
        }
        if (NetletLogMgr.loggingEnabled) {
            try {
                this.netletLogId = new Integer(NetletLogMgr.getLogId());
                NetletLogMgr.write("Netlet", GWLocale.getPFString("en1", new Object[]{this.netletLogId, new String(NetletLogMgr.getUserId(this.sessID)), "START", this.fromClient.getInetAddress().toString(), new Integer(this.fromClient.getPort()), this.toNP.getInetAddress().toString(), new Integer(this.toNP.getPort())}));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            this.src_to_dst = new ReaderWriterClear(this, this.fromClient.getInputStream(), this.toNP.getOutputStream());
            this.dst_to_src = new ReaderWriterClear(this, this.toNP.getInputStream(), this.fromClient.getOutputStream());
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX084");
        }
        try {
            GWThreadPool.run(this.src_to_dst);
            GWThreadPool.run(this.dst_to_src);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX085");
        }
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void notifyFinished(ReaderWriter obj) {
        if (!this.stopLogged && NetletLogMgr.loggingEnabled) {
            try {
                this.netletLogId = new Integer(NetletLogMgr.getLogId());
                NetletLogMgr.write("Netlet", GWLocale.getPFString("en1", new Object[]{this.netletLogId, new String(NetletLogMgr.getUserId(this.sessID)), new String("STOP"), this.fromClient.getInetAddress().toString(), new Integer(this.fromClient.getPort()), this.toNP.getInetAddress().toString(), new Integer(this.toNP.getPort())}));
                this.stopLogged = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (obj == this.src_to_dst) {
            if (this.dst_to_src.isAlive()) {
                this.dst_to_src.stop();
            }
        } else if (obj == this.dst_to_src && this.src_to_dst.isAlive()) {
            this.src_to_dst.stop();
        }
        this.cleanup();
        if (obj == this.src_to_dst) {
            this.src_to_dst_clean = true;
        } else if (obj == this.dst_to_src) {
            this.dst_to_src_clean = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanup() {
        try {
            if (this.fromClient != null) {
                try {
                    this.fromClient.close();
                    MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
                }
                catch (Exception e) {
                }
                finally {
                    this.fromClient = null;
                }
            }
            if (this.toNP == null) return;
            try {
                this.toNP.close();
                MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
                this.toNP = null;
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                this.toNP = null;
            }
        }
        finally {
            this.done = true;
            this.npHost = null;
        }
    }

    public boolean isDone() {
        if (this.dst_to_src_clean && this.src_to_dst_clean) {
            this.dst_to_src = null;
            this.src_to_dst = null;
        }
        return this.dst_to_src_clean && this.src_to_dst_clean;
    }

    private int encryptSessionId(byte[] id, int id_len, DataOutputStream out) {
        int rc = 0;
        SessionKey initKey = new SessionKey("SN1.0SN1.0SN1.0S.SN9.0SN3.0SN.05".getBytes());
        SessionCipherMsg sMsg = new SessionCipherMsg(id = (new String(id) + "|" + this.dynamicAlgo).getBytes(), id_len += this.dynamicAlgo.length() + 1);
        if (sMsg.writeMsg(out) != 0) {
            logger.severe("PSSRNTLT_CSPNEPROX086");
            rc = -1;
        }
        return rc;
    }

    public long getLastActivityTime() {
        if (this.src_to_dst.getLastActivityTime() > this.dst_to_src.getLastActivityTime()) {
            return this.src_to_dst.getLastActivityTime();
        }
        return this.dst_to_src.getLastActivityTime();
    }

    public synchronized void stopAll() {
        if (!this.done) {
            if (this.dst_to_src != null) {
                this.dst_to_src.stop();
            }
            if (this.src_to_dst != null) {
                this.src_to_dst.stop();
            }
            this.cleanup();
        }
    }

    public int getAppletSrcPort() {
        return 0;
    }

    public long getStartTime() {
        return this.startTime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

