/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterDecrypt;
import com.sun.portal.netlet.econnection.ReaderWriterEncrypt;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.SConn;
import com.sun.portal.netlet.eproxy.SessionAuthenticator;
import com.sun.portal.netlet.eproxy.SessionRequest;
import com.sun.portal.rproxy.configservlet.client.NetletProfile;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.NetletLogMgr;
import com.sun.portal.util.SRAEvent;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RWGroupCrypt
extends ReaderWriterLock {
    public boolean done = false;
    private int srcPort;
    private String destPort;
    private String destHost;
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterDecrypt src_to_dst;
    private ReaderWriterEncrypt dst_to_src;
    private SessionAuthenticator sessionAuth;
    private SessionRequest sessionReq;
    private Integer netletLogId;
    private long startTime;
    private boolean stopLogged = false;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$RWGroupCrypt == null ? (class$com$sun$portal$netlet$eproxy$RWGroupCrypt = RWGroupCrypt.class$("com.sun.portal.netlet.eproxy.RWGroupCrypt")) : class$com$sun$portal$netlet$eproxy$RWGroupCrypt));
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$RWGroupCrypt;

    public ReaderWriterDecrypt getReaderWriterDecrypt() {
        return this.src_to_dst;
    }

    public ReaderWriterEncrypt getReaderWriterEncrypt() {
        return this.dst_to_src;
    }

    public String getDestPort() {
        return this.destPort;
    }

    public String getDestHost() {
        return this.destHost;
    }

    public RWGroupCrypt(Socket in, int sport, String dport, String dhost, SessionAuthenticator sa, SessionRequest rq) {
        this.fromClient = in;
        this.srcPort = sport;
        this.destPort = new String(dport);
        this.destHost = new String(dhost);
        this.sessionAuth = sa;
        this.sessionReq = rq;
        this.toServer = SConn.connect(this.destPort, this.destHost);
        if (this.toServer == null) {
            logger.severe("PSSRNTLT_CSPNEPROX075");
            this.cleanup();
            return;
        }
        try {
            this.toServer.setKeepAlive(true);
            this.fromClient.setKeepAlive(true);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX076");
        }
        if (NetletLogMgr.loggingEnabled) {
            try {
                this.netletLogId = new Integer(NetletLogMgr.getLogId());
                NetletLogMgr.write("Netlet", GWLocale.getPFString("en1", new Object[]{this.netletLogId, new String(NetletLogMgr.getUserId(this.sessionReq.getSessionID())), "START", this.fromClient.getInetAddress().toString(), new Integer(this.srcPort), this.toServer.getInetAddress().toString(), new Integer(this.toServer.getPort())}));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.getNetletKeepAliveInterval(rq) > 0) {
            try {
                this.toServer.setSoTimeout(this.getNetletKeepAliveInterval(rq) * 1000);
            }
            catch (Exception se) {
                System.out.println("Unable to set socket time out.." + se);
            }
        }
        try {
            this.src_to_dst = new ReaderWriterDecrypt(this, this.fromClient.getInputStream(), this.toServer.getOutputStream());
            this.dst_to_src = new ReaderWriterEncrypt(this, this.toServer.getInputStream(), this.fromClient.getOutputStream(), this.getNetletKeepAliveInterval(rq));
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX077");
        }
        try {
            GWThreadPool.run(this.src_to_dst);
            GWThreadPool.run(this.dst_to_src);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX079");
        }
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void notifyFinished(ReaderWriter obj) {
        if (!this.stopLogged && NetletLogMgr.loggingEnabled) {
            try {
                this.netletLogId = new Integer(NetletLogMgr.getLogId());
                NetletLogMgr.write("Netlet", GWLocale.getPFString("en1", new Object[]{this.netletLogId, new String(NetletLogMgr.getUserId(this.sessionReq.getSessionID())), new String("STOP"), this.fromClient.getInetAddress().toString(), new Integer(this.srcPort), this.toServer.getInetAddress().toString(), new Integer(this.toServer.getPort())}));
                this.stopLogged = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (obj == this.src_to_dst) {
            if (this.dst_to_src != null) {
                this.dst_to_src.stop();
            }
        } else if (obj == this.dst_to_src && this.src_to_dst != null) {
            this.src_to_dst.stop();
        }
        this.cleanup();
    }

    public synchronized void stopAll() {
        if (!this.done) {
            if (this.dst_to_src != null) {
                this.dst_to_src.stop();
            }
            if (this.src_to_dst != null) {
                this.src_to_dst.stop();
            }
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            if (this.fromClient != null) {
                try {
                    this.fromClient.close();
                }
                catch (Exception e) {
                }
                finally {
                    MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
                    this.fromClient = null;
                }
            }
            if (this.toServer != null) {
                try {
                    this.toServer.close();
                }
                catch (Exception exception) {
                }
                finally {
                    MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
                    this.toServer = null;
                }
            }
            Object var5_5 = null;
            this.src_to_dst = null;
            this.dst_to_src = null;
            this.done = true;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.src_to_dst = null;
            this.dst_to_src = null;
            this.done = true;
            throw throwable;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public long getLastActivityTime() {
        if (this.src_to_dst.getLastActivityTime() > this.dst_to_src.getLastActivityTime()) {
            return this.src_to_dst.getLastActivityTime();
        }
        return this.dst_to_src.getLastActivityTime();
    }

    private int getNetletKeepAliveInterval(SessionRequest rq) {
        try {
            String sid = rq.getSessionID();
            NetletProfile profile = new NetletProfile(sid);
            Object[] objectArray = new Object[1];
            objectArray[0] = new Integer(NetletProfile.getInt("KeepAliveInterval", 0));
            Object[] params5 = objectArray;
            logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX080", params5);
            return NetletProfile.getInt("KeepAliveInterval", 0);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getAppletSrcPort() {
        return this.srcPort;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

