/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterClear;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.SConn;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.LogInfoContainer;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.SystemProperties;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.jss.ssl.SSLSocket;

public class RWGroupClear
extends ReaderWriterLock {
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterClear src_to_dst;
    private ReaderWriterClear dst_to_src;
    private boolean src_to_dst_clean = false;
    private boolean dst_to_src_clean = false;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$RWGroupClear == null ? (class$com$sun$portal$netlet$eproxy$RWGroupClear = RWGroupClear.class$("com.sun.portal.netlet.eproxy.RWGroupClear")) : class$com$sun$portal$netlet$eproxy$RWGroupClear));
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$RWGroupClear;

    public RWGroupClear(Socket fromClient, int sslPort, Integer logId) {
        this.fromClient = fromClient;
        String bindAddress = SystemProperties.get("gateway.bindipaddress");
        if (bindAddress == null) {
            bindAddress = "127.0.0.1";
        }
        this.toServer = SConn.connect(sslPort, bindAddress);
        if (this.toServer == null) {
            logger.warning("RWGroupClear cannot open connection to localhost:" + sslPort);
            return;
        }
        Object[] params0 = new Object[]{this.toServer};
        logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX069", params0);
        String unqID = this.toServer.getLocalPort() + "_" + "A";
        if (GWLogManager.logIdMap.containsKey(unqID)) {
            GWLogManager.logIdMap.remove(unqID);
        }
        GWLogManager.logIdMap.put(unqID, new LogInfoContainer(logId, fromClient));
        Object[] params1 = new Object[]{this.toServer.getLocalPort() + ""};
        logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX070", params1);
        Object[] params2 = new Object[]{fromClient};
        logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX071", params2);
        try {
            this.src_to_dst = new ReaderWriterClear(this, fromClient.getInputStream(), this.toServer.getOutputStream(), logId, fromClient.getOutputStream());
            this.dst_to_src = new ReaderWriterClear(this, this.toServer.getInputStream(), fromClient.getOutputStream(), logId);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX072");
        }
        this.src_to_dst.useKeepAliveLogic();
        this.dst_to_src.useKeepAliveLogic();
        try {
            GWThreadPool.run(this.src_to_dst);
            GWThreadPool.run(this.dst_to_src);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX073");
        }
    }

    public synchronized void notifyFinished(ReaderWriter obj) {
        if (obj == this.src_to_dst) {
            if (this.dst_to_src.isAlive()) {
                this.dst_to_src.stop();
            }
        } else if (obj == this.dst_to_src && this.src_to_dst.isAlive()) {
            this.src_to_dst.stop();
        }
        this.cleanup();
        if (obj == this.src_to_dst) {
            this.src_to_dst_clean = true;
        } else if (obj == this.dst_to_src) {
            this.dst_to_src_clean = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.fromClient != null) {
            try {
                this.fromClient.close();
                if (this.fromClient instanceof SSLSocket) {
                    MonitoringSubsystem.handleEvent(SRAEvent.SSL_SOCKET_DESTROYED);
                } else {
                    MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.fromClient = null;
            }
        }
        if (this.toServer != null) {
            try {
                this.toServer.close();
                if (this.toServer instanceof SSLSocket) {
                    MonitoringSubsystem.handleEvent(SRAEvent.SSL_SOCKET_DESTROYED);
                } else {
                    MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.toServer = null;
            }
        }
    }

    public boolean isDone() {
        if (this.dst_to_src_clean && this.src_to_dst_clean) {
            this.dst_to_src = null;
            this.src_to_dst = null;
        }
        return this.dst_to_src_clean && this.src_to_dst_clean;
    }

    public long getLastActivityTime() {
        long ctime;
        long stime = this.src_to_dst.getLastActivityTime();
        if (stime > (ctime = this.dst_to_src.getLastActivityTime())) {
            return ctime;
        }
        return stime;
    }

    public synchronized void stopAll() {
        logger.info("PSSRNTLT_CSPNEPROX074");
        if (this.dst_to_src != null) {
            this.dst_to_src.stop();
        }
        if (this.src_to_dst != null) {
            this.src_to_dst.stop();
        }
        this.cleanup();
    }

    public int getAppletSrcPort() {
        return 0;
    }

    public long getStartTime() {
        return 0L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

