/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.netlet.econnection.ESessionMsg;
import com.sun.portal.netlet.econnection.GWRunnable;
import com.sun.portal.netlet.eproxy.EProxy;
import com.sun.portal.netlet.eproxy.ESession;
import com.sun.portal.netlet.eproxy.ProxyConnection;
import com.sun.portal.netlet.eproxy.ProxyletSession;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.rproxy.server.RequestProcessor;
import com.sun.portal.rproxy.server.ServerSocketFactory;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.LogInfoContainer;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RProxyConnection
extends ProxyConnection {
    private boolean secureConnection;
    private int port = 0;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$RProxyConnection == null ? (class$com$sun$portal$netlet$eproxy$RProxyConnection = RProxyConnection.class$("com.sun.portal.netlet.eproxy.RProxyConnection")) : class$com$sun$portal$netlet$eproxy$RProxyConnection));
    private RequestProcessor requestProcessor;
    static boolean useAcceleratorSupport = false;
    private static final String TIMEOUT = "RProxyPortTimeout";
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int timeout;
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$RProxyConnection;

    public static void startHttps(final int port) {
        Runnable r = new Runnable(){

            public void run() {
                block2: {
                    RProxyConnection rpconn = new RProxyConnection(true, port);
                    try {
                        rpconn.start();
                    }
                    catch (SocketException e) {
                        if (!GWDebug.debug.errorEnabled()) break block2;
                        GWDebug.debug.error("RProxyConnection:startHttps(int) cannot start : " + e);
                    }
                }
            }
        };
        Thread thread = new Thread(r);
        thread.start();
    }

    public static void startHttps(final int exposedPort, final int port) {
        Runnable r = new Runnable(){

            public void run() {
                block2: {
                    RProxyConnection rpconn = new RProxyConnection(true, exposedPort, port);
                    try {
                        rpconn.start();
                    }
                    catch (SocketException e) {
                        if (!GWDebug.debug.errorEnabled()) break block2;
                        GWDebug.debug.error("RProxyConnection:startHttps(int,int) cannot start : " + e);
                    }
                }
            }
        };
        Thread thread = new Thread(r);
        thread.start();
    }

    public static void startHttp(final int port) {
        Runnable r = new Runnable(){

            public void run() {
                block2: {
                    RProxyConnection rpconn = new RProxyConnection(false, port);
                    try {
                        rpconn.start();
                    }
                    catch (SocketException e) {
                        if (!GWDebug.debug.errorEnabled()) break block2;
                        GWDebug.debug.error("RProxyConnection:startHttp(int) cannot start : " + e);
                    }
                }
            }
        };
        Thread thread = new Thread(r);
        thread.start();
    }

    private RProxyConnection(boolean secureConnection, int port) {
        super("RProxyHTTPSThread", "epc1");
        this.secureConnection = secureConnection;
        this.port = port;
        this.requestProcessor = this.secureConnection ? new RequestProcessor("https", port) : new RequestProcessor("http", port);
    }

    private RProxyConnection(boolean secureConnection, int exposedPort, int port) {
        super("RProxyHTTPSThread", "epc1");
        this.secureConnection = secureConnection;
        this.port = port;
        this.requestProcessor = this.secureConnection ? new RequestProcessor("https", exposedPort) : new RequestProcessor("http", exposedPort);
    }

    protected ServerSocket makeServerSocket() throws SocketException {
        if (this.secureConnection && useAcceleratorSupport && ServiceIdentifier.isGateway()) {
            return ServerSocketFactory.createSRAPServerSocket(this.port);
        }
        return this.secureConnection ? ServerSocketFactory.createSSLSocketServer(this.port) : ServerSocketFactory.createSRAPServerSocket(this.port);
    }

    private int isNetletTraffic(Socket inconnection) {
        InputStream in = null;
        try {
            in = inconnection.getInputStream();
        }
        catch (IOException e) {
            Object[] params0 = new Object[]{inconnection, e};
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX058", params0);
            try {
                inconnection.close();
                MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
            }
            catch (Exception e1) {
                // empty catch block
            }
            return -1;
        }
        ESessionMsg emsg = new ESessionMsg();
        try {
            in.mark(512);
        }
        catch (Exception e) {
            Object[] params1 = new Object[]{inconnection, e};
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX059", params1);
            try {
                inconnection.close();
                MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
            }
            catch (Exception e1) {
                // empty catch block
            }
            emsg = null;
            return -1;
        }
        int result = emsg.readMsg(new DataInputStream(in));
        if (result == 0 || result == 1) {
            emsg = null;
            return result;
        }
        try {
            in.reset();
        }
        catch (Exception e) {
            Object[] params2 = new Object[]{inconnection, e};
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX060", params2);
        }
        emsg = null;
        return -1;
    }

    protected void process(Socket connection, Integer logId) {
        try {
            GWThreadPool.run(new RProxyThread(connection, logId));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String strUseAcceleratorSupport = SystemProperties.get("gateway.enable.accelerator", "false");
        if (strUseAcceleratorSupport != null) {
            useAcceleratorSupport = strUseAcceleratorSupport.trim().equalsIgnoreCase("true");
        }
        timeout = GatewayProfile.getInt(TIMEOUT, 60000) * 1000;
    }

    class RProxyThread
    implements GWRunnable {
        private Socket connection;
        private Integer logId;

        public RProxyThread(Socket _connection, Integer _logId) {
            this.connection = _connection;
            this.logId = _logId;
        }

        public void run() {
            String unqID;
            Object tmp_1;
            boolean checkNetlet = false;
            boolean checkProxylet = false;
            Socket nonsslsocket = null;
            GWLogManager.logIdMap.put(new Integer(this.connection.getPort()), new LogInfoContainer(this.logId, this.connection));
            int initialTimeout = 0;
            try {
                initialTimeout = this.connection.getSoTimeout();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX061");
            }
            try {
                this.connection.setSoTimeout(timeout);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX062");
            }
            if (ServiceIdentifier.isGateway()) {
                checkNetlet = EProxy.isNetletEnabled;
            } else if (ServiceIdentifier.isNetletProxy()) {
                checkNetlet = true;
            }
            checkProxylet = EProxy.isProxyletEnabled;
            int result = RProxyConnection.this.isNetletTraffic(this.connection);
            boolean isNetletTraffic = false;
            boolean isEnd2EndSSLRequest = false;
            if (result == 0) {
                isNetletTraffic = true;
            } else if (result == 1) {
                isEnd2EndSSLRequest = true;
            }
            if (checkProxylet && (tmp_1 = GWLogManager.logIdMap.get(unqID = this.connection.getPort() + "_" + "A")) != null) {
                LogInfoContainer info = (LogInfoContainer)tmp_1;
                nonsslsocket = info.getClientSocket();
            }
            if (checkNetlet && isNetletTraffic) {
                logger.info("PSSRNTLT_CSPNEPROX063");
                try {
                    this.connection.setSoTimeout(initialTimeout);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX064");
                }
                ESession es = new ESession(this.connection, this.logId);
                try {
                    GWThreadPool.run(es);
                }
                catch (InterruptedException e) {
                    logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX065");
                    try {
                        this.connection.close();
                        MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    return;
                }
            }
            if (checkProxylet && isEnd2EndSSLRequest) {
                try {
                    this.connection.setSoTimeout(initialTimeout);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX066");
                }
                String req = null;
                String host = null;
                int port = 443;
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
                    req = r.readLine();
                    req = req.substring(req.indexOf(" "), req.length());
                    req = req.trim();
                    host = req.substring(0, req.indexOf(":"));
                    port = Integer.parseInt(req.substring(req.indexOf(":") + 1, req.length()));
                    String cookie = r.readLine();
                    SSOToken token = null;
                    try {
                        token = SSOTokenManager.getInstance().createSSOToken(cookie);
                    }
                    catch (SSOException ssoe) {
                        try {
                            token = SSOTokenManager.getInstance().createSSOToken(URLDecoder.decode(cookie));
                        }
                        catch (SSOException ssoe2) {
                            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX067");
                            return;
                        }
                    }
                }
                catch (IOException e) {
                    return;
                }
                ProxyletSession es = new ProxyletSession(nonsslsocket, this.logId, host, port, this.connection);
                Thread _t = new Thread(es);
                _t.start();
            } else if (!ServiceIdentifier.isNetletProxy()) {
                RProxyConnection.this.requestProcessor.processRequestInGWTheadPool(this.connection, this.logId);
            } else {
                RProxyConnection.this.closeSocket(this.connection);
            }
        }

        private String readRequest(InputStream in) throws IOException {
            byte[] reply = new byte[100];
            int replyLen = 0;
            int newlinesSeen = 0;
            boolean headerDone = false;
            boolean error = false;
            while (newlinesSeen < 2) {
                int i = in.read();
                if (i < 0) {
                    throw new IOException("Unexpected EOF from proxy");
                }
                if (i == 10) {
                    headerDone = true;
                    ++newlinesSeen;
                    continue;
                }
                if (i == 13) continue;
                newlinesSeen = 0;
                if (headerDone || replyLen >= reply.length) continue;
                reply[replyLen++] = (byte)i;
            }
            reply[replyLen++] = 0;
            return new String(reply);
        }

        public String getType() {
            return "rProxyThread";
        }
    }
}

