/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.netlet.eproxy.GW;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.SRAPSocket;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.jss.ssl.SSLServerSocket;

public abstract class ProxyConnection {
    private static String dummyLockString = "DummyLockString";
    private String threadName = null;
    private ServerSocket serverSocket = null;
    private String connectionInfoKey = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$ProxyConnection == null ? (class$com$sun$portal$netlet$eproxy$ProxyConnection = ProxyConnection.class$("com.sun.portal.netlet.eproxy.ProxyConnection")) : class$com$sun$portal$netlet$eproxy$ProxyConnection));
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$ProxyConnection;

    public ProxyConnection(String threadName, String connectionInfoKey) {
        this.threadName = threadName;
        this.connectionInfoKey = connectionInfoKey;
    }

    public void start() throws SocketException {
        Thread.currentThread().setName(this.threadName);
        this.serverSocket = this.makeServerSocket();
        Integer logid = new Integer(0);
        GW.run_GW();
        while (this.serverSocket != null) {
            Socket inconnection = null;
            try {
                try {
                    inconnection = this.serverSocket.accept();
                    this.incrementSocketCount();
                }
                catch (SocketException se) {
                    continue;
                }
                catch (IOException e) {
                    Object[] params0 = new Object[]{" cannot accept new connection on ", this.serverSocket, e};
                    logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX051", params0);
                    this.closeServerSocket();
                    this.resetServerSocket();
                    continue;
                }
                if (GWLogManager.loggingEnabled) {
                    logid = new Integer(GWLogManager.getLogId());
                    try {
                        GWLogManager.write(this.threadName, GWLocale.getPFString(this.connectionInfoKey, new Object[]{logid, inconnection.getInetAddress().toString(), new Integer(inconnection.getPort())}));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                try {
                    inconnection.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    Object[] params1 = new Object[]{" cannot set TcpNoDelay on ", inconnection, e};
                    logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX052", params1);
                    this.closeSocket(inconnection);
                    inconnection = null;
                    continue;
                }
                this.process(new SRAPSocket(inconnection), logid);
            }
            catch (Throwable t) {
                Object[] params2 = new Object[]{": Uncaught exception:", t};
                logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX053", params2);
            }
        }
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetServerSocket() throws SocketException {
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String string = dummyLockString;
        synchronized (string) {
            GW.unrun_GW();
            GW.setNumberOfInstances(1);
            this.serverSocket = this.makeServerSocket();
            GW.run_GW();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSocket(Socket socket) {
        try {
            socket.close();
            boolean isHTTPS = this.serverSocket instanceof SSLServerSocket;
            if (isHTTPS) {
                MonitoringSubsystem.handleEvent(SRAEvent.SSL_SOCKET_DESTROYED);
            } else {
                MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
            }
        }
        catch (IOException ee) {
            Object[] params3 = new Object[]{": IO Exception while closing server socket:", ee};
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX054", params3);
        }
        finally {
            socket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeServerSocket() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ee) {
                Object[] params4 = new Object[]{" cannot close server socket", ee};
                logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX055", params4);
            }
            finally {
                MonitoringSubsystem.handleEvent(SRAEvent.SERVER_SOCKET_DESTROYED);
                this.serverSocket = null;
            }
        }
    }

    private void incrementSocketCount() {
        boolean isHTTPS = this.serverSocket instanceof SSLServerSocket;
        if (isHTTPS) {
            MonitoringSubsystem.handleEvent(SRAEvent.SSL_SOCKET_CREATED);
        } else {
            MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_CREATED);
        }
    }

    private void stop() {
        Object[] params5 = new Object[]{this.threadName, " exited"};
        logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX056", params5);
    }

    protected abstract ServerSocket makeServerSocket() throws SocketException;

    protected abstract void process(Socket var1, Integer var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

