/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.netlet.eproxy.ProxyConnection;
import com.sun.portal.netlet.eproxy.RWGroupClear;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.server.RequestProcessor;
import com.sun.portal.rproxy.server.ServerSocketFactory;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PProxyConnection
extends ProxyConnection {
    private boolean secureConnection;
    private int port = 0;
    private int exposedport = 0;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$PProxyConnection == null ? (class$com$sun$portal$netlet$eproxy$PProxyConnection = PProxyConnection.class$("com.sun.portal.netlet.eproxy.PProxyConnection")) : class$com$sun$portal$netlet$eproxy$PProxyConnection));
    private RequestProcessor requestProcessor;
    static boolean useAcceleratorSupport = false;
    private static final String TIMEOUT = "RProxyPortTimeout";
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int timeout;
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$PProxyConnection;

    public static void startHttps(final int port) {
        Runnable r = new Runnable(){

            public void run() {
                block2: {
                    PProxyConnection rpconn = new PProxyConnection(false, port);
                    try {
                        rpconn.start();
                    }
                    catch (SocketException e) {
                        if (!GWDebug.debug.errorEnabled()) break block2;
                        GWDebug.debug.error("PProxyConnection:startHttps(int) cannot start : " + e);
                    }
                }
            }
        };
        Thread thread = new Thread(r);
        thread.start();
    }

    public static void startHttps(final int exposedPort, final int port) {
        Runnable r = new Runnable(){

            public void run() {
                block2: {
                    PProxyConnection rpconn = new PProxyConnection(false, exposedPort, port);
                    try {
                        rpconn.start();
                    }
                    catch (SocketException e) {
                        if (!GWDebug.debug.errorEnabled()) break block2;
                        GWDebug.debug.error("PProxyConnection:startHttps(int,int) cannot start : " + e);
                    }
                }
            }
        };
        Thread thread = new Thread(r);
        thread.start();
    }

    private PProxyConnection(boolean secureConnection, int port) {
        super("PProxyHTTPSThread", "epc1");
        this.secureConnection = secureConnection;
        this.port = port;
        this.requestProcessor = new RequestProcessor("http", port);
    }

    private PProxyConnection(boolean secureConnection, int exposedPort, int port) {
        super("PProxyHTTPSThread", "epc1");
        this.secureConnection = secureConnection;
        this.port = port;
        this.exposedport = exposedPort;
        this.requestProcessor = new RequestProcessor("http", exposedPort);
    }

    protected ServerSocket makeServerSocket() {
        if (this.secureConnection && useAcceleratorSupport && ServiceIdentifier.isGateway()) {
            return ServerSocketFactory.createSRAPServerSocket(this.port);
        }
        Object[] params0 = new Object[]{this.exposedport + ""};
        logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX050", params0);
        return ServerSocketFactory.createNormalServerSocket(this.exposedport);
    }

    protected void process(Socket connection, Integer logId) {
        try {
            GWThreadPool.run(new PProxyThread(connection, logId));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String strUseAcceleratorSupport = SystemProperties.get("gateway.enable.accelerator", "false");
        if (strUseAcceleratorSupport != null) {
            useAcceleratorSupport = strUseAcceleratorSupport.trim().equalsIgnoreCase("true");
        }
        timeout = GatewayProfile.getInt(TIMEOUT, 60000) * 1000;
    }

    class PProxyThread
    implements Runnable {
        private Socket connection;
        private Integer logId;

        public PProxyThread(Socket _connection, Integer _logId) {
            this.connection = _connection;
            this.logId = _logId;
        }

        public void run() {
            try {
                this.connection.setSoTimeout(timeout);
                new RWGroupClear(this.connection, PProxyConnection.this.port, this.logId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

