/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.NetletGroup;
import com.sun.portal.netlet.eproxy.SessionKeepAlive;
import com.sun.portal.util.GWThreadPool;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetletGroupManager {
    private static Hashtable userNetlets = new Hashtable();
    private static NetletGroupManager manager = null;
    private static SessionKeepAlive ska = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$NetletGroupManager == null ? (class$com$sun$portal$netlet$eproxy$NetletGroupManager = NetletGroupManager.class$("com.sun.portal.netlet.eproxy.NetletGroupManager")) : class$com$sun$portal$netlet$eproxy$NetletGroupManager));
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$NetletGroupManager;

    private NetletGroupManager() {
    }

    public static NetletGroupManager getNetletGroupManager() {
        if (manager == null) {
            manager = new NetletGroupManager();
        }
        return manager;
    }

    public static void registerReaderWriter(ReaderWriterLock r, SSOToken ssoToken) throws SSOException {
        String ssoTokenID = ssoToken.getTokenID().toString();
        NetletGroupManager.init(ssoToken);
        NetletGroupManager.safeAddToUserNetlets(r, ssoToken, ssoTokenID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void safeAddToUserNetlets(ReaderWriterLock r, SSOToken ssoToken, String ssoTokenID) throws SSOException {
        Hashtable hashtable = userNetlets;
        synchronized (hashtable) {
            NetletGroup ng = (NetletGroup)userNetlets.get(ssoTokenID);
            if (ng == null) {
                ng = new NetletGroup(manager, ssoToken);
            }
            ng.add(r);
            userNetlets.put(ssoTokenID, ng);
        }
    }

    public static void registerReaderWriter(ReaderWriterLock r, SSOTokenID ssoTokenId) throws SSOException {
        String ssoTokenID = ssoTokenId.toString();
        SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
        SSOToken ssoToken = ssoTokenManager.createSSOToken(ssoTokenID);
        NetletGroupManager.init(ssoToken);
        NetletGroupManager.safeAddToUserNetlets(r, ssoToken, ssoTokenID);
    }

    public static void registerReaderWriter(ReaderWriterLock r, String ssoTokenID) throws SSOException {
        SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
        SSOToken ssoToken = ssoTokenManager.createSSOToken(ssoTokenID);
        NetletGroupManager.init(ssoToken);
        NetletGroupManager.safeAddToUserNetlets(r, ssoToken, ssoTokenID);
    }

    public static void unregister(SSOToken ssoToken) {
        String ssoTokenID = ssoToken.getTokenID().toString();
        NetletGroupManager.clean(ssoTokenID);
        userNetlets.remove(ssoTokenID);
    }

    public static void unregister(SSOTokenID ssoTokenId) {
        String ssoTokenID = ssoTokenId.toString();
        NetletGroupManager.clean(ssoTokenID);
        userNetlets.remove(ssoTokenID);
    }

    public static void unregister(String ssoTokenID) {
        NetletGroupManager.clean(ssoTokenID);
        userNetlets.remove(ssoTokenID);
    }

    public static void clean(String ssoTokenID) {
        NetletGroup ng = (NetletGroup)userNetlets.get(ssoTokenID);
        ng.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getRegisteredSessions() {
        Enumeration enumeration = null;
        String[] keys = null;
        Hashtable hashtable = userNetlets;
        synchronized (hashtable) {
            enumeration = userNetlets.keys();
            keys = new String[userNetlets.size()];
        }
        int i = 0;
        while (enumeration.hasMoreElements()) {
            keys[i] = (String)enumeration.nextElement();
            ++i;
        }
        return keys;
    }

    public static NetletGroup getNetletGroup(String ssoTokenID) {
        return (NetletGroup)userNetlets.get(ssoTokenID);
    }

    private static void init(SSOToken ssoToken) {
        if (ska == null) {
            try {
                ska = new SessionKeepAlive(manager, ssoToken.getMaxIdleTime());
                GWThreadPool.run(ska);
            }
            catch (InterruptedException ie) {
                logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX047");
            }
            catch (SSOException se) {
                logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX048");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

