/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.NetletGroupManager;
import com.sun.portal.netlet.monitoring.util.EProxyEvent;
import com.sun.portal.rproxy.configservlet.client.NetletProfile;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetletGroup
implements SSOTokenListener {
    private List userNetlets = new ArrayList(){

        public boolean add(Object o) {
            MonitoringSubsystem.handleEvent(EProxyEvent.NETLET_ADDED, new Object[]{o, this});
            return super.add(o);
        }

        public boolean remove(Object o) {
            MonitoringSubsystem.handleEvent(EProxyEvent.NETLET_REMOVED, o);
            return super.remove(o);
        }
    };
    private SSOToken ssoToken = null;
    private NetletGroupManager manager;
    private boolean netletRunUponLogout = false;
    private NetletProfile netletUserattrs = null;
    private Hashtable appletSrcPorts = null;
    private Vector srcPorts = null;
    private static final HashMap srcPortVsRuleName = new HashMap();
    private long userLoginTime;
    private long maxSessionTime;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$NetletGroup == null ? (class$com$sun$portal$netlet$eproxy$NetletGroup = NetletGroup.class$("com.sun.portal.netlet.eproxy.NetletGroup")) : class$com$sun$portal$netlet$eproxy$NetletGroup));
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$NetletGroup;

    public NetletGroup(NetletGroupManager ngm, SSOToken s) throws SSOException {
        this.ssoToken = s;
        this.manager = ngm;
        this.appletSrcPorts = new Hashtable();
        this.srcPorts = new Vector();
        this.getNetletProfile();
        this.setSrcPorts();
        this.setNetletRunUponLogout();
        this.ssoToken.addSSOTokenListener((SSOTokenListener)this);
        this.userLoginTime = System.currentTimeMillis() - (this.ssoToken.getMaxSessionTime() * 60L - this.ssoToken.getTimeLeft()) * 1000L + 10000L;
        this.maxSessionTime = this.ssoToken.getMaxSessionTime() * 60000L;
    }

    public NetletGroup(NetletGroupManager ngm, SSOTokenID ssoTokenID) throws SSOException {
        SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
        this.ssoToken = ssoTokenManager.createSSOToken(ssoTokenID.toString());
        this.manager = ngm;
        this.appletSrcPorts = new Hashtable();
        this.srcPorts = new Vector();
        this.getNetletProfile();
        this.setSrcPorts();
        this.setNetletRunUponLogout();
        this.ssoToken.addSSOTokenListener((SSOTokenListener)this);
        this.userLoginTime = System.currentTimeMillis() - (this.ssoToken.getMaxSessionTime() * 60L - this.ssoToken.getTimeLeft()) * 1000L + 10000L;
        this.maxSessionTime = this.ssoToken.getMaxSessionTime() * 60000L;
    }

    public NetletGroup(NetletGroupManager ngm, String tokenID) throws SSOException {
        SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
        this.ssoToken = ssoTokenManager.createSSOToken(tokenID);
        this.manager = ngm;
        this.appletSrcPorts = new Hashtable();
        this.srcPorts = new Vector();
        this.getNetletProfile();
        this.setSrcPorts();
        this.setNetletRunUponLogout();
        this.ssoToken.addSSOTokenListener((SSOTokenListener)this);
        this.userLoginTime = System.currentTimeMillis() - (this.ssoToken.getMaxSessionTime() * 60L - this.ssoToken.getTimeLeft()) * 1000L + 10000L;
        this.maxSessionTime = this.ssoToken.getMaxSessionTime() * 60000L;
    }

    public void getNetletProfile() {
        try {
            this.netletUserattrs = new NetletProfile(this.ssoToken.getTokenID().toString());
            Object[] params0 = new Object[]{this.netletUserattrs.toString()};
            logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX000", params0);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX001");
            this.netletUserattrs = null;
        }
    }

    public void setNetletRunUponLogout() {
        if (this.netletUserattrs != null) {
            try {
                this.netletRunUponLogout = !NetletProfile.getBoolean("TerminateAtLogout", true);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX002");
                this.netletRunUponLogout = false;
            }
        } else {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX003");
            this.netletRunUponLogout = false;
        }
    }

    public boolean getNetletRunUponLogout() {
        return this.netletRunUponLogout;
    }

    private void setSrcPorts() {
        if (this.netletUserattrs != null) {
            List rules = NetletProfile.getStringList("Rules");
            for (int x = 0; x < rules.size(); ++x) {
                String rule = (String)rules.get(x);
                boolean isExtend = rule.endsWith("EXTEND");
                if (!isExtend) continue;
                rule = rule.substring(0, rule.lastIndexOf("|"));
                String es = "false";
                StringTokenizer st = new StringTokenizer(rule, "|");
                String tmp = st.nextToken();
                tmp = st.nextToken();
                tmp = st.nextToken();
                while (st.hasMoreElements()) {
                    tmp = st.nextToken();
                    int sp = Integer.parseInt(tmp);
                    this.srcPorts.add(new Integer(sp));
                    tmp = st.nextToken();
                    tmp = st.nextToken();
                }
            }
        } else {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX004");
        }
    }

    public void addAppletSrcPort(ReaderWriterLock r) {
        try {
            this.appletSrcPorts.put(r, new Integer(r.getAppletSrcPort()));
        }
        catch (NullPointerException ne) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX005", ne);
        }
    }

    public void removeAppletSrcPort(ReaderWriterLock r) {
        this.appletSrcPorts.remove(r);
    }

    public synchronized void add(ReaderWriterLock r) {
        this.userNetlets.add(r);
        this.addAppletSrcPort(r);
    }

    public synchronized void remove(ReaderWriter r) {
        this.userNetlets.remove(r);
    }

    public synchronized void remove(ReaderWriterLock r) {
        this.removeAppletSrcPort(r);
        this.userNetlets.remove(r);
    }

    public SSOToken getSSOToken() {
        return this.ssoToken;
    }

    public int activeGroupCount() {
        return this.userNetlets.size();
    }

    public synchronized void clean() {
        ReaderWriterLock rwl = null;
        for (int i = 0; i < this.userNetlets.size(); ++i) {
            rwl = (ReaderWriterLock)this.userNetlets.get(i);
            if (rwl == null) continue;
            rwl.stopAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        long lastActivityTime = 0L;
        try {
            Object[] rws = null;
            lastActivityTime = System.currentTimeMillis() - (this.ssoToken.getMaxIdleTime() * 60000L + 10000L);
            long holdlastActivityTime = 0L;
            List list = this.userNetlets;
            synchronized (list) {
                rws = new Object[this.userNetlets.size()];
                rws = this.userNetlets.toArray();
            }
            for (int i = 0; i < rws.length; ++i) {
                block11: {
                    ReaderWriterLock rw = (ReaderWriterLock)rws[i];
                    if (rw == null) continue;
                    try {
                        holdlastActivityTime = rw.getLastActivityTime();
                        if (System.currentTimeMillis() - holdlastActivityTime >= this.ssoToken.getMaxIdleTime() * 60000L) {
                            rw.stopAll();
                            this.remove(rw);
                        }
                        break block11;
                    }
                    catch (NullPointerException ne) {
                        this.remove(rw);
                    }
                    continue;
                }
                if (lastActivityTime >= holdlastActivityTime) continue;
                lastActivityTime = holdlastActivityTime;
            }
            return lastActivityTime;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX006", e);
            try {
                lastActivityTime = System.currentTimeMillis() - (this.ssoToken.getMaxIdleTime() * 60000L + 1000L);
            }
            catch (SSOException se) {
                logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX007", se);
            }
            return lastActivityTime;
        }
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        logger.info("PSSRNTLT_CSPNEPROX008");
        SSOToken token = null;
        try {
            token = evt.getToken();
            int evtType = evt.getType();
        }
        catch (SSOException ssoe) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX009", ssoe);
            return;
        }
        String tokenID = token.getTokenID().toString();
        String ssoTokenID = this.ssoToken.getTokenID().toString();
        if (ssoTokenID.equals(tokenID) && !this.getNetletRunUponLogout()) {
            NetletGroupManager.unregister(ssoTokenID.toString());
        }
    }

    public boolean needToExtend() {
        boolean needtoextend = false;
        Enumeration enumeration = this.appletSrcPorts.keys();
        Collection currentSrcPorts = this.appletSrcPorts.values();
        Iterator iter = currentSrcPorts.iterator();
        while (iter.hasNext()) {
            Integer currentSrcPort = (Integer)iter.next();
            if (currentSrcPort == -1) {
                currentSrcPort = new Integer(30021);
            }
            if (!this.srcPorts.contains(currentSrcPort)) continue;
            needtoextend = true;
            break;
        }
        return needtoextend;
    }

    public long getUserLoginTime() {
        return this.userLoginTime;
    }

    public long getMaxSessionTime() {
        return this.maxSessionTime;
    }

    public static String getRulenameForPort(Integer port) {
        String rule = (String)srcPortVsRuleName.get(port);
        return rule == null ? "Unknown rule" : rule;
    }

    public String getUserName() {
        try {
            return this.ssoToken.getPrincipal().getName();
        }
        catch (SSOException e) {
            return "UNKNOWN";
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

