/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.NetletProfile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetletAccessController {
    private NetletProfile netletUserProfile = null;
    private List denyList = null;
    private List allowList = null;
    private static final String serverDomain = GatewayProfile.getString("DefaultDomainAndSubdomains", null);
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$NetletAccessController == null ? (class$com$sun$portal$netlet$eproxy$NetletAccessController = NetletAccessController.class$("com.sun.portal.netlet.eproxy.NetletAccessController")) : class$com$sun$portal$netlet$eproxy$NetletAccessController));
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$NetletAccessController;

    public NetletAccessController(NetletProfile netletProfile) {
        this.netletUserProfile = netletProfile;
        this.denyList = NetletProfile.getStringList("DenyHosts");
        this.allowList = NetletProfile.getStringList("AccessHosts");
    }

    public boolean isAccessAllowed(String host, int port) {
        return this.isAccessAllowed(host.trim() + ":" + Integer.toString(port));
    }

    public boolean isAccessAllowed(String host) {
        StringTokenizer hosts = new StringTokenizer(host, "+");
        while (hosts.hasMoreTokens()) {
            String currentHost = hosts.nextToken().toString();
            if (!this.isValidHost(currentHost)) {
                logger.warning("NetletAccessController: host not resolvable : " + currentHost);
                continue;
            }
            if (this.checkDenyAccess(currentHost) || !this.checkAllowAccess(currentHost)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidHost(String hostName) {
        InetAddress inetaddr = null;
        try {
            inetaddr = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        String resolvedHostName = inetaddr.getHostName();
        return !this.isIPAddress(hostName) || !hostName.equals(resolvedHostName);
    }

    private boolean checkAllowAccess(String host) {
        if (this.allowList != null) {
            boolean stringMatch = false;
            String ipAddr = null;
            try {
                InetAddress inetaddr = InetAddress.getByName(host);
                if (this.isIPAddress(host)) {
                    ipAddr = host;
                    host = inetaddr.getHostName();
                } else {
                    ipAddr = inetaddr.getHostAddress();
                }
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
            if (host.indexOf(".") == -1 && serverDomain != null) {
                host = host + ".";
                host = host + serverDomain;
            }
            for (int i = 0; i < this.allowList.size(); ++i) {
                String privilegeString = (String)this.allowList.get(i);
                if (privilegeString.equals("*")) {
                    return true;
                }
                if (privilegeString.indexOf(".") == -1 && serverDomain != null) {
                    privilegeString = privilegeString + ".";
                    privilegeString = privilegeString + serverDomain;
                }
                if (!(stringMatch = this.wildcardMatch(host.toLowerCase(), privilegeString.toLowerCase()))) {
                    stringMatch = this.wildcardMatch(ipAddr, privilegeString.toLowerCase());
                }
                Object[] param = new Object[]{host, ipAddr, serverDomain, privilegeString, new Boolean(stringMatch)};
                logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX045", param);
                if (!stringMatch) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkDenyAccess(String host) {
        if (this.denyList != null) {
            boolean stringMatch = false;
            String ipAddr = null;
            try {
                InetAddress inetaddr = InetAddress.getByName(host);
                if (this.isIPAddress(host)) {
                    ipAddr = host;
                    host = inetaddr.getHostName();
                } else {
                    ipAddr = inetaddr.getHostAddress();
                }
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
            if (host.indexOf(".") == -1 && serverDomain != null) {
                host = host + ".";
                host = host + serverDomain;
            }
            for (int i = 0; i < this.denyList.size(); ++i) {
                String privilegeString = (String)this.denyList.get(i);
                if (privilegeString.length() > 0) {
                    if (privilegeString.equals("*")) {
                        return true;
                    }
                    if (privilegeString.indexOf(".") == -1 && serverDomain != null) {
                        privilegeString = privilegeString + ".";
                        privilegeString = privilegeString + serverDomain;
                    }
                    if (!(stringMatch = this.wildcardMatch(host.toLowerCase(), privilegeString.toLowerCase()))) {
                        stringMatch = this.wildcardMatch(ipAddr, privilegeString.toLowerCase());
                    }
                    Object[] params = new Object[]{host, ipAddr, privilegeString, new Boolean(stringMatch)};
                    logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX046", params);
                }
                if (!stringMatch) continue;
                return true;
            }
        }
        return false;
    }

    private boolean wildcardMatch(String str1, String str2) {
        int beginIndex1 = 0;
        int endIndex1 = 0;
        int beginIndex2 = 0;
        int endIndex2 = 0;
        int strlen1 = str1.length();
        int strlen2 = str2.length();
        String substr = null;
        if (str1 == null || str2 == null) {
            return false;
        }
        endIndex2 = str2.indexOf(42, beginIndex2);
        if (endIndex2 != -1) {
            substr = str2.substring(beginIndex2, endIndex2);
            if (endIndex2 > beginIndex2) {
                if ((beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                    return false;
                }
                if (beginIndex1 != beginIndex2) {
                    return false;
                }
            }
            beginIndex1 += endIndex2 - beginIndex2;
            if (endIndex2 >= strlen2 - 1) {
                return true;
            }
            beginIndex2 = endIndex2 + 1;
        } else {
            beginIndex1 = str1.indexOf(str2);
            if (beginIndex1 == -1) {
                return false;
            }
            return strlen1 == strlen2;
        }
        while ((endIndex2 = str2.indexOf(42, beginIndex2)) != -1) {
            substr = str2.substring(beginIndex2, endIndex2);
            if (endIndex2 > beginIndex2 && (beginIndex1 = str1.indexOf(substr, beginIndex1)) == -1) {
                return false;
            }
            beginIndex1 += endIndex2 - beginIndex2;
            if (endIndex2 >= strlen2 - 1) {
                return true;
            }
            beginIndex2 = endIndex2 + 1;
        }
        substr = str2.substring(beginIndex2, strlen2);
        endIndex1 = str1.lastIndexOf(substr, strlen1 - 1);
        if (endIndex1 == -1) {
            return false;
        }
        if (beginIndex1 > endIndex1) {
            return false;
        }
        beginIndex1 = endIndex1;
        return strlen1 - beginIndex1 == strlen2 - beginIndex2;
    }

    private boolean isIPAddress(String hostName) {
        StringTokenizer st = new StringTokenizer(hostName, ".");
        int count = 0;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            try {
                int intVal = Integer.parseInt(str);
                if (intVal > 255) {
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                return false;
            }
            ++count;
        }
        return count == 4;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

