/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.netlet.econnection.GWRunnable;
import com.sun.portal.netlet.econnection.KeyConstants;
import com.sun.portal.netlet.econnection.ProxyCipherMsg;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.NetletAccessController;
import com.sun.portal.netlet.eproxy.NetletGroupManager;
import com.sun.portal.netlet.eproxy.NetletProxyRouter;
import com.sun.portal.netlet.eproxy.RWGroupCrypt;
import com.sun.portal.netlet.eproxy.RWGroupForward;
import com.sun.portal.netlet.eproxy.RWGroupFtp;
import com.sun.portal.netlet.eproxy.Redirect;
import com.sun.portal.netlet.eproxy.SessionAuthenticator;
import com.sun.portal.netlet.eproxy.SessionRequest;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.GetResponseException;
import com.sun.portal.rproxy.configservlet.client.NetletProfile;
import com.sun.portal.rproxy.configservlet.client.SendRequestException;
import com.sun.portal.rproxy.connectionhandler.Session;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.SRAEvent;
import com.sun.portal.util.ServiceIdentifier;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLSocket;

public class ESession
implements KeyConstants,
GWRunnable {
    protected SessionRequest sessReq = null;
    protected NetletProfile userProfile;
    protected ProxyCipherMsg pMsg;
    protected RWGroupCrypt rwg = null;
    protected RWGroupForward rwgf = null;
    protected RWGroupFtp rwgcf = null;
    protected Socket fromSock;
    protected DataInputStream fromClient;
    protected Integer logId;
    protected SessionAuthenticator sessionAuth;
    protected static boolean useNetletProxy = false;
    protected String netletProxyHost = null;
    protected int netletProxyPort = 10555;
    protected Hashtable cipherList = new Hashtable();
    public static final String NETLET_PROXY = "__sra_netlet_proxy__";
    private boolean validatePDC = false;
    private String digest = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$ESession == null ? (class$com$sun$portal$netlet$eproxy$ESession = ESession.class$("com.sun.portal.netlet.eproxy.ESession")) : class$com$sun$portal$netlet$eproxy$ESession));
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$ESession;

    public ESession(Socket s, Integer _logId) {
        try {
            this.fromClient = new DataInputStream(s.getInputStream());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX018");
            return;
        }
        this.logId = _logId;
        this.fromSock = s;
        this.sessionAuth = new SessionAuthenticator();
    }

    public void run() {
        SSOToken ssoToken = null;
        if (!this.readClientCertificate()) {
            this.cleanUp();
            logger.info("PSSRNTLT_CSPNEPROX019");
            return;
        }
        if (this.readSessionId() != 0) {
            this.cleanUp();
            return;
        }
        if (this.sessionAuth.authenticate(this.sessReq) != 0) {
            logger.severe("PSSRNTLT_CSPNEPROX020");
            this.cleanUp();
            return;
        }
        try {
            SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
            ssoToken = ssoTokenManager.createSSOToken(this.sessReq.getSessionID());
            ssoTokenManager.refreshSession(ssoToken);
            if (this.validatePDC && !this.verifyClientCertificate(ssoToken)) {
                this.cleanUp();
                logger.info("PSSRNTLT_CSPNEPROX021");
                return;
            }
            this.userProfile = new NetletProfile(ssoToken.getTokenID().toString());
            List algoEnum = NetletProfile.getStringList("Ciphers");
            StringBuffer algoList = new StringBuffer();
            for (int x = 0; x < algoEnum.size(); ++x) {
                algoList.append((String)algoEnum.get(x)).append("|");
            }
            StringTokenizer algoSplitter = new StringTokenizer(algoList.toString(), "|");
            while (algoSplitter.hasMoreElements()) {
                this.cipherList.put(algoSplitter.nextToken(), algoSplitter.nextToken());
            }
        }
        catch (SSOException se) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX023", se);
        }
        catch (GetResponseException gre) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX024", gre);
        }
        catch (SendRequestException sre) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX025", sre);
        }
        if (useNetletProxy) {
            String sessionId = this.sessReq.getSessionID();
            try {
                this.netletProxyHost = this.getAssociatedNetletProxy(ssoToken);
            }
            catch (SSOException soe) {
                soe.printStackTrace();
                logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX026", soe);
                return;
            }
            URL nlp_url = null;
            try {
                nlp_url = new URL(this.netletProxyHost);
            }
            catch (MalformedURLException me) {
                me.printStackTrace();
            }
            this.netletProxyHost = nlp_url.getHost();
            int nlp_Port = nlp_url.getPort();
            if (nlp_Port != -1) {
                this.netletProxyPort = nlp_Port;
            }
            nlp_url = null;
            Object[] param = new Object[]{this.netletProxyHost, this.netletProxyPort + ""};
            logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX027");
            this.rwgf = new RWGroupForward(this.fromSock, this.netletProxyHost, this.netletProxyPort, sessionId);
            try {
                NetletGroupManager.getNetletGroupManager();
                NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwgf, sessionId);
            }
            catch (SSOException se) {
                try {
                    NetletGroupManager.getNetletGroupManager();
                    NetletGroupManager.unregister(sessionId);
                }
                catch (Exception e) {
                    logger.severe("PSSRNTLT_CSPNEPROX028");
                }
            }
            String logmsg = GWLocale.getPFString("es1", new Object[]{this.logId, new String(GWLogManager.getUserId(sessionId)), this.netletProxyHost, new Integer(this.netletProxyPort)});
            if (GWLogManager.loggingEnabled) {
                GWLogManager.write("netlet", logmsg);
            }
        } else {
            NetletAccessController netletAccessCheck = new NetletAccessController(this.userProfile);
            try {
                this.pMsg = new ProxyCipherMsg();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (this.pMsg.readMsg(this.fromClient) == 0) {
                String logmsg;
                Object[] params11 = new Object[]{this.pMsg.getSrcPort() + ""};
                logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX029", params11);
                Redirect rd = new Redirect(this.pMsg.getSrcPort(), this.sessReq);
                if (rd.doRedirect()) {
                    Object[] params12 = new Object[]{rd.getDstPortList(), " ", rd.getDstHost()};
                    logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX030", params12);
                    logmsg = GWLocale.getPFString("es2", new Object[]{this.logId, new String(GWLogManager.getUserId(this.sessReq.getSessionID())), rd.getDstHost(), rd.getDstPortList()});
                    if (!netletAccessCheck.isAccessAllowed(rd.getDstHost())) {
                        this.cleanUp();
                        return;
                    }
                    this.rwg = new RWGroupCrypt(this.fromSock, this.pMsg.getSrcPort(), rd.getDstPortList(), rd.getDstHost(), this.sessionAuth, this.sessReq);
                    try {
                        NetletGroupManager.getNetletGroupManager();
                        NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwg, this.sessReq.getSessionID());
                    }
                    catch (SSOException se) {
                        try {
                            NetletGroupManager.getNetletGroupManager();
                            NetletGroupManager.unregister(this.sessReq.getSessionID());
                        }
                        catch (Exception e) {
                            logger.severe("PSSRNTLT_CSPNEPROX031");
                        }
                    }
                } else if (this.pMsg.getDstPort().equals("-1")) {
                    Object[] params14 = new Object[]{rd.getDstHost()};
                    logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX032", params14);
                    logmsg = GWLocale.getPFString("es4", new Object[]{this.logId, rd.getDstHost()});
                    this.rwgcf = new RWGroupFtp(this.fromSock, this.sessionAuth, this.sessReq);
                    try {
                        NetletGroupManager.getNetletGroupManager();
                        NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwgcf, this.sessReq.getSessionID());
                    }
                    catch (SSOException se) {
                        try {
                            NetletGroupManager.getNetletGroupManager();
                            NetletGroupManager.unregister(this.sessReq.getSessionID());
                        }
                        catch (Exception e) {
                            logger.severe("PSSRNTLT_CSPNEPROX033");
                        }
                    }
                } else {
                    logmsg = GWLocale.getPFString("es3", new Object[]{this.logId, new String(GWLogManager.getUserId(this.sessReq.getSessionID())), this.pMsg.getHostName(), this.pMsg.getDstPort()});
                    if (!netletAccessCheck.isAccessAllowed(this.pMsg.getHostName())) {
                        this.cleanUp();
                        return;
                    }
                    this.rwg = new RWGroupCrypt(this.fromSock, this.pMsg.getSrcPort(), this.pMsg.getDstPort(), this.pMsg.getHostName(), this.sessionAuth, this.sessReq);
                    try {
                        NetletGroupManager.getNetletGroupManager();
                        NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwg, this.sessReq.getSessionID());
                    }
                    catch (SSOException se) {
                        try {
                            NetletGroupManager.getNetletGroupManager();
                            NetletGroupManager.unregister(this.sessReq.getSessionID());
                        }
                        catch (Exception e) {
                            logger.severe("PSSRNTLT_CSPNEPROX034");
                        }
                    }
                }
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("netlet", logmsg);
                }
            } else {
                logger.severe("PSSRNTLT_CSPNEPROX035");
            }
            this.pMsg = null;
        }
    }

    public void stop() {
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        if (this.fromSock != null) {
            try {
                this.fromSock.close();
            }
            catch (IOException iOException) {
            }
            finally {
                MonitoringSubsystem.handleEvent(SRAEvent.PLAIN_SOCKET_DESTROYED);
                this.fromSock = null;
            }
        }
    }

    public String getSessionID() {
        return this.sessReq.getSessionID();
    }

    public boolean isDone() {
        if (this.rwg != null) {
            return this.rwg.isDone();
        }
        if (this.rwgf != null) {
            return this.rwgf.isDone();
        }
        if (this.rwgcf != null) {
            return this.rwgcf.isDone();
        }
        return this.fromSock == null;
    }

    private int readSessionId() {
        if (this.sessReq == null) {
            this.sessReq = new SessionRequest();
        }
        if (this.sessReq.readMsg(this.fromClient) != 0) {
            logger.info("PSSRNTLT_CSPNEPROX037");
            return -1;
        }
        Object[] params18 = new Object[]{this.sessReq.getSessionID()};
        logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX036", params18);
        return 0;
    }

    private String getAssociatedNetletProxy(SSOToken ssoToken) throws SSOException {
        String associatedNLP = ssoToken.getProperty(NETLET_PROXY);
        if (associatedNLP == null) {
            associatedNLP = NetletProxyRouter.getNetletProxyAlive();
            if (associatedNLP == null) {
                return NetletProxyRouter.getServer();
            }
            ssoToken.setProperty(NETLET_PROXY, associatedNLP);
            return associatedNLP;
        }
        if (NetletProxyRouter.isNetletProxyAlive(associatedNLP)) {
            return associatedNLP;
        }
        associatedNLP = NetletProxyRouter.getNetletProxyAlive();
        if (associatedNLP == null) {
            return NetletProxyRouter.getServer();
        }
        ssoToken.setProperty(NETLET_PROXY, associatedNLP);
        return associatedNLP;
    }

    private boolean readClientCertificate() {
        if (!(this.fromSock instanceof SSLSocket)) {
            return true;
        }
        if (!Session.doingPDC) {
            return true;
        }
        try {
            X509Certificate clientCert = ((SSLSocket)this.fromSock).getStatus().getPeerCertificate();
            byte[] certbyte = clientCert.getEncoded();
            String xxb64Cert = JSSUtil.getDefaultDecoder().getEncodedStr(certbyte);
            this.digest = JSSUtil.getDefaultDecoder().digest(xxb64Cert);
        }
        catch (Exception e) {
            logger.severe("PSSRNTLT_CSPNEPROX038");
            return false;
        }
        return false;
    }

    private boolean verifyClientCertificate(SSOToken ssoToken) {
        String pdcCertInfo = null;
        if (this.digest == null || this.digest.trim().length() == 0) {
            return false;
        }
        try {
            pdcCertInfo = ssoToken.getProperty("__sra_pdc_cert__");
        }
        catch (SSOException soe) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX039");
            return false;
        }
        if (pdcCertInfo == null || pdcCertInfo.trim().length() == 0) {
            return false;
        }
        return this.digest.equals(pdcCertInfo);
    }

    public String getType() {
        return "eSession";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        useNetletProxy = GatewayProfile.getBoolean("UseNetletProxy", false) && ServiceIdentifier.isGateway();
    }
}

