/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.netlet.eproxy.GW;
import com.sun.portal.netlet.eproxy.PProxyConnection;
import com.sun.portal.netlet.eproxy.RProxyConnection;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.rproxy.monitoring.MonitoringSubsystem;
import com.sun.portal.rproxy.rewriter.SRAPRewriterModule;
import com.sun.portal.rproxy.server.GatewayContext;
import com.sun.portal.rproxy.server.GatewayContextFactory;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWNSSInit;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.NetletLogMgr;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EProxy {
    public static boolean isNetletEnabled = true;
    public static boolean isProxyletEnabled = false;
    public static Logger logger = null;
    static final String watchdogInfoFileBase = "/var/opt/SUNWportal/.gw.";
    static /* synthetic */ Class class$com$sun$portal$netlet$eproxy$EProxy;

    private static void init() throws SocketException {
        StringBuffer logsb;
        System.setProperty("com.sun.portal.sra.component.type", "gateway");
        if (logger == null) {
            logger = PortalLogger.getLogger((Class)(class$com$sun$portal$netlet$eproxy$EProxy == null ? (class$com$sun$portal$netlet$eproxy$EProxy = EProxy.class$("com.sun.portal.netlet.eproxy.EProxy")) : class$com$sun$portal$netlet$eproxy$EProxy));
        }
        GWDebug.createDefault("srapGateway");
        if (!GWNSSInit.initialize()) {
            System.exit(1);
        }
        ServiceIdentifier.createDefault("srapGateway");
        try {
            String profileName = System.getProperty("gateway.profilename", "default");
            GatewayProfile.init("this-should-be-sid", profileName);
            PlatformProfile.init("this-should-be-sid");
            SRAPRewriterModule.initIDSAME();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSRNTLT_CSPNEPROX010");
            System.exit(1);
        }
        GatewayContextFactory.init(1);
        GWLogManager.initialise();
        if (GWLogManager.loggingEnabled) {
            logsb = new StringBuffer();
            logsb.append("srapGateway_").append(SystemProperties.get("gateway.host").replace('-', '_')).append('_').append(System.getProperty("gateway.profilename", "default").replace('-', '_'));
            GWLogManager.createDefault(logsb.toString());
        }
        if (NetletLogMgr.loggingEnabled) {
            logsb = new StringBuffer();
            logsb.append("srapNetlet_").append(SystemProperties.get("gateway.host").replace('-', '_')).append('_').append(System.getProperty("gateway.profilename", "default").replace('-', '_'));
            NetletLogMgr.createDefault(logsb.toString());
        }
        GWLocale.createDefault();
        GWThreadPool.init();
    }

    public static void main(String[] argv) {
        try {
            EProxy.init();
            if (GWLogManager.loggingEnabled) {
                GWLogManager.write("EProxy", GWLocale.getPFString("StartEProxy"));
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (GWLogManager.loggingEnabled) {
            GWLogManager.write("EProxy", GWLocale.getPFString("StartEProxy"));
        }
        GatewayContext gatewayContext = GatewayContextFactory.getGatewayContext();
        boolean httpEnabled = gatewayContext.isHttpEnabled();
        boolean httpsEnabled = gatewayContext.isHttpsEnabled();
        if (!httpEnabled && !httpsEnabled) {
            return;
        }
        int httpPort = gatewayContext.getHttpPort();
        int httpsPort = gatewayContext.getHttpsPort();
        EProxy.writePortInfoForWatchdog(httpEnabled, httpPort, httpsEnabled, httpsPort);
        isNetletEnabled = gatewayContext.isEProxyEnabled();
        isProxyletEnabled = gatewayContext.isPProxyEnabled();
        if (isProxyletEnabled) {
            logger.info("PSSRNTLT_CSPNEPROX011");
            int internalPort = 0;
            try {
                ServerSocket s = new ServerSocket(0);
                internalPort = s.getLocalPort();
                s.close();
                s = null;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            Object[] params2 = new Object[]{"" + internalPort};
            logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX012", params2);
            EProxy.startRProxy(httpEnabled, httpPort, httpsEnabled, internalPort);
            EProxy.startPProxy(httpsEnabled, httpsPort, internalPort);
        } else {
            EProxy.startRProxy(httpEnabled, httpPort, httpsEnabled, httpsPort);
        }
        MonitoringSubsystem.getInstance();
    }

    private static void startPProxy_HTTP(boolean httpEnabled, int httpPort, int internalPort) {
        if (httpEnabled) {
            PProxyConnection.startHttps(httpPort, internalPort);
            Object[] params3 = new Object[]{httpPort + ""};
            logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX013", params3);
        }
    }

    private static void startPProxy(boolean httpsEnabled, int httpsPort, int internalPort) {
        if (httpsEnabled) {
            PProxyConnection.startHttps(httpsPort, internalPort);
            Object[] params4 = new Object[]{"" + httpsPort};
            logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX014", params4);
        }
    }

    private static void startRProxy(boolean httpEnabled, int httpPort, boolean httpsEnabled, int httpsPort) {
        int numberOfGatewayInstances = httpEnabled && httpsEnabled ? 2 : 1;
        GW.setNumberOfInstances(numberOfGatewayInstances);
        if (httpEnabled) {
            RProxyConnection.startHttp(httpPort);
            Object[] params5 = new Object[]{httpPort + ""};
            logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX015", params5);
        }
        if (httpsEnabled) {
            RProxyConnection.startHttps(httpsPort);
            Object[] params6 = new Object[]{httpsPort + ""};
            logger.log(Level.INFO, "PSSRNTLT_CSPNEPROX016", params6);
        }
    }

    private static void writePortInfoForWatchdog(boolean httpEnabled, int httpPort, boolean httpsEnabled, int httpsPort) {
        File watchdogInfoFile = new File(watchdogInfoFileBase + System.getProperty("conf.suffix"));
        if (watchdogInfoFile.exists()) {
            watchdogInfoFile.delete();
        }
        try {
            FileWriter fw = new FileWriter(watchdogInfoFile);
            if (httpEnabled) {
                fw.write(httpPort + "\n");
            }
            if (httpsEnabled) {
                fw.write(httpsPort + "\n");
            }
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            logger.severe("PSSRNTLT_CSPNEPROX017");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

