/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.admin.model;

import com.sun.portal.desktop.admin.model.DisplayProfileModelImpl;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.portlet.admin.model.PortletPreferenceDPModel;
import com.sun.portal.portletcontainercommon.PortletPreferencesUtility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PortletPreferenceDPModelImpl
extends DisplayProfileModelImpl
implements PortletPreferenceDPModel {
    private static String PORTLET_CLASS = "PortletWindowProvider";
    private static String PORTLET_PREFIX = "__Portlet__";
    private static String PORTLET_PREFERENCE_PROPS = "__Portlet__PreferenceProperties";
    private static String PORTLET_PREFERENCE_DESCRIPTION = "description";
    private static String PORTLET_PREFERENCE_DEFAULT = "default";
    private static String PORTLET_PREFERENCE_READONLY = "isReadOnly";
    protected String[] availablePortlets = null;
    protected String[] availablePortletDisplayNames = null;
    protected String[] portletPreferences = null;
    protected DPCollection defaultNodeFromProvider = null;
    protected DPCollection defaultNodeFromChannel = null;
    protected DPCollection readOnlyNode = null;

    public PortletPreferenceDPModelImpl(HttpServletRequest req, String rbName, Map map) {
        super(req, rbName, map);
    }

    public String[] getAvailablePortlets() {
        if (this.availablePortlets == null) {
            this.preparePortletLists();
        }
        return this.availablePortlets;
    }

    public String[] getAvailablePortletDisplayNames() {
        if (this.availablePortletDisplayNames == null) {
            this.preparePortletLists();
        }
        return this.availablePortletDisplayNames;
    }

    public String getPortletDisplayName(String portletName) {
        if (portletName.startsWith("__Portlet__")) {
            return portletName.substring("__Portlet__".length());
        }
        return portletName;
    }

    public String[] getPortletPreferenceNames() {
        if (this.portletPreferences == null) {
            Set portletPrefs;
            if (this.readOnlyNode == null) {
                this.getPortletPreferencesNodes();
            }
            if ((portletPrefs = this.readOnlyNode.getNames()) != null) {
                String[] prefs = new String[portletPrefs.size()];
                this.portletPreferences = portletPrefs.toArray(prefs);
            } else {
                this.portletPreferences = EMPTY_STRING_LIST;
            }
        }
        return this.portletPreferences;
    }

    public String getPortletPreferenceStringValue(int index) {
        String prefName = this.getPortletPreferenceName(index);
        return this.getPortletPreferenceStringValue(prefName);
    }

    public List getPortletPreferenceValues(int index) {
        String prefName = this.getPortletPreferenceName(index);
        String pref = this.getPortletPreferenceStringValue(prefName);
        return PortletPreferencesUtility.getPreferenceValues((String)pref);
    }

    public boolean getPortletPreferenceIsUserReadOnly(int index) {
        String prefName = this.getPortletPreferenceName(index);
        if (this.readOnlyNode == null) {
            this.getPortletPreferencesNodes();
        }
        DPProperty readOnly = this.readOnlyNode.get(prefName);
        return (Boolean)readOnly.getValue();
    }

    public String getPortletPreferenceName(int index) {
        String[] prefs = this.getPortletPreferenceNames();
        if (prefs == null || prefs.length < index) {
            return null;
        }
        return prefs[index];
    }

    public void setPortletPreferenceDefaultStringValues(Map prefMap) {
        String origCollectionPath = this.getCollectionPath();
        String[] prefNames = this.getPortletPreferenceNames();
        DPProperties providerProperties = ((DPChannel)this.currentNode).getProvider().getProperties();
        DPProperties properties = this.currentNode.getProperties();
        for (int i = 0; i < prefNames.length; ++i) {
            String prefName = prefNames[i];
            String value = null;
            value = prefMap.containsKey(prefName) ? (String)prefMap.get(prefName) : this.getPortletPreferenceStringValue(prefName);
            prefName = PORTLET_PREFIX + prefName;
            DPProperty property = properties.get(prefName, false);
            if (property == null) {
                property = providerProperties.get(prefName);
                property = properties.add(property);
            }
            property.setValue((Object)value);
        }
    }

    private void preparePortletLists() {
        HashMap<String, String> portletMap = new HashMap<String, String>();
        Set allProviderNames = this.currentNode.getProviderNames();
        Iterator<Object> iter = allProviderNames.iterator();
        while (iter.hasNext()) {
            String providerName = (String)iter.next();
            String className = this.currentNode.getProvider(providerName).getClassName();
            boolean isContainerProvider = this.isContainerProvider(className);
            if (this.getProviderClass(className) == null || this.isAddingContainer && !isContainerProvider || !this.isAddingContainer && isContainerProvider) {
                this.message("DisplayProfileModelImpl.resetData(): Droping provider " + providerName);
                continue;
            }
            if (!this.isPortlet(providerName)) continue;
            portletMap.put(providerName, this.getPortletDisplayName(providerName));
        }
        this.availablePortlets = new String[portletMap.size()];
        this.availablePortletDisplayNames = new String[portletMap.size()];
        iter = portletMap.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String portletName;
            this.availablePortlets[i] = portletName = (String)iter.next();
            this.availablePortletDisplayNames[i] = (String)portletMap.get(portletName);
            ++i;
        }
    }

    private void getPortletPreferencesNodes() {
        if (this.defaultNodeFromProvider == null || this.defaultNodeFromChannel == null || this.readOnlyNode == null) {
            DPProperties properties = this.currentNode.getProperties();
            DPCollection prefProp = properties.getCollection(PORTLET_PREFERENCE_PROPS);
            if (prefProp == null) {
                this.error("PortletDisplayProfileModelImpl.getPortletPreferencesNodes(): " + PORTLET_PREFERENCE_PROPS + " not defined in dp.");
                return;
            }
            properties = ((DPChannel)this.currentNode).getProvider().getProperties();
            DPCollection providerPrefProp = properties.getCollection(PORTLET_PREFERENCE_PROPS);
            if (this.defaultNodeFromChannel == null) {
                this.defaultNodeFromChannel = (DPCollection)prefProp.get(PORTLET_PREFERENCE_DEFAULT);
            }
            if (this.defaultNodeFromProvider == null) {
                this.defaultNodeFromProvider = (DPCollection)providerPrefProp.get(PORTLET_PREFERENCE_DEFAULT);
                if (this.defaultNodeFromProvider == null) {
                    this.error("PortletDisplayProfileModelImpl.getPortletPreferencesNodes(): " + PORTLET_PREFERENCE_DEFAULT + " not defined in dp.");
                }
            }
            if (this.readOnlyNode == null) {
                this.readOnlyNode = (DPCollection)prefProp.get(PORTLET_PREFERENCE_READONLY);
                if (this.readOnlyNode == null && providerPrefProp != null) {
                    this.readOnlyNode = (DPCollection)providerPrefProp.get(PORTLET_PREFERENCE_READONLY);
                }
                if (this.readOnlyNode == null) {
                    this.error("PortletDisplayProfileModelImpl.getPortletPreferencesNodes(): " + PORTLET_PREFERENCE_READONLY + " not defined in dp.");
                }
            }
        }
    }

    private boolean isPortlet(String providerName) {
        String className = this.currentNode.getProvider(providerName).getClassName();
        return className.endsWith(PORTLET_CLASS);
    }

    protected String getPortletPreferenceStringValue(String prefName) {
        String pref = PORTLET_PREFIX + prefName;
        DPProperties properties = this.currentNode.getProperties();
        DPProperty property = properties.get(pref, false);
        if (property == null) {
            DPProperties providerProperties = ((DPChannel)this.currentNode).getProvider().getProperties();
            property = providerProperties.get(pref);
        }
        return property.getValue().toString();
    }

    protected boolean getPortletPreferenceIsUserReadOnly(String prefName) {
        if (this.readOnlyNode == null) {
            this.getPortletPreferencesNodes();
        }
        DPProperty readOnly = this.readOnlyNode.get(prefName);
        return (Boolean)readOnly.getValue();
    }
}

