/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.admin.mbeans.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebAppExtractor {
    private static final String DD_LOCATION = "DDFileLocation";
    public static String PORTLET_XML_DESCRIPTOR = "portlet.xml";
    public static String EXTENSION_XML_DESCRIPTOR = "sun-portlet.xml";
    public static String WEB_XML_DESCRIPTOR = "web.xml";
    public static String PORTLET_XML_PATH = "WEB-INF/portlet.xml";
    public static String EXTENSION_XML_PATH = "WEB-INF/sun-portlet.xml";
    public static String WEB_XML_PATH = "WEB-INF/web.xml";
    public static final String TEMP_WAR_EXTN = ".tmp";
    private Properties configProps = null;
    private JarFile earFile = null;
    private String earApplicationName = null;
    private String ddLocation = null;
    private boolean verbose = false;
    private Logger logger = null;

    public WebAppExtractor(File earFile, Properties props, boolean verbose, Logger logger) throws IOException {
        this.earFile = new JarFile(earFile);
        this.earApplicationName = earFile.getName().substring(0, earFile.getName().indexOf("."));
        this.configProps = props;
        this.verbose = verbose;
        this.logger = logger;
        this.ddLocation = this.configProps.getProperty(DD_LOCATION);
    }

    public List extractPortletWars() {
        int i;
        if (this.verbose) {
            this.logger.log(Level.INFO, "PSPL_CSPPAMT0016", new Object[]{this.earFile});
        }
        ArrayList<File[]> descriptors = new ArrayList<File[]>();
        ArrayList<File> allWarFiles = new ArrayList<File>();
        ArrayList<JarEntry> allWarEntries = new ArrayList<JarEntry>();
        Enumeration<JarEntry> entries = this.earFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry earFileEntry = entries.nextElement();
            if (!earFileEntry.getName().endsWith(".war")) continue;
            allWarEntries.add(earFileEntry);
        }
        for (i = 0; i < allWarEntries.size(); ++i) {
            File tempWarFile = this.getWarFromEar((JarEntry)allWarEntries.get(i));
            if (tempWarFile == null) continue;
            allWarFiles.add(tempWarFile);
        }
        for (i = 0; i < allWarFiles.size(); ++i) {
            File file = (File)allWarFiles.get(i);
            File sunDescriptor = null;
            File webDescriptor = null;
            File xmlDescriptor = this.getDescriptorFromWarFile(PORTLET_XML_DESCRIPTOR, PORTLET_XML_PATH, file);
            if (xmlDescriptor != null) {
                sunDescriptor = this.getDescriptorFromWarFile(EXTENSION_XML_DESCRIPTOR, EXTENSION_XML_PATH, file);
                webDescriptor = this.getDescriptorFromWarFile(WEB_XML_DESCRIPTOR, WEB_XML_PATH, file);
            }
            file.delete();
            if (xmlDescriptor == null) continue;
            File[] fileArray = new File[]{xmlDescriptor, sunDescriptor, webDescriptor};
            descriptors.add(fileArray);
        }
        return descriptors;
    }

    private File getWarFromEar(JarEntry warEntry) {
        File tempWarFile = null;
        try {
            int bytesRead;
            String webAppName = warEntry.getName();
            InputStream entryStream = this.earFile.getInputStream(warEntry);
            tempWarFile = new File(this.ddLocation, webAppName + TEMP_WAR_EXTN);
            FileOutputStream warOutput = new FileOutputStream(tempWarFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = entryStream.read(buffer)) != -1) {
                warOutput.write(buffer, 0, bytesRead);
            }
            entryStream.close();
            warOutput.close();
        }
        catch (IOException excp) {
            this.logger.log(Level.SEVERE, "PSPL_CSPPAMT0017", new Object[]{warEntry, this.earFile});
        }
        return tempWarFile;
    }

    private File getDescriptorFromWarFile(String descriptorName, String descriptorPath, File tempWarFile) {
        File tempXMLFile = null;
        try {
            JarFile warFile = new JarFile(tempWarFile);
            Enumeration<JarEntry> entries = warFile.entries();
            while (entries.hasMoreElements()) {
                int bytesRead;
                JarEntry thisEntry = entries.nextElement();
                if (!thisEntry.getName().equalsIgnoreCase(descriptorPath)) continue;
                InputStream entryStream = warFile.getInputStream(thisEntry);
                String webAppName = tempWarFile.getName().substring(0, tempWarFile.getName().indexOf("."));
                tempXMLFile = new File(this.ddLocation, this.earApplicationName + "_" + webAppName + "_" + descriptorName);
                FileOutputStream xmlOutput = new FileOutputStream(tempXMLFile);
                byte[] buffer = new byte[1024];
                while ((bytesRead = entryStream.read(buffer)) != -1) {
                    xmlOutput.write(buffer, 0, bytesRead);
                }
                entryStream.close();
                xmlOutput.close();
            }
            warFile.close();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "PSPL_CSPPAMT0018", e);
        }
        return tempXMLFile;
    }
}

