/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.admin.mbeans.tasks;

import com.sun.portal.portlet.admin.mbeans.tasks.PortletDeployerException;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeploymentDescriptorFinder {
    private static final String DD_LOCATION = "DDFileLocation";
    private Properties configProps = null;
    private JarFile earFile = null;
    private String earApplicationName = null;
    private String ddLocation = null;
    private boolean verbose = false;
    private Logger logger = null;

    public DeploymentDescriptorFinder(String earApplicationName, Properties props, boolean verbose, Logger logger) {
        this.earApplicationName = earApplicationName;
        this.configProps = props;
        this.ddLocation = this.configProps.getProperty(DD_LOCATION);
        this.verbose = verbose;
        this.logger = logger;
    }

    public List findPortletDescriptors() throws PortletDeployerException {
        if (this.verbose) {
            this.logger.log(Level.INFO, "PSPL_CSPPAMT0019", new Object[]{this.earApplicationName});
        }
        ArrayList<File> descriptors = new ArrayList<File>();
        File parentDir = new File(this.ddLocation);
        File[] files = parentDir.listFiles(new DDFileFilter());
        if (files.length == 0) {
            throw new PortletDeployerException("noRegisteredPortlets");
        }
        for (int i = 0; i < files.length; ++i) {
            descriptors.add(files[i]);
        }
        if (this.verbose) {
            this.logger.log(Level.INFO, "PSPL_CSPPAMT0020", new Integer(descriptors.size()));
        }
        return descriptors;
    }

    private String getEarApplicationName(String portletXMLName) {
        StringBuffer thisEarName = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(portletXMLName, "_");
        int count = tokenizer.countTokens();
        for (int k = 0; k < count - 2; ++k) {
            thisEarName.append(tokenizer.nextToken());
            if (k == count - 3) continue;
            thisEarName.append("_");
        }
        return thisEarName.toString();
    }

    class DDFileFilter
    implements FileFilter {
        DDFileFilter() {
        }

        public boolean accept(File file) {
            StringTokenizer tokenizer = new StringTokenizer(file.getName(), "_");
            if (tokenizer.countTokens() == 3) {
                return DeploymentDescriptorFinder.this.getEarApplicationName(file.getName()).equals(DeploymentDescriptorFinder.this.earApplicationName);
            }
            return false;
        }
    }
}

