/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.admin.mbeans.tasks;

import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.portlet.admin.mbeans.tasks.DeploymentDescriptorFinder;
import com.sun.portal.portlet.admin.mbeans.tasks.PDDPUpdater;
import com.sun.portal.portlet.admin.mbeans.tasks.PDProviderEntryGenerator;
import com.sun.portal.portlet.admin.mbeans.tasks.PortletDeployerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DPUNRegister {
    private static final String WEB_XML = "web.xml";
    private static final String PORTLET_XML = "portlet.xml";
    private static final String EXT_XML = "sun-portlet.xml";
    private static final String WEB_INF_PREFIX = "WEB-INF/";
    private static final String DD_LOCATION = "DDFileLocation";
    private static final String DD_SUFFIX = "_portlet.xml";
    private static final String WAR_SUFFIX = ".war";
    private Properties configProps = null;

    public DPUNRegister(Properties pdconfigProp) throws PortletDeployerException {
        this.configProps = pdconfigProp;
    }

    public void process(AdminDPContext dadc, String dn, boolean global, String earAppName, boolean verbose, Logger logger) throws PortletDeployerException {
        if (verbose) {
            logger.log(Level.INFO, "PSPL_CSPPAMT0021", new Object[]{earAppName});
        }
        try {
            DeploymentDescriptorFinder finder = new DeploymentDescriptorFinder(earAppName, this.configProps, verbose, logger);
            List list = finder.findPortletDescriptors();
            if (verbose) {
                logger.log(Level.INFO, "PSPL_CSPPAMT0021", new Object[]{new Integer(list.size())});
            }
            if (verbose && list.size() == 0) {
                logger.log(Level.INFO, "PSPL_CSPPAMT0021");
            }
            for (int i = 0; i < list.size(); ++i) {
                File descriptorFile = (File)list.get(i);
                FileInputStream portletXMLStream = new FileInputStream(descriptorFile);
                String webAppName = this.getWebAppNameFromFileName(descriptorFile.getName());
                if (verbose) {
                    logger.log(Level.INFO, "PSPL_CSPPAMT0030", new Object[]{webAppName});
                }
                PDProviderEntryGenerator providerGen = new PDProviderEntryGenerator(portletXMLStream, null, this.configProps, webAppName);
                List providerNames = providerGen.getProviderNames();
                PDDPUpdater dpUpdater = new PDDPUpdater(dadc, dn, global, verbose, logger);
                if (verbose) {
                    logger.log(Level.INFO, "PSPL_CSPPAMT0031");
                }
                dpUpdater.removeProviders(providerNames);
                descriptorFile.delete();
            }
        }
        catch (IOException excp) {
            logger.log(Level.SEVERE, "PSPL_CSPPAMT0025", excp);
        }
    }

    public String getWebAppNameFromFileName(String descriptorFileName) {
        StringTokenizer tokenizer = new StringTokenizer(descriptorFileName, "_");
        tokenizer.nextToken();
        return tokenizer.nextToken();
    }
}

