/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.admin.mbeans.tasks;

import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.portlet.admin.mbeans.tasks.PDDPUpdater;
import com.sun.portal.portlet.admin.mbeans.tasks.PDProviderEntryGenerator;
import com.sun.portal.portlet.admin.mbeans.tasks.PDWebAppUpdater;
import com.sun.portal.portlet.admin.mbeans.tasks.PortletDeployerException;
import com.sun.portal.portlet.admin.mbeans.tasks.WebAppExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DPRegister {
    private static final String WEB_XML = "web.xml";
    private static final String PORTLET_XML = "portlet.xml";
    private static final String EXT_XML = "sun-portlet.xml";
    private static final String WEB_INF_PREFIX = "WEB-INF/";
    private static final String DD_LOCATION = "DDFileLocation";
    private static final String DD_SUFFIX = "_portlet.xml";
    private static final String WAR_SUFFIX = ".war";
    private Properties configProps = null;

    public DPRegister(Properties pdconfigProp) throws PortletDeployerException {
        this.configProps = pdconfigProp;
    }

    public void process(AdminDPContext dadc, String dn, boolean global, File earFile, Properties rolesProperties, Properties userinfoProperties, boolean verbose, Logger logger) throws PortletDeployerException {
        if (verbose) {
            logger.log(Level.INFO, "PSPL_CSPPAMT0021", new Object[]{earFile});
        }
        try {
            WebAppExtractor extractor = null;
            extractor = new WebAppExtractor(earFile, this.configProps, verbose, logger);
            if (verbose) {
                logger.log(Level.INFO, "PSPL_CSPPAMT0022");
            }
            List listOfDescriptors = extractor.extractPortletWars();
            if (verbose) {
                logger.log(Level.INFO, "PSPL_CSPPAMT0023", new Object[]{new Integer(listOfDescriptors.size())});
            }
            if (rolesProperties == null) {
                rolesProperties = new Properties();
            }
            if (userinfoProperties == null) {
                userinfoProperties = new Properties();
            }
            for (int i = 0; i < listOfDescriptors.size(); ++i) {
                File[] fileArray = (File[])listOfDescriptors.get(i);
                File portletXMLDesc = fileArray[0];
                File extensionXMLDesc = fileArray[1];
                File webXMLDesc = fileArray[2];
                String webAppName = this.getWebAppNameFromFileName(portletXMLDesc.getName());
                FileInputStream portletXMLStream = new FileInputStream(portletXMLDesc);
                FileInputStream extensionXMLStream = null;
                if (extensionXMLDesc != null) {
                    extensionXMLStream = new FileInputStream(extensionXMLDesc);
                }
                FileInputStream webXMLStream = new FileInputStream(webXMLDesc);
                if (verbose) {
                    logger.log(Level.INFO, "PSPL_CSPPAMT0023", new Object[]{this.getWebAppNameFromFileName(portletXMLDesc.getName())});
                }
                List roles = new ArrayList();
                try {
                    roles = PDWebAppUpdater.getRolesWithNamespace(webXMLStream);
                }
                catch (Exception ioe) {
                    logger.log(Level.WARNING, "PSPL_CSPPAMT0033", ioe.getMessage());
                }
                if (verbose) {
                    logger.log(Level.INFO, "PSPL_CSPPAMT0026", new Object[]{roles});
                }
                PDProviderEntryGenerator providerGen = new PDProviderEntryGenerator(portletXMLStream, extensionXMLStream, this.configProps, webAppName);
                List providerElements = providerGen.createProviderElements(rolesProperties, userinfoProperties, roles);
                PDDPUpdater dpUpdater = new PDDPUpdater(dadc, dn, global, verbose, logger);
                dpUpdater.addProviders(providerElements);
                webXMLDesc.delete();
                if (extensionXMLDesc == null) continue;
                extensionXMLDesc.delete();
            }
        }
        catch (IOException excp) {
            logger.log(Level.SEVERE, "PSPL_CSPPAMT0032", excp);
        }
    }

    private String getWebAppNameFromFileName(String descriptorFileName) {
        StringTokenizer tokenizer = new StringTokenizer(descriptorFileName, "_");
        tokenizer.nextToken();
        return tokenizer.nextToken();
    }
}

