/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.config;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.config.PortalConfigData;
import com.sun.portal.fabric.config.PortalConfigurator;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.WebContainer;
import com.sun.portal.fabric.tasks.WebContainerFactory;
import com.sun.portal.fabric.util.AMUtil;
import com.sun.portal.fabric.util.NetworkUtil;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.LDAPUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class ValidatePortalInputData {
    protected static final String COMP_PORTAL_SERVER = "portalserver";
    protected static final String COMP_SRA_CORE = "sracore";
    protected static final String COMP_NETLET_PROXY = "netletproxy";
    protected static final String COMP_REWRITER_PROXY = "rewriterproxy";
    protected static final String COMP_GATEWAY = "gateway";
    protected String message = null;
    protected static final String FS = File.separator;
    protected static boolean bLinux = false;
    private static Logger configLogger;
    protected static LDAPConnection connection;
    protected static PSConfigContext pcc;
    protected static PortalConfigurator pc;
    protected static Map sharedComponentsCheckData;
    protected static Map sharedComponentsCheckData2;
    protected static List allComponentsList;
    static /* synthetic */ Class class$com$sun$portal$fabric$config$ValidatePortalInputData;

    public ValidatePortalInputData(PortalConfigData pci) throws ConfigurationException {
        List componentsToConfigure = pci.getPSComponentsToConfigure();
        if (!this.validateComponentsToConfigure(componentsToConfigure)) {
            throw new ConfigurationException(this.message);
        }
        String host = pcc.getDirectoryServerHost();
        int port = Integer.parseInt(pcc.getDirectoryServerPort());
        this.message = "please refer the log file " + pci.getPSDataDir() + FS + "logs/config/portal.fabric.0.0.log for more information";
        if (!NetworkUtil.isLocalHost((String)pci.getConfigHostName())) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0172", pci.getConfigHostName());
            throw new ConfigurationException(this.message);
        }
        if (connection == null) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0046", new String[]{host, String.valueOf(port)});
            throw new ConfigurationException(this.message);
        }
        if (!pci.isOnlySRAComponentInstalled() || pci.getConfigHostName().equals(pcc.getDirectoryServerHost())) {
            if (!this.validateCredentials(pcc.getUserDataStoreManager(), pcc.getUserDataStoreManagerCredentials()) && !pci.isOnlySRAComponentInstalled()) {
                throw new ConfigurationException(this.message);
            }
            if (!this.validateCredentials(pcc.getAdminUserDN(), pci.getAMAdminPassword()) && !pci.isOnlySRAComponentInstalled()) {
                throw new ConfigurationException(this.message);
            }
            String amLDAPUserDN = pcc.getAMSpecialUsersDN().replaceFirst("dsameuser", pci.getLDAPUserId());
            if (!(this.validateCredentials(amLDAPUserDN, pci.getLDAPUserPassword()) && this.validateCredentials(pcc.getUserDataStoreManager(), pcc.getUserDataStoreManagerCredentials()) && this.validateCredentials(pcc.getAdminUserDN(), pci.getAMAdminPassword()) || pci.isOnlySRAComponentInstalled())) {
                throw new ConfigurationException(this.message);
            }
        }
        try {
            connection.disconnect();
            configLogger.log(Level.INFO, "PSFB_CSPFC0165");
        }
        catch (LDAPException e1) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0063", e1);
            throw new ConfigurationException(this.message);
        }
        configLogger.log(Level.INFO, "PSFB_CSPFC0049");
        if (!this.validateAMSDK(pci.getAMAdmin(), pci.getAMAdminPassword(), pcc.getDefaultOrganization()) && !pci.isOnlySRAComponentInstalled()) {
            throw new ConfigurationException(this.message);
        }
        if (!this.validateSharedComponents(pci.getsharedCompDetails(), componentsToConfigure) || !this.checkPSAMInstallData(pci)) {
            throw new ConfigurationException(this.message);
        }
        configLogger.log(Level.INFO, "PSFB_CSPFC0075");
        if (componentsToConfigure.contains("COMP_PORTAL_SERVER")) {
            if (this.validatePortalServerData(pci.getSamplePortalData()) && this.validateSearchServerData(pci.getSearchServerDetails())) {
                configLogger.log(Level.INFO, "PSFB_CSPFC0076");
            } else {
                throw new ConfigurationException(this.message);
            }
        }
        int iComponentsListSize = componentsToConfigure != null ? componentsToConfigure.size() : 0;
        String sDSHostName = componentsToConfigure.contains("COMP_SRA_CORE") ? null : host;
        for (int z = 0; z < iComponentsListSize; ++z) {
            String sComponent = (String)componentsToConfigure.get(z);
            if (sComponent == null || !sComponent.equalsIgnoreCase("COMP_NETLET_PROXY") && !sComponent.equalsIgnoreCase("COMP_REWRITER_PROXY") && !sComponent.equalsIgnoreCase("COMP_GATEWAY")) continue;
            configLogger.log(Level.INFO, "PSFB_CSPFC0180", new String[]{sComponent});
            if (this.validateSRAComponentData(pci, sComponent, sDSHostName, port)) {
                sDSHostName = null;
                configLogger.log(Level.INFO, "PSFB_CSPFC0183", new String[]{sComponent});
                try {
                    configLogger.log(Level.INFO, "PSFB_CSPFC0186");
                    pci.getcertificateOrganization();
                    configLogger.log(Level.INFO, "PSFB_CSPFC0187");
                    continue;
                }
                catch (Exception e) {
                    configLogger.log(Level.SEVERE, "PSFB_CSPFC0188", e);
                    throw new ConfigurationException(this.message);
                }
            }
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0189", new String[]{sComponent});
            throw new ConfigurationException(this.message);
        }
    }

    public boolean validateCredentials(String userName, String credentials) {
        boolean bRet = true;
        try {
            configLogger.log(Level.INFO, "PSFB_CSPFC0164", userName);
            connection.authenticate(userName, credentials);
            configLogger.log(Level.INFO, "PSFB_CSPFC0047", userName);
        }
        catch (LDAPException e) {
            if (configLogger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFC0087");
                record.setLoggerName(configLogger.getName());
                record.setParameters(new String[]{userName});
                record.setThrown(e);
                configLogger.log(record);
            }
            bRet = false;
        }
        return bRet;
    }

    public boolean validateAMSDK(String amAdminDN, String amAdminPassword, String orgName) {
        boolean bRet = true;
        try {
            SSOToken amSSOToken = AMUtil.createSSOToken((String)amAdminDN, (String)amAdminPassword, (String)orgName);
            if (SSOTokenManager.getInstance().isValidToken(amSSOToken)) {
                configLogger.log(Level.INFO, "PSFB_CSPFC0055");
                SSOTokenManager.getInstance().destroyToken(amSSOToken);
            }
        }
        catch (SSOException e1) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0056", e1);
            bRet = false;
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0054", e);
            bRet = false;
        }
        return bRet;
    }

    private boolean validateComponentsToConfigure(List components) {
        boolean bRet = true;
        if (components == null || components.isEmpty()) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0238");
        } else if (!allComponentsList.containsAll(components)) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0239", new String[]{components.toString()});
            bRet = false;
        } else if (components.contains(COMP_SRA_CORE) && !components.contains(COMP_PORTAL_SERVER)) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0240");
            bRet = false;
        } else {
            configLogger.log(Level.INFO, "PSFB_CSPFC0241", new String[]{components.toString()});
        }
        return bRet;
    }

    private boolean validateSharedComponents(Map sharedComponents, List components) {
        boolean bRet = true;
        Iterator iter = sharedComponents.keySet().iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            String shareComponentDir = (String)sharedComponents.get(element);
            String[] filesList = (String[])sharedComponentsCheckData.get(element);
            String[] privList = (String[])sharedComponentsCheckData2.get(element);
            if ((privList == null || privList[1].equals("true")) && (shareComponentDir == null || shareComponentDir.trim().equals(""))) {
                configLogger.log(Level.SEVERE, "PSFB_CSPFC0060", element);
                bRet = false;
                break;
            }
            if (privList == null || components.contains(privList[0])) {
                if (filesList != null && filesList[0] != null) {
                    bRet = this.checkFileExists(element, shareComponentDir, filesList);
                } else if (!this.checkDirExists(element, shareComponentDir)) {
                    bRet = false;
                }
            }
            if (bRet) continue;
            if (privList != null && privList[1].equals("false")) {
                configLogger.log(Level.INFO, "PSFB_CSPFC0085", element);
                continue;
            }
            configLogger.log(Level.INFO, "PSFB_CSPFC0168", element);
            break;
        }
        return bRet;
    }

    private boolean checkDirExists(String token, String value) {
        File dir = new File(value);
        boolean bIsDir = dir.isDirectory();
        configLogger.log(Level.INFO, bIsDir ? "PSFB_CSPFC0058" : "PSFB_CSPFC0059", new String[]{token, value});
        return bIsDir;
    }

    private boolean checkFileExists(String sharedComponent, String sharedComponentLocation, String[] files) {
        boolean bIsFile = true;
        for (int i = 0; i < files.length; ++i) {
            File shareComponentFile = new File(sharedComponentLocation, files[i]);
            if (!shareComponentFile.isFile()) {
                configLogger.log(Level.SEVERE, "PSFB_CSPFC0167", shareComponentFile.toString());
                this.checkDirExists(sharedComponent, sharedComponentLocation);
                bIsFile = false;
                break;
            }
            configLogger.log(Level.INFO, "PSFB_CSPFC0166", shareComponentFile.toString());
        }
        return bIsFile;
    }

    private boolean checkPSAMInstallData(PortalConfigData pci) {
        boolean bRet = true;
        bRet = this.checkFileExists("AccessManagerProdDir", pci.getAMProdDir(), new String[]{"lib/am_sdk.jar"});
        if (!(bRet &= this.checkFileExists("PortalServerProdDir", pci.getPSProdDir(), new String[]{"lib/config.jar", "lib/fabric.jar"}))) {
            return bRet;
        }
        if (this.checkDirExists("AccessManagerDataDir", pci.getAMDataDir()) && this.checkDirExists("AccessManagerConfigDir", pci.getAMConfigDir()) && this.checkDirExists("PortalServerConfigDir", pci.getPSConfigDir()) && this.checkDirExists("PortalServerDataDir", pci.getPSDataDir())) {
            String sAMConfigFile = pci.getAMConfigFile();
            if (sAMConfigFile == null || sAMConfigFile.trim().equals("")) {
                configLogger.log(Level.SEVERE, "PSFB_CSPFC0086", sAMConfigFile);
                return false;
            }
            File amAccessFile = new File(pci.getAMConfigDir() + FS + sAMConfigFile);
            if (!(amAccessFile.exists() && amAccessFile.canRead() && amAccessFile.canWrite())) {
                return false;
            }
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0061", amAccessFile.getAbsolutePath());
        } else {
            bRet = false;
        }
        return bRet;
    }

    private boolean validateSearchServerData(Map searchServerData) {
        if (searchServerData == null || searchServerData.isEmpty()) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0077");
            return true;
        }
        HashSet<String> portNos = new HashSet<String>();
        Iterator iter = searchServerData.keySet().iterator();
        while (iter.hasNext()) {
            String searchServerID = (String)iter.next();
            Properties SearchServerWCDetails = (Properties)searchServerData.get(searchServerID);
            if (!portNos.add(SearchServerWCDetails.getProperty("Port"))) {
                configLogger.log(Level.SEVERE, "PSFB_CSPFC0072");
                return false;
            }
            try {
                Properties searchServerWCDetailsMap = SearchServerWCDetails;
                WebContainer wc = WebContainerFactory.getWebContainer((Map)searchServerWCDetailsMap, (Logger)configLogger, (boolean)true);
            }
            catch (Exception e) {
                configLogger.log(Level.SEVERE, e.getMessage());
                if (configLogger.isLoggable(Level.SEVERE)) {
                    LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFC0071");
                    record.setLoggerName(configLogger.getName());
                    record.setThrown(e);
                    configLogger.log(record);
                }
                return false;
            }
        }
        return true;
    }

    private boolean validateSRAComponentData(PortalConfigData pci, String component, String dsHost, int dsPort) {
        Map sraComponentData = null;
        if (component != null && pci != null) {
            if (component.equalsIgnoreCase("COMP_NETLET_PROXY")) {
                sraComponentData = pci.getNetletProxyDetails();
            } else if (component.equalsIgnoreCase("COMP_REWRITER_PROXY")) {
                sraComponentData = pci.getRewriterProxyDetails();
            } else if (component.equalsIgnoreCase("COMP_GATEWAY")) {
                sraComponentData = pci.getGatewayDetails();
            }
        }
        if (sraComponentData == null || sraComponentData.isEmpty()) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0177");
            return false;
        }
        Iterator iter = sraComponentData.keySet().iterator();
        while (iter.hasNext()) {
            String instanceID = (String)iter.next();
            configLogger.log(Level.INFO, "PSFB_CSPFC0179", instanceID);
            Properties sraInstanceProp = (Properties)sraComponentData.get(instanceID);
            if (dsHost != null) {
                try {
                    connection.connect(dsHost, dsPort);
                    if (!this.validateCredentials("uid=amService-srapGateway,ou=agents," + pcc.getDefaultOrganization(), sraInstanceProp.getProperty("LogUserPassword"))) {
                        return false;
                    }
                    connection.disconnect();
                }
                catch (LDAPException e) {
                    return false;
                }
            }
            String host = sraInstanceProp.getProperty("Host");
            String ipAddress = sraInstanceProp.getProperty("IPAddress");
            String port = sraInstanceProp.getProperty("Port");
            try {
                Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                configLogger.log(Level.SEVERE, "PSFB_CSPFC0192", new String[]{port, instanceID});
                return false;
            }
            if (!NetworkUtil.isHostValid((String)host)) {
                configLogger.log(Level.SEVERE, "PSFB_CSPFC0170", host);
                return false;
            }
            if (!NetworkUtil.validateIPAddressAndHost((String)host, (String)ipAddress)) {
                configLogger.log(Level.SEVERE, "PSFB_CSPFC0171", new String[]{host, ipAddress});
                return false;
            }
            if (NetworkUtil.isPortValid((String)host, (String)port)) {
                configLogger.log(Level.SEVERE, "PSFB_CSPFC0207", new String[]{host, port});
                return false;
            }
            configLogger.log(Level.INFO, "PSFB_CSPFC0195", new String[]{instanceID, host, port, ipAddress});
        }
        configLogger.log(Level.INFO, "PSFB_CSPFC0197");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validatePortalServerData(Map portalServerData) {
        HashSet<String> portNos = new HashSet<String>();
        HashSet<String> instanceIDs = new HashSet<String>();
        Iterator iter = portalServerData.keySet().iterator();
        try {
            while (iter.hasNext()) {
                Map portalInstances;
                configLogger.log(Level.INFO, "PSFB_CSPFC0064");
                String portalID = (String)iter.next();
                if (portalID == null || portalID.trim().length() == 0) {
                    configLogger.log(Level.SEVERE, "PSFB_CSPFC0028");
                    return false;
                }
                ArrayList psData = (ArrayList)portalServerData.get(portalID);
                Iterator e = psData.iterator();
                String portalwebappURI = e.hasNext() ? (String)e.next() : "";
                String portalAccessURL = e.hasNext() ? (String)e.next() : "";
                String searchServerID = e.hasNext() ? (String)e.next() : "";
                String configureDevSample = e.hasNext() ? (String)e.next() : null;
                String configureEntSample = e.hasNext() ? (String)e.next() : null;
                String configureCommunitySample = e.hasNext() ? (String)e.next() : null;
                List profiler = e.hasNext() ? (List)e.next() : new ArrayList();
                List mail = e.hasNext() ? (List)e.next() : new ArrayList();
                List calendar = e.hasNext() ? (List)e.next() : new ArrayList();
                List addressBook = e.hasNext() ? (List)e.next() : new ArrayList();
                List instantMessenger = e.hasNext() ? (List)e.next() : new ArrayList();
                Map map = portalInstances = e.hasNext() ? (Map)e.next() : null;
                if (!portalwebappURI.startsWith("/")) {
                    configLogger.log(Level.SEVERE, "PSFB_CSPFC0088", portalwebappURI);
                    return false;
                }
                try {
                    new URL(portalAccessURL);
                }
                catch (MalformedURLException me) {
                    configLogger.log(Level.SEVERE, "PSFB_CSPFC0065", portalAccessURL);
                    return false;
                }
                if (!(configureDevSample == null && configureEntSample == null && configureCommunitySample == null || searchServerID != null && !searchServerID.trim().equals(""))) {
                    configLogger.log(Level.SEVERE, "PSFB_CSPFC0066");
                }
                if (portalInstances == null) continue;
                Iterator itr = portalInstances.keySet().iterator();
                while (itr.hasNext()) {
                    String instanceID = (String)itr.next();
                    Properties webconfigprop = (Properties)portalInstances.get(instanceID);
                    if (!portNos.add(webconfigprop.getProperty("Port"))) {
                        configLogger.log(Level.SEVERE, "PSFB_CSPFC0072");
                        return false;
                    }
                    if (!instanceIDs.add(instanceID)) {
                        configLogger.log(Level.SEVERE, "PSFB_CSPFC0072");
                        return false;
                    }
                    try {
                        Properties wcAttribs = webconfigprop;
                        WebContainer wc = WebContainerFactory.getWebContainer((Map)wcAttribs, (Logger)configLogger, (boolean)true);
                    }
                    catch (Exception e0) {
                        configLogger.log(Level.SEVERE, e0.getMessage());
                        if (!configLogger.isLoggable(Level.SEVERE)) return false;
                        LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFC0070");
                        record.setLoggerName(configLogger.getName());
                        record.setThrown(e0);
                        configLogger.log(record);
                        return false;
                    }
                }
                continue;
                return true;
            }
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0070", e);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String OSStr = System.getProperty("os.name");
        bLinux = OSStr.indexOf("Linux") != -1;
        configLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$config$ValidatePortalInputData == null ? (class$com$sun$portal$fabric$config$ValidatePortalInputData = ValidatePortalInputData.class$("com.sun.portal.fabric.config.ValidatePortalInputData")) : class$com$sun$portal$fabric$config$ValidatePortalInputData));
        pc = new PortalConfigurator();
        try {
            pcc = pc.getPSConfigContext();
        }
        catch (ConfigurationException ex) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0244");
        }
        connection = LDAPUtil.getLDAPConnection((String)pcc.getDirectoryServerHost(), (String)pcc.getDirectoryServerPort(), (String)pcc.getUserDataStoreManager(), (String)pcc.getUserDataStoreManagerCredentials(), (boolean)pcc.isDomainDataSecure());
        sharedComponentsCheckData = new HashMap();
        sharedComponentsCheckData.put("CacaoConfigDir", new String[]{"cacao.properties"});
        if (bLinux) {
            sharedComponentsCheckData.put("CacaoProdDir", new String[]{"bin/cacaoadm", "/share/lib/cacao_cacao.jar"});
        } else {
            sharedComponentsCheckData.put("CacaoProdDir", new String[]{"bin/cacaoadm", "/lib/cacao_cacao.jar"});
        }
        sharedComponentsCheckData.put("JDMKLibDir", new String[]{"jmxremote_optional.jar"});
        sharedComponentsCheckData.put("JSSJarDir", new String[]{"jss4.jar"});
        sharedComponentsCheckData.put("JavaHome", new String[]{"/bin/java", "/bin/jar", "/lib/tools.jar"});
        sharedComponentsCheckData.put("NSSLibDir", new String[]{null});
        sharedComponentsCheckData.put("SharedLibDir", new String[]{"ldapjdk.jar"});
        sharedComponentsCheckData.put("DerbyLibDir", new String[]{"derby.jar"});
        sharedComponentsCheckData.put("AntLibDir", new String[]{"ant.jar"});
        sharedComponentsCheckData.put("AntHomeDir", new String[]{"bin/ant"});
        sharedComponentsCheckData.put("RegistryLibDir", new String[]{"omar-common.jar"});
        sharedComponentsCheckData.put("WebNFSLibDir", new String[]{"webnfs.zip"});
        sharedComponentsCheckData2 = new HashMap();
        sharedComponentsCheckData2.put("DerbyLibDir", new String[]{COMP_PORTAL_SERVER, "true"});
        sharedComponentsCheckData2.put("AntLibDir", new String[]{COMP_PORTAL_SERVER, "true"});
        sharedComponentsCheckData2.put("AntHomeDir", new String[]{COMP_PORTAL_SERVER, "true"});
        sharedComponentsCheckData2.put("RegistryLibDir", new String[]{COMP_PORTAL_SERVER, "false"});
        sharedComponentsCheckData2.put("WebNFSLibDir", new String[]{COMP_SRA_CORE, "true"});
        allComponentsList = new ArrayList();
        allComponentsList.add(COMP_PORTAL_SERVER);
        allComponentsList.add(COMP_SRA_CORE);
        allComponentsList.add(COMP_NETLET_PROXY);
        allComponentsList.add(COMP_REWRITER_PROXY);
        allComponentsList.add(COMP_GATEWAY);
    }
}

