/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.config;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.log.common.PortalLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.jdom.Attribute;

public class SamplePortals
implements BuildListener {
    private PSConfigContext pscContext;
    private static String fs = File.separator;
    private static String samplesBaseDir;
    private static String sharedBaseDir;
    private static String buildfile;
    private static String logDir;
    private static String tmpDir;
    private static Logger logger;
    Vector portalTargets = null;
    Vector postTargets = null;
    Vector sraTargets = null;
    Vector uninstallTargets = null;
    private static String INPUT_FILE;
    private static String PASSWORD_FILE;
    private static String COMMS_FILE;
    private static String COMMUNITY_PORTAL;
    private static String COMMUNITY_POST;
    private static String COMMUNITY_SRA;
    private static String DEVELOPER_PORTAL;
    private static String DEVELOPER_POST;
    private static String DEVELOPER_SRA;
    private static String ENTERPRISE_PORTAL;
    private static String ENTERPRISE_POST;
    private static String ENTERPRISE_SRA;
    private static String WELCOME_PORTAL;
    private static String WELCOME_POST;
    private static String TEMPLATE;
    private static String LOG;
    private String SHARED_BUILD_FILE = "build.xml";
    private static String INSTALL_REDEPLOY;
    private static String UNINSTALL_SAMPLES;
    private static String PORTALS;
    private static String SAMPLES;
    private static String SHARED;
    private static String ANT_INSTANCE_PROP;
    private static String PROFILER_EMAIL;
    private static String PROFILER_SMTP;
    private static String PROTOCOL;
    private static String HOST;
    private static String PORT;
    private static String SMTP_HOST;
    private static String SMTP_PORT;
    private static String CLIENT_PROTOCOL;
    private static String CLIENT_HOST;
    private static String CLIENT_PORT;
    private static String WEBAPP_URI;
    private static String DOMAIN;
    private static String CODEBASE;
    private String CONFIG_LOGFILE = "portal.samples.";
    private String CONFIG_SRA_LOGFILE = "portal.samples.sra";
    private String UNCONFIG_LOGFILE = "portal.samples.unconfig";
    static /* synthetic */ Class class$com$sun$portal$fabric$config$SamplePortals;

    public SamplePortals(PSConfigContext pcc) {
        this.pscContext = pcc;
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$config$SamplePortals == null ? (class$com$sun$portal$fabric$config$SamplePortals = SamplePortals.class$("com.sun.portal.fabric.config.SamplePortals")) : class$com$sun$portal$fabric$config$SamplePortals));
        logDir = pcc.getPSDataDir() + fs + "logs" + fs + "config";
        tmpDir = this.pscContext.getPSDataDir() + fs + "tmp";
        samplesBaseDir = pcc.getPSBaseDir() + fs + SAMPLES + fs + PORTALS;
        sharedBaseDir = samplesBaseDir + fs + SHARED;
        buildfile = samplesBaseDir + fs + this.SHARED_BUILD_FILE;
        this.portalTargets = new Vector();
        this.postTargets = new Vector();
        this.sraTargets = new Vector();
        this.uninstallTargets = new Vector();
    }

    public void configure(boolean configDeveloper, boolean configEnterprise, boolean configCommunity, String portalID, String portalAccessURL, String portalWebappURI, String amAdminPassword, String amldapuserPassword, String searchID, String searchURL, List portalInstances, List profiler, List addressbook, List calendar, List instantmessenger, List mail, MBeanServerConnection msc) {
        if (configDeveloper || configEnterprise || configCommunity) {
            logger.log(Level.INFO, "PSFB_CSPFC0078");
            this.setConfigCommunity(configCommunity);
            this.setConfigDeveloper(configDeveloper);
            this.setConfigEnterprise(configEnterprise);
            this.setConfigWelcome(configCommunity, configDeveloper, configEnterprise);
            this.portalTargets.add(INSTALL_REDEPLOY);
            this.portalTargets.addAll(this.postTargets);
            this.generatePasswordFile(amAdminPassword, amldapuserPassword);
            this.generateInputFile(portalID, portalAccessURL, portalWebappURI, amAdminPassword, searchID, searchURL, profiler);
            this.generateCommsFile(addressbook, calendar, instantmessenger, mail);
            String logprefix = this.CONFIG_LOGFILE + portalID;
            this.runant(this.portalTargets, logprefix, null, null);
            this.removePasswordFile();
            logger.log(Level.INFO, "PSFB_CSPFC0080");
        } else {
            logger.log(Level.INFO, "PSFB_CSPFC0079");
        }
    }

    public void configureSRA(String amAdminPassword, String amldapuserPassword) {
        this.generatePasswordFile(amAdminPassword, amldapuserPassword);
        this.runant(this.sraTargets, this.CONFIG_SRA_LOGFILE, null, null);
        this.removePasswordFile();
    }

    public void unconfigure(String amAdminPassword, String amldapuserPassword) {
        logger.log(Level.INFO, "PSFB_CSPFC0082");
        this.generatePasswordFile(amAdminPassword, amldapuserPassword);
        this.uninstallTargets.add(UNINSTALL_SAMPLES);
        this.runant(this.uninstallTargets, this.UNCONFIG_LOGFILE, null, null);
        this.removePasswordFile();
        logger.log(Level.INFO, "PSFB_CSPFC0162");
    }

    public void runant(Vector targets, String logName, String key, String val) {
        String logfile = logDir + fs + logName + LOG;
        Project project = new Project();
        DefaultLogger antlogger = new DefaultLogger();
        try {
            PrintStream logstream = new PrintStream(new FileOutputStream(logfile));
            antlogger.setErrorPrintStream(logstream);
            antlogger.setOutputPrintStream(logstream);
            antlogger.setMessageOutputLevel(2);
            project.addBuildListener((BuildListener)antlogger);
            project.addBuildListener((BuildListener)this);
            project.fireBuildStarted();
            project.init();
            project.setUserProperty("ant.file", buildfile);
            project.setUserProperty("config.location", tmpDir);
            if (key != null) {
                project.setUserProperty(key, val);
            }
            Object[] params = new String[]{project.getUserProperties().toString(), targets.toString()};
            logger.log(Level.INFO, "PSFB_CSPFC0081", this.pscContext.getAntLibDir());
            logger.log(Level.INFO, "PSFB_CSPFC0083", params);
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            helper.parse(project, (Object)new File(buildfile));
            project.executeTargets(targets);
            project.fireBuildFinished(null);
            logstream.close();
        }
        catch (Exception e) {
            project.fireBuildFinished((Throwable)e);
        }
    }

    public void setConfigWelcome(boolean community, boolean developer, boolean enterprise) {
        if (community || developer || enterprise) {
            this.portalTargets.add(WELCOME_PORTAL);
        }
    }

    public void setConfigDeveloper(boolean val) {
        if (val) {
            this.portalTargets.add(DEVELOPER_PORTAL);
            this.postTargets.add(DEVELOPER_POST);
            this.sraTargets.add(DEVELOPER_SRA);
        }
    }

    public void setConfigEnterprise(boolean val) {
        if (val) {
            this.portalTargets.add(ENTERPRISE_PORTAL);
            this.sraTargets.add(ENTERPRISE_SRA);
        }
    }

    public void setConfigCommunity(boolean val) {
        if (val) {
            this.portalTargets.add(COMMUNITY_PORTAL);
            this.sraTargets.add(COMMUNITY_SRA);
        }
    }

    private void generateInputFile(String portalID, String portalAccessURL, String portalWebappURI, String amAdminPassword, String searchID, String searchURL, List profiler) {
        File file = this.getSharedAntFile(INPUT_FILE);
        FileUtil.replaceTokenInFile((File)file, (String)"%DEFAULT_ORG_DN%", (String)this.pscContext.getDefaultOrganization());
        FileUtil.replaceTokenInFile((File)file, (String)"%AM.ADMIN.DN%", (String)this.pscContext.getAdminUserDN());
        FileUtil.replaceTokenInFile((File)file, (String)"%PS_CONFIG_LOCATION%", (String)this.pscContext.getPSConfigDir());
        FileUtil.replaceTokenInFile((File)file, (String)"%PORTAL_ID%", (String)portalID);
        FileUtil.replaceTokenInFile((File)file, (String)"%PORTAL_ACCESS_URL%", (String)portalAccessURL);
        FileUtil.replaceTokenInFile((File)file, (String)"%PORTAL_WEBAPP_URI%", (String)portalWebappURI);
        FileUtil.replaceTokenInFile((File)file, (String)"%SEARCH_ACCESS_URL%", (String)searchURL);
        FileUtil.replaceTokenInFile((File)file, (String)"%SEARCH_ID%", (String)searchID);
        String profilerEmail = "";
        String profilerSMTP = "";
        if (!profiler.isEmpty()) {
            HashMap<String, String> pmap = new HashMap<String, String>(profiler.size());
            Iterator it = profiler.iterator();
            while (it.hasNext()) {
                Attribute attr = (Attribute)it.next();
                pmap.put(attr.getName(), attr.getValue());
            }
            profilerEmail = (String)pmap.get(PROFILER_EMAIL);
            profilerSMTP = (String)pmap.get(PROFILER_SMTP);
        }
        FileUtil.replaceTokenInFile((File)file, (String)"%PROFILER_EMAIL%", (String)profilerEmail);
        FileUtil.replaceTokenInFile((File)file, (String)"%PROFILER_SMTP_HOST%", (String)profilerSMTP);
    }

    private void generateCommsFile(List ab, List calendar, List im, List mail) {
        File file = this.getSharedAntFile(COMMS_FILE);
        if (!ab.isEmpty()) {
            HashMap<String, String> abMap = new HashMap<String, String>(ab.size());
            Iterator abIt = ab.iterator();
            while (abIt.hasNext()) {
                Attribute abAttr = (Attribute)abIt.next();
                abMap.put(abAttr.getName(), abAttr.getValue());
            }
            FileUtil.replaceTokenInFile((File)file, (String)"%AB_PROTOCOL%", (String)((String)abMap.get(PROTOCOL)));
            FileUtil.replaceTokenInFile((File)file, (String)"%AB_HOST%", (String)((String)abMap.get(HOST)));
            FileUtil.replaceTokenInFile((File)file, (String)"%AB_PORT%", (String)((String)abMap.get(PORT)));
            FileUtil.replaceTokenInFile((File)file, (String)"%AB_CLIENT_PROTOCOL%", (String)((String)abMap.get(CLIENT_PROTOCOL)));
            FileUtil.replaceTokenInFile((File)file, (String)"%AB_CLIENT_HOST%", (String)((String)abMap.get(CLIENT_HOST)));
            FileUtil.replaceTokenInFile((File)file, (String)"%AB_CLIENT_PORT%", (String)((String)abMap.get(CLIENT_PORT)));
            FileUtil.replaceTokenInFile((File)file, (String)"%AB_WEBAPP_URI%", (String)((String)abMap.get(WEBAPP_URI)));
            FileUtil.replaceTokenInFile((File)file, (String)"%AB_DOMAIN%", (String)((String)abMap.get(DOMAIN)));
        }
        if (!calendar.isEmpty()) {
            HashMap<String, String> calMap = new HashMap<String, String>(calendar.size());
            Iterator calIt = calendar.iterator();
            while (calIt.hasNext()) {
                Attribute calAttr = (Attribute)calIt.next();
                calMap.put(calAttr.getName(), calAttr.getValue());
            }
            FileUtil.replaceTokenInFile((File)file, (String)"%CAL_PROTOCOL%", (String)((String)calMap.get(PROTOCOL)));
            FileUtil.replaceTokenInFile((File)file, (String)"%CAL_HOST%", (String)((String)calMap.get(HOST)));
            FileUtil.replaceTokenInFile((File)file, (String)"%CAL_PORT%", (String)((String)calMap.get(PORT)));
            FileUtil.replaceTokenInFile((File)file, (String)"%CAL_CLIENT_PROTOCOL%", (String)((String)calMap.get(CLIENT_PROTOCOL)));
            FileUtil.replaceTokenInFile((File)file, (String)"%CAL_CLIENT_HOST%", (String)((String)calMap.get(CLIENT_HOST)));
            FileUtil.replaceTokenInFile((File)file, (String)"%CAL_CLIENT_PORT%", (String)((String)calMap.get(CLIENT_PORT)));
            FileUtil.replaceTokenInFile((File)file, (String)"%CAL_WEBAPP_URI%", (String)((String)calMap.get(WEBAPP_URI)));
            FileUtil.replaceTokenInFile((File)file, (String)"%CAL_DOMAIN%", (String)((String)calMap.get(DOMAIN)));
        }
        if (!mail.isEmpty()) {
            HashMap<String, String> mMap = new HashMap<String, String>(mail.size());
            Iterator mailIt = mail.iterator();
            while (mailIt.hasNext()) {
                Attribute mailAttr = (Attribute)mailIt.next();
                mMap.put(mailAttr.getName(), mailAttr.getValue());
            }
            FileUtil.replaceTokenInFile((File)file, (String)"%MAIL_IMAP_HOST%", (String)((String)mMap.get(HOST)));
            FileUtil.replaceTokenInFile((File)file, (String)"%MAIL_IMAP_PORT%", (String)((String)mMap.get(PORT)));
            FileUtil.replaceTokenInFile((File)file, (String)"%MAIL_SMTP_HOST%", (String)((String)mMap.get(SMTP_HOST)));
            FileUtil.replaceTokenInFile((File)file, (String)"%MAIL_SMTP_PORT%", (String)((String)mMap.get(SMTP_PORT)));
            FileUtil.replaceTokenInFile((File)file, (String)"%MAIL_CLIENT_PROTOCOL%", (String)((String)mMap.get(CLIENT_PROTOCOL)));
            FileUtil.replaceTokenInFile((File)file, (String)"%MAIL_CLIENT_HOST%", (String)((String)mMap.get(CLIENT_HOST)));
            FileUtil.replaceTokenInFile((File)file, (String)"%MAIL_CLIENT_PORT%", (String)((String)mMap.get(CLIENT_PORT)));
            FileUtil.replaceTokenInFile((File)file, (String)"%MAIL_WEBAPP_URI%", (String)((String)mMap.get(WEBAPP_URI)));
            FileUtil.replaceTokenInFile((File)file, (String)"%MAIL_DOMAIN%", (String)((String)mMap.get(DOMAIN)));
        }
        if (!im.isEmpty()) {
            HashMap<String, String> imMap = new HashMap<String, String>(im.size());
            Iterator imIt = im.iterator();
            while (imIt.hasNext()) {
                Attribute imAttr = (Attribute)imIt.next();
                imMap.put(imAttr.getName(), imAttr.getValue());
            }
            FileUtil.replaceTokenInFile((File)file, (String)"%IM_HOST%", (String)((String)imMap.get(HOST)));
            FileUtil.replaceTokenInFile((File)file, (String)"%IM_PORT%", (String)((String)imMap.get(PORT)));
            FileUtil.replaceTokenInFile((File)file, (String)"%IM_CODEBASE%", (String)((String)imMap.get(CODEBASE)));
        }
    }

    private void generatePasswordFile(String amAdminPassword, String amldapuser) {
        File file = this.getSharedAntFile(PASSWORD_FILE);
        FileUtil.replaceTokenInFile((File)file, (String)"%AMADMIN_PASSWORD%", (String)amAdminPassword);
        FileUtil.replaceTokenInFile((File)file, (String)"%AMLDAPUSER_PASSWORD%", (String)amldapuser);
    }

    private File getSharedAntFile(String filename) {
        StringBuffer fromFile = new StringBuffer();
        StringBuffer toFile = new StringBuffer();
        String baseLocation = sharedBaseDir;
        fromFile.append(baseLocation).append(fs).append(filename).append(TEMPLATE);
        toFile.append(tmpDir).append(fs).append(filename);
        FileUtil.copyFile((String)fromFile.toString(), (String)toFile.toString());
        File file = new File(toFile.toString());
        return file;
    }

    public void removePasswordFile() {
        String filename = tmpDir + fs + PASSWORD_FILE;
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
        }
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        if (error != null) {
            Object[] param = new String[]{error instanceof BuildException ? error.toString() : error.getMessage()};
            logger.log(Level.SEVERE, "PSFB_CSPFC0084", param);
        }
    }

    public void buildStarted(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        INPUT_FILE = "input.properties";
        PASSWORD_FILE = "password.properties";
        COMMS_FILE = "comms.properties";
        COMMUNITY_PORTAL = "community_portal";
        COMMUNITY_POST = "community_post";
        COMMUNITY_SRA = "community_sra";
        DEVELOPER_PORTAL = "developer_portal";
        DEVELOPER_POST = "developer_post";
        DEVELOPER_SRA = "developer_sra";
        ENTERPRISE_PORTAL = "enterprise_portal";
        ENTERPRISE_POST = "enterprise_post";
        ENTERPRISE_SRA = "enterprise_sra";
        WELCOME_PORTAL = "welcome_portal";
        WELCOME_POST = "welcome_post";
        TEMPLATE = ".template";
        LOG = ".log";
        INSTALL_REDEPLOY = "install_redeploy";
        UNINSTALL_SAMPLES = "uninstall_samples";
        PORTALS = "portals";
        SAMPLES = "samples";
        SHARED = "shared";
        ANT_INSTANCE_PROP = "ps.instance.id";
        PROFILER_EMAIL = "ProfilerFromEmailAddress";
        PROFILER_SMTP = "ProfilerSMTPHost";
        PROTOCOL = "Protocol";
        HOST = "Host";
        PORT = "Port";
        SMTP_HOST = "SMTPHost";
        SMTP_PORT = "SMTPPort";
        CLIENT_PROTOCOL = "ClientProtocol";
        CLIENT_HOST = "ClientHost";
        CLIENT_PORT = "ClientPort";
        WEBAPP_URI = "WebappURI";
        DOMAIN = "Domain";
        CODEBASE = "Codebase";
    }
}

