/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.config;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PSConfigContextImpl;
import com.sun.portal.admin.common.util.AdminClientUtil;
import com.sun.portal.fabric.config.PortalConfigData;
import com.sun.portal.fabric.config.SamplePortals;
import com.sun.portal.fabric.tasks.Cacao;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.Derby;
import com.sun.portal.fabric.tasks.Domain;
import com.sun.portal.fabric.tasks.EnableServices;
import com.sun.portal.fabric.util.AMUtil;
import com.sun.portal.fabric.util.AntUtil;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.LogConfigUtil;
import com.sun.portal.fabric.util.os.OSTasks;
import com.sun.portal.fabric.util.os.OSTasksFactory;
import com.sun.portal.log.common.PortalLogManager;
import com.sun.portal.log.common.PortalLogger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import sun.misc.BASE64Encoder;

public class PortalConfigurator {
    private static Logger configLogger;
    private LogRecord record;
    public static final String FS;
    private JMXConnector m_connector;
    private static final String SunCopyRightMsg;
    private HashMap portalIDs = new HashMap();
    private String successURL;
    private Properties gwConfigProperties;
    private Properties nlpConfigProperties;
    private Properties rwpConfigProperties;
    private SamplePortals samplePortals = null;
    private Derby derby = null;
    static /* synthetic */ Class class$com$sun$portal$fabric$config$PortalConfigurator;

    public PortalConfigurator() {
        configLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$config$PortalConfigurator == null ? (class$com$sun$portal$fabric$config$PortalConfigurator = PortalConfigurator.class$("com.sun.portal.fabric.config.PortalConfigurator")) : class$com$sun$portal$fabric$config$PortalConfigurator));
    }

    protected static void createPortalDirectories(PortalConfigData pci) {
        String psConfigDir = pci.getPSConfigDir();
        FileUtil.copyDir((String)(pci.getPSProdDir() + FS + "template" + FS + "config"), (String)psConfigDir);
        System.out.println("Copying config templates from: " + pci.getPSProdDir() + FS + "template" + FS + "config");
        String psDataDir = pci.getPSDataDir();
        if (!FileUtil.directoryExists((String)psDataDir)) {
            FileUtil.makeDir((String)psDataDir);
            FileUtil.makeDir((String)(psDataDir + FS + "tmp"));
            FileUtil.makeDir((String)(psDataDir + FS + "tmp" + FS + "portlet"));
        }
    }

    protected static void preparePropertyFiles(PortalConfigData pci) throws ConfigurationException {
        try {
            String configLoc = pci.getPSConfigDir();
            if (!configLoc.equals("/etc/opt/SUNWportal")) {
                File psEnvFile = new File(pci.getPSProdDir() + FS + "lib" + FS + "psEnv.sh");
                String pattern = "# Override";
                String text = "PS_CONFIG_DIR=" + configLoc;
                FileUtil.appendLineInFile((File)psEnvFile, (String)pattern, (String)text);
            }
            PortalConfigurator.preparePortalDomainConfigPropFile(pci);
            PortalConfigurator.prepareLogConfigPropFile(pci);
            new PortalLogManager().init("debug.com.sun.portal.fabric");
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private static void preparePortalDomainConfigPropFile(PortalConfigData pci) {
        String TemplateDirLocation = pci.getPSProdDir() + FS + "template";
        String domainDir = pci.getPSConfigDir() + FS + "domains" + FS + "defaultDomain";
        FileUtil.makeDir((String)domainDir);
        FileUtil.copyFile((String)(TemplateDirLocation + FS + "PortalDomainConfig.properties"), (String)(domainDir + FS + "PortalDomainConfig.properties"));
        File PortalDomainConfigFile = new File(domainDir + FS + "PortalDomainConfig.properties");
        String pattern = "domain.users.datastore.manager=";
        String text = pattern + pci.getDirectoryManagerDN();
        FileUtil.replaceLineInFile((File)PortalDomainConfigFile, (String)pattern, (String)text);
        pattern = "domain.users.datastore.manager.password=";
        String password = pci.getDirectoryManagerPassword();
        if (password == null) {
            password = "";
        } else {
            try {
                byte[] passwordBytes = password.getBytes("8859_1");
                password = new BASE64Encoder().encodeBuffer(passwordBytes);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        text = pattern + password;
        FileUtil.replaceLineInFile((File)PortalDomainConfigFile, (String)pattern, (String)text);
        pattern = "domain.users.auth.configuration=";
        text = pattern + pci.getAMConfigDir() + FS + pci.getAMConfigFile();
        FileUtil.replaceLineInFile((File)PortalDomainConfigFile, (String)pattern, (String)text);
        System.out.println("Successfully created PortalDomainConfig.properties file");
    }

    protected void updatePSConfigFile(Properties psconfig, PortalConfigData pci) throws ConfigurationException {
        try {
            PSConfigContext pcc = this.getPSConfigContext();
            if (!pci.isOnlySRAComponentInstalled()) {
                SSOToken amSSOToken = AMUtil.createSSOToken((String)pci.getAMAdmin(), (String)pci.getAMAdminPassword(), (String)pcc.getDefaultOrganization());
                if (SSOTokenManager.getInstance().isValidToken(amSSOToken)) {
                    psconfig.setProperty("user.naming.attribute", AMUtil.getUserNamingAttribute((SSOToken)amSSOToken));
                    psconfig.setProperty("org.naming.attribute", AMUtil.getOrgNamingAttribute((SSOToken)amSSOToken));
                    psconfig.setProperty("role.naming.attribute", AMUtil.getRoleNamingAttribute((SSOToken)amSSOToken));
                    psconfig.setProperty("peoplecontainer.naming.attribute", AMUtil.getPeopleContainerNamingAttribute((SSOToken)amSSOToken));
                    psconfig.setProperty("amldap.user.dn", pcc.getAMSpecialUsersDN().replaceFirst("dsameuser", pci.getLDAPUserId()));
                    SSOTokenManager.getInstance().destroyToken(amSSOToken);
                }
            }
            File psConfigFile = new File(pci.getPSConfigDir() + FS + "PSConfig.properties");
            FileOutputStream out = new FileOutputStream(psConfigFile);
            psconfig.store(out, SunCopyRightMsg);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void createSRAConfigPropFile(PortalConfigData pci) {
        Properties prop = new Properties();
        File sraConfigFile = new File(pci.getPSConfigDir() + FS + "SRAConfig.properties");
        try {
            FileOutputStream out = new FileOutputStream(sraConfigFile);
            prop.setProperty("gateway.protocol", pci.getSRAGatewayProtocol());
            prop.setProperty("gateway.port", pci.getSRAGatewayPortNo());
            prop.setProperty("portal.server.domain", pci.getSRAPortalServerDomain());
            prop.setProperty("sra.gateway.profile", pci.getSRAGatewayProfileName());
            prop.store(out, SunCopyRightMsg);
            ((OutputStream)out).close();
            configLogger.log(Level.INFO, "PSFB_CSPFC0016");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    protected void configureGateway(MBeanServerConnection msc, PortalConfigData pci) throws Exception {
        Map gatewayData = pci.getGatewayDetails();
        Iterator iter = gatewayData.keySet().iterator();
        try {
            while (iter.hasNext()) {
                String InstanceName = (String)iter.next();
                Properties gatewayProp = (Properties)gatewayData.get(InstanceName);
                configLogger.log(Level.INFO, "PSFB_CSPFC0008");
                this.createGatewayConfigPropFile(pci, InstanceName, gatewayProp);
                System.out.println("Configuring Gateway Instance " + InstanceName);
                configLogger.log(Level.INFO, "PSFB_CSPFC0090", InstanceName);
                this.configureSRAComponents(msc, "gateway");
            }
        }
        catch (Exception e) {
            System.out.println("Exception while configuring Gateway. Please see the logs for more information");
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0161", e);
            throw e;
        }
    }

    protected void configureNetletProxy(MBeanServerConnection msc, PortalConfigData pci) throws Exception {
        Map netletProxyData = pci.getNetletProxyDetails();
        Iterator iter = netletProxyData.keySet().iterator();
        try {
            while (iter.hasNext()) {
                String InstanceName = (String)iter.next();
                Properties netletProxyProp = (Properties)netletProxyData.get(InstanceName);
                configLogger.log(Level.INFO, "PSFB_CSPFC0010");
                this.createNetletProxyConfigPropFile(pci, InstanceName, netletProxyProp);
                System.out.println("Configuring NetletProxy Instance " + InstanceName);
                configLogger.log(Level.INFO, "PSFB_CSPFC0091", InstanceName);
                this.configureSRAComponents(msc, "nlproxy");
            }
        }
        catch (Exception e) {
            System.out.println("Exception while configuring NetletProxy. Please see the logs for more information");
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0159", e);
            throw e;
        }
    }

    protected void configureRewriterProxy(MBeanServerConnection msc, PortalConfigData pci) throws Exception {
        Map rewriterProxyData = pci.getRewriterProxyDetails();
        Iterator iter = rewriterProxyData.keySet().iterator();
        try {
            while (iter.hasNext()) {
                String InstanceName = (String)iter.next();
                Properties rewriterProxyProp = (Properties)rewriterProxyData.get(InstanceName);
                configLogger.log(Level.INFO, "PSFB_CSPFC0010");
                this.createRewriterProxyConfigPropFile(pci, InstanceName, rewriterProxyProp);
                System.out.println("Configuring RewriterProxy Instance " + InstanceName);
                configLogger.log(Level.INFO, "PSFB_CSPFC0092", InstanceName);
                this.configureSRAComponents(msc, "rwproxy");
            }
        }
        catch (Exception e) {
            System.out.println("Exception while configuring RewriterProxy. Please see the logs for more information");
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0160", e);
            throw e;
        }
    }

    protected void createGatewayConfigPropFile(PortalConfigData pci, String instanceName, Properties gatewayProp) throws ConfigurationException {
        this.gwConfigProperties = new Properties();
        String DS = ",";
        URL portalAccessURL = null;
        try {
            portalAccessURL = new URL(pci.getportalAccessURL());
        }
        catch (MalformedURLException e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0223", portalAccessURL);
            throw new ConfigurationException((Throwable)e);
        }
        String certificateInformation = "CN=\"" + gatewayProp.getProperty("Host") + "\"" + DS + "L=" + "\"" + pci.getcertificateCityOrLocality() + "\"" + DS + "ST=" + "\"" + pci.getcertificateStateProvince() + "\"" + DS + "C=" + "\"" + pci.getcertificateCountryCode() + "\"" + DS + "O=" + "\"" + pci.getcertificateDivision() + "\"" + DS + "OU=" + "\"" + pci.getcertificateOrganization() + "\"";
        this.gwConfigProperties.setProperty("gateway.profile.name", instanceName);
        this.gwConfigProperties.setProperty("start.gateway", gatewayProp.getProperty("StartInstance"));
        this.gwConfigProperties.setProperty("portal.deploy.uri", portalAccessURL.getPath());
        this.gwConfigProperties.setProperty("portal.server.hostname", portalAccessURL.getHost());
        this.gwConfigProperties.setProperty("portal.server.portno", new Integer(portalAccessURL.getPort()).toString());
        this.gwConfigProperties.setProperty("portal.server.protocol", portalAccessURL.getProtocol());
        this.gwConfigProperties.setProperty("gateway.ipaddress", gatewayProp.getProperty("IPAddress"));
        this.gwConfigProperties.setProperty("gateway.hostname", gatewayProp.getProperty("Host"));
        this.gwConfigProperties.setProperty("gateway.portno", gatewayProp.getProperty("Port"));
        this.gwConfigProperties.setProperty("gateway.protocol", gatewayProp.getProperty("Protocol"));
        this.gwConfigProperties.setProperty("sra.log.user.password", gatewayProp.getProperty("LogUserPassword"));
        this.gwConfigProperties.setProperty("generate.selfsigned.certificate", "yes");
        this.gwConfigProperties.setProperty("create.identity.server.instance", "yes");
        this.gwConfigProperties.setProperty("certificate.database.password", pci.getCertifcateDBPassword());
        this.gwConfigProperties.setProperty("certificate.information", certificateInformation);
        configLogger.log(Level.INFO, "PSFB_CSPFC0017");
    }

    protected void createNetletProxyConfigPropFile(PortalConfigData pci, String instanceName, Properties netletProxyProp) throws ConfigurationException {
        this.nlpConfigProperties = new Properties();
        String DS = ",";
        URL portalAccessURL = null;
        try {
            portalAccessURL = new URL(pci.getportalAccessURL());
        }
        catch (MalformedURLException e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0223", portalAccessURL);
            throw new ConfigurationException((Throwable)e);
        }
        String certificateInformation = "CN=\"" + netletProxyProp.getProperty("Host") + "\"" + DS + "L=" + "\"" + pci.getcertificateCityOrLocality() + "\"" + DS + "ST=" + "\"" + pci.getcertificateStateProvince() + "\"" + DS + "C=" + "\"" + pci.getcertificateCountryCode() + "\"" + DS + "O=" + "\"" + pci.getcertificateDivision() + "\"" + DS + "OU=" + "\"" + pci.getcertificateOrganization() + "\"";
        this.nlpConfigProperties.setProperty("netletproxy.profile.name", instanceName);
        this.nlpConfigProperties.setProperty("start.netletproxy", netletProxyProp.getProperty("StartInstance"));
        this.nlpConfigProperties.setProperty("portal.deploy.uri", portalAccessURL.getPath());
        this.nlpConfigProperties.setProperty("portal.server.hostname", portalAccessURL.getHost());
        this.nlpConfigProperties.setProperty("portal.server.portno", new Integer(portalAccessURL.getPort()).toString());
        this.nlpConfigProperties.setProperty("portal.server.protocol", portalAccessURL.getProtocol());
        this.nlpConfigProperties.setProperty("netletproxy.ipaddress", netletProxyProp.getProperty("IPAddress"));
        this.nlpConfigProperties.setProperty("netletproxy.hostname", netletProxyProp.getProperty("Host"));
        this.nlpConfigProperties.setProperty("netletproxy.portno", netletProxyProp.getProperty("Port"));
        this.nlpConfigProperties.setProperty("netletproxy.protocol", netletProxyProp.getProperty("Protocol"));
        this.nlpConfigProperties.setProperty("sra.log.user.password", netletProxyProp.getProperty("LogUserPassword"));
        this.nlpConfigProperties.setProperty("generate.selfsigned.certificate", "yes");
        this.nlpConfigProperties.setProperty("create.identity.server.instance", "yes");
        this.nlpConfigProperties.setProperty("certificate.database.password", pci.getCertifcateDBPassword());
        this.nlpConfigProperties.setProperty("certificate.information", certificateInformation);
        configLogger.log(Level.INFO, "PSFB_CSPFC0018");
    }

    protected void createRewriterProxyConfigPropFile(PortalConfigData pci, String instanceName, Properties rewriterProxyProp) throws ConfigurationException {
        this.rwpConfigProperties = new Properties();
        URL portalAccessURL = null;
        try {
            portalAccessURL = new URL(pci.getportalAccessURL());
        }
        catch (MalformedURLException e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0223", portalAccessURL);
            throw new ConfigurationException((Throwable)e);
        }
        String DS = ",";
        String certificateInformation = "CN=\"" + rewriterProxyProp.getProperty("Host") + "\"" + DS + "L=" + "\"" + pci.getcertificateCityOrLocality() + "\"" + DS + "ST=" + "\"" + pci.getcertificateStateProvince() + "\"" + DS + "C=" + "\"" + pci.getcertificateCountryCode() + "\"" + DS + "O=" + "\"" + pci.getcertificateDivision() + "\"" + DS + "OU=" + "\"" + pci.getcertificateOrganization() + "\"";
        this.rwpConfigProperties.setProperty("rewriterproxy.profile.name", instanceName);
        this.rwpConfigProperties.setProperty("start.rewriterproxy", rewriterProxyProp.getProperty("StartInstance"));
        this.rwpConfigProperties.setProperty("portal.deploy.uri", portalAccessURL.getPath());
        this.rwpConfigProperties.setProperty("portal.server.hostname", portalAccessURL.getHost());
        this.rwpConfigProperties.setProperty("portal.server.portno", new Integer(portalAccessURL.getPort()).toString());
        this.rwpConfigProperties.setProperty("portal.server.protocol", portalAccessURL.getProtocol());
        this.rwpConfigProperties.setProperty("rewriterproxy.ipaddress", rewriterProxyProp.getProperty("IPAddress"));
        this.rwpConfigProperties.setProperty("rewriterproxy.hostname", rewriterProxyProp.getProperty("Host"));
        this.rwpConfigProperties.setProperty("rewriterproxy.portno", rewriterProxyProp.getProperty("Port"));
        this.rwpConfigProperties.setProperty("rewriterproxy.protocol", rewriterProxyProp.getProperty("Protocol"));
        this.rwpConfigProperties.setProperty("sra.log.user.password", rewriterProxyProp.getProperty("LogUserPassword"));
        this.rwpConfigProperties.setProperty("generate.selfsigned.certificate", "yes");
        this.rwpConfigProperties.setProperty("create.identity.server.instance", "yes");
        this.rwpConfigProperties.setProperty("certificate.database.password", pci.getCertifcateDBPassword());
        this.rwpConfigProperties.setProperty("certificate.information", certificateInformation);
        configLogger.log(Level.INFO, "PSFB_CSPFC0019");
    }

    private static byte[] getByteData(InputStream is) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            byte[] byteBuf = new byte[1024];
            int num = 0;
            while ((num = is.read(byteBuf)) != -1) {
                os.write(byteBuf, 0, num);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return os.toByteArray();
    }

    private static void prepareLogConfigPropFile(PortalConfigData pci) throws ConfigurationException {
        String adminLogDestDir;
        boolean excludeAudit = true;
        String configLogDestDir = pci.getPSDataDir() + FS + "logs" + FS + "config";
        try {
            File logConfigFile = LogConfigUtil.getAdminLogConfigFile((String)pci.getPSProdDir(), (String)configLogDestDir, (String)"debug.com.sun.portal", (boolean)excludeAudit);
            File logDestFile = new File(pci.getPSConfigDir() + FS + "PSConfiguratorLogConfig.properties");
            FileUtil.copyFile((File)logConfigFile, (File)logDestFile);
            System.setProperty("com.sun.portal.log.config.file", logDestFile.toString());
        }
        catch (IOException ioe) {
            throw new ConfigurationException((Throwable)ioe);
        }
        String adminLogDestDirForCLI = adminLogDestDir = pci.getPSDataDir() + FS + "logs" + FS + "admin";
        String adminLogDestDirForMBeans = adminLogDestDir;
        try {
            File logConfigFileForCLI = LogConfigUtil.getAdminLogConfigFile((String)pci.getPSProdDir(), (String)adminLogDestDirForCLI, (String)"debug.com.sun.portal.admin.cli", (boolean)excludeAudit);
            File logConfigFileForMBeans = LogConfigUtil.getAdminLogConfigFile((String)pci.getPSProdDir(), (String)adminLogDestDirForMBeans, (String)"debug.com.sun.portal", (!excludeAudit ? 1 : 0) != 0);
            File logDestFile = new File(pci.getPSConfigDir() + FS + "PSAdminLogConfig.properties");
            FileInputStream fis = null;
            fis = new FileInputStream(logConfigFileForCLI);
            byte[] cli = PortalConfigurator.getByteData(fis);
            fis.close();
            fis = new FileInputStream(logConfigFileForMBeans);
            byte[] mbeans = PortalConfigurator.getByteData(fis);
            fis.close();
            FileOutputStream fout = new FileOutputStream(logDestFile);
            fout.write(cli);
            fout.write(mbeans);
            fout.close();
        }
        catch (IOException ioe) {
            throw new ConfigurationException((Throwable)ioe);
        }
    }

    protected PSConfigContext getPSConfigContext() throws ConfigurationException {
        PSConfigContextImpl configCtx = null;
        try {
            configCtx = new PSConfigContextImpl("defaultDomain");
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0097");
            throw new ConfigurationException((Throwable)e);
        }
        return configCtx;
    }

    protected synchronized void configureHost() throws ConfigurationException {
        Cacao cc = new Cacao(this.getPSConfigContext());
        int i = 0;
        try {
            cc.configureDomain();
            String result = cc.getCacaoStatus();
            while (result.indexOf("Cacao uptime") == -1) {
                this.wait(15000L);
                if (i >= 6) {
                    configLogger.log(Level.SEVERE, "PSFB_CSPFC0020");
                    throw new ConfigurationException();
                }
                configLogger.log(Level.INFO, "PSFB_CSPFC0021");
                result = cc.getCacaoStatus();
                ++i;
            }
            configLogger.log(Level.INFO, "PSFB_CSPFC0022");
        }
        catch (InterruptedException e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0023", e);
            throw new ConfigurationException((Throwable)e);
        }
        catch (Exception ex) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0024", ex);
            throw new ConfigurationException((Throwable)ex);
        }
    }

    protected MBeanServerConnection getMbeanServerConnection(String userID, String password, String hostName) throws SecurityException, ConfigurationException {
        try {
            this.m_connector = AdminClientUtil.getJMXConnector((String)hostName, (String)"defaultDomain", (String)userID, (String)password);
            return this.m_connector.getMBeanServerConnection();
        }
        catch (SecurityException se) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0025", se);
            throw new ConfigurationException((Throwable)se);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0026", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void configDerby(PSConfigContext pcc, String hostName) {
        File propFile;
        File buildFile = new File(pcc.getPSBaseDir() + FS + "lib" + FS + "derby.xml");
        if (buildFile.exists() && !(propFile = new File(pcc.getPSDataDir() + FS + "derby" + FS + "derby.properties")).exists()) {
            configLogger.log(Level.INFO, "PSFB_CSPFC0222");
            System.out.println("Configuring Derby Server Instance");
            this.derby = new Derby(pcc, hostName);
            this.derby.configureDerby();
        }
    }

    protected void configurePortal(MBeanServerConnection msc, Map PortalServerData) throws ConfigurationException {
        Iterator iter = PortalServerData.keySet().iterator();
        try {
            while (iter.hasNext()) {
                configLogger.log(Level.INFO, "PSFB_CSPFC0027");
                String portalID = (String)iter.next();
                if (portalID == null) {
                    configLogger.log(Level.SEVERE, "PSFB_CSPFC0028", portalID);
                    return;
                }
                ArrayList psData = (ArrayList)PortalServerData.get(portalID);
                Iterator e = psData.iterator();
                String portalwebappURI = e.hasNext() ? (String)e.next() : "";
                String portalAccessURL = e.hasNext() ? (String)e.next() : "";
                Map portalInstances = e.hasNext() ? (Map)e.next() : new HashMap();
                this.portalIDs.put(portalID, portalAccessURL);
                this.successURL = portalAccessURL;
                configLogger.log(Level.INFO, "PSFB_CSPFC0029", portalID);
                this.createPortal(msc, portalID, portalwebappURI);
                configLogger.log(Level.INFO, "PSFB_CSPFC0030", portalID);
                System.out.println("Successfully created Portal: " + portalID);
                if (portalInstances.isEmpty()) {
                    configLogger.log(Level.INFO, "PSFB_CSPFC0067", portalID);
                    continue;
                }
                configLogger.log(Level.INFO, "PSFB_CSPFC0032");
                this.createPortalInstances(msc, portalInstances, portalID);
                configLogger.log(Level.INFO, "PSFB_CSPFC0033");
            }
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0034", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    private String getSearchURL(MBeanServerConnection msc, String searchServerID) throws ConfigurationException {
        URL searchURL = null;
        String surl = null;
        try {
            configLogger.log(Level.INFO, "PSFB_CSPFC0065", searchServerID);
            ObjectName pattern = AdminClientUtil.getSearchServerPattern((String)"defaultDomain");
            Set<ObjectName> objects = msc.queryNames(pattern, new ObjectName(""));
            Iterator<ObjectName> i = objects.iterator();
            while (i.hasNext()) {
                ObjectName on = i.next();
                if (!((String)msc.getAttribute(on, "ID")).equals(searchServerID)) continue;
                Properties p = (Properties)msc.getAttribute(on, "Vitals");
                searchURL = new URL(p.getProperty("url"));
                surl = searchURL.toString();
                if (surl != null && surl != "") {
                    surl = surl + "/search";
                }
                return surl;
            }
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0136", e);
            throw new ConfigurationException((Throwable)e);
        }
        return surl;
    }

    protected void configureSamplePortal(MBeanServerConnection msc, Map PortalServerData, PSConfigContext pcc, String amAdminPassword, String amldapuserPassword, String hostname) throws ConfigurationException {
        Iterator iter = PortalServerData.keySet().iterator();
        try {
            while (iter.hasNext()) {
                configLogger.log(Level.INFO, "PSFB_CSPFC0027");
                String portalID = (String)iter.next();
                if (portalID == null) {
                    configLogger.log(Level.SEVERE, "PSFB_CSPFC0028", portalID);
                    return;
                }
                ArrayList psData = (ArrayList)PortalServerData.get(portalID);
                Iterator e = psData.iterator();
                String portalwebappURI = e.hasNext() ? (String)e.next() : "";
                String portalAccessURL = e.hasNext() ? (String)e.next() : "";
                String searchID = e.hasNext() ? (String)e.next() : "";
                String configureDevSample = e.hasNext() ? (String)e.next() : "";
                String configureEntSample = e.hasNext() ? (String)e.next() : "";
                String configureCommunitySample = e.hasNext() ? (String)e.next() : "";
                List profiler = e.hasNext() ? (List)e.next() : new ArrayList();
                List mail = e.hasNext() ? (List)e.next() : new ArrayList();
                List calendar = e.hasNext() ? (List)e.next() : new ArrayList();
                List addressbook = e.hasNext() ? (List)e.next() : new ArrayList();
                List instantMessenger = e.hasNext() ? (List)e.next() : new ArrayList();
                List portalInstances = this.getPortalInstances(msc, portalID, hostname);
                String searchURL = this.getSearchURL(msc, searchID);
                this.samplePortals = new SamplePortals(pcc);
                this.samplePortals.configure(new Boolean(configureDevSample), new Boolean(configureEntSample), new Boolean(configureCommunitySample), portalID, portalAccessURL, portalwebappURI, amAdminPassword, amldapuserPassword, searchID, searchURL, portalInstances, profiler, addressbook, calendar, instantMessenger, mail, msc);
                configLogger.log(Level.INFO, "PSFB_CSPFC0031");
            }
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0034", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void configureCollabApps(Map PortalServerData, PSConfigContext pcc, String amAdminPassword) {
        try {
            AntUtil antUtil = new AntUtil(pcc.getPSDataDir());
            String derbyPropFileLoc = pcc.getPSDataDir() + FS + "derby" + FS + "derby.properties";
            File propertiesFile = new File(derbyPropFileLoc);
            String derbyPort = null;
            String derbyHost = null;
            if (propertiesFile.exists()) {
                derbyPort = FileUtil.extractPatternTillEOL((File)propertiesFile, (String)"derby.drda.portNumber", (String)"=");
                derbyHost = FileUtil.extractPatternTillEOL((File)propertiesFile, (String)"derby.drda.host", (String)"=");
            }
            Iterator iter = PortalServerData.keySet().iterator();
            while (iter.hasNext()) {
                String portalID = (String)iter.next();
                if (portalID == null) {
                    configLogger.log(Level.SEVERE, "PSFB_CSPFC0028", portalID);
                    return;
                }
                ArrayList psData = (ArrayList)PortalServerData.get(portalID);
                Iterator e = psData.iterator();
                String portalwebappURI = e.hasNext() ? (String)e.next() : "";
                String collabAppsBaseDir = pcc.getPSBaseDir() + FS + "portletapps";
                String collabAppsDataDir = pcc.getPSDataDir() + FS + "portals" + FS + portalID + FS + "portletapps";
                if (!FileUtil.directoryExists((String)collabAppsBaseDir) || !FileUtil.copyDir((String)collabAppsBaseDir, (String)collabAppsDataDir)) continue;
                String inputProp = collabAppsDataDir + FS + "input.properties";
                File inputFile = new File(inputProp);
                FileUtil.replaceTokenInFile((File)inputFile, (String)"%AM_ADMIN_DN%", (String)pcc.getAdminUserDN());
                FileUtil.replaceTokenInFile((File)inputFile, (String)"%PS_CONFIG_LOCATION%", (String)pcc.getPSConfigDir());
                FileUtil.replaceTokenInFile((File)inputFile, (String)"%PORTAL_ID%", (String)portalID);
                FileUtil.replaceTokenInFile((File)inputFile, (String)"%AMADMIN_PASSWORD%", (String)amAdminPassword);
                FileUtil.replaceTokenInFile((File)inputFile, (String)"%PORTAL_WEBAPP_URI%", (String)portalwebappURI);
                File collabDir = new File(collabAppsDataDir);
                File[] fFileList = collabDir.listFiles();
                for (int i = 0; i < fFileList.length; ++i) {
                    File collabFile = fFileList[i];
                    if (!collabFile.isDirectory()) continue;
                    String logPrefix = "portlet." + collabFile.getName();
                    String buildFileLoc = collabFile.getAbsolutePath() + FS + "build.xml";
                    File buildFile = new File(buildFileLoc);
                    FileUtil.makeDir((String)(collabFile.getAbsolutePath() + FS + "web"));
                    File tokensPropFile = new File(collabFile.getAbsolutePath() + FS + "tokens.properties");
                    FileUtil.replaceTokenInFile((File)tokensPropFile, (String)"%DERBY_HOST%", (String)derbyHost);
                    FileUtil.replaceTokenInFile((File)tokensPropFile, (String)"%PORTAL_ID%", (String)portalID);
                    FileUtil.replaceTokenInFile((File)tokensPropFile, (String)"%PORTAL_DATA_DIR%", (String)pcc.getPSDataDir());
                    FileUtil.replaceTokenInFile((File)tokensPropFile, (String)"%DERBY_PORT%", (String)derbyPort);
                    FileUtil.replaceTokenInFile((File)tokensPropFile, (String)"%DERBY_LIB_DIR%", (String)pcc.getDerbyLibDir());
                    if (!buildFile.exists()) continue;
                    antUtil.runant(buildFileLoc, null, logPrefix, null, null);
                }
            }
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0235", e);
        }
    }

    public void createPortal(MBeanServerConnection msc, String portalID, String portalwebappURI) throws ConfigurationException {
        try {
            Object[] params = new Object[]{portalID, null, portalwebappURI};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            ObjectName objName = AdminClientUtil.getPortalDomainMBeanObjectName((String)"defaultDomain");
            msc.invoke(objName, "createPortal", params, signature);
        }
        catch (InstanceNotFoundException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0035", ie);
            throw new ConfigurationException((Throwable)ie);
        }
        catch (MBeanException me) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0035", me);
            throw new ConfigurationException((Throwable)me);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0035", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void configureSRAComponents(MBeanServerConnection msc, String sraComponent) throws ConfigurationException {
        String method = null;
        Object[] params = new Object[1];
        String[] signature = new String[1];
        LinkedList<String> path = new LinkedList<String>();
        try {
            if (sraComponent.equals("gateway")) {
                method = "CreateGWInstance";
                params[0] = this.gwConfigProperties;
            }
            if (sraComponent.equals("nlproxy")) {
                method = "CreateNLPInstance";
                params[0] = this.nlpConfigProperties;
            }
            if (sraComponent.equals("rwproxy")) {
                method = "CreateRWPInstance";
                params[0] = this.rwpConfigProperties;
            }
            signature[0] = "java.util.Properties";
            path.addFirst("defaultDomain");
            path.addFirst("sra");
            ObjectName objName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.SRA", path);
            msc.invoke(objName, method, params, signature);
        }
        catch (InstanceNotFoundException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0035", ie);
            throw new ConfigurationException((Throwable)ie);
        }
        catch (MBeanException me) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0035", me);
            throw new ConfigurationException((Throwable)me);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0035", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void configureSRA(PortalConfigData pci, PSConfigContext pcc) {
        try {
            this.portalIDs.put("domain", pci.getportalAccessURL());
            SSOToken ssoToken = AMUtil.createSSOToken((String)pcc.getAdminUserDN(), (String)pci.getAMAdminPassword(), (String)pcc.getDefaultOrganization());
            Domain pDomain = new Domain(pcc);
            pDomain.configureSRAServices(ssoToken);
            EnableServices es = new EnableServices(pci.getPSProdDir(), pci.getPSDataDir(), pci.getAMProdDir(), pcc.getAdminUserDN(), pci.getAMAdminPassword(), configLogger);
            es.sraServices(pcc.getDefaultOrganization(), pci.getSRAPortalServerDomain(), pci.getSRAGatewayProtocol(), pci.getSRAGatewayPortNo(), pci.getSRAGatewayProfileName(), pci.getSRALogUserPassword(), pcc.getISConsoleURI(), pcc.getISServerURI(), pcc.getDefaultPeopleDN(), pci.getportalAccessURL());
            OSTasksFactory osTasksFactory = OSTasksFactory.getInstance();
            OSTasks osTasks = OSTasksFactory.getOSTasks((PSConfigContext)pcc, (Logger)configLogger);
            osTasks.addNetFilePAM();
            if (this.samplePortals != null) {
                this.samplePortals.configureSRA(pci.getAMAdminPassword(), pci.getLDAPUserPassword());
            }
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0036", e);
        }
    }

    protected void createSearchServer(MBeanServerConnection msc, Map SearchServerList) throws ConfigurationException {
        try {
            ObjectName objName = AdminClientUtil.getPortalDomainMBeanObjectName((String)"defaultDomain");
            Iterator iter = SearchServerList.keySet().iterator();
            while (iter.hasNext()) {
                configLogger.log(Level.INFO, "PSFB_CSPFC0037");
                String searchServerID = (String)iter.next();
                Properties SearchServerWCDetails = (Properties)SearchServerList.get(searchServerID);
                Object[] params = new Object[]{searchServerID, SearchServerWCDetails};
                String[] signature = new String[]{"java.lang.String", "java.util.Properties"};
                msc.invoke(objName, "createSearchServer", params, signature);
                configLogger.log(Level.INFO, "PSFB_CSPFC0038", searchServerID);
            }
        }
        catch (InstanceNotFoundException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0039", ie);
            throw new ConfigurationException((Throwable)ie);
        }
        catch (MBeanException me) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0039", me);
            throw new ConfigurationException((Throwable)me);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0039", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void createPortalInstances(MBeanServerConnection msc, Map PortalInstancesList, String portalID) throws ConfigurationException {
        try {
            Iterator iter = PortalInstancesList.keySet().iterator();
            while (iter.hasNext()) {
                String instanceID = (String)iter.next();
                Properties webconfigprop = (Properties)PortalInstancesList.get(instanceID);
                Object[] iParams = new Object[]{instanceID, webconfigprop};
                String[] iSignature = new String[]{"java.lang.String", "java.util.Properties"};
                ObjectName iObjName = AdminClientUtil.getPortalMBeanObjectName((String)"defaultDomain", (String)portalID);
                msc.invoke(iObjName, "createInstance", iParams, iSignature);
                configLogger.log(Level.INFO, "PSFB_CSPFC0040", new String[]{instanceID, portalID});
            }
        }
        catch (InstanceNotFoundException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0041", ie);
            throw new ConfigurationException((Throwable)ie);
        }
        catch (MBeanException me) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0041", me);
            throw new ConfigurationException((Throwable)me);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0041", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void restartPortalInstances(MBeanServerConnection msc, Map portalInstances) throws ConfigurationException {
        try {
            Iterator iter = portalInstances.keySet().iterator();
            while (iter.hasNext()) {
                String portalID = (String)iter.next();
                String instanceID = (String)portalInstances.get(portalID);
                ObjectName mBeanName = AdminClientUtil.getInstanceMBeanObjectName((String)"defaultDomain", (String)portalID, (String)instanceID);
                String[] signature = new String[]{};
                Object[] params = new Object[]{};
                configLogger.log(Level.INFO, "Invoking restart method on: " + mBeanName);
                msc.invoke(mBeanName, "restart", params, signature);
            }
        }
        catch (InstanceNotFoundException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0233", ie);
            throw new ConfigurationException((Throwable)ie);
        }
        catch (MBeanException me) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0233", me);
            throw new ConfigurationException((Throwable)me);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0233", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void deployWebappsToPortalInstances(MBeanServerConnection msc, Map portalInstances) throws ConfigurationException {
        try {
            Iterator iter = portalInstances.keySet().iterator();
            while (iter.hasNext()) {
                String portalID = (String)iter.next();
                String instanceID = (String)portalInstances.get(portalID);
                ObjectName mBeanName = AdminClientUtil.getInstanceMBeanObjectName((String)"defaultDomain", (String)portalID, (String)instanceID);
                String[] signature = new String[]{};
                Object[] params = new Object[]{};
                configLogger.log(Level.INFO, "Invoking deployAll method on: " + mBeanName);
                msc.invoke(mBeanName, "deployAll", params, signature);
            }
        }
        catch (InstanceNotFoundException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0234", ie);
            throw new ConfigurationException((Throwable)ie);
        }
        catch (MBeanException me) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0234", me);
            throw new ConfigurationException((Throwable)me);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0234", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void closeMbeanServerConnection() throws ConfigurationException {
        try {
            if (this.m_connector != null) {
                this.m_connector.close();
                this.m_connector = null;
            }
        }
        catch (IOException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0042", ie);
            throw new ConfigurationException((Throwable)ie);
        }
    }

    protected void postConfigurationTasks(PSConfigContext pcc, String amAdminPassword) throws ConfigurationException {
        configLogger.log(Level.INFO, "PSFB_CSPFC0043");
        EnableServices es = new EnableServices(pcc.getPSBaseDir(), pcc.getPSDataDir(), pcc.getISBaseDir(), pcc.getAdminUserDN(), amAdminPassword, configLogger);
        try {
            es.postInstallRequests(pcc.getDefaultOrganization(), this.successURL + "/dt");
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0044", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void setAccessManagerJSSProperty(PSConfigContext pcc) {
        String amConfigLoc = pcc.getUserAuthConfigFile();
        String pattern = "com.sun.identity.jss.donotInstallAtHighestPriority";
        String text = "com.sun.identity.jss.donotInstallAtHighestPriority=true";
        FileUtil.replaceLineInFile((File)new File(amConfigLoc), (String)pattern, (String)text);
    }

    protected void configureCommunityPortlet(MBeanServerConnection msc, Map PortalServerData, PSConfigContext pcc) {
        String searchID = null;
        Iterator iter = PortalServerData.keySet().iterator();
        try {
            while (iter.hasNext()) {
                configLogger.log(Level.INFO, "PSFB_CSPFC0027");
                String portalID = (String)iter.next();
                if (portalID == null) {
                    configLogger.log(Level.SEVERE, "PSFB_CSPFC0028", portalID);
                    return;
                }
                ArrayList psData = (ArrayList)PortalServerData.get(portalID);
                Iterator e = psData.iterator();
                if (e.hasNext()) {
                    e.next();
                    if (e.hasNext()) {
                        e.next();
                        if (e.hasNext()) {
                            e.next();
                            searchID = e.hasNext() ? (String)e.next() : "";
                        }
                    }
                }
                String searchURL = this.getSearchURL(msc, searchID);
                String propFileLoc = pcc.getPSDataDir() + FS + "portals" + FS + portalID + FS + "config" + FS + "communityportlets.properties";
                File propFile = new File(propFileLoc);
                FileUtil.replaceTokenInFile((File)propFile, (String)"%SEARCH_SERVER_URL%", (String)searchURL);
            }
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0237", e);
        }
    }

    protected Map getPortals(MBeanServerConnection msc) throws ConfigurationException {
        HashMap portals = new HashMap();
        try {
            configLogger.log(Level.INFO, "PSFB_CSPFC0131");
            ObjectName portalPat = AdminClientUtil.getPortalsPattern((String)"defaultDomain");
            Set<ObjectName> portalObjs = msc.queryNames(portalPat, new ObjectName(""));
            Iterator<ObjectName> i = portalObjs.iterator();
            while (i.hasNext()) {
                ObjectName o = i.next();
                String pId = (String)msc.getAttribute(o, "ID");
                portals.put(pId, new ArrayList());
            }
            configLogger.log(Level.INFO, "PSFB_CSPFC0132");
            return portals;
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0133");
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected Map getSearchServers(MBeanServerConnection msc, String hostname) throws ConfigurationException {
        HashMap<String, String> searchServers = new HashMap<String, String>();
        try {
            configLogger.log(Level.INFO, "PSFB_CSPFC0134");
            ObjectName pattern = AdminClientUtil.getSearchServerPattern((String)"defaultDomain");
            Set<ObjectName> objects = msc.queryNames(pattern, new ObjectName(""));
            Iterator<ObjectName> i = objects.iterator();
            while (i.hasNext()) {
                ObjectName on = i.next();
                String searchServerID = (String)msc.getAttribute(on, "ID");
                Properties p = (Properties)msc.getAttribute(on, "Vitals");
                URL searchURL = new URL(p.getProperty("url"));
                String host = searchURL.getHost();
                if (hostname == null) {
                    searchServers.put(searchServerID, host);
                    continue;
                }
                if (!hostname.equals(host)) continue;
                configLogger.log(Level.INFO, "PSFB_CSPFC0135", host);
                searchServers.put(searchServerID, host);
            }
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0136");
            throw new ConfigurationException((Throwable)e);
        }
        return searchServers;
    }

    protected Map getPortalInstances(MBeanServerConnection msc, List portals, String hostname) throws ConfigurationException {
        HashMap<String, String> portalInstances = new HashMap<String, String>();
        ObjectName instancePat = null;
        Set<ObjectName> instanceObjs = null;
        Iterator i = portals.iterator();
        while (i.hasNext()) {
            String portalID = (String)i.next();
            try {
                configLogger.log(Level.INFO, "PSFB_CSPFC0137", portalID);
                instancePat = AdminClientUtil.getPortalServerInstancesPattern((String)"defaultDomain", (String)portalID);
                instanceObjs = msc.queryNames(instancePat, new ObjectName(""));
                Iterator<ObjectName> j = instanceObjs.iterator();
                while (j.hasNext()) {
                    ObjectName iObj = j.next();
                    String iId = (String)msc.getAttribute(iObj, "ID");
                    String host = (String)msc.getAttribute(iObj, "Host");
                    if (hostname.equals(null)) {
                        portalInstances.put(portalID, iId);
                        continue;
                    }
                    if (!hostname.equals(host)) continue;
                    configLogger.log(Level.INFO, "PSFB_CSPFC0138", new String[]{portalID, host});
                    portalInstances.put(portalID, iId);
                }
            }
            catch (Exception e) {
                configLogger.log(Level.SEVERE, "PSFB_CSPFC0139", portalID);
                throw new ConfigurationException((Throwable)e);
            }
        }
        return portalInstances;
    }

    protected List getPortalInstances(MBeanServerConnection msc, String portalID, String hostname) throws ConfigurationException {
        ArrayList<String> instances = new ArrayList<String>();
        ObjectName instancePat = null;
        Set<ObjectName> instanceObjs = null;
        try {
            configLogger.log(Level.INFO, "PSFB_CSPFC0137", portalID);
            instancePat = AdminClientUtil.getPortalServerInstancesPattern((String)"defaultDomain", (String)portalID);
            instanceObjs = msc.queryNames(instancePat, new ObjectName(""));
            Iterator<ObjectName> j = instanceObjs.iterator();
            while (j.hasNext()) {
                ObjectName iObj = j.next();
                String iId = (String)msc.getAttribute(iObj, "ID");
                String host = (String)msc.getAttribute(iObj, "Host");
                if (iId.equals(null)) continue;
                if (hostname != null && hostname.equals(host)) {
                    configLogger.log(Level.INFO, "PSFB_CSPFC0138", new String[]{portalID, host});
                    instances.add(iId);
                    continue;
                }
                instances.add(iId);
            }
            configLogger.log(Level.INFO, "PSFB_CSPFC0140", portalID);
            return instances;
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0139", portalID);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void deletePortalInstances(MBeanServerConnection msc, String hostname) throws ConfigurationException {
        ArrayList portals = new ArrayList();
        Map portalInstances = new HashMap();
        try {
            configLogger.log(Level.INFO, "PSFB_CSPFC0141");
            portalInstances = this.getPortalInstances(msc, portals, hostname);
            Iterator iter = portalInstances.keySet().iterator();
            while (iter.hasNext()) {
                String portalID = (String)iter.next();
                String instanceID = (String)portalInstances.get(portalID);
                Object[] iParams = new Object[]{instanceID};
                String[] iSignature = new String[]{"java.lang.String"};
                ObjectName iObjName = AdminClientUtil.getPortalMBeanObjectName((String)"defaultDomain", (String)portalID);
                configLogger.log(Level.INFO, "PSFB_CSPFC0142", new String[]{instanceID, portalID});
                msc.invoke(iObjName, "deleteInstance", iParams, iSignature);
                configLogger.log(Level.INFO, "PSFB_CSPFC0143", new String[]{instanceID, portalID});
            }
        }
        catch (Exception e) {
            configLogger.log(Level.INFO, "PSFB_CSPFC0144");
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void unconfigurePortal(MBeanServerConnection msc, Map portalsToDelete, String hostname) throws ConfigurationException {
        Map portals = new HashMap();
        List instances = new ArrayList();
        if (portalsToDelete.isEmpty()) {
            configLogger.log(Level.INFO, "PSFB_CSPFC0124");
            portals = this.getPortals(msc);
        } else {
            portals = portalsToDelete;
        }
        try {
            Iterator iter = portals.keySet().iterator();
            while (iter.hasNext()) {
                String portalID = (String)iter.next();
                instances = (ArrayList)portals.get(portalID);
                Iterator e = instances.iterator();
                if (e.hasNext()) {
                    configLogger.log(Level.INFO, "PSFB_CSPFC0128");
                    this.deletePortalInstances(msc, portalID, instances);
                    continue;
                }
                configLogger.log(Level.INFO, "PSFB_CSPFC0121");
                instances = this.getPortalInstances(msc, portalID, hostname);
                configLogger.log(Level.INFO, "PSFB_CSPFC0128");
                this.deletePortalInstances(msc, portalID, instances);
                configLogger.log(Level.INFO, "PSFB_CSPFC0129");
                this.deletePortal(msc, portalID);
            }
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0130");
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void deletePortal(MBeanServerConnection msc, String portalID) throws ConfigurationException {
        List portalInstances = new ArrayList();
        try {
            configLogger.log(Level.INFO, "PSFB_CSPFC0121", portalID);
            portalInstances = this.getPortalInstances(msc, portalID, null);
            configLogger.log(Level.INFO, "PSFB_CSPFC0122", portalID);
            if (portalInstances.isEmpty()) {
                configLogger.log(Level.INFO, "PSFB_CSPFC0123", portalID);
                Object[] params = new Object[]{portalID};
                String[] signature = new String[]{"java.lang.String"};
                ObjectName objName = AdminClientUtil.getPortalDomainMBeanObjectName((String)"defaultDomain");
                msc.invoke(objName, "deletePortal", params, signature);
                configLogger.log(Level.INFO, "PSFB_CSPFC0124", portalID);
            } else {
                configLogger.log(Level.INFO, "PSFB_CSPFC0125", portalID);
            }
        }
        catch (InstanceNotFoundException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0147", ie.toString());
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0126", portalID);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void deletePortalInstances(MBeanServerConnection msc, String portalID, List portalInstances) throws ConfigurationException {
        Iterator iter = portalInstances.iterator();
        try {
            while (iter.hasNext()) {
                String instanceID = (String)iter.next();
                configLogger.log(Level.INFO, "PSFB_CSPFC0118", instanceID);
                Object[] iParams = new Object[]{instanceID};
                String[] iSignature = new String[]{"java.lang.String"};
                ObjectName iObjName = AdminClientUtil.getPortalMBeanObjectName((String)"defaultDomain", (String)portalID);
                msc.invoke(iObjName, "deleteInstance", iParams, iSignature);
                configLogger.log(Level.INFO, "PSFB_CSPFC0119", instanceID);
            }
        }
        catch (InstanceNotFoundException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0147", ie.toString());
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0120");
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void deleteSearchServer(MBeanServerConnection msc, List searchServers, String hostname) throws ConfigurationException {
        Map searchServersList = new HashMap();
        try {
            searchServersList = this.getSearchServers(msc, hostname);
            Iterator iter = searchServersList.keySet().iterator();
            while (iter.hasNext()) {
                String searchServersID = (String)iter.next();
                if (hostname == null || searchServers.contains(searchServersID) || searchServersList.get(searchServersID).equals(hostname)) {
                    configLogger.log(Level.INFO, "PSFB_CSPFC0094", searchServersID);
                    Object[] params = new Object[]{searchServersID};
                    String[] signature = new String[]{"java.lang.String"};
                    ObjectName objName = AdminClientUtil.getPortalDomainMBeanObjectName((String)"defaultDomain");
                    msc.invoke(objName, "deleteSearchServer", params, signature);
                    configLogger.log(Level.INFO, "PSFB_CSPFC0095", searchServersID);
                    continue;
                }
                configLogger.log(Level.SEVERE, "PSFB_CSPFC0093", new String[]{searchServersID, hostname});
            }
        }
        catch (InstanceNotFoundException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0147", ie.toString());
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void removeSRAComponent(MBeanServerConnection msc, String sraComponent, String instanceName, String amadmin, String amAdminPassword, String hostName) throws ConfigurationException {
        String method = null;
        Object[] params = new Object[1];
        String[] signature = new String[1];
        LinkedList<String> path = new LinkedList<String>();
        try {
            if (!AdminClientUtil.isLocal((String)hostName)) {
                configLogger.log(Level.INFO, "PSFB_CSPFC0232", hostName);
                msc = this.getMbeanServerConnection(amadmin, amAdminPassword, hostName);
            }
        }
        catch (UnknownHostException e1) {
            throw new ConfigurationException((Throwable)e1);
        }
        configLogger.log(Level.INFO, "PSFB_CSPFC0116", new String[]{sraComponent, instanceName});
        try {
            if (sraComponent.equals("gateway")) {
                method = "RemoveGWInstance";
                params[0] = instanceName;
            }
            if (sraComponent.equals("nlproxy")) {
                method = "RemoveNLPInstance";
                params[0] = instanceName;
            }
            if (sraComponent.equals("rwproxy")) {
                method = "RemoveRWPInstance";
                params[0] = instanceName;
            }
            signature[0] = "java.lang.String";
            path.addFirst("defaultDomain");
            path.addFirst("sra");
            ObjectName objName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.SRA", path);
            msc.invoke(objName, method, params, signature);
            configLogger.log(Level.INFO, "PSFB_CSPFC0117", new String[]{sraComponent, instanceName});
        }
        catch (InstanceNotFoundException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0035", ie);
            throw new ConfigurationException((Throwable)ie);
        }
        catch (MBeanException me) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0035", me);
            throw new ConfigurationException((Throwable)me);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0035", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected Map getListofSRAComponents(MBeanServerConnection msc, String sraComponent, String hostname) throws ConfigurationException {
        String method = null;
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        LinkedList<String> path = new LinkedList<String>();
        Map instances = new HashMap();
        configLogger.log(Level.INFO, "PSFB_CSPFC0114", sraComponent);
        try {
            if (sraComponent.equals("gateway")) {
                method = "ListGatewayInstances";
            }
            if (sraComponent.equals("nlproxy")) {
                method = "ListNLPInstances";
            }
            if (sraComponent.equals("rwproxy")) {
                method = "ListRWPInstances";
            }
            path.addFirst("defaultDomain");
            path.addFirst("sra");
            ObjectName objName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.SRA", path);
            Object returnval = msc.invoke(objName, method, params, signature);
            if (returnval != null) {
                Object[] objs = (Object[])returnval;
                if (objs.length == 0) {
                    configLogger.log(Level.INFO, "PSFB_CSPFC0146");
                } else {
                    instances = this.parseSRAInstanceOutput(objs, hostname);
                }
            }
            configLogger.log(Level.INFO, "PSFB_CSPFC0115", sraComponent);
            return instances;
        }
        catch (InstanceNotFoundException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0035", ie);
            throw new ConfigurationException((Throwable)ie);
        }
        catch (MBeanException me) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0035", me);
            throw new ConfigurationException((Throwable)me);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0035", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void unconfigureSRAComponents(MBeanServerConnection msc, String sraComponent, Map instances, String amadmin, String amAdminPassword) throws ConfigurationException {
        try {
            Iterator iter = instances.keySet().iterator();
            while (iter.hasNext()) {
                String instanceName = (String)iter.next();
                String hostName = (String)instances.get(instanceName);
                configLogger.log(Level.INFO, "PSFB_CSPFC0112", new String[]{sraComponent, instanceName});
                this.removeSRAComponent(msc, sraComponent, instanceName, amadmin, amAdminPassword, hostName);
            }
        }
        catch (ConfigurationException e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0113", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void removePortalDomainServicesFromAM(MBeanServerConnection msc, PSConfigContext pcc, String amAdminPassword, String orgDN) {
        try {
            this.removeRewriterRuleSet(msc, "portalserver");
            configLogger.log(Level.INFO, "PSFB_CSPFC0149");
            EnableServices es = new EnableServices(pcc.getPSBaseDir(), pcc.getPSDataDir(), pcc.getISBaseDir(), pcc.getAdminUserDN(), amAdminPassword, configLogger);
            es.unConfigdomainServices(orgDN, pcc.getUserNamingAttribute());
            configLogger.log(Level.INFO, "PSFB_CSPFC0150");
            Domain pDomain = new Domain(pcc);
            SSOToken ssoToken = AMUtil.createSSOToken((String)pcc.getAdminUserDN(), (String)amAdminPassword, (String)pcc.getDefaultOrganization());
            pDomain.removeDomainServices(ssoToken);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0148", e);
        }
    }

    protected void removeSRAServicesFromAM(MBeanServerConnection msc, PSConfigContext pcc, String amAdminPassword, String orgDN) {
        try {
            this.removeRewriterRuleSet(msc, "sracore");
            configLogger.log(Level.INFO, "PSFB_CSPFC0151");
            EnableServices es = new EnableServices(pcc.getPSBaseDir(), pcc.getPSDataDir(), pcc.getISBaseDir(), pcc.getAdminUserDN(), amAdminPassword, configLogger);
            es.unConfigSRAServices(orgDN, pcc.getUserNamingAttribute());
            configLogger.log(Level.INFO, "PSFB_CSPFC0152");
            Domain pDomain = new Domain(pcc);
            SSOToken ssoToken = AMUtil.createSSOToken((String)pcc.getAdminUserDN(), (String)amAdminPassword, (String)pcc.getDefaultOrganization());
            pDomain.removeSRAServices(ssoToken);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0153", e);
        }
    }

    protected void unconfigDerby(PSConfigContext pcc, String hostName) {
        this.derby = new Derby(pcc, hostName);
        this.derby.unconfigureDerby();
    }

    private Set getRewriterRuleSet(MBeanServerConnection msc) {
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        LinkedList<String> path = new LinkedList<String>();
        Set ruleSetIds = new HashSet();
        configLogger.log(Level.INFO, "PSFB_CSPFC0154");
        path.addFirst("defaultDomain");
        path.addFirst("rewriter");
        try {
            ObjectName objName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.Rewriter", path);
            Object returnval = msc.invoke(objName, "listRules", params, signature);
            ruleSetIds = (Set)returnval;
        }
        catch (InstanceNotFoundException e1) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0155", e1);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0155", e);
        }
        return ruleSetIds;
    }

    private void removeRewriterRuleSet(MBeanServerConnection msc, String component) {
        LinkedList<String> path = new LinkedList<String>();
        Set ruleSetIds = new HashSet();
        path.addFirst("defaultDomain");
        path.addFirst("rewriter");
        ruleSetIds = this.getRewriterRuleSet(msc);
        if (!ruleSetIds.isEmpty()) {
            Iterator i = ruleSetIds.iterator();
            while (i.hasNext()) {
                String ruleSetID = (String)i.next();
                configLogger.log(Level.INFO, "PSFB_CSPFC0156", ruleSetID);
                try {
                    if (component.equals("sracore") && (ruleSetID.equals("generic_ruleset") || ruleSetID.equals("default_ruleset"))) continue;
                    Object[] params = new Object[]{ruleSetID};
                    String[] signature = new String[]{"java.lang.String"};
                    ObjectName objName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.Rewriter", path);
                    msc.invoke(objName, "removeRule", params, signature);
                }
                catch (InstanceNotFoundException e1) {
                    configLogger.log(Level.SEVERE, "PSFB_CSPFC0157", e1);
                }
                catch (Exception e) {
                    configLogger.log(Level.SEVERE, "PSFB_CSPFC0157", e);
                }
            }
        }
    }

    private Map parseSRAInstanceOutput(Object[] obj, String hostname) {
        String[] temp = new String[]{};
        String temp1 = null;
        HashMap<String, String> instances = new HashMap<String, String>();
        for (int ii = 0; ii < obj.length; ++ii) {
            String instanceData = obj[ii].toString();
            temp = instanceData.split(":");
            if (temp.length == 0 || (temp1 = temp[1].substring(0, temp[1].indexOf("|"))).equals(null) || hostname != null && !temp1.equals(hostname)) continue;
            instances.put(temp[0], temp1);
        }
        return instances;
    }

    private void loadRewriterRuleSets(MBeanServerConnection msc, String ruleSetXMLPath) throws ConfigurationException {
        block5: {
            String lResult = "";
            LinkedList<String> path = new LinkedList<String>();
            path.addFirst("defaultDomain");
            path.addFirst("rewriter");
            try {
                StringBuffer sb;
                BufferedReader buffReader;
                if (new File(ruleSetXMLPath).exists()) {
                    buffReader = new BufferedReader(new FileReader(ruleSetXMLPath));
                    sb = new StringBuffer();
                    char[] data = new char[2048];
                    int count = 0;
                    while ((count = buffReader.read(data)) != -1) {
                        sb.append(data, 0, count);
                    }
                } else {
                    throw new ConfigurationException("File" + ruleSetXMLPath + "doesn't Exists");
                }
                buffReader.close();
                lResult = sb.toString();
                Object[] params = new Object[]{lResult};
                String[] signature = new String[]{"java.lang.String"};
                ObjectName objName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.Rewriter", path);
                configLogger.log(Level.INFO, "PSFB_CSPFC0199", ruleSetXMLPath);
                msc.invoke(objName, "storeRule", params, signature);
                configLogger.log(Level.INFO, "PSFB_CSPFC0200", ruleSetXMLPath);
            }
            catch (Exception e) {
                if (!configLogger.isLoggable(Level.SEVERE)) break block5;
                this.record = new LogRecord(Level.SEVERE, "PSFB_CSPFC0198");
                this.record.setLoggerName(configLogger.getName());
                this.record.setParameters(new String[]{ruleSetXMLPath});
                this.record.setThrown(e);
                this.record.setLoggerName(configLogger.getName());
                configLogger.log(this.record);
                throw new ConfigurationException();
            }
        }
    }

    protected void loadPortalRewriterRulseSet(MBeanServerConnection msc, PSConfigContext pcc) throws ConfigurationException {
        String ruleDir = pcc.getPSBaseDir() + FS + "export" + FS + "rewriter_rule";
        String[] ruleXMLPaths = new String[]{ruleDir + FS + "GenericRuleSet.xml", ruleDir + FS + "DefaultRuleSet.xml"};
        for (int i = 0; i < ruleXMLPaths.length; ++i) {
            this.loadRewriterRuleSets(msc, ruleXMLPaths[i]);
        }
    }

    protected void loadSRARewriterRulseSet(MBeanServerConnection msc, PSConfigContext pcc) throws ConfigurationException {
        File ruleSetDir = new File(pcc.getPSBaseDir() + FS + "export" + FS + "rewriter_rule");
        FilenameFilter filter = FileUtil.getExtensionFilter((String)"xml");
        File[] ruleSetFiles = ruleSetDir.listFiles(filter);
        for (int i = 0; i < ruleSetFiles.length; ++i) {
            String ruleSetPath = ruleSetFiles[i].getAbsolutePath();
            String ruleSetXML = ruleSetPath.substring(ruleSetPath.trim().lastIndexOf(FS) + 1);
            if (ruleSetXML.equals("DefaultRuleSet.xml") || ruleSetXML.equals("GenericRuleSet.xml")) continue;
            this.loadRewriterRuleSets(msc, FileUtil.decoratePath((String)ruleSetPath));
        }
    }

    protected boolean isPortalComponentsConfigured(MBeanServerConnection msc, String hostname) {
        try {
            if (!this.getListofSRAComponents(msc, "nlproxy", hostname).isEmpty()) {
                return true;
            }
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        try {
            if (!this.getListofSRAComponents(msc, "rwproxy", hostname).isEmpty()) {
                return true;
            }
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        try {
            if (!this.getListofSRAComponents(msc, "gateway", hostname).isEmpty()) {
                return true;
            }
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        try {
            if (!this.getSearchServers(msc, hostname).isEmpty()) {
                return true;
            }
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        try {
            Iterator iter = this.getPortals(msc).keySet().iterator();
            while (iter.hasNext()) {
                String portalID = (String)iter.next();
                List instances = this.getPortalInstances(msc, portalID, hostname);
                if (instances.isEmpty()) continue;
                return true;
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FS = File.separator;
        SunCopyRightMsg = null;
    }
}

