/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.config;

import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.XMLJdomFileCreationException;
import com.sun.portal.fabric.util.XMLJdomUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

public class PortalConfigData {
    private Document doc = null;
    private Map hash = null;
    private Element portalConfigDetails;
    private Element sharedCompDetails;
    private Element amInstallDetails;
    private Element amAccessInfo;
    private Element psConfigInfo;
    private Element psInstallDetails;
    private Element sraCompDetails;
    private Element certificateInfo;
    private Element psComponentsToConfigure;
    private List searchServers = null;
    private List netletProxyInfo = null;
    private List rewriterProxyInfo = null;
    private List gatewayInfo = null;
    private List portals;

    public PortalConfigData(String sFilePath) throws ConfigurationException {
        try {
            XMLJdomUtil xmlJdomUtil = new XMLJdomUtil();
            this.doc = xmlJdomUtil.readXMLFile(sFilePath);
        }
        catch (XMLJdomFileCreationException e) {
            throw new ConfigurationException(e.getMessage());
        }
        this.portalConfigDetails = this.doc.getRootElement().getChild("Configure");
        if (this.portalConfigDetails != null) {
            this.sharedCompDetails = this.portalConfigDetails.getChild("SharedComponents");
            this.amInstallDetails = this.portalConfigDetails.getChild("AccessManager").getChild("InstallationDirectory");
            this.amAccessInfo = this.portalConfigDetails.getChild("AccessManager").getChild("UserCredentials");
            this.psConfigInfo = this.portalConfigDetails.getChild("PortalConfiguration");
            this.psInstallDetails = this.psConfigInfo.getChild("InstallationDirectory");
            this.searchServers = this.psConfigInfo.getChildren("SearchServer");
            this.portals = this.psConfigInfo.getChildren("PortalServer");
            this.sraCompDetails = this.psConfigInfo.getChild("SecureRemoteAccessCore");
            this.gatewayInfo = this.psConfigInfo.getChildren("Gateway");
            this.netletProxyInfo = this.psConfigInfo.getChildren("NetletProxy");
            this.rewriterProxyInfo = this.psConfigInfo.getChildren("RewriterProxy");
            this.certificateInfo = this.psConfigInfo.getChild("CertificateInformation");
            this.psComponentsToConfigure = this.psConfigInfo.getChild("ComponentsToConfigure");
        } else {
            this.portalConfigDetails = this.doc.getRootElement().getChild("Unconfigure");
            this.amAccessInfo = this.portalConfigDetails.getChild("AccessManager").getChild("UserCredentials");
            this.psConfigInfo = this.portalConfigDetails.getChild("PortalConfiguration");
            this.psComponentsToConfigure = this.psConfigInfo.getChild("ComponentsToConfigure");
            this.searchServers = this.psConfigInfo.getChildren("SearchServer");
            this.portals = this.psConfigInfo.getChildren("PortalServer");
            this.gatewayInfo = this.psConfigInfo.getChildren("Gateway");
            this.netletProxyInfo = this.psConfigInfo.getChildren("NetletProxy");
            this.rewriterProxyInfo = this.psConfigInfo.getChildren("RewriterProxy");
        }
    }

    public String getAMProdDir() {
        return this.amInstallDetails.getAttributeValue("ProdDir");
    }

    public String getAMConfigFile() {
        return this.amInstallDetails.getAttributeValue("ConfigFile");
    }

    public String getAMConfigDir() {
        return this.amInstallDetails.getAttributeValue("ConfigDir");
    }

    public String getAMDataDir() {
        return this.amInstallDetails.getAttributeValue("DataDir");
    }

    public String getAMAdmin() {
        return this.amAccessInfo.getAttributeValue("AdministratorUID");
    }

    public String getAMAdminPassword() {
        return this.amAccessInfo.getAttributeValue("AdministratorUserPassword");
    }

    public String getLDAPUserId() {
        return this.amAccessInfo.getAttributeValue("LDAPUserId");
    }

    public String getLDAPUserPassword() {
        return this.amAccessInfo.getAttributeValue("LDAPUserIdPassword");
    }

    public String getDirectoryManagerDN() {
        return this.amAccessInfo.getAttributeValue("DirectoryManagerDn");
    }

    public String getDirectoryManagerPassword() {
        return this.amAccessInfo.getAttributeValue("DirectoryManagerPassword");
    }

    public String getPSConfigMode() {
        List configmode = this.doc.getRootElement().getChildren();
        Iterator it = configmode.iterator();
        String mode = null;
        if (it.hasNext()) {
            Element configurationType = (Element)it.next();
            if (configurationType.getName().equals("Configure")) {
                mode = "Configure";
            }
            if (configurationType.getName().equals("Unconfigure")) {
                mode = "Unconfigure";
            }
        }
        return mode;
    }

    public String getPSProdDir() {
        return this.psInstallDetails.getAttributeValue("ProdDir");
    }

    public String getPSConfigDir() {
        return this.psInstallDetails.getAttributeValue("ConfigDir");
    }

    public String getPSDataDir() {
        return this.psInstallDetails.getAttributeValue("DataDir");
    }

    public Map getsharedCompDetails() {
        Iterator it = this.sharedCompDetails.getAttributes().iterator();
        HashMap<String, String> hm = new HashMap<String, String>();
        while (it.hasNext()) {
            Attribute Attr = (Attribute)it.next();
            hm.put(Attr.getName(), Attr.getValue());
        }
        return hm;
    }

    public String getJavaHome() {
        return this.sharedCompDetails.getAttributeValue("JavaHome");
    }

    public String getCacaoProdDir() {
        return this.sharedCompDetails.getAttributeValue("CacaoProdDir");
    }

    public String getCacaoConfigDir() {
        return this.sharedCompDetails.getAttributeValue("CacaoConfigDir");
    }

    public String getShareLibDir() {
        return this.sharedCompDetails.getAttributeValue("SharedLibDir");
    }

    public String getPrivateLibDir() {
        return this.sharedCompDetails.getAttributeValue("PrivateLibDir");
    }

    public String getJDMKLibDir() {
        return this.sharedCompDetails.getAttributeValue("JDMKLibDir");
    }

    public String getNSSLibDir() {
        return this.sharedCompDetails.getAttributeValue("NSSLibDir");
    }

    public String getJSSJarDir() {
        return this.sharedCompDetails.getAttributeValue("JSSJarDir");
    }

    public String getKTSearchLibDir() {
        return this.sharedCompDetails.getAttributeValue("KTSearchLibDir");
    }

    public String getWebNFSLibDir() {
        return this.sharedCompDetails.getAttributeValue("WebNFSLibDir");
    }

    public String getAntLibDir() {
        return this.sharedCompDetails.getAttributeValue("AntLibDir");
    }

    public String getDerbyLibDir() {
        return this.sharedCompDetails.getAttributeValue("DerbyLibDir");
    }

    public String getAntHomeDir() {
        return this.sharedCompDetails.getAttributeValue("AntHomeDir");
    }

    public String getRegistryLibDir() {
        return this.sharedCompDetails.getAttributeValue("RegistryLibDir");
    }

    public List getPSComponentsToConfigure() {
        ArrayList<String> components = new ArrayList<String>();
        if (this.psComponentsToConfigure != null) {
            Iterator componentsItr = this.psComponentsToConfigure.getChildren("component").iterator();
            while (componentsItr.hasNext()) {
                Element comp = (Element)componentsItr.next();
                components.add(comp.getTextTrim());
            }
        }
        return components;
    }

    public List getPSComponentsToUnConfigure() {
        ArrayList<String> components = new ArrayList<String>();
        Iterator componentsItr = this.psComponentsToConfigure.getChildren("component").iterator();
        while (componentsItr.hasNext()) {
            Element comp = (Element)componentsItr.next();
            components.add(comp.getTextTrim());
        }
        return components;
    }

    public String getConfigHostName() {
        return this.portalConfigDetails.getAttributeValue("ConfigurationHostName");
    }

    public String getSystemUser() {
        return this.portalConfigDetails.getAttributeValue("SystemUser");
    }

    public String getSystemGroup() {
        return this.portalConfigDetails.getAttributeValue("SystemGroup");
    }

    public String isValidateData() {
        return this.portalConfigDetails.getAttributeValue("Validate");
    }

    public String getportalAccessURL() {
        return this.psConfigInfo.getChild("PortalServer").getAttributeValue("PortalAccessURL");
    }

    public Map getPSWebContainerProp(List portalInstances) {
        Iterator it = portalInstances.iterator();
        HashMap<String, Properties> hm = new HashMap<String, Properties>();
        while (it.hasNext()) {
            Properties prop = new Properties();
            Element wcinfo = (Element)it.next();
            String instanceID = wcinfo.getAttributeValue("InstanceID");
            List webcont = wcinfo.getChild("WebContainerProperties").getAttributes();
            Iterator webcontItr = webcont.iterator();
            while (webcontItr.hasNext()) {
                Attribute Attr = (Attribute)webcontItr.next();
                prop.setProperty(Attr.getName(), Attr.getValue());
            }
            hm.put(instanceID, prop);
        }
        return hm;
    }

    public Map getSearchServerDetails() {
        Iterator it = this.searchServers.iterator();
        HashMap<String, Properties> hm = new HashMap<String, Properties>();
        while (it.hasNext()) {
            Properties prop = new Properties();
            Element searchInfo = (Element)it.next();
            String searchID = searchInfo.getAttributeValue("SearchServerID");
            Element wcinfo = searchInfo.getChild("WebContainerProperties");
            List webcont = wcinfo.getAttributes();
            Iterator webcontItr = webcont.iterator();
            while (webcontItr.hasNext()) {
                Attribute Attr = (Attribute)webcontItr.next();
                prop.setProperty(Attr.getName(), Attr.getValue());
            }
            hm.put(searchID, prop);
        }
        return hm;
    }

    public Map getPortalServerData() {
        Iterator it = this.portals.iterator();
        HashMap hm = new HashMap();
        Map portalInstancesData = new HashMap();
        List portalInstances = new ArrayList();
        while (it.hasNext()) {
            ArrayList<Object> portalDeploymentInfo = new ArrayList<Object>();
            Element portal = (Element)it.next();
            String portalID = portal.getAttributeValue("PortalID");
            portalDeploymentInfo.add(portal.getAttributeValue("PortalWebappURI"));
            portalDeploymentInfo.add(portal.getAttributeValue("PortalAccessURL"));
            portalInstances = portal.getChildren("Instance");
            portalInstancesData = this.getPSWebContainerProp(portalInstances);
            portalDeploymentInfo.add(portalInstancesData);
            portalDeploymentInfo.add(portal.getAttributeValue("SearchServerID"));
            hm.put(portalID, portalDeploymentInfo);
        }
        return hm;
    }

    public Map getPortalInstances() {
        Iterator it = this.portals.iterator();
        HashMap<String, String> hm = new HashMap<String, String>();
        List portalInstances = new ArrayList();
        String instanceID = "";
        while (it.hasNext()) {
            Element portal = (Element)it.next();
            String portalID = portal.getAttributeValue("PortalID");
            portalInstances = portal.getChildren("Instance");
            Iterator itr = portalInstances.iterator();
            while (itr.hasNext()) {
                Element instance = (Element)itr.next();
                instanceID = instance.getAttributeValue("InstanceID");
            }
            hm.put(portalID, instanceID);
        }
        return hm;
    }

    public Map getSamplePortalData() {
        Iterator it = this.portals.iterator();
        HashMap hm = new HashMap();
        Map portalInstancesData = new HashMap();
        List portalInstances = new ArrayList();
        String enterprisePortal = "false";
        String developerPortal = "false";
        String communityPortal = "false";
        while (it.hasNext()) {
            ArrayList<Object> portalDeploymentInfo = new ArrayList<Object>();
            Element portal = (Element)it.next();
            String portalID = portal.getAttributeValue("PortalID");
            portalDeploymentInfo.add(portal.getAttributeValue("PortalWebappURI"));
            portalDeploymentInfo.add(portal.getAttributeValue("PortalAccessURL"));
            portalDeploymentInfo.add(portal.getAttributeValue("SearchServerID"));
            Element samplePortal = portal.getChild("SamplePortal");
            Element profiler = portal.getChild("Profiler");
            Element mail = portal.getChild("MailServer");
            Element calendar = portal.getChild("CalendarServer");
            Element addressBook = portal.getChild("AddressBookServer");
            Element instantMessenger = portal.getChild("InstantMessagingServer");
            if (samplePortal != null) {
                List samples = new ArrayList();
                samples = samplePortal.getChildren("Sample");
                Iterator itr = samples.iterator();
                while (itr.hasNext()) {
                    Element sample = (Element)itr.next();
                    String sampleName = sample.getAttributeValue("Name");
                    if (!sampleName.equals("DeveloperPortal") && !sampleName.equals("CommunityPortal") && !sampleName.equals("EnterprisePortal")) continue;
                    if (sampleName.equals("DeveloperPortal")) {
                        developerPortal = "true";
                    }
                    if (sampleName.equals("EnterprisePortal")) {
                        enterprisePortal = "true";
                    }
                    if (!sampleName.equals("CommunityPortal")) continue;
                    communityPortal = "true";
                }
            }
            portalDeploymentInfo.add(developerPortal);
            portalDeploymentInfo.add(enterprisePortal);
            portalDeploymentInfo.add(communityPortal);
            if (profiler != null) {
                portalDeploymentInfo.add(profiler.getAttributes());
            } else {
                portalDeploymentInfo.add(new ArrayList());
            }
            if (mail != null) {
                portalDeploymentInfo.add(mail.getAttributes());
            } else {
                portalDeploymentInfo.add(new ArrayList());
            }
            if (calendar != null) {
                portalDeploymentInfo.add(calendar.getAttributes());
            } else {
                portalDeploymentInfo.add(new ArrayList());
            }
            if (addressBook != null) {
                portalDeploymentInfo.add(addressBook.getAttributes());
            } else {
                portalDeploymentInfo.add(new ArrayList());
            }
            if (instantMessenger != null) {
                portalDeploymentInfo.add(instantMessenger.getAttributes());
            } else {
                portalDeploymentInfo.add(new ArrayList());
            }
            portalInstances = portal.getChildren("Instance");
            portalInstancesData = this.getPSWebContainerProp(portalInstances);
            portalDeploymentInfo.add(portalInstancesData);
            hm.put(portalID, portalDeploymentInfo);
        }
        return hm;
    }

    public String getSRAGatewayProtocol() {
        return this.sraCompDetails.getAttributeValue("GatewayProtocol");
    }

    public String getSRAPortalServerDomain() {
        return this.sraCompDetails.getAttributeValue("PortalServerDomain");
    }

    public String getSRAGatewayPortNo() {
        return this.sraCompDetails.getAttributeValue("GatewayPort");
    }

    public String getSRAGatewayProfileName() {
        return this.sraCompDetails.getAttributeValue("GatewayProfileName");
    }

    public String getSRALogUserPassword() {
        return this.sraCompDetails.getAttributeValue("LogUserPassword");
    }

    public boolean isConfiguringSearchalone() {
        return this.portals.isEmpty();
    }

    public Map getGatewayDetails() {
        Iterator it = this.gatewayInfo.iterator();
        HashMap<String, Properties> hm = new HashMap<String, Properties>();
        while (it.hasNext()) {
            Properties prop = new Properties();
            Element gatewayData = (Element)it.next();
            String profileName = gatewayData.getAttributeValue("Profile");
            Element instanceinfo = gatewayData.getChild("SRAInstance");
            List instanceProp = instanceinfo.getAttributes();
            Iterator instancePropItr = instanceProp.iterator();
            while (instancePropItr.hasNext()) {
                Attribute Attr = (Attribute)instancePropItr.next();
                prop.setProperty(Attr.getName(), Attr.getValue());
            }
            hm.put(profileName, prop);
        }
        return hm;
    }

    public Map getNetletProxyDetails() {
        Iterator it = this.netletProxyInfo.iterator();
        HashMap<String, Properties> hm = new HashMap<String, Properties>();
        while (it.hasNext()) {
            Properties prop = new Properties();
            Element netletProxyData = (Element)it.next();
            String profileName = netletProxyData.getAttributeValue("Profile");
            Element instanceinfo = netletProxyData.getChild("SRAInstance");
            List instanceProp = instanceinfo.getAttributes();
            Iterator instancePropItr = instanceProp.iterator();
            while (instancePropItr.hasNext()) {
                Attribute Attr = (Attribute)instancePropItr.next();
                prop.setProperty(Attr.getName(), Attr.getValue());
            }
            hm.put(profileName, prop);
        }
        return hm;
    }

    public Map getRewriterProxyDetails() {
        Iterator it = this.rewriterProxyInfo.iterator();
        HashMap<String, Properties> hm = new HashMap<String, Properties>();
        while (it.hasNext()) {
            Properties prop = new Properties();
            Element rewriterProxyData = (Element)it.next();
            String profileName = rewriterProxyData.getAttributeValue("Profile");
            Element instanceinfo = rewriterProxyData.getChild("SRAInstance");
            List instanceProp = instanceinfo.getAttributes();
            Iterator instancePropItr = instanceProp.iterator();
            while (instancePropItr.hasNext()) {
                Attribute Attr = (Attribute)instancePropItr.next();
                prop.setProperty(Attr.getName(), Attr.getValue());
            }
            hm.put(profileName, prop);
        }
        return hm;
    }

    public String getcertificateOrganization() {
        return this.certificateInfo.getAttributeValue("Organization");
    }

    public String getcertificateDivision() {
        return this.certificateInfo.getAttributeValue("Division");
    }

    public String getcertificateCityOrLocality() {
        return this.certificateInfo.getAttributeValue("CityOrLocality");
    }

    public String getcertificateStateProvince() {
        return this.certificateInfo.getAttributeValue("StateProvince");
    }

    public String getcertificateCountryCode() {
        return this.certificateInfo.getAttributeValue("CountryCode");
    }

    public String getCertifcateDBPassword() {
        return this.certificateInfo.getAttributeValue("CertificateDatabasePassword");
    }

    public String getIsUnconfigureAll() {
        return this.portalConfigDetails.getAttributeValue("UnconfigureAll");
    }

    public List getSearchSeversToDelete() {
        Iterator it = this.searchServers.iterator();
        ArrayList<String> searchServerslist = new ArrayList<String>();
        while (it.hasNext()) {
            Element searchInfo = (Element)it.next();
            String searchID = searchInfo.getAttributeValue("SearchServerID");
            searchServerslist.add(searchID);
        }
        return searchServerslist;
    }

    public Map getSRAComponentInstancesToDelete(String sraComponentToDelete, String hostname) {
        HashMap<String, String> sraComponentInstances = new HashMap<String, String>();
        List sraComponentInfo = new ArrayList();
        if (sraComponentToDelete.equals("gateway")) {
            sraComponentInfo = this.gatewayInfo;
        }
        if (sraComponentToDelete.equals("netletproxy")) {
            sraComponentInfo = this.netletProxyInfo;
        }
        if (sraComponentToDelete.equals("rewriterproxy")) {
            sraComponentInfo = this.rewriterProxyInfo;
        }
        Iterator it = sraComponentInfo.iterator();
        while (it.hasNext()) {
            Element sraComponent = (Element)it.next();
            String instanceName = sraComponent.getAttributeValue("Profile");
            sraComponentInstances.put(instanceName, hostname);
        }
        return sraComponentInstances;
    }

    public boolean isOnlySRAComponentInstalled() {
        String fs = File.separator;
        boolean onlySRAComponentInstalled = false;
        String libDir = this.getPSProdDir() + fs + "lib";
        String webInfLibDir = this.getPSProdDir() + fs + "web-src" + fs + "WEB-INF" + fs + "lib";
        if (FileUtil.fileExists((String)(libDir + fs + "gateway.jar"))) {
            onlySRAComponentInstalled = true;
            if (FileUtil.fileExists((String)(webInfLibDir + fs + "netletprovider.jar"))) {
                onlySRAComponentInstalled = false;
            }
        }
        return onlySRAComponentInstalled;
    }
}

