/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.config;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.util.AdminClientUtil;
import com.sun.portal.fabric.config.PortalConfigData;
import com.sun.portal.fabric.config.PortalConfigurator;
import com.sun.portal.fabric.config.ValidatePortalInputData;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.util.LogConfigUtil;
import com.sun.portal.log.common.PortalLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class ConfigurePortal {
    private static PortalConfigData pci = null;
    private static PortalConfigurator pc;
    private static List components;
    private static Logger configLogger;
    private static final char SEPARATOR = '/';
    private static Properties psConfigProps;
    static /* synthetic */ Class class$com$sun$portal$fabric$config$ConfigurePortal;
    static /* synthetic */ Class class$java$net$URLClassLoader;
    static /* synthetic */ Class class$java$net$URL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        int exitCode;
        block29: {
            String psconfigMode;
            block30: {
                MBeanServerConnection msc;
                exitCode = 1;
                if (args == null || args.length < 1) {
                    System.err.println("ERROR: Missing arguments");
                    System.err.println("Please provide the config XML file location");
                    System.exit(exitCode);
                }
                try {
                    pci = new PortalConfigData(args[0]);
                }
                catch (Exception e) {
                    System.err.println("ERROR: Invalid input XML");
                    System.err.println("Please correct errors listed below");
                    e.printStackTrace();
                    System.exit(exitCode);
                }
                psconfigMode = pci.getPSConfigMode();
                if (psconfigMode == null || !psconfigMode.equals("Configure")) break block30;
                components = pci.getPSComponentsToConfigure();
                ConfigurePortal.createPSConfigFile(pci);
                ConfigurePortal.setClassPath();
                PortalConfigurator.createPortalDirectories(pci);
                PortalConfigurator.preparePropertyFiles(pci);
                pc = new PortalConfigurator();
                configLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$config$ConfigurePortal == null ? (class$com$sun$portal$fabric$config$ConfigurePortal = ConfigurePortal.class$("com.sun.portal.fabric.config.ConfigurePortal")) : class$com$sun$portal$fabric$config$ConfigurePortal));
                if (pci.isValidateData().equals("true") || pci.isValidateData().equals("1")) {
                    System.out.println("Validating the Input Config XML File");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0048");
                    new ValidatePortalInputData(pci);
                }
                pc.updatePSConfigFile(psConfigProps, pci);
                if (components.contains("sracore")) {
                    configLogger.log(Level.INFO, "PSFB_CSPFC0001");
                    pc.createSRAConfigPropFile(pci);
                }
                PSConfigContext pcc = pc.getPSConfigContext();
                configLogger.log(Level.INFO, "PSFB_CSPFC0002");
                System.out.println("Configuring Cacao Agent for Portal Software");
                pc.configureHost();
                pc.configDerby(pcc, pci.getConfigHostName());
                pc.setAccessManagerJSSProperty(pcc);
                if (components.contains("portalserver")) {
                    System.out.println("Connecting to Cacao MBean Server");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0004");
                    msc = pc.getMbeanServerConnection(pci.getAMAdmin(), pci.getAMAdminPassword(), pci.getConfigHostName());
                    if (pci.getPortalServerData() != null) {
                        System.out.println("Creating Portals");
                        pc.configurePortal(msc, pci.getPortalServerData());
                        System.out.println("Restarting Portal Server Instances");
                        pc.restartPortalInstances(msc, pci.getPortalInstances());
                        System.out.println("Closing the MBean Server Connection");
                        configLogger.log(Level.INFO, "PSFB_CSPFC0227");
                        pc.closeMbeanServerConnection();
                        System.out.println("Opening MBean Server Connection");
                        configLogger.log(Level.INFO, "PSFB_CSPFC0230");
                        msc = pc.getMbeanServerConnection(pci.getAMAdmin(), pci.getAMAdminPassword(), pci.getConfigHostName());
                        System.out.println("Deploying Web Applications to Portal Server Instances");
                        pc.deployWebappsToPortalInstances(msc, pci.getPortalInstances());
                        try {
                            configLogger.log(Level.INFO, "PSFB_CSPFC0201");
                            pc.loadPortalRewriterRulseSet(msc, pcc);
                            configLogger.log(Level.INFO, "PSFB_CSPFC0202");
                        }
                        catch (ConfigurationException e) {
                            configLogger.log(Level.SEVERE, "PSFB_CSPFC0224");
                        }
                        System.out.println("Configuring Collaboration Applications");
                        pc.configureCollabApps(pci.getPortalServerData(), pcc, pci.getAMAdminPassword());
                    }
                    if (!pci.getSearchServerDetails().isEmpty()) {
                        System.out.println("Creating Search Server");
                        pc.createSearchServer(msc, pci.getSearchServerDetails());
                    }
                    System.out.println("Configuring Samples");
                    pc.configureSamplePortal(msc, pci.getSamplePortalData(), pcc, pci.getAMAdminPassword(), pci.getLDAPUserPassword(), pci.getConfigHostName());
                    if (pci.getPortalServerData() != null) {
                        pc.configureCommunityPortlet(msc, pci.getPortalServerData(), pcc);
                    }
                    System.out.println("Performing Post Configuration Tasks");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0073");
                    pc.postConfigurationTasks(pcc, pci.getAMAdminPassword());
                    System.out.println("Closing the MBean Server Connection");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0015");
                    pc.closeMbeanServerConnection();
                }
                if (components.contains("sracore")) {
                    pc.configureSRA(pci, pcc);
                    try {
                        System.out.println("Connecting to Cacao MBean Server");
                        configLogger.log(Level.INFO, "PSFB_CSPFC0004");
                        msc = pc.getMbeanServerConnection(pci.getAMAdmin(), pci.getAMAdminPassword(), pci.getConfigHostName());
                        System.out.println("Configuring SRA core");
                        configLogger.log(Level.INFO, "PSFB_CSPFC0203");
                        pc.loadSRARewriterRulseSet(msc, pcc);
                        configLogger.log(Level.INFO, "PSFB_CSPFC0204");
                        System.out.println("Closing the MBean Server Connection");
                        configLogger.log(Level.INFO, "PSFB_CSPFC0015");
                        pc.closeMbeanServerConnection();
                    }
                    catch (ConfigurationException e) {
                        configLogger.log(Level.SEVERE, "PSFB_CSPFC0198");
                    }
                }
                if (components.contains("gateway")) {
                    System.out.println("Connecting to Cacao MBean Server");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0004");
                    msc = pc.getMbeanServerConnection(pci.getAMAdmin(), pci.getAMAdminPassword(), pci.getConfigHostName());
                    System.out.println("Configuring Gateway");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0009");
                    pc.configureGateway(msc, pci);
                    System.out.println("Closing the MBean Server Connection");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0015");
                    pc.closeMbeanServerConnection();
                }
                if (components.contains("netletproxy")) {
                    System.out.println("Connecting to Cacao MBean Server");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0004");
                    msc = pc.getMbeanServerConnection(pci.getAMAdmin(), pci.getAMAdminPassword(), pci.getConfigHostName());
                    System.out.println("Configuring NetletProxy");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0011");
                    pc.configureNetletProxy(msc, pci);
                    System.out.println("Closing the MBean Server Connection");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0015");
                    pc.closeMbeanServerConnection();
                }
                if (components.contains("rewriterproxy")) {
                    System.out.println("Connecting to Cacao MBean Server");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0004");
                    msc = pc.getMbeanServerConnection(pci.getAMAdmin(), pci.getAMAdminPassword(), pci.getConfigHostName());
                    System.out.println("Configuring RewriterProxy");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0013");
                    pc.configureRewriterProxy(msc, pci);
                    System.out.println("Closing the MBean Server Connection");
                    configLogger.log(Level.INFO, "PSFB_CSPFC0015");
                    pc.closeMbeanServerConnection();
                }
                exitCode = 0;
                Object var7_10 = null;
                try {
                    ConfigurePortal.resetLogLevel();
                    pc.closeMbeanServerConnection();
                    configLogger.log(Level.INFO, "PSFB_CSPFC0015");
                }
                catch (Exception e2) {}
                break block29;
                {
                    catch (Exception e) {
                        System.err.println("Configuration Failed : " + e.getMessage());
                        e.printStackTrace();
                        configLogger.log(Level.SEVERE, "PSFB_CSPFC0014", e);
                        Object var7_11 = null;
                        try {
                            ConfigurePortal.resetLogLevel();
                            pc.closeMbeanServerConnection();
                            configLogger.log(Level.INFO, "PSFB_CSPFC0015");
                        }
                        catch (Exception e2) {}
                        break block29;
                    }
                    catch (Throwable e1) {
                        System.err.println("ERROR: Configuration Failed");
                        System.err.println("Dependency paths in input xml maybe incorrect");
                        e1.printStackTrace();
                        Object var7_12 = null;
                        try {
                            ConfigurePortal.resetLogLevel();
                            pc.closeMbeanServerConnection();
                            configLogger.log(Level.INFO, "PSFB_CSPFC0015");
                        }
                        catch (Exception e2) {}
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    try {
                        ConfigurePortal.resetLogLevel();
                        pc.closeMbeanServerConnection();
                        configLogger.log(Level.INFO, "PSFB_CSPFC0015");
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (psconfigMode != null) {
                System.err.println("ERROR: Invalid input file. XML has a '" + pci.getPSConfigMode() + "' Element.");
            } else {
                System.err.println("ERROR: Invalid input file");
            }
            exitCode = 1;
        }
        System.exit(exitCode);
    }

    private static void resetLogLevel() throws ConfigurationException {
        try {
            String defaultLevel = LogConfigUtil.getDefaultLogLevel();
            MBeanServerConnection msc = pc.getMbeanServerConnection(pci.getAMAdmin(), pci.getAMAdminPassword(), pci.getConfigHostName());
            LinkedList<String> path = new LinkedList<String>();
            path.addFirst("defaultDomain");
            path.addFirst("portalLogConfigurator");
            ObjectName objName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.PortalLogConfigurator", path);
            Object[] params = new Object[]{"pas", "", "", "debug.com.sun.portal", defaultLevel};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
            msc.invoke(objName, "setLevel", params, signature);
            configLogger.log(Level.INFO, "PSFB_CSPFC0242", defaultLevel);
            pc.closeMbeanServerConnection();
        }
        catch (InstanceNotFoundException ie) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0243", ie);
            throw new ConfigurationException((Throwable)ie);
        }
        catch (MBeanException me) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0243", me);
            throw new ConfigurationException((Throwable)me);
        }
        catch (Exception e) {
            configLogger.log(Level.SEVERE, "PSFB_CSPFC0243", e);
            throw new ConfigurationException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void setClassPath() throws ConfigurationException {
        BufferedReader reader = null;
        try {
            try {
                URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                InputStream ins = sysloader.getResourceAsStream("psconfig.classpath");
                InputStreamReader classpathJarsList = new InputStreamReader(ins);
                reader = new BufferedReader(classpathJarsList);
                Class sysclass = class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = ConfigurePortal.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader;
                Class[] parameters = new Class[]{class$java$net$URL == null ? (class$java$net$URL = ConfigurePortal.class$("java.net.URL")) : class$java$net$URL};
                Method method = sysclass.getDeclaredMethod("addURL", parameters);
                method.setAccessible(true);
                String sysClasspath = System.getProperty("java.class.path");
                StringBuffer cPathBuf = new StringBuffer(sysClasspath);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    line.trim();
                    int index = line.indexOf(47);
                    String key = line.substring(0, index);
                    String src = line.substring(index);
                    src = psConfigProps.getProperty(key, "") + src;
                    src = src.replace('/', File.separatorChar);
                    String ps = File.pathSeparator;
                    if (sysClasspath.indexOf(src) != -1) continue;
                    File jarFile = new File(src);
                    method.invoke((Object)sysloader, jarFile.toURL());
                    cPathBuf.append(ps);
                    cPathBuf.append(src);
                }
                System.setProperty("java.class.path", cPathBuf.toString());
            }
            catch (Exception ex) {
                throw new ConfigurationException(ex.toString());
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new ConfigurationException(ioe.toString());
            }
        }
        try {}
        catch (IOException ioe) {
            throw new ConfigurationException(ioe.toString());
        }
        reader.close();
    }

    private static void createPSConfigFile(PortalConfigData pci) throws ConfigurationException {
        File psConfigDir = new File(pci.getPSConfigDir());
        File psConfigFile = new File(pci.getPSConfigDir() + File.separator + "PSConfig.properties");
        try {
            if (!psConfigDir.exists()) {
                System.out.println("Creating directory: " + psConfigDir);
                psConfigDir.mkdirs();
            } else if (psConfigDir.isFile()) {
                throw new ConfigurationException("Please remove file:" + psConfigDir);
            }
            FileOutputStream out = new FileOutputStream(psConfigFile);
            psConfigProps.setProperty("java.home", pci.getJavaHome());
            psConfigProps.setProperty("ps.product.location", pci.getPSProdDir());
            psConfigProps.setProperty("ps.data.location", pci.getPSDataDir());
            psConfigProps.setProperty("ps.config.location", pci.getPSConfigDir());
            psConfigProps.setProperty("ps.default.portal", "Upgraded");
            psConfigProps.setProperty("am.product.location", pci.getAMProdDir());
            psConfigProps.setProperty("am.data.location", pci.getAMDataDir());
            psConfigProps.setProperty("am.config.location", pci.getAMConfigDir());
            psConfigProps.setProperty("cacao.product.location", pci.getCacaoProdDir());
            psConfigProps.setProperty("cacao.config.location", pci.getCacaoConfigDir());
            psConfigProps.setProperty("shared.lib.location", pci.getShareLibDir());
            psConfigProps.setProperty("private.lib.location", pci.getPrivateLibDir());
            psConfigProps.setProperty("jdmk.lib.location", pci.getJDMKLibDir());
            psConfigProps.setProperty("jss.nss.lib.location", pci.getNSSLibDir());
            psConfigProps.setProperty("jss.jar.location", pci.getJSSJarDir());
            psConfigProps.setProperty("webnfs.lib.location", pci.getWebNFSLibDir());
            psConfigProps.setProperty("ant.home.location", pci.getAntHomeDir());
            psConfigProps.setProperty("ant.lib.location", pci.getAntLibDir());
            psConfigProps.setProperty("derby.lib.location", pci.getDerbyLibDir());
            psConfigProps.setProperty("registry.lib.location", pci.getRegistryLibDir());
            psConfigProps.setProperty("amconsole.lib.location", "/usr/share/lib");
            psConfigProps.store(out, "");
            ((OutputStream)out).close();
            System.out.println("Successfully created PSConfig.properties file");
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (IOException ioe) {
            throw new ConfigurationException((Throwable)ioe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        psConfigProps = new Properties();
    }
}

