/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletappengine.impl;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.portlet.impl.ActionRequestPool;
import com.sun.portal.portlet.impl.ActionResponsePool;
import com.sun.portal.portlet.impl.EventRequestPool;
import com.sun.portal.portlet.impl.EventResponsePool;
import com.sun.portal.portlet.impl.RenderRequestPool;
import com.sun.portal.portlet.impl.RenderResponsePool;
import com.sun.portal.portletappengine.RequestResponseFactory;
import com.sun.portal.portletappengine.ipc.EventRequest;
import com.sun.portal.portletappengine.ipc.EventResponse;
import com.sun.portal.portletcontainercommon.PortletContainerActionRequest;
import com.sun.portal.portletcontainercommon.PortletContainerActionResponse;
import com.sun.portal.portletcontainercommon.PortletContainerEventRequest;
import com.sun.portal.portletcontainercommon.PortletContainerEventResponse;
import com.sun.portal.portletcontainercommon.PortletContainerRenderRequest;
import com.sun.portal.portletcontainercommon.PortletContainerRenderResponse;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestResponseFactoryImpl
implements RequestResponseFactory {
    public static final String MIN_SIZE = "minSizeParam";
    public static final String MAX_SIZE = "maxSizeParam";
    public static final String PARTITION = "partitionParam";
    private ActionRequestPool _actionRequestPool;
    private RenderRequestPool _renderRequestPool;
    private ActionResponsePool _actionResponsePool;
    private RenderResponsePool _renderResponsePool;
    private static Logger _logger = PortalLogger.getLogger((Class)(class$com$sun$portal$portletappengine$impl$RequestResponseFactoryImpl == null ? (class$com$sun$portal$portletappengine$impl$RequestResponseFactoryImpl = RequestResponseFactoryImpl.class$("com.sun.portal.portletappengine.impl.RequestResponseFactoryImpl")) : class$com$sun$portal$portletappengine$impl$RequestResponseFactoryImpl));
    private EventRequestPool eventRequestPool;
    private EventResponsePool eventResponsePool;
    private ServletContext sc = null;
    private static final int DEFAULT_MIN_SIZE = 0;
    private static final int DEFAULT_MAX_SIZE = 200;
    private static final int DEFAULT_PARTITION_SIZE = 10;
    private static final int ACTION_REQUEST = 1;
    private static final int RENDER_REQUEST = 2;
    private static final int ACTION_RESPONSE = 3;
    private static final int RENDER_RESPONSE = 4;
    private static final int EVENT_REQUEST = 5;
    private static final int EVENT_RESPONSE = 6;
    static /* synthetic */ Class class$com$sun$portal$portletappengine$impl$RequestResponseFactoryImpl;

    public void init(ServletContext context) {
        this.sc = context;
        String min = context.getInitParameter("request_response_factory.minSizeParam").trim();
        String max = context.getInitParameter("request_response_factory.maxSizeParam").trim();
        String partition = context.getInitParameter("request_response_factory.partitionParam").trim();
        _logger.log(Level.FINEST, "PSPL_PAECSPPAI0001", min);
        _logger.log(Level.FINEST, "PSPL_PAECSPPAI0002", max);
        _logger.log(Level.FINEST, "PSPL_PAECSPPAI0003", partition);
        this.initRequestResponsePool(context, Integer.parseInt(min), Integer.parseInt(max), Integer.parseInt(partition), 1);
        this.initRequestResponsePool(context, Integer.parseInt(min), Integer.parseInt(max), Integer.parseInt(partition), 2);
        this.initRequestResponsePool(context, Integer.parseInt(min), Integer.parseInt(max), Integer.parseInt(partition), 3);
        this.initRequestResponsePool(context, Integer.parseInt(min), Integer.parseInt(max), Integer.parseInt(partition), 4);
        this.initRequestResponsePool(context, Integer.parseInt(min), Integer.parseInt(max), Integer.parseInt(partition), 5);
        this.initRequestResponsePool(context, Integer.parseInt(min), Integer.parseInt(max), Integer.parseInt(partition), 6);
        context.setAttribute("_actionRequestPool", (Object)this._actionRequestPool);
        context.setAttribute("_renderRequestPool", (Object)this._renderRequestPool);
        context.setAttribute("_actionResponsePool", (Object)this._actionResponsePool);
        context.setAttribute("_renderResponsePool", (Object)this._renderResponsePool);
        context.setAttribute("eventRequestPool", (Object)this.eventRequestPool);
        context.setAttribute("eventResponsePool", (Object)this.eventResponsePool);
    }

    public ActionRequest getActionRequest(HttpServletRequest req, HttpServletResponse res, PortletContainerActionRequest pContReq, PortletContainerActionResponse pContRes, PortletContext context, PortalContext portalContext, PortletDescriptor pDescriptor, StringWriter writer) {
        if (this._actionRequestPool == null) {
            this._actionRequestPool = (ActionRequestPool)((Object)this.sc.getAttribute("_actionRequestPool"));
        }
        return this._actionRequestPool.obtainObject(req, res, pContReq, pContRes, context, portalContext, pDescriptor, writer);
    }

    public RenderRequest getRenderRequest(HttpServletRequest req, HttpServletResponse res, PortletContainerRenderRequest pContReq, PortletContainerRenderResponse pContRes, PortletContext context, PortalContext portalContext, PortletDescriptor pDescriptor) {
        if (this._renderRequestPool == null) {
            this._renderRequestPool = (RenderRequestPool)((Object)this.sc.getAttribute("_renderRequestPool"));
        }
        return this._renderRequestPool.obtainObject(req, res, pContReq, pContRes, context, portalContext, pDescriptor);
    }

    public ActionResponse getActionResponse(HttpServletRequest req, HttpServletResponse res, ActionRequest aReq, PortletContainerActionRequest pContReq, PortletContainerActionResponse pContRes) {
        if (this._actionResponsePool == null) {
            this._actionResponsePool = (ActionResponsePool)((Object)this.sc.getAttribute("_actionResponsePool"));
        }
        return this._actionResponsePool.obtainObject(req, res, aReq, pContReq, pContRes);
    }

    public RenderResponse getRenderResponse(HttpServletRequest req, HttpServletResponse res, RenderRequest rReq, PortletContainerRenderRequest pContReq, PortletContainerRenderResponse pContRes, StringWriter writer, ByteArrayOutputStream output, PortletDescriptor pDescriptor) {
        if (this._renderResponsePool == null) {
            this._renderResponsePool = (RenderResponsePool)((Object)this.sc.getAttribute("_renderResponsePool"));
        }
        return this._renderResponsePool.obtainObject(req, res, rReq, pContReq, pContRes, writer, output, pDescriptor);
    }

    public void releaseActionRequest(ActionRequest actionReq) {
        this._actionRequestPool.releaseObject(actionReq);
    }

    public void releaseRenderRequest(RenderRequest renderReq) {
        this._renderRequestPool.releaseObject(renderReq);
    }

    public void releaseActionResponse(ActionResponse actionRes) {
        this._actionResponsePool.releaseObject(actionRes);
    }

    public void releaseRenderResponse(RenderResponse portletRes) {
        this._renderResponsePool.releaseObject(portletRes);
    }

    public EventRequest getEventRequest(HttpServletRequest req, HttpServletResponse res, PortletContainerEventRequest pceRequest, PortletContainerEventResponse pceResponse, PortletContext context, PortalContext portalContext, PortletDescriptor pDescriptor) {
        return this.eventRequestPool.obtainObject(req, res, pceRequest, pceResponse, context, portalContext, pDescriptor);
    }

    public EventResponse getEventResponse(PortletContainerEventResponse pceResponse) {
        return this.eventResponsePool.obtainObject(pceResponse);
    }

    public void releaseEventRequest(EventRequest ereq) {
        this.eventRequestPool.releaseObject(ereq);
    }

    public void releaseEventResponse(EventResponse eres) {
        this.eventResponsePool.releaseObject(eres);
    }

    private void initRequestResponsePool(ServletContext context, int minSize, int maxSize, int partition, int type) {
        if (minSize < 0) {
            _logger.log(Level.FINER, "PSPL_PAECSPPAI0004", new Integer(0));
            minSize = 0;
        }
        if (maxSize < 0) {
            _logger.log(Level.FINER, "PSPL_PAECSPPAI0005", new Integer(200));
            maxSize = 200;
        }
        if (partition < 0) {
            _logger.log(Level.FINER, "PSPL_PAECSPPAI0006", new Integer(10));
            partition = 10;
        }
        if (minSize > maxSize) {
            _logger.log(Level.FINER, "PSPL_PAECSPPAI0007", new Integer(200));
            minSize = 200;
        }
        if (partition > maxSize) {
            _logger.log(Level.FINER, "PSPL_PAECSPPAI0008", new Integer(200));
            partition = 200;
        }
        switch (type) {
            case 1: {
                this._actionRequestPool = new ActionRequestPool(context, minSize, maxSize, true, partition, _logger);
                break;
            }
            case 2: {
                this._renderRequestPool = new RenderRequestPool(context, minSize, maxSize, true, partition, _logger);
                break;
            }
            case 3: {
                this._actionResponsePool = new ActionResponsePool(minSize, maxSize, true, partition, _logger);
                break;
            }
            case 4: {
                this._renderResponsePool = new RenderResponsePool(minSize, maxSize, true, partition, _logger);
            }
            case 5: {
                this.eventRequestPool = new EventRequestPool(context, minSize, maxSize, true, partition, _logger);
            }
            case 6: {
                this.eventResponsePool = new EventResponsePool(minSize, maxSize, true, partition, _logger);
            }
        }
    }

    public void destroy() {
        this._actionRequestPool = null;
        this._renderRequestPool = null;
        this._actionResponsePool = null;
        this._renderResponsePool = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

