/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletappengine.impl;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.portlet.impl.PortalContextImpl;
import com.sun.portal.portlet.impl.PortletConfigImpl;
import com.sun.portal.portlet.impl.PortletContextImpl;
import com.sun.portal.portletappengine.LifecycleManager;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorReader;
import com.sun.portal.portletcontainercommon.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletPreferencesDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletsDescriptor;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortalContext;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PreferencesValidator;
import javax.portlet.UnavailableException;
import javax.servlet.ServletContext;

public class LifecycleManagerImpl
implements LifecycleManager {
    private PortletAppDescriptor _portletAppDescriptor;
    private PortletContext _portletContext;
    private static Logger _logger = PortalLogger.getLogger((Class)(class$com$sun$portal$portletappengine$impl$LifecycleManagerImpl == null ? (class$com$sun$portal$portletappengine$impl$LifecycleManagerImpl = LifecycleManagerImpl.class$("com.sun.portal.portletappengine.impl.LifecycleManagerImpl")) : class$com$sun$portal$portletappengine$impl$LifecycleManagerImpl));
    private Map _portlets = new HashMap();
    private Map _portletConfigs = new HashMap();
    private Map _validators = new HashMap();
    private PortalContext _portalContext;
    static /* synthetic */ Class class$com$sun$portal$portletappengine$impl$LifecycleManagerImpl;

    public void init(ServletContext context) {
        InputStream xmlStream = context.getResourceAsStream("/WEB-INF/portlet.xml");
        InputStream xmlExtStream = context.getResourceAsStream("/WEB-INF/sun-portlet.xml");
        String schemaLocation = context.getInitParameter(DeploymentDescriptorReader.PORTLET_SCHEMA_LOCATION);
        this._portletAppDescriptor = this.initDeploymentDescriptor(xmlStream, xmlExtStream, schemaLocation);
        this._portalContext = this.initPortalContext();
        if (this._portletAppDescriptor != null) {
            this._portletContext = this.initPortletContext(context);
            this.createPortlets();
        }
    }

    public LinkedHashMap getGeneratedEvents() {
        return this._portletAppDescriptor.getPortletsDescriptor().getGeneratedEvents();
    }

    public LinkedHashMap getConsumeEvents() {
        return this._portletAppDescriptor.getPortletsDescriptor().getConsumeEvents();
    }

    private PortletContext initPortletContext(ServletContext context) {
        return new PortletContextImpl(context, this._portletAppDescriptor);
    }

    private PortalContext initPortalContext() {
        return new PortalContextImpl();
    }

    private PortletAppDescriptor initDeploymentDescriptor(InputStream xmlStream, InputStream xmlExtStream, String schemaLocation) {
        DeploymentDescriptorReader reader = new DeploymentDescriptorReader(_logger, schemaLocation);
        PortletAppDescriptor portletAppDescriptor = null;
        try {
            portletAppDescriptor = reader.loadPortletAppDescriptor(xmlStream, xmlExtStream);
        }
        catch (DeploymentDescriptorException de) {
            // empty catch block
        }
        return portletAppDescriptor;
    }

    public PortletAppDescriptor getDeploymentDescriptor() {
        return this._portletAppDescriptor;
    }

    public Portlet getPortlet(String portletName) throws PortletException {
        Portlet p = (Portlet)this._portlets.get(portletName);
        if (p == null) {
            _logger.log(Level.FINER, "PSPL_PAECSPPAI0009", portletName);
            throw new PortletException("LifecycleManagerImpl.getPortlet(), can not get portlet.");
        }
        return p;
    }

    public PreferencesValidator getPreferencesValidator(String portletName) {
        return (PreferencesValidator)this._validators.get(portletName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePortlet(String portletName) {
        Portlet p = (Portlet)this._portlets.get(portletName);
        if (p != null) {
            Map map = this._portlets;
            synchronized (map) {
                this._portlets.put(portletName, null);
            }
        }
    }

    public PortletConfig getPortletConfig(String portletName) {
        PortletConfig config = (PortletConfig)this._portletConfigs.get(portletName);
        if (config == null) {
            _logger.log(Level.FINER, "PSPL_PAECSPPAI0009", portletName);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePortletConfig(String portletName) {
        PortletConfig config = (PortletConfig)this._portletConfigs.get(portletName);
        if (config != null) {
            Map map = this._portletConfigs;
            synchronized (map) {
                this._portletConfigs.put(portletName, null);
            }
        }
    }

    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    public PortalContext getPortalContext() {
        return this._portalContext;
    }

    public Logger getLogger() {
        return _logger;
    }

    public void destroy() {
        this._portletAppDescriptor = null;
        this._portletContext = null;
        Iterator i = this._portlets.keySet().iterator();
        while (i.hasNext()) {
            String portletName = (String)i.next();
            Portlet p = (Portlet)this._portlets.get(portletName);
            try {
                p.destroy();
            }
            catch (RuntimeException re) {
                _logger.log(Level.FINE, "PSPL_PAECSPPAI0010", portletName);
            }
        }
        this._portlets.clear();
        this._portletConfigs.clear();
        this._validators.clear();
    }

    private Portlet createPortlet(String portletName, PortletDescriptor portletDescriptor) throws UnavailableException {
        Portlet portlet;
        String portletClassName = portletDescriptor.getClassName();
        PreferencesValidator validator = null;
        if (portletClassName == null) {
            throw new UnavailableException("LifecycleManagerImpl.getPortlet(), the portlet class name is not defined for portlet: " + portletName);
        }
        _logger.log(Level.FINEST, "PSPL_PAECSPPAI0011", portletClassName);
        try {
            Class<?> portletClass = Thread.currentThread().getContextClassLoader().loadClass(portletClassName);
            portlet = (Portlet)portletClass.newInstance();
            PortletPreferencesDescriptor pPrefDescriptor = portletDescriptor.getPortletPreferencesDescriptor();
            if (pPrefDescriptor != null && (validator = this.instantiatePreferencesValidator(pPrefDescriptor.getPreferencesValidatorName())) != null) {
                this._validators.put(portletName, validator);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnavailableException("LifecycleManagerImpl.createPortlet(): ");
        }
        catch (IllegalAccessException iae) {
            throw new UnavailableException("LifecycleManagerImpl.createPortlet(): ");
        }
        catch (ClassCastException cce) {
            throw new UnavailableException("LifecycleManagerImpl.createPortlet(): ");
        }
        catch (InstantiationException ie) {
            throw new UnavailableException("LifecycleManagerImpl.createPortlet(): ");
        }
        return portlet;
    }

    private void createPortlets() {
        PortletsDescriptor portletsDescriptor = null;
        if (this._portletAppDescriptor != null) {
            portletsDescriptor = this._portletAppDescriptor.getPortletsDescriptor();
        }
        if (portletsDescriptor != null) {
            List names = portletsDescriptor.getPortletNames();
            for (int i = 0; i < names.size(); ++i) {
                String portletName = (String)names.get(i);
                PortletDescriptor portletDescriptor = portletsDescriptor.getPortletDescriptor(portletName);
                if (portletDescriptor == null) continue;
                PortletConfigImpl config = new PortletConfigImpl(portletDescriptor, portletName, this._portletContext);
                try {
                    Portlet p = this.createPortlet(portletName, portletDescriptor);
                    p.init((PortletConfig)config);
                    this._portlets.put(portletName, p);
                    this._portletConfigs.put(portletName, config);
                    _logger.log(Level.FINEST, "PSPL_PAECSPPAI0012", portletName);
                    continue;
                }
                catch (UnavailableException ue) {
                    _logger.log(Level.INFO, "PSPL_PAECSPPAI0013", ue);
                    continue;
                }
                catch (PortletException pe) {
                    _logger.log(Level.INFO, "PSPL_PAECSPPAI0013", pe);
                    continue;
                }
                catch (Throwable e) {
                    _logger.log(Level.INFO, "PSPL_PAECSPPAI0013", e);
                }
            }
        }
    }

    private PreferencesValidator instantiatePreferencesValidator(String validatorName) {
        PreferencesValidator validator = null;
        if (validatorName != null) {
            try {
                Class<?> validatorClass = Thread.currentThread().getContextClassLoader().loadClass(validatorName);
                validator = (PreferencesValidator)validatorClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (ClassCastException cce) {
            }
            catch (InstantiationException ie) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return validator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

