/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletappengine;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.portlet.impl.PortletsResources;
import com.sun.portal.portletappengine.LifecycleManager;
import com.sun.portal.portletappengine.PortletAppEngineConstants;
import com.sun.portal.portletappengine.PortletAppEngineUtils;
import com.sun.portal.portletappengine.RequestResponseFactory;
import com.sun.portal.portletappengine.ipc.EventRequest;
import com.sun.portal.portletappengine.ipc.EventResponse;
import com.sun.portal.portletappengine.ipc.PortletEventListener;
import com.sun.portal.portletappengine.ubt.PortletLogRecord;
import com.sun.portal.portletcontainercommon.PortletContainerActionRequest;
import com.sun.portal.portletcontainercommon.PortletContainerActionResponse;
import com.sun.portal.portletcontainercommon.PortletContainerErrorCode;
import com.sun.portal.portletcontainercommon.PortletContainerEventRequest;
import com.sun.portal.portletcontainercommon.PortletContainerEventResponse;
import com.sun.portal.portletcontainercommon.PortletContainerRenderRequest;
import com.sun.portal.portletcontainercommon.PortletContainerRenderResponse;
import com.sun.portal.portletcontainercommon.PortletContainerRequest;
import com.sun.portal.portletcontainercommon.PortletContainerResponse;
import com.sun.portal.portletcontainercommon.PreferencesValidatorSetter;
import com.sun.portal.portletcontainercommon.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.SecurityConstraintDescriptor;
import com.sun.portal.ubt.UBTEvent;
import com.sun.portal.ubt.UBTLogManager;
import com.sun.portal.ubt.UBTLogRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import javax.portlet.WindowStateException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletAppEngineServlet
extends HttpServlet {
    private static final String GET = "get";
    private static final char DELIMETER = '|';
    private static final String JAVAX_PORTLET_ENTITY_ID = "javax.portlet.entityID";
    private static final String JAVAX_PORTLET_TITLE = "javax.portlet.title";
    public static final String CONFIDENTIAL = "CONFIDENTIAL";
    public static final String INTEGRAL = "INTEGRAL";
    private LifecycleManager lifecycleManager;
    private RequestResponseFactory requestResponseFactory;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$portletappengine$PortletAppEngineServlet == null ? (class$com$sun$portal$portletappengine$PortletAppEngineServlet = PortletAppEngineServlet.class$("com.sun.portal.portletappengine.PortletAppEngineServlet")) : class$com$sun$portal$portletappengine$PortletAppEngineServlet));
    private PortletAppDescriptor descriptor;
    private ServletContext context;
    private ServletConfig config = null;
    static /* synthetic */ Class class$com$sun$portal$portletappengine$PortletAppEngineServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.lifecycleManager = (LifecycleManager)config.getServletContext().getAttribute("lifecycle_manager");
        this.requestResponseFactory = (RequestResponseFactory)config.getServletContext().getAttribute("request_response_factory");
        this.descriptor = this.lifecycleManager.getDeploymentDescriptor();
        this.context = config.getServletContext();
        this.context.setAttribute("portlet_resources", (Object)new PortletsResources(this.descriptor, logger).getPortletResourceMap());
    }

    public void getTitle(HttpServletRequest req, HttpServletResponse res) {
        String entityID = (String)req.getAttribute(JAVAX_PORTLET_ENTITY_ID);
        String portletName = entityID.substring(entityID.indexOf(124) + 1, entityID.lastIndexOf(124));
        PortletDescriptor pd = this.getPortletDescriptor(portletName);
        String rbName = pd.getResourceBundle();
        String title = null;
        if (rbName != null && rbName.length() > 0) {
            ResourceBundle rb = null;
            try {
                rb = ResourceBundle.getBundle(rbName, req.getLocale(), Thread.currentThread().getContextClassLoader());
                if (rb != null) {
                    title = rb.getString(JAVAX_PORTLET_TITLE);
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "PSPL_PAECSPPA0006", e);
            }
        }
        if (title != null && title.length() > 0) {
            req.setAttribute(JAVAX_PORTLET_TITLE, (Object)title);
        } else {
            req.removeAttribute(JAVAX_PORTLET_TITLE);
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String portletTitle = (String)req.getAttribute(JAVAX_PORTLET_TITLE);
        if (portletTitle != null && portletTitle.length() > 0 && portletTitle.equalsIgnoreCase(GET)) {
            this.getTitle(req, res);
            return;
        }
        StringWriter writer = new StringWriter(PortletAppEngineConstants.INITIAL_BUFFER_SIZE);
        ByteArrayOutputStream output = new ByteArrayOutputStream(PortletAppEngineConstants.INITIAL_BUFFER_SIZE);
        ActionRequest aReq = null;
        RenderRequest rReq = null;
        ActionResponse aRes = null;
        RenderResponse rRes = null;
        EventRequest eventRequest = null;
        EventResponse eventResponse = null;
        PortletContainerRequest pContReq = (PortletContainerRequest)req.getAttribute("portlet_container_request");
        PortletContainerResponse pContRes = (PortletContainerResponse)req.getAttribute("portlet_container_response");
        String portletName = pContReq.getPortletName();
        PortletMode portletMode = PortletAppEngineUtils.getPortletMode(pContReq.getChannelMode());
        List actionList = pContReq.getActions();
        String entityID = pContReq.getEntityID();
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer buf = new StringBuffer();
            buf.append("context path=").append(req.getContextPath()).append("///");
            buf.append("entityID=").append(entityID).append("///");
            buf.append("portletName=").append(portletName).append("///");
            buf.append("portletMode=").append(portletMode).append("///");
            buf.append("windowState=").append(pContReq.getWindowState()).append("///");
            buf.append("actionList=");
            for (int j = 0; j < actionList.size(); ++j) {
                buf.append((String)actionList.get(j)).append(" | ");
            }
            buf.append("///");
            logger.log(Level.FINEST, "PSPL_PAECSPPA0001", buf.toString());
        }
        if (this.checkSecurityConstraint(req, portletName)) {
            PortletDescriptor portletDescriptor = this.getPortletDescriptor(portletName);
            PreferencesValidator validator = this.lifecycleManager.getPreferencesValidator(portletName);
            Portlet p = null;
            try {
                p = this.lifecycleManager.getPortlet(portletName);
                req.setAttribute("javax.portlet.config", (Object)this.lifecycleManager.getPortletConfig(portletName));
                logger.log(Level.FINEST, "PSPL_PAECSPPA0002", portletName);
                boolean stop = false;
                for (int i = 0; i < actionList.size() && !stop; ++i) {
                    String action = (String)actionList.get(i);
                    req.setAttribute("javax.portlet.currentAction", (Object)action);
                    if (action.equals("ACTION")) {
                        PortletContainerActionRequest pContActionReq = (PortletContainerActionRequest)pContReq;
                        PortletContainerActionResponse pContActionRes = (PortletContainerActionResponse)pContRes;
                        aReq = this.requestResponseFactory.getActionRequest(req, res, pContActionReq, pContActionRes, this.lifecycleManager.getPortletContext(), this.lifecycleManager.getPortalContext(), portletDescriptor, writer);
                        aRes = this.requestResponseFactory.getActionResponse(req, res, aReq, pContActionReq, pContActionRes);
                        this.setValidator((PortletRequest)aReq, validator, false);
                        p.processAction(aReq, aRes);
                        if (pContActionRes.getRedirectURL() != null) {
                            stop = true;
                        }
                        this.setValidator((PortletRequest)aReq, validator, true);
                        try {
                            UBTLogManager manager = UBTLogManager.getInstance();
                            if (manager.isUBTEnabled()) {
                                UBTEvent port_act = UBTEvent.getInstance((String)"PORTLET_ACTION");
                                manager.logEvent((UBTLogRecord)new PortletLogRecord(port_act, req, res, pContReq, pContRes));
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        LinkedHashMap evts = (LinkedHashMap)aReq.getAttribute("fired_events");
                        if (evts == null || evts.size() <= 0) continue;
                        req.setAttribute("event_map", (Object)evts);
                        continue;
                    }
                    if (action.equals("EVENT")) {
                        PortletContainerEventRequest pceRequest = (PortletContainerEventRequest)pContReq;
                        PortletContainerEventResponse pceResponse = (PortletContainerEventResponse)pContRes;
                        eventRequest = this.requestResponseFactory.getEventRequest(req, res, pceRequest, pceResponse, this.lifecycleManager.getPortletContext(), this.lifecycleManager.getPortalContext(), portletDescriptor);
                        eventResponse = this.requestResponseFactory.getEventResponse(pceResponse);
                        PortletEventListener pel = null;
                        if (p instanceof PortletEventListener) {
                            pel = (PortletEventListener)p;
                            pel.handleEvent(eventRequest, eventResponse);
                            LinkedHashMap evts = (LinkedHashMap)eventRequest.getAttribute("fired_events");
                            if (evts != null && evts.size() > 0) {
                                LinkedHashMap oldEvts = (LinkedHashMap)req.getAttribute("event_map");
                                if (oldEvts != null && !oldEvts.isEmpty()) {
                                    Set keys = evts.keySet();
                                    Iterator it = keys.iterator();
                                    while (it.hasNext()) {
                                        String eventName = (String)it.next();
                                        ByteArrayOutputStream baos = (ByteArrayOutputStream)evts.get(eventName);
                                        oldEvts.put(eventName, baos);
                                    }
                                    req.setAttribute("event_map", (Object)oldEvts);
                                } else {
                                    req.setAttribute("event_map", (Object)evts);
                                }
                            }
                        }
                        this.requestResponseFactory.releaseEventRequest(eventRequest);
                        this.requestResponseFactory.releaseEventResponse(eventResponse);
                        continue;
                    }
                    if (!action.equals("RENDER")) continue;
                    PortletContainerRenderRequest pContRenderReq = (PortletContainerRenderRequest)pContReq;
                    PortletContainerRenderResponse pContRenderRes = (PortletContainerRenderResponse)pContRes;
                    this.setCacheParams(pContRenderRes, portletDescriptor);
                    rReq = this.requestResponseFactory.getRenderRequest(req, res, pContRenderReq, pContRenderRes, this.lifecycleManager.getPortletContext(), this.lifecycleManager.getPortalContext(), portletDescriptor);
                    rRes = this.requestResponseFactory.getRenderResponse(req, res, rReq, pContRenderReq, pContRenderRes, writer, output, portletDescriptor);
                    this.setValidator((PortletRequest)rReq, validator, false);
                    PortletDescriptor pdesc = this.getPortletDescriptor(portletName);
                    String rbundleName = pdesc.getResourceBundle();
                    String rtitle = null;
                    if (rbundleName != null && rbundleName.length() > 0) {
                        ResourceBundle rb = null;
                        try {
                            rb = ResourceBundle.getBundle(rbundleName, req.getLocale(), Thread.currentThread().getContextClassLoader());
                            if (rb != null) {
                                rtitle = rb.getString(JAVAX_PORTLET_TITLE);
                            }
                        }
                        catch (Exception e1) {
                            logger.log(Level.WARNING, "PSPL_PAECSPPA0007", e1);
                        }
                    }
                    if (rtitle != null && rtitle.length() > 0) {
                        rReq.setAttribute("com.sun.portal.portlet.DPTITLE", (Object)rtitle);
                    } else {
                        String title = (String)req.getAttribute("com.sun.portal.portlet." + entityID + ".DPTITLE");
                        if (title != null && title.length() > 0) {
                            rReq.setAttribute("com.sun.portal.portlet.DPTITLE", (Object)title);
                        }
                    }
                    p.render(rReq, rRes);
                    StringBuffer buff = writer.getBuffer();
                    String outString = output.toString(res.getCharacterEncoding());
                    if (buff.length() > 0) {
                        pContRenderRes.setMarkup(writer.getBuffer());
                    } else if (outString.length() > 0) {
                        pContRenderRes.setMarkup(new StringBuffer(outString));
                    } else {
                        pContRenderRes.setMarkup(new StringBuffer(""));
                    }
                    this.setValidator((PortletRequest)rReq, validator, true);
                    try {
                        UBTLogManager manager = UBTLogManager.getInstance();
                        if (!manager.isUBTEnabled()) continue;
                        UBTEvent port_ren = UBTEvent.getInstance((String)"PORTLET_RENDER");
                        manager.logEvent((UBTLogRecord)new PortletLogRecord(port_ren, req, res, pContReq, pContRes));
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            catch (UnavailableException ue) {
                if (p != null) {
                    p.destroy();
                    this.lifecycleManager.removePortlet(portletName);
                    this.lifecycleManager.removePortletConfig(portletName);
                }
                pContRes.setErrorCode(PortletContainerErrorCode.PORTLET_UNAVAILABLE);
                logger.log(Level.FINEST, "PSPL_PAECSPPA0004", ue);
            }
            catch (PortletSecurityException se) {
                pContRes.setErrorCode(PortletContainerErrorCode.SECURITY_VIOLATION);
                logger.log(Level.FINEST, "PSPL_PAECSPPA0004", se);
            }
            catch (PortletException pe) {
                Throwable cause = pe.getCause();
                if (pe instanceof PortletModeException || cause instanceof PortletModeException) {
                    pContRes.setErrorCode(PortletContainerErrorCode.UNSUPPORTED_MODE);
                } else if (pe instanceof ReadOnlyException || cause instanceof ReadOnlyException) {
                    pContRes.setErrorCode(PortletContainerErrorCode.READONLY_ERROR);
                } else if (pe instanceof WindowStateException || cause instanceof WindowStateException) {
                    pContRes.setErrorCode(PortletContainerErrorCode.UNSUPPORTED_STATE);
                } else {
                    pContRes.setErrorCode(PortletContainerErrorCode.MISC_ERROR);
                }
                logger.log(Level.FINEST, "PSPL_PAECSPPA0004", pe);
            }
            catch (IOException ie) {
                pContRes.setErrorCode(PortletContainerErrorCode.MISC_ERROR);
                logger.log(Level.FINEST, "PSPL_PAECSPPA0004", ie);
            }
            catch (RuntimeException re) {
                pContRes.setErrorCode(PortletContainerErrorCode.MISC_ERROR);
                logger.log(Level.FINEST, "PSPL_PAECSPPA0004", re);
            }
            if (aReq != null) {
                this.requestResponseFactory.releaseActionRequest(aReq);
            }
            if (rReq != null) {
                this.requestResponseFactory.releaseRenderRequest(rReq);
            }
            if (aRes != null) {
                this.requestResponseFactory.releaseActionResponse(aRes);
            }
            if (rRes != null) {
                this.requestResponseFactory.releaseRenderResponse(rRes);
            }
        } else {
            pContRes.setErrorCode(PortletContainerErrorCode.SECURITY_VIOLATION);
            logger.log(Level.FINEST, "PSPL_PAECSPPA0005");
        }
    }

    private PortletDescriptor getPortletDescriptor(String portletName) {
        PortletDescriptor portletDescriptor = null;
        if (this.descriptor != null && this.descriptor.getPortletsDescriptor() != null) {
            portletDescriptor = this.descriptor.getPortletsDescriptor().getPortletDescriptor(portletName);
            logger.log(Level.FINEST, "PSPL_PAECSPPA0003", new Boolean(portletDescriptor.sessionEnabled()));
        }
        return portletDescriptor;
    }

    private void setValidator(PortletRequest pReq, PreferencesValidator validator, boolean cleanup) {
        PreferencesValidatorSetter setter = (PreferencesValidatorSetter)pReq.getPreferences();
        if (setter != null && cleanup) {
            setter.setPreferencesValidator(null);
        }
        if (setter != null && validator != null) {
            setter.setPreferencesValidator(validator);
        }
    }

    private void setCacheParams(PortletContainerRenderResponse pContRes, PortletDescriptor portletDescriptor) {
        int expiration = -999;
        if (portletDescriptor != null) {
            expiration = portletDescriptor.getCacheExpiration();
        }
        pContRes.setExpiration(expiration);
    }

    private boolean checkSecurityConstraint(HttpServletRequest req, String portletName) {
        String consType;
        boolean isValid = true;
        SecurityConstraintDescriptor secConsDescriptor = this.descriptor.getSecurityConstraintDescriptor();
        if (secConsDescriptor != null && ((consType = secConsDescriptor.getTransportGuaranteeType()).equals(CONFIDENTIAL) || consType.equals(INTEGRAL))) {
            List portlets = secConsDescriptor.getConstrainedPortlets();
            boolean stop = false;
            Iterator i = portlets.iterator();
            while (i.hasNext() && !stop) {
                String nextP = (String)i.next();
                if (!portletName.equals(nextP)) continue;
                stop = true;
            }
            if (stop && req.isSecure()) {
                isValid = false;
            }
        }
        return isValid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

