/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import com.sun.portal.portlet.impl.PortletResponseImpl;
import com.sun.portal.portlet.impl.PortletURLImpl;
import com.sun.portal.portletappengine.PortletAppEngineConstants;
import com.sun.portal.portletcontainercommon.PortletContainerRenderRequest;
import com.sun.portal.portletcontainercommon.PortletContainerRenderResponse;
import com.sun.portal.portletcontainercommon.PortletContainerRequest;
import com.sun.portal.portletcontainercommon.PortletContainerResponse;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Logger;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RenderResponseImpl
extends PortletResponseImpl
implements RenderResponse {
    private RenderRequest _rReq;
    private HttpServletResponse _res;
    private PortletContainerRenderRequest _pContReq;
    private PortletContainerRenderResponse _pContRes;
    private PrintWriter _writer;
    private StringWriter _stringWriter;
    private ByteArrayOutputStream _output;
    private String _contentType;
    private PortletDescriptor _pDescriptor;
    private boolean _gotWriter;
    private boolean _gotOutputStream;
    private boolean _committed;
    private static Logger _logger;
    private int _bufSize;

    void init(HttpServletRequest req, HttpServletResponse res, RenderRequest rReq, PortletContainerRenderRequest pContReq, PortletContainerRenderResponse pContRes, StringWriter writer, ByteArrayOutputStream output, PortletDescriptor pDescriptor, Logger logger) {
        super.init(req, res, (PortletRequest)rReq, (PortletContainerRequest)pContReq, (PortletContainerResponse)pContRes, logger);
        this._res = res;
        this._rReq = rReq;
        this._pContReq = pContReq;
        this._pContRes = pContRes;
        this._writer = new PrintWriter(writer);
        this._stringWriter = writer;
        this._output = output;
        this._pDescriptor = pDescriptor;
        this._gotWriter = false;
        this._gotOutputStream = false;
        this._committed = false;
        _logger = logger;
        this._bufSize = PortletAppEngineConstants.INITIAL_BUFFER_SIZE;
    }

    void clear() {
        super.clear();
        this._writer = null;
        this._stringWriter = null;
        this._output = null;
        this._pDescriptor = null;
        this._gotWriter = false;
        this._gotOutputStream = false;
        this._committed = false;
        _logger = null;
        this._bufSize = 0;
        this._contentType = null;
    }

    public String getContentType() {
        return this._contentType;
    }

    public PortletURL createRenderURL() {
        PortletURLImpl url = new PortletURLImpl((PortletRequest)this._rReq, (PortletContainerRequest)this._pContReq, "RENDER");
        return url;
    }

    public PortletURL createActionURL() {
        PortletURLImpl url = new PortletURLImpl((PortletRequest)this._rReq, (PortletContainerRequest)this._pContReq, "ACTION");
        return url;
    }

    public String getNamespace() {
        String prefix = new String(this._pContReq.getEntityID());
        prefix = prefix.replace('/', '_');
        return prefix.replace('|', '_');
    }

    public void setTitle(String title) {
        this._pContRes.setTitle(title);
    }

    public void setContentType(String type) {
        if (!this._gotWriter || !this._gotOutputStream) {
            if (type.indexOf(";") != -1) {
                type = type.substring(0, type.indexOf(";"));
            }
            boolean found = false;
            Enumeration e = this._rReq.getResponseContentTypes();
            while (e.hasMoreElements() && !found) {
                String next = (String)e.nextElement();
                if (!type.equalsIgnoreCase(next)) continue;
                found = true;
            }
            if (found) {
                this._contentType = type;
                this._res.setContentType(type);
            } else {
                throw new IllegalArgumentException("Unsupported response content type: " + type);
            }
        }
    }

    public String getCharacterEncoding() {
        return this._res.getCharacterEncoding();
    }

    public PrintWriter getWriter() throws IOException {
        if (this._gotOutputStream) {
            throw new IllegalStateException("RenderResponseImpl.getWriter: illegal getting writer since getPortletOutputStream() has already been called");
        }
        if (!this.isContentTypeValid()) {
            throw new IllegalStateException("RenderResponseImpl.getWriter: contentType either contains wildcard or is not set.");
        }
        this._gotWriter = true;
        return this._writer;
    }

    public Locale getLocale() {
        return this._rReq.getLocale();
    }

    public void setBufferSize(int size) {
        this._bufSize = size;
    }

    public int getBufferSize() {
        return this._bufSize;
    }

    public void flushBuffer() throws IOException {
        this._committed = true;
    }

    public void resetBuffer() {
        if (this._committed) {
            throw new IllegalStateException("RenderResponseImpl.resetBuffer: illegal resetting buffer: buffer has already commited.");
        }
        if (this._gotOutputStream) {
            this._output.reset();
        }
        if (this._gotWriter) {
            this._stringWriter.getBuffer().setLength(0);
        }
    }

    public boolean isCommitted() {
        int size = 0;
        if (this._gotOutputStream) {
            size = this._output.size();
        } else if (this._gotWriter) {
            size = this._stringWriter.getBuffer().length();
        }
        if (size > PortletAppEngineConstants.INITIAL_BUFFER_SIZE) {
            this._committed = true;
        }
        return this._committed;
    }

    public void reset() {
        this.resetBuffer();
    }

    public OutputStream getPortletOutputStream() throws IOException {
        if (this._gotWriter) {
            throw new IllegalStateException("RenderResponseImpl.getOutputStream: illegal getting output stream: getWriter() has already been called");
        }
        if (!this.isContentTypeValid()) {
            throw new IllegalStateException("RenderResponseImpl.getOutputStream: contentType either contains wildcard or is not set.");
        }
        this._gotOutputStream = true;
        return this._output;
    }

    private boolean isContentTypeValid() {
        boolean valid = true;
        if (this.getContentType() == null) {
            valid = false;
        }
        return valid;
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Property name should not be null.");
        }
        if (key.equals("portlet.expiration-cache")) {
            int cacheVal = this._pContRes.getExpiration();
            if (this._pContRes.getExpiration() != -999) {
                try {
                    cacheVal = Integer.parseInt(value);
                }
                catch (NumberFormatException ne) {
                    // empty catch block
                }
                this._pContRes.setExpiration(cacheVal);
            }
        }
    }
}

