/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.portletcontainercommon.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortletsResources {
    private Map _portletResourceMap = null;
    private PortletAppDescriptor _portletAppD = null;
    private static Logger _logger = PortalLogger.getLogger((Class)(class$com$sun$portal$portlet$impl$PortletsResources == null ? (class$com$sun$portal$portlet$impl$PortletsResources = PortletsResources.class$("com.sun.portal.portlet.impl.PortletsResources")) : class$com$sun$portal$portlet$impl$PortletsResources));
    static /* synthetic */ Class class$com$sun$portal$portlet$impl$PortletsResources;

    public PortletsResources(PortletAppDescriptor pd, Logger logger) {
        this._portletAppD = pd;
        this.init();
    }

    private void init() {
        List portlets;
        if (this.getPortletAppD() != null && (portlets = this.getPortletNames()) != null) {
            this._portletResourceMap = new HashMap();
            Iterator iter = portlets.iterator();
            while (iter.hasNext()) {
                String portlet = (String)iter.next();
                this.loadResources(portlet);
            }
        }
    }

    private void loadResources(String portlet) {
        HashMap<String, ResourceBundle> resBundleMap = new HashMap<String, ResourceBundle>();
        String rbName = this.getResourceBundleName(portlet);
        if (rbName != null) {
            ResourceBundle bundle;
            List locales = this.getSupportedLocales(portlet);
            if (locales != null && locales.size() > 0) {
                Iterator iter = locales.iterator();
                while (iter.hasNext()) {
                    Locale thisLocale;
                    ResourceBundle bundle2;
                    String locale = (String)iter.next();
                    String lang = "";
                    String country = "";
                    String variant = "";
                    StringTokenizer tokenizer = new StringTokenizer(locale, "_");
                    lang = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        country = tokenizer.nextToken();
                    }
                    if (tokenizer.hasMoreTokens()) {
                        variant = tokenizer.nextToken();
                    }
                    if ((bundle2 = this.loadResource(rbName, thisLocale = new Locale(lang, country, variant))) == null) continue;
                    resBundleMap.put(thisLocale.toString(), bundle2);
                }
            }
            if ((bundle = this.loadResource(rbName, Locale.getDefault())) != null) {
                resBundleMap.put(Locale.getDefault().toString(), bundle);
            }
            this._portletResourceMap.put(portlet, resBundleMap);
        }
    }

    private ResourceBundle loadResource(String rbName, Locale locale) {
        ResourceBundle retval = null;
        try {
            retval = locale != null ? ResourceBundle.getBundle(rbName, locale) : ResourceBundle.getBundle(rbName);
        }
        catch (MissingResourceException ex) {
            _logger.log(Level.FINE, "PSPL_PAECSPPI0013", rbName);
            retval = null;
        }
        return retval;
    }

    public Map getPortletResourceMap() {
        return this._portletResourceMap;
    }

    private PortletAppDescriptor getPortletAppD() {
        return this._portletAppD;
    }

    private PortletDescriptor getPortletDescriptor(String portlet) {
        return this.getPortletAppD().getPortletsDescriptor().getPortletDescriptor(portlet);
    }

    private List getSupportedLocales(String portlet) {
        return this.getPortletDescriptor(portlet).getSupportedLocales();
    }

    private String getResourceBundleName(String portlet) {
        return this.getPortletDescriptor(portlet).getResourceBundle();
    }

    private List getPortletNames() {
        return this.getPortletAppD().getPortletsDescriptor().getPortletNames();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

