/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import com.sun.portal.container.ChannelURL;
import com.sun.portal.portlet.impl.PortletToContainerMap;
import com.sun.portal.portletcontainercommon.PortletContainerRequest;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class PortletURLImpl
implements PortletURL {
    private Map _params;
    private String _action;
    private PortletMode _portletMode;
    private WindowState _windowState;
    private PortletRequest _pReq;
    private PortletContainerRequest _pContReq;
    private ChannelURL _channelURL;

    public PortletURLImpl(PortletRequest pReq, PortletContainerRequest pContReq, String action) {
        this._pReq = pReq;
        this._pContReq = pContReq;
        this._channelURL = pContReq.getChannelURLFactory().createChannelURL();
        this._channelURL.setURLType(PortletToContainerMap.mapURLTypeToContainer(action));
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (!this._pReq.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Invalid setting window state", windowState);
        }
        this._channelURL.setWindowState(PortletToContainerMap.mapWindowStateToContainer(windowState));
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (!this._pReq.isPortletModeAllowed(portletMode)) {
            throw new PortletModeException("Invalid setting portlet mode", portletMode);
        }
        this._channelURL.setChannelMode(PortletToContainerMap.mapPortletModeToContainer(portletMode));
    }

    public void setParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("Can not set parameter with null name or value.");
        }
        this._channelURL.setParameter(name, value);
    }

    public void setParameter(String name, String[] values) {
        if (name == null || values == null) {
            throw new IllegalArgumentException("Can not set parameter with null name or value.");
        }
        this._channelURL.setParameter(name, values);
    }

    public void setParameters(Map parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Can not set parameter with null map object.");
        }
        Iterator i = parameters.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object val = parameters.get(key);
            if (key instanceof String && val instanceof String[]) continue;
            throw new IllegalArgumentException("Parameter keys should be type String and values should be type String[].");
        }
        this._channelURL.setParameters(parameters);
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        if (secure && !this._pReq.isSecure()) {
            throw new PortletSecurityException("PortletURLImpl.setSecure: the Portal Server is not running on secure mode");
        }
        this._channelURL.setSecure(secure);
    }

    public String toString() {
        return this._channelURL.toString();
    }
}

