/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import com.sun.portal.common.pool.ObjectManager;
import com.sun.portal.common.pool.ObjectPool;
import com.sun.portal.portlet.impl.EventRequestImpl;
import com.sun.portal.portletappengine.ipc.EventRequest;
import com.sun.portal.portletcontainercommon.PortletContainerEventRequest;
import com.sun.portal.portletcontainercommon.PortletContainerEventResponse;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import java.io.ByteArrayInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EventRequestPool
extends ObjectPool {
    private static Logger logger = null;

    public EventRequestPool(ServletContext context, int minSize, int maxSize, boolean overflow, int partitionSize, Logger log) {
        super((ObjectManager)new EventRequestPoolManager(context, logger), minSize, maxSize, overflow, partitionSize);
        logger = log;
    }

    public EventRequest obtainObject(HttpServletRequest req, HttpServletResponse res, PortletContainerEventRequest pceRequest, PortletContainerEventResponse pceResponse, PortletContext context, PortalContext portalContext, PortletDescriptor pDescriptor) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "EventRequestPool.obtainerObject(): obtained");
        }
        EventRequestImpl eventRequest = (EventRequestImpl)this.getPool().obtainObject(null);
        eventRequest.init(req, res, pceRequest, pceResponse, context, portalContext, pDescriptor);
        String evtName = (String)req.getAttribute("event_name");
        eventRequest.setEventName(evtName);
        byte[] serializedData = (byte[])req.getAttribute("event_data");
        ByteArrayInputStream evtStream = new ByteArrayInputStream(serializedData);
        if (evtStream != null) {
            evtStream.mark(0);
        }
        eventRequest.setEventStream(evtStream);
        return eventRequest;
    }

    public void releaseObject(EventRequest aReq) {
        ((EventRequestImpl)aReq).clear();
        this.getPool().releaseObject((Object)aReq);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "ActionRequestPool.releaseObject(): released");
        }
    }

    private static class EventRequestPoolManager
    implements ObjectManager {
        private static Logger logger;

        public EventRequestPoolManager(ServletContext context, Logger logger) {
            EventRequestPoolManager.logger = logger;
        }

        public Object createObject(Object param) {
            EventRequestImpl aReq = new EventRequestImpl();
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "PorletRequestPool.createObject(): created object");
            }
            return aReq;
        }

        public void destroyObject(Object o) {
        }
    }
}

