/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import com.sun.portal.portlet.impl.PortletResponseImpl;
import com.sun.portal.portletappengine.PortletAppEngineUtils;
import com.sun.portal.portletcontainercommon.PortletContainerActionRequest;
import com.sun.portal.portletcontainercommon.PortletContainerActionResponse;
import com.sun.portal.portletcontainercommon.PortletContainerRequest;
import com.sun.portal.portletcontainercommon.PortletContainerResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ActionResponseImpl
extends PortletResponseImpl
implements ActionResponse {
    private PortletContainerActionRequest _pContReq;
    private PortletContainerActionResponse _pContRes;
    private ActionRequest _aReq;
    private boolean _sendRedirectIsCalled = false;
    private boolean _setMethodIsCalled = false;
    private static Logger _logger;

    void init(HttpServletRequest req, HttpServletResponse res, ActionRequest aReq, PortletContainerActionRequest pContReq, PortletContainerActionResponse pContRes, Logger logger) {
        super.init(req, res, (PortletRequest)aReq, (PortletContainerRequest)pContReq, (PortletContainerResponse)pContRes, logger);
        this._aReq = aReq;
        this._pContReq = pContReq;
        this._pContRes = pContRes;
        _logger = logger;
        this._sendRedirectIsCalled = false;
        this._setMethodIsCalled = false;
    }

    void clear() {
        super.clear();
        this._aReq = null;
        this._pContReq = null;
        this._pContRes = null;
        _logger = null;
        this._sendRedirectIsCalled = false;
        this._setMethodIsCalled = false;
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (!this._aReq.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Invalid setting window state", windowState);
        }
        if (this._sendRedirectIsCalled) {
            throw new IllegalStateException("Illegal to set window state after sendRedirect is called.");
        }
        this._setMethodIsCalled = true;
        this._pContRes.setNewWindowState(PortletAppEngineUtils.getWindowState(windowState));
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (!this._aReq.isPortletModeAllowed(portletMode)) {
            throw new PortletModeException("Attempt to set an invalid portlet mode: ", portletMode);
        }
        if (this._sendRedirectIsCalled) {
            throw new IllegalStateException("Illegal to set portlet mode after sendRedirect is called.");
        }
        this._setMethodIsCalled = true;
        this._pContRes.setNewChannelMode(PortletAppEngineUtils.getChannelMode(portletMode));
    }

    public void sendRedirect(String location) throws IOException {
        if (this._setMethodIsCalled) {
            throw new IllegalStateException("Illegal to sendRedirect after setting window state, portlet mode, or render parameters.");
        }
        URL retURL = null;
        if (location.indexOf("://") == -1) {
            StringBuffer b = new StringBuffer(128);
            b.append(this._pContReq.getHttpServletRequest().getScheme());
            b.append("://");
            b.append(this._pContReq.getHttpServletRequest().getServerName());
            b.append(":");
            b.append(this._pContReq.getHttpServletRequest().getServerPort());
            b.append(location);
            location = b.toString();
        }
        try {
            retURL = new URL(location);
        }
        catch (MalformedURLException mfue) {
            throw new IllegalArgumentException(mfue.getMessage());
        }
        this._sendRedirectIsCalled = true;
        this._pContRes.setRedirectURL(retURL);
    }

    public void setRenderParameters(Map parameters) {
        if (this._sendRedirectIsCalled) {
            throw new IllegalStateException("Illegal to set parameters after sendRedirect is called.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("The passed in map should not be null");
        }
        this._setMethodIsCalled = true;
        this._pContRes.setRenderParameters(parameters);
    }

    public void setRenderParameter(String key, String value) {
        if (this._sendRedirectIsCalled) {
            throw new IllegalStateException("Illegal to set parameter after sendRedirect is called.");
        }
        if (key == null || value == null) {
            throw new IllegalArgumentException("Key or value argument should not be null.");
        }
        this._setMethodIsCalled = true;
        HashMap<String, String[]> renderMap = this._pContRes.getRenderParameters();
        String[] values = new String[]{value};
        if (renderMap == null || renderMap == Collections.EMPTY_MAP) {
            renderMap = new HashMap<String, String[]>();
            renderMap.put(key, values);
            this._pContRes.setRenderParameters(renderMap);
        } else {
            renderMap.put(key, values);
        }
    }

    public void setRenderParameter(String key, String[] values) {
        if (this._sendRedirectIsCalled) {
            throw new IllegalStateException("Illegal to set parameter after sendRedirect is called.");
        }
        if (key == null || values == null) {
            throw new IllegalArgumentException("Key or values argument should not be null.");
        }
        this._setMethodIsCalled = true;
        HashMap<String, String[]> renderMap = this._pContRes.getRenderParameters();
        if (renderMap == null || renderMap == Collections.EMPTY_MAP) {
            renderMap = new HashMap<String, String[]>();
            renderMap.put(key, values);
            this._pContRes.setRenderParameters(renderMap);
        } else {
            renderMap.put(key, values);
        }
    }
}

