/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.taskadmin.context;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.taskadmin.TaskAdminException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class TaskAdminISConnection {
    private static SSOTokenManager _tokenMgr = null;
    protected AMStoreConnection connection = null;
    protected String userDN = null;
    protected AMUser user = null;
    protected SSOToken ssoToken = null;
    protected String sid = null;
    protected ServiceManager serviceManager = null;

    public TaskAdminISConnection(HttpServletRequest httpreq) throws TaskAdminException {
        this(TaskAdminISConnection.getSSOToken(httpreq));
    }

    public TaskAdminISConnection(SSOToken token) throws TaskAdminException {
        this.ssoToken = token;
        try {
            this.connection = new AMStoreConnection(token);
            this.userDN = ((Object)token.getPrincipal()).toString();
            this.user = this.connection.getUser(this.userDN);
            this.initSessionID(token);
            this.serviceManager = new ServiceManager(this.ssoToken);
        }
        catch (SMSException smse) {
            throw new TaskAdminException("TaskAdminISConnection.init(): Failed to get ServiceManager.  ", smse);
        }
        catch (SSOException se) {
            throw new TaskAdminException("TaskAdminISConnection.init(): Failed to get SSOToken.  ", se);
        }
    }

    public AMStoreConnection getConnection() {
        return this.connection;
    }

    public AMUser getUser() {
        return this.user;
    }

    public static SSOToken getSSOToken(HttpServletRequest request) throws TaskAdminException {
        SSOToken token = null;
        try {
            token = TaskAdminISConnection.getSSOTokenManager().createSSOToken(request);
        }
        catch (SSOException se) {
            throw new TaskAdminException("TaskAdmin.getSSOToken(): Failed to get SSOToken.  ", se);
        }
        return token;
    }

    public SSOToken getSSOToken() {
        return this.ssoToken;
    }

    private static synchronized SSOTokenManager getSSOTokenManager() throws TaskAdminException {
        if (_tokenMgr == null) {
            try {
                _tokenMgr = SSOTokenManager.getInstance();
                if (_tokenMgr == null) {
                    throw new TaskAdminException("TaskAdmin.getSSOTokenMgr(): Failed to get SSOTokenManager. ");
                }
            }
            catch (SSOException se) {
                throw new TaskAdminException("TaskAdmin.getSSOTokenMgr(): Failed to get SSOTokenManager.  ", se);
            }
        }
        return _tokenMgr;
    }

    protected void initSessionID(SSOToken token) {
        this.sid = token.getTokenID().toString();
    }

    public String getSessionID() {
        return this.sid;
    }

    public String getAttribute(String attributeName) {
        String val = null;
        Set vals = this.getAttributeMultiVal(attributeName);
        if (vals != null && vals.size() > 0) {
            Iterator iter = vals.iterator();
            val = (String)iter.next();
        }
        return val;
    }

    public Set getAttributeMultiVal(String attributeName) {
        Set vals = null;
        try {
            vals = this.user.getAttribute(attributeName);
        }
        catch (Exception e) {
            throw new ContextError("TaskAdminISConnection.getAttributeMultiVal(): attributeName=" + attributeName, e);
        }
        return vals;
    }

    public String getGlobalAttribute(String serviceName, String attributeName) {
        Set vals = this.getGlobalAttributeMultiValue(serviceName, attributeName);
        if (vals == null || vals.size() < 1) {
            return null;
        }
        Iterator iter = vals.iterator();
        String val = (String)iter.next();
        return val;
    }

    public Set getGlobalAttributeMultiValue(String serviceName, String attributeName) {
        Map attrs = this.getGlobalAttributes(serviceName);
        Set vals = (Set)attrs.get(attributeName);
        return vals;
    }

    public Map getGlobalAttributes(String serviceName) {
        Map attrs = null;
        try {
            ServiceSchemaManager schemaMgr = this.serviceManager.getSchemaManager(serviceName, "1.0");
            ServiceSchema schema = schemaMgr.getGlobalSchema();
            attrs = schema.getReadOnlyAttributeDefaults();
        }
        catch (Exception ex) {
            throw new ContextError("TaskAdminISConnection.getGlobalAttributes(): " + serviceName, ex);
        }
        return attrs;
    }
}

