/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.taskadmin.context;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.taskadmin.TaskAdminException;
import com.sun.portal.taskadmin.context.ISTaskAdminContext;
import com.sun.portal.taskadmin.context.TaskAdminContext;
import com.sun.portal.taskadmin.context.TaskAdminContextFactory;
import com.sun.portal.taskadmin.context.TaskAdminISConnection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class ISTaskAdminContextFactory
implements TaskAdminContextFactory,
SSOTokenListener {
    private HashMap taskAdminContexts = new HashMap();

    public void init() {
    }

    public TaskAdminContext getTaskAdminContext(HttpServletRequest req) throws TaskAdminException {
        return this.getTaskAdminContext(req, true);
    }

    public synchronized TaskAdminContext getTaskAdminContext(HttpServletRequest req, boolean create) throws TaskAdminException {
        ISTaskAdminContext context = null;
        String sid = this.getSessionID(req);
        context = (ISTaskAdminContext)this.taskAdminContexts.get(sid);
        if (context == null && create) {
            try {
                context = new ISTaskAdminContext();
                context.init(req);
                context.addSSOTokenListener(this);
                this.taskAdminContexts.put(sid, context);
            }
            catch (SecurityException se) {
                throw new ContextError("TaskAdminContextFactory.getTaskAdminContext(): ", se);
            }
        }
        return context;
    }

    public TaskAdminContext getTaskAdminContext(SSOToken ssoToken, String portalId) throws TaskAdminException {
        return this.getTaskAdminContext(ssoToken, true, portalId);
    }

    public synchronized TaskAdminContext getTaskAdminContext(SSOToken ssoToken, boolean create, String portalId) throws TaskAdminException {
        ISTaskAdminContext context = null;
        String sid = ssoToken.getTokenID().toString();
        context = (ISTaskAdminContext)this.taskAdminContexts.get(sid);
        if (context == null && create) {
            try {
                context = new ISTaskAdminContext();
                context.init(ssoToken, portalId);
                context.addSSOTokenListener(this);
                this.taskAdminContexts.put(sid, context);
            }
            catch (SecurityException se) {
                throw new ContextError("TaskAdminContextFactory.getTaskAdminContext(): ", se);
            }
        }
        return context;
    }

    public synchronized void ssoTokenChanged(SSOTokenEvent se) {
        String sid = se.getToken().getTokenID().toString();
        System.out.println("received the SSOTokenevent for sid=" + sid);
        this.taskAdminContexts.remove(sid);
    }

    public String getSessionID(HttpServletRequest req) throws TaskAdminException {
        return TaskAdminISConnection.getSSOToken(req).getTokenID().toString();
    }
}

