/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.taskadmin.context;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.util.Locale;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.context.ConfigContext;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.taskadmin.TaskAdminException;
import com.sun.portal.taskadmin.context.TaskAdminContext;
import com.sun.portal.taskadmin.context.TaskAdminISConnection;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class ISTaskAdminContext
implements TaskAdminContext {
    protected static final String LOCALE_STRING = "localeString";
    protected static final String defaultLocaleString = java.util.Locale.getDefault().toString();
    protected TaskAdminISConnection conn = null;
    protected boolean ssoTokenListenerAdded = false;
    private Set roles = null;
    protected ConfigContext configContext = null;
    protected java.util.Locale locale = null;

    public void init(HttpServletRequest req) {
        try {
            this.conn = new TaskAdminISConnection(req);
            this.initRoleDNs();
            this.initLocale(req);
        }
        catch (TaskAdminException tae) {
            throw new ContextError("ISTaskAdminContext.init(req):couldn't initialize TaskASdminContext", tae);
        }
    }

    public void init(SSOToken ssoToken, String portalId) {
        try {
            this.conn = new TaskAdminISConnection(ssoToken);
            this.initRoleDNs();
            this.initLocale();
        }
        catch (TaskAdminException tae) {
            throw new ContextError("ISTaskAdminContext.init(req):couldn't initialize TaskASdminContext", tae);
        }
    }

    private void initRoleDNs() {
        this.roles = new TreeSet();
        try {
            String orgDN = this.conn.getUser().getOrganizationDN();
            if (orgDN != null && orgDN.length() > 0) {
                AMOrganizationalUnit orgUnit = this.conn.getConnection().getOrganizationalUnit(orgDN);
                if (this.isTopLevelAdmin()) {
                    this.roles.add(orgDN);
                    Set roleDNs = orgUnit.getRoles(1);
                    Iterator i = roleDNs.iterator();
                    while (i.hasNext()) {
                        String roleDN = (String)i.next();
                        if (roleDN == null || roleDN.length() <= 0) continue;
                        this.roles.add(roleDN);
                    }
                    Set filteredRoleDNs = orgUnit.getFilteredRoles(1);
                    Iterator i2 = filteredRoleDNs.iterator();
                    while (i2.hasNext()) {
                        String froleDN = (String)i2.next();
                        if (froleDN == null || froleDN.length() <= 0) continue;
                        this.roles.add(froleDN);
                    }
                    Set suborgDNs = orgUnit.getOrganizations(2);
                    Iterator i3 = suborgDNs.iterator();
                    while (i3.hasNext()) {
                        String suborgDN = (String)i3.next();
                        if (suborgDN == null || suborgDN.length() <= 0) continue;
                        this.roles.add(suborgDN);
                    }
                } else {
                    AMOrganization org = this.conn.getConnection().getOrganization(orgDN);
                    Set roleDNs = org.searchRoles("*", 1);
                    Iterator i = roleDNs.iterator();
                    while (i.hasNext()) {
                        String roleDN = (String)i.next();
                        if (roleDN == null || roleDN.length() <= 0) continue;
                        this.roles.add(roleDN);
                    }
                    Set filteredRoleDNs = org.searchFilteredRoles("*", 1);
                    Iterator i4 = filteredRoleDNs.iterator();
                    while (i4.hasNext()) {
                        String froleDN = (String)i4.next();
                        if (froleDN == null || froleDN.length() <= 0) continue;
                        this.roles.add(froleDN);
                    }
                    Set suborgDNs = org.searchSubOrganizations("*", 2);
                    Iterator i5 = suborgDNs.iterator();
                    while (i5.hasNext()) {
                        String suborgDN = (String)i5.next();
                        if (suborgDN == null || suborgDN.length() <= 0) continue;
                        this.roles.add(suborgDN);
                    }
                }
            }
        }
        catch (AMException ame) {
            throw new ContextError("ISTaskAdminContext.initRoleDNs(): ", ame);
        }
        catch (SSOException ssoe) {
            throw new ContextError("ISTaskAdminContext.initRoleDNs(): ", ssoe);
        }
    }

    private boolean isTopLevelAdmin() {
        try {
            Set userRoles = this.conn.getUser().getRoleDNs();
            Iterator i = userRoles.iterator();
            while (i.hasNext()) {
                String role = (String)i.next();
                AMRole amRole = this.conn.getConnection().getRole(role);
                int roleType = 0;
                roleType = amRole.getRoleType();
                if (roleType != 1) continue;
                return true;
            }
        }
        catch (AMException ame) {
            return false;
        }
        catch (SSOException ssoe) {
            throw new ContextError("TaskAdmin.initNodes(): ", ssoe);
        }
        return false;
    }

    private boolean isLocaleChanged() {
        String newLocale = this.getLocaleString();
        return newLocale != null && !newLocale.equals(this.locale.toString());
    }

    public java.util.Locale getLocale() {
        if (this.locale == null) {
            throw new ContextError("ISTaskAdminContext.getLocale(): not initialized");
        }
        if (this.isLocaleChanged()) {
            this.locale = ISTaskAdminContext.initLocale(this.getLocaleString());
        }
        return this.locale;
    }

    protected java.util.Locale initLocale() {
        this.locale = ISTaskAdminContext.initLocale(this.getLocaleString());
        if (this.locale == null) {
            this.locale = java.util.Locale.getDefault();
        }
        return this.locale;
    }

    protected java.util.Locale initLocale(HttpServletRequest req) {
        this.locale = ISTaskAdminContext.initLocale(this.getLocaleString(req));
        if (this.locale == null) {
            this.locale = java.util.Locale.getDefault();
        }
        return this.locale;
    }

    protected static java.util.Locale initLocale(String stringformat) {
        if (stringformat == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(stringformat, "_");
        String lang = "";
        String country = "";
        String variant = "";
        if (tokenizer.hasMoreTokens()) {
            lang = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            variant = tokenizer.nextToken();
        }
        return new java.util.Locale(lang, country, variant);
    }

    protected String getLocaleString(HttpServletRequest req) {
        String localeString = null;
        if (ROC.containsObject(LOCALE_STRING)) {
            localeString = (String)ROC.getObject(LOCALE_STRING);
        } else {
            localeString = this.conn.getAttribute("preferredlocale");
            if (localeString == null) {
                localeString = Locale.getLocaleStringFromAcceptLangHeader((String)req.getHeader("accept-language"));
            }
            if (localeString == null) {
                localeString = defaultLocaleString;
            }
        }
        return localeString;
    }

    protected String getLocaleString() {
        String localeString = this.conn.getAttribute("preferredlocale");
        if (localeString == null) {
            localeString = defaultLocaleString;
        }
        return localeString;
    }

    public Set getBaseDNs() {
        return this.roles;
    }

    public Set getAssignableRoles() {
        TreeSet<String> assignableRoles = new TreeSet<String>();
        try {
            String orgDN = this.conn.getUser().getOrganizationDN();
            if (orgDN != null && orgDN.length() > 0) {
                AMOrganizationalUnit orgUnit = this.conn.getConnection().getOrganizationalUnit(orgDN);
                if (this.isTopLevelAdmin()) {
                    Set roleDNs = orgUnit.getRoles(1);
                    Iterator i = roleDNs.iterator();
                    while (i.hasNext()) {
                        String roleDN = (String)i.next();
                        if (roleDN == null || roleDN.length() <= 0) continue;
                        assignableRoles.add(roleDN);
                    }
                } else {
                    AMOrganization org = this.conn.getConnection().getOrganization(orgDN);
                    Set roleDNs = org.searchRoles("*", 1);
                    Iterator i = roleDNs.iterator();
                    while (i.hasNext()) {
                        String roleDN = (String)i.next();
                        if (roleDN == null || roleDN.length() <= 0) continue;
                        assignableRoles.add(roleDN);
                    }
                }
            }
        }
        catch (AMException ame) {
            throw new ContextError("ISTaskAdminContext.getAssignableRoles(): ", ame);
        }
        catch (SSOException ssoe) {
            throw new ContextError("ISTaskAdminContext.getAssignableRoles(): ", ssoe);
        }
        return assignableRoles;
    }

    public String DNToName(String dn) {
        String name = dn.substring(dn.indexOf("=") + 1, dn.indexOf(","));
        return name;
    }

    protected TaskAdminISConnection getISConnection() {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSSOTokenListener(SSOTokenListener sl) {
        block6: {
            SSOToken token = this.conn.getSSOToken();
            try {
                if (this.ssoTokenListenerAdded) break block6;
                ISTaskAdminContext iSTaskAdminContext = this;
                synchronized (iSTaskAdminContext) {
                    if (!this.ssoTokenListenerAdded) {
                        token.addSSOTokenListener(sl);
                        this.ssoTokenListenerAdded = true;
                    }
                }
            }
            catch (SSOException ssoe) {
                throw new ContextError("TaskAdminContext.addSSOTokenListener(): ", ssoe);
            }
        }
    }
}

