/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.taskadmin.context;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.taskadmin.TaskAdminException;
import com.sun.portal.taskadmin.context.ChannelTaskAdminContext;
import com.sun.portal.taskadmin.context.ChannelTaskAdminContextFactory;
import com.sun.portal.taskadmin.context.DPRootCacheManager;
import com.sun.portal.taskadmin.context.ISChannelTaskAdminContext;
import com.sun.portal.taskadmin.context.TaskAdminISConnection;
import com.sun.portal.util.ResourceLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ISChannelTaskAdminContextFactory
implements ChannelTaskAdminContextFactory,
SSOTokenListener {
    private Map channelTaskAdminContexts = new HashMap();

    public void init() {
    }

    public ChannelTaskAdminContext getChannelTaskAdminContext(HttpServletRequest req) throws TaskAdminException {
        return this.getChannelTaskAdminContext(req, true);
    }

    public synchronized ChannelTaskAdminContext getChannelTaskAdminContext(HttpServletRequest req, boolean create) throws TaskAdminException {
        String portalId = ResourceLoader.getInstance((Properties)System.getProperties()).getPortalId();
        ISChannelTaskAdminContext context = null;
        String sid = this.getSessionID(req);
        HashMap<String, ISChannelTaskAdminContext> contextsperPortal = (HashMap<String, ISChannelTaskAdminContext>)this.channelTaskAdminContexts.get(sid);
        if (contextsperPortal != null && !contextsperPortal.isEmpty() && contextsperPortal.containsKey(portalId)) {
            context = (ISChannelTaskAdminContext)contextsperPortal.get(portalId);
        }
        if (context == null && create) {
            try {
                context = new ISChannelTaskAdminContext();
                context.init(req);
                context.addSSOTokenListener(this);
                if (contextsperPortal == null) {
                    contextsperPortal = new HashMap<String, ISChannelTaskAdminContext>();
                }
                contextsperPortal.put(portalId, context);
                this.channelTaskAdminContexts.put(sid, contextsperPortal);
            }
            catch (SecurityException se) {
                throw new ContextError("TaskAdminContextFactory.getTaskAdminContext(): ", se);
            }
        }
        return context;
    }

    public ChannelTaskAdminContext getChannelTaskAdminContext(SSOToken ssoToken, String portalId) throws TaskAdminException {
        return this.getChannelTaskAdminContext(ssoToken, portalId, true);
    }

    public synchronized ChannelTaskAdminContext getChannelTaskAdminContext(SSOToken ssoToken, String portalId, boolean create) throws TaskAdminException {
        ISChannelTaskAdminContext context = null;
        String sid = ssoToken.getTokenID().toString();
        HashMap<String, ISChannelTaskAdminContext> contextsperPortal = (HashMap<String, ISChannelTaskAdminContext>)this.channelTaskAdminContexts.get(sid);
        if (contextsperPortal != null && !contextsperPortal.isEmpty() && contextsperPortal.containsKey(portalId)) {
            context = (ISChannelTaskAdminContext)contextsperPortal.get(portalId);
        }
        if (context == null && create) {
            try {
                context = new ISChannelTaskAdminContext();
                context.init(ssoToken, portalId);
                context.addSSOTokenListener(this);
                if (contextsperPortal == null) {
                    contextsperPortal = new HashMap<String, ISChannelTaskAdminContext>();
                }
                contextsperPortal.put(portalId, context);
                this.channelTaskAdminContexts.put(sid, contextsperPortal);
            }
            catch (SecurityException se) {
                throw new ContextError("TaskAdminContextFactory.getTaskAdminContext(): ", se);
            }
        }
        return context;
    }

    public synchronized void ssoTokenChanged(SSOTokenEvent se) {
        String sid = se.getToken().getTokenID().toString();
        DPRootCacheManager.clearCache(sid);
        this.channelTaskAdminContexts.remove(sid);
    }

    public String getSessionID(HttpServletRequest req) throws TaskAdminException {
        return TaskAdminISConnection.getSSOToken(req).getTokenID().toString();
    }
}

