/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.taskadmin.context;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.context.DSAMEMultiPortalConstants;
import com.sun.portal.desktop.context.ProviderClassLoader;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.taskadmin.TaskAdminException;
import com.sun.portal.taskadmin.context.ChannelTaskAdminContext;
import com.sun.portal.taskadmin.context.TaskAdminContext;
import com.sun.portal.taskadmin.context.TaskAdminContextFactoryManager;
import com.sun.portal.taskadmin.context.TaskAdminISConnection;
import com.sun.portal.util.ResourceLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class ISChannelTaskAdminContext
implements ChannelTaskAdminContext {
    private static final String ATTR_DP_CAN_VIEW = "sunPortalDesktopDpCanView";
    protected TaskAdminContext taskAdminContext = null;
    protected TaskAdminISConnection conn = null;
    protected boolean ssoTokenListenerAdded = false;
    private boolean canViewDTAttributes = true;
    private AdminDPContext dpContext = null;
    protected ProviderClassLoader pcl = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$taskadmin$context$ISChannelTaskAdminContext == null ? (class$com$sun$portal$taskadmin$context$ISChannelTaskAdminContext = ISChannelTaskAdminContext.class$("com.sun.portal.taskadmin.context.ISChannelTaskAdminContext")) : class$com$sun$portal$taskadmin$context$ISChannelTaskAdminContext));
    private String sid = null;
    static /* synthetic */ Class class$com$sun$portal$taskadmin$context$ISChannelTaskAdminContext;

    public void init(HttpServletRequest req) {
        try {
            this.conn = new TaskAdminISConnection(req);
            this.taskAdminContext = TaskAdminContextFactoryManager.getFactory().getTaskAdminContext(req);
            String portalId = ResourceLoader.getInstance((Properties)System.getProperties()).getPortalId();
            this.initCanViewFlag(portalId);
            this.initDPContext(req);
            this.initProviderClassLoader();
            this.sid = this.conn.getSSOToken().getTokenID().toString();
        }
        catch (TaskAdminException tae) {
            throw new ContextError("ISTaskAdminContext.init(req):couldn't initialize TaskASdminContext", tae);
        }
    }

    public void init(SSOToken ssoToken, String portalId) {
        try {
            this.conn = new TaskAdminISConnection(ssoToken);
            this.taskAdminContext = TaskAdminContextFactoryManager.getFactory(portalId).getTaskAdminContext(ssoToken, portalId);
            this.initCanViewFlag(portalId);
            this.initDPContext(ssoToken, portalId);
            this.initProviderClassLoader(portalId);
            this.sid = ssoToken.getTokenID().toString();
        }
        catch (TaskAdminException tae) {
            throw new ContextError("ISTaskAdminContext.init(req):couldn't initialize TaskASdminContext", tae);
        }
    }

    private void initDPContext(HttpServletRequest req) {
        try {
            this.dpContext = new DSAMEAdminDPContext();
            this.dpContext.init(req);
        }
        catch (DPError e) {
            logger.log(Level.INFO, "PSDT_CSPTC0002", e.getMessage());
            throw new ContextError(e.getMessage());
        }
    }

    private void initDPContext(SSOToken ssoToken, String portalId) {
        try {
            this.dpContext = new DSAMEAdminDPContext();
            this.dpContext.init(ssoToken, null, portalId);
        }
        catch (DPError e) {
            logger.log(Level.INFO, "PSDT_CSPTC0002", e.getMessage());
            throw new ContextError(e.getMessage());
        }
    }

    private void initProviderClassLoader() {
        String providerClassBaseDir = null;
        try {
            Properties desktopProps = ResourceLoader.getInstance((Properties)System.getProperties()).getProperties("desktopconfig.properties");
            providerClassBaseDir = desktopProps.getProperty("providerClassBaseDir");
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (providerClassBaseDir != null) {
            this.pcl = ProviderClassLoader.getInstance(providerClassBaseDir);
        }
    }

    private void initProviderClassLoader(String portalId) {
        String providerClassBaseDir = null;
        try {
            Properties desktopProps = ResourceLoader.getInstance((String)portalId).getProperties("desktopconfig.properties");
            providerClassBaseDir = desktopProps.getProperty("providerClassBaseDir");
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (providerClassBaseDir != null) {
            this.pcl = ProviderClassLoader.getInstance(providerClassBaseDir);
        }
    }

    public ProviderClassLoader getProviderClassLoader() {
        return this.pcl;
    }

    private void initCanViewFlag(String portalId) {
        try {
            Iterator ri = this.conn.getUser().getRoleDNs().iterator();
            while (ri.hasNext() && this.canViewDTAttributes) {
                String value;
                AMRole amRole = this.conn.getConnection().getRole((String)ri.next());
                if (amRole == null || !amRole.isExists()) continue;
                DSAMEMultiPortalConstants.createInstance(portalId);
                AMTemplate amTemplate = amRole.getTemplate(DSAMEMultiPortalConstants.getInstance((String)portalId).MP_SUN_DESKTOP_SERVICE, 301);
                if (amTemplate == null || !amTemplate.isExists() || (value = amTemplate.getStringAttribute(ATTR_DP_CAN_VIEW)).length() <= 0) continue;
                this.canViewDTAttributes = Boolean.valueOf(value);
            }
        }
        catch (AMException ame) {
            throw new ContextError("TaskAdmin.init:Couldn't initialize the canView flag", ame);
        }
        catch (SSOException ssoe) {
            throw new ContextError("TaskAdmin.init:Couldn't initialize the canView flag", ssoe);
        }
    }

    public Locale getLocale() {
        return this.taskAdminContext.getLocale();
    }

    public AdminDPContext getDPContext() {
        return this.dpContext;
    }

    public Set getBaseDNs() {
        return this.taskAdminContext.getBaseDNs();
    }

    public String DNToName(String dn) {
        return this.taskAdminContext.DNToName(dn);
    }

    public boolean canViewDTAttributes() {
        return this.canViewDTAttributes;
    }

    protected TaskAdminISConnection getISConnection() {
        return this.conn;
    }

    public void store(String nodeDN, String dpText) {
        if (this.dpContext.isGlobal(nodeDN)) {
            this.dpContext.storeGlobalDPDocument(dpText);
        } else {
            this.dpContext.storeDPDocument(nodeDN, dpText);
        }
    }

    public String getOrganizationDN(String baseDN) {
        try {
            return this.conn.getConnection().getEntity(baseDN).getOrganizationDN();
        }
        catch (SSOException ssoe) {
            throw new ContextError("TaskAdminContext.getOrganizationDN(): ", ssoe);
        }
        catch (AMException ame) {
            throw new ContextError("TaskAdminContext.getOrganizationDN: ", ame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSSOTokenListener(SSOTokenListener sl) {
        block6: {
            SSOToken token = this.conn.getSSOToken();
            try {
                if (this.ssoTokenListenerAdded) break block6;
                ISChannelTaskAdminContext iSChannelTaskAdminContext = this;
                synchronized (iSChannelTaskAdminContext) {
                    if (!this.ssoTokenListenerAdded) {
                        token.addSSOTokenListener(sl);
                        this.ssoTokenListenerAdded = true;
                    }
                }
            }
            catch (SSOException ssoe) {
                throw new ContextError("TaskAdminContext.addSSOTokenListener(): ", ssoe);
            }
        }
    }

    public String getSessionID() {
        return this.sid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

