/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.taskadmin.context;

import com.sun.portal.log.common.PortalLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DPRootCacheManager {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$taskadmin$context$DPRootCacheManager == null ? (class$com$sun$portal$taskadmin$context$DPRootCacheManager = DPRootCacheManager.class$("com.sun.portal.taskadmin.context.DPRootCacheManager")) : class$com$sun$portal$taskadmin$context$DPRootCacheManager));
    private static Map dpRootsPerPortal = Collections.synchronizedMap(new HashMap());
    private static Map dnSessionIDPerPortal = new HashMap();
    static /* synthetic */ Class class$com$sun$portal$taskadmin$context$DPRootCacheManager;

    public static void updateDPRootCache(String portalId, Map dpRoots) {
        dpRootsPerPortal.put(portalId, dpRoots);
    }

    public static Map getDPRootMapFromCache(String portalId) {
        Map dpRoots = null;
        if (dpRootsPerPortal.containsKey(portalId)) {
            dpRoots = (Map)dpRootsPerPortal.get(portalId);
        } else {
            dpRoots = Collections.synchronizedMap(new HashMap());
            dpRootsPerPortal.put(portalId, dpRoots);
        }
        return dpRoots;
    }

    public static void markDNAsRecentlyAccessed(String portalId, Set DNs, String sid) {
        Map dnMap = null;
        Set sids = null;
        dnMap = dnSessionIDPerPortal.containsKey(portalId) ? (Map)dnSessionIDPerPortal.get(portalId) : new HashMap();
        Iterator i = DNs.iterator();
        while (i.hasNext()) {
            String dn = (String)i.next();
            sids = dnMap.containsKey(dn) ? (Set)dnMap.get(dn) : new HashSet();
            sids.add(sid);
            dnMap.put(dn, sids);
        }
        dnSessionIDPerPortal.put(portalId, dnMap);
        logger.log(Level.FINEST, "DNSessionIDMap: " + dnSessionIDPerPortal);
    }

    public static synchronized void clearCache(String sid) {
        Set keys = dnSessionIDPerPortal.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String portalId = (String)i.next();
            Map dnMap = (Map)dnSessionIDPerPortal.get(portalId);
            Set dns = dnMap.keySet();
            Iterator j = dns.iterator();
            while (j.hasNext()) {
                String dn = (String)j.next();
                Set sids = (Set)dnMap.get(dn);
                sids.remove(sid);
                if (!sids.isEmpty()) continue;
                j.remove();
                if (dnMap.isEmpty()) {
                    i.remove();
                }
                Map dpRoots = (Map)dpRootsPerPortal.get(portalId);
                dpRoots.remove(dn);
                if (dpRoots.isEmpty()) {
                    dpRootsPerPortal.remove(portalId);
                    continue;
                }
                dpRootsPerPortal.put(portalId, dpRoots);
            }
        }
        logger.log(Level.FINEST, "DPRootCache after clear: " + dpRootsPerPortal);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

