/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.taskadmin;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class TaskAdminException
extends Exception {
    public static final String UNKNOWN = "unknown";
    public static final String[] errorKeys = new String[]{"generic.error.message", "message.nochannel", "message.noprovider", "message.typeunknown", "message.channelexists", "message.store", "message.notcontainer", "message.noproperty", "message.role.assign.error", "message.role.remove.error", "message.user.roles.error", "message.userstatus.error", "message.resetpassword.error", "message.users.error", "message.assignable.roles.error", "message.DNName.error", "message.invalidDN.error", "message.invalidpattern.error", "message.createusers.error", "message.deleteusers.error", "message.nullpassword", "message.invalidpreference", "message.nullchannelname", "message.invaliduserdn", "message.invalidroledn", "message.producers.id.list", "message.porlets.handler.list", "message.producer.name.error", "message.porlet.name.error", "message.createuser.error", "message.invalidrole.error", "message.createrole.error", "message.searchtimelimit.error", "message.searchsizelimit.error", "message.store.dpmodified.error", "message.delete.channel.error", "error.empty.dp.document"};
    private int errorCode = 0;
    protected Throwable wrapped = null;
    protected String exceptionType = "unknown";
    protected Object[] tokens = null;

    private TaskAdminException() {
    }

    public TaskAdminException(String msg) {
        super(msg);
    }

    public TaskAdminException(String msg, String type) {
        super(msg);
        this.exceptionType = type;
    }

    public TaskAdminException(String msg, Throwable e) {
        super(msg);
        this.wrapped = e;
    }

    public TaskAdminException(int errorCode, Throwable e, Object[] tokens) {
        super(e.getMessage());
        this.wrapped = e;
        this.errorCode = this.validateErrorCode(errorCode);
        this.tokens = tokens;
    }

    public TaskAdminException(int errorCode, String msg, Object[] tokens) {
        super(msg);
        this.errorCode = this.validateErrorCode(errorCode);
        this.tokens = tokens;
    }

    public TaskAdminException(int errorCode, Object[] tokens) {
        this.errorCode = this.validateErrorCode(errorCode);
        this.tokens = tokens;
    }

    public Throwable getWrapped() {
        return this.wrapped;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(super.toString());
        if (this.getWrapped() != null) {
            b.append(this.wrapped.toString());
        }
        return b.toString();
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.getWrapped() != null) {
            this.wrapped.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.getWrapped() != null) {
            this.wrapped.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.getWrapped() != null) {
            this.wrapped.printStackTrace(s);
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorKey() {
        return errorKeys[this.errorCode];
    }

    public Object[] getTokens() {
        return this.tokens;
    }

    public String getMessageFromRB(ResourceBundle rb, String key, Object[] tokens) {
        String msg = rb.getString(key);
        if (tokens != null && tokens.length > 0) {
            MessageFormat mf = new MessageFormat("");
            mf.setLocale(rb.getLocale());
            mf.applyPattern(msg);
            return mf.format(tokens);
        }
        return msg;
    }

    public String getLocalizedMessage(ResourceBundle rb) {
        return this.getMessageFromRB(rb, this.getErrorKey(), this.getTokens());
    }

    private int validateErrorCode(int code) {
        if (code < errorKeys.length) {
            return code;
        }
        return 0;
    }
}

