/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.taskadmin;

import com.iplanet.sso.SSOToken;
import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPBoolean;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPInteger;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPString;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.context.PropertiesFilter;
import com.sun.portal.providers.context.PropertiesFilterException;
import com.sun.portal.providers.context.PropertiesFilterFactory;
import com.sun.portal.taskadmin.TaskAdminConstants;
import com.sun.portal.taskadmin.TaskAdminException;
import com.sun.portal.taskadmin.context.ChannelTaskAdminContext;
import com.sun.portal.taskadmin.context.DPRootCacheManager;
import com.sun.portal.taskadmin.context.TaskAdminContextFactoryManager;
import com.sun.portal.util.ResourceLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;

public class ChannelTaskAdmin
implements TaskAdminConstants {
    protected static String PORTLET_CLASS = "PortletWindowProvider";
    protected static String REMOTE_PORTLET_CLASS = "WSRPWindowProvider";
    private static final String WILD_CARD = "*";
    private static final String REPLACEMENT_STRING = ".*";
    private static final String DP_PRIORITY_USER = "user";
    private static final String DP_PRIORITY_NOT_SET = "Not Yet Set";
    private Map dpRoots = null;
    private boolean canViewDTAttributes = true;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$taskadmin$ChannelTaskAdmin == null ? (class$com$sun$portal$taskadmin$ChannelTaskAdmin = ChannelTaskAdmin.class$("com.sun.portal.taskadmin.ChannelTaskAdmin")) : class$com$sun$portal$taskadmin$ChannelTaskAdmin));
    protected ChannelTaskAdminContext context = null;
    protected AdminDPContext dpContext = null;
    protected boolean dpRootMerged = true;
    protected boolean dpDocExists = false;
    protected DPRoot dpRoot = null;
    protected String baseDN = null;
    public static String CHANNEL_NAME_SEPARATOR = String.valueOf('/');
    public static String COLLECTION_NAME_SEPARATOR = "|";
    public static String CLIENT_SEPARATOR = "/";
    public static short STRING_DP = 1;
    public static short INTEGER_DP = (short)3;
    public static short BOOLEAN_DP = (short)4;
    public static short COLLECTION_DP = (short)14;
    public static short CONDITIONAL_DP = (short)16;
    public static short LOCALE_DP = (short)15;
    public static short UNKNOWN_DP = (short)-1;
    String CONDITIONAL_PREFIX = "_conditional_";
    private String portalId = null;
    private Set mergers = null;
    protected static final Object dpLock = new Object();
    static /* synthetic */ Class class$com$sun$portal$taskadmin$ChannelTaskAdmin;
    static /* synthetic */ Class class$com$sun$portal$providers$containers$ContainerProvider;

    public ChannelTaskAdmin(HttpServletRequest req, String baseDN) throws TaskAdminException {
        try {
            this.context = TaskAdminContextFactoryManager.getChannelTaskAdminFactory().getChannelTaskAdminContext(req);
            this.dpContext = this.context.getDPContext();
            if (!this.dpContext.isGlobal(baseDN)) {
                this.mergers = this.dpContext.getDPDocumentNames(baseDN);
            }
            this.canViewDTAttributes = this.context.canViewDTAttributes();
            this.portalId = ResourceLoader.getInstance((Properties)System.getProperties()).getPortalId();
            this.dpRoots = DPRootCacheManager.getDPRootMapFromCache(this.portalId);
            this.dpRoot = this.getDPRootByDN(baseDN);
            this.baseDN = baseDN;
        }
        catch (ContextError ce) {
            throw new TaskAdminException("ChannelTaskAdmin():Unable to intialize taskadmincontext", ce);
        }
    }

    public ChannelTaskAdmin(SSOToken ssoToken, String baseDN, String portalId) throws TaskAdminException {
        this.init(ssoToken, baseDN, portalId, true, true);
    }

    public ChannelTaskAdmin(SSOToken ssoToken, String baseDN, String portalId, boolean resetData) throws TaskAdminException {
        this.init(ssoToken, baseDN, portalId, true, resetData);
    }

    public ChannelTaskAdmin(SSOToken ssoToken, String baseDN, String portalId, boolean merge, boolean resetData) throws TaskAdminException {
        this.init(ssoToken, baseDN, portalId, merge, resetData);
    }

    public void init(SSOToken ssoToken, String baseDN, String portalId, boolean merge, boolean resetData) throws TaskAdminException {
        try {
            this.context = TaskAdminContextFactoryManager.getChannelTaskAdminFactory(portalId).getChannelTaskAdminContext(ssoToken, portalId);
            this.dpContext = this.context.getDPContext();
            if (!this.dpContext.isGlobal(baseDN)) {
                this.mergers = this.dpContext.getDPDocumentNames(baseDN);
            }
            this.canViewDTAttributes = this.context.canViewDTAttributes();
            this.portalId = portalId;
            this.dpRoots = DPRootCacheManager.getDPRootMapFromCache(portalId);
            this.dpRoot = this.getDPRootByDN(baseDN, merge, resetData);
            this.baseDN = baseDN;
            logger.log(Level.FINEST, "portalId=" + portalId);
            logger.log(Level.FINEST, "baseDN=" + baseDN);
        }
        catch (ContextError ce) {
            throw new TaskAdminException("ChannelTaskAdmin():Unable to intialize taskadmincontext", ce);
        }
    }

    public ChannelTaskAdmin(HttpServletRequest req, DPRoot someDPRoot) throws TaskAdminException {
        try {
            this.context = TaskAdminContextFactoryManager.getChannelTaskAdminFactory().getChannelTaskAdminContext(req);
            this.dpContext = this.context.getDPContext();
            this.canViewDTAttributes = this.context.canViewDTAttributes();
            this.portalId = "notset";
            this.dpRoot = someDPRoot;
            this.baseDN = "notset";
        }
        catch (ContextError ce) {
            throw new TaskAdminException("ChannelTaskAdmin():Unable to intialize taskadmincontext", ce);
        }
    }

    private void resetModified(boolean clear) {
        this.dpRoots = DPRootCacheManager.getDPRootMapFromCache(this.portalId);
        if (clear) {
            this.dpRoots.clear();
            DPRootCacheManager.updateDPRootCache(this.portalId, this.dpRoots);
        }
        Iterator i = this.dpRoots.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            long lastRead = this.dpContext.getDPDocumentLastRead(name);
            long lastModified = this.dpContext.getDPDocumentLastModified(name);
            logger.log(Level.FINEST, "PSDT_CSPT0001", new Object[]{name, lastRead + ""});
            logger.log(Level.FINEST, "PSDT_CSPT0002", new Object[]{name, lastModified + ""});
            if (lastRead != -1L && lastModified <= lastRead) continue;
            logger.log(Level.FINEST, "PSDT_CSPT0003", new Object[]{name});
            clear = true;
            break;
        }
        if (clear) {
            this.dpRoots.clear();
            DPRootCacheManager.updateDPRootCache(this.portalId, this.dpRoots);
        }
    }

    protected DPRoot getDPRootByDN(String baseDN) throws TaskAdminException {
        return this.getDPRootByDN(baseDN, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DPRoot getDPRootByDN(String baseDN, boolean merge, boolean resetData) throws TaskAdminException {
        DPRoot dpRoot = null;
        try {
            Object object = dpLock;
            synchronized (object) {
                String doc;
                boolean clearDPRoots = false;
                long lastRead = this.dpContext.getDPDocumentLastRead(baseDN);
                long lastModified = this.dpContext.getDPDocumentLastModified(baseDN);
                logger.log(Level.FINEST, "PSDT_CSPT0001", new Object[]{baseDN, lastRead + ""});
                logger.log(Level.FINEST, "PSDT_CSPT0002", new Object[]{baseDN, lastModified + ""});
                if (lastRead != -1L && lastModified > lastRead) {
                    if (!resetData) {
                        logger.log(Level.FINEST, "PSDT_CSPT0003", new Object[]{baseDN});
                        Object[] tokens = new Object[]{baseDN};
                        throw new TaskAdminException(34, "DisplayProfile was modified by another user", tokens);
                    }
                    clearDPRoots = true;
                } else if (lastRead == -1L) {
                    clearDPRoots = true;
                }
                if (this.dpContext.isGlobal(baseDN)) {
                    this.resetModified(clearDPRoots);
                    doc = this.dpContext.getGlobalDPDocument();
                    if (doc != null && doc.length() > 0) {
                        this.dpDocExists = true;
                    }
                    if (this.dpRoots.containsKey(baseDN)) {
                        dpRoot = (DPRoot)this.dpRoots.get(baseDN);
                    } else {
                        dpRoot = XMLDPFactory.getInstance().createRoot((DPContext)this.dpContext, doc);
                        this.dpRoots.put(baseDN, dpRoot);
                        DPRootCacheManager.updateDPRootCache(this.portalId, this.dpRoots);
                    }
                } else if (!merge) {
                    this.dpRootMerged = false;
                    this.resetModified(clearDPRoots);
                    doc = this.dpContext.getDPDocument(baseDN);
                    if (doc != null && doc.length() > 0) {
                        this.dpDocExists = true;
                    }
                    dpRoot = XMLDPFactory.getInstance().createRoot((DPContext)this.dpContext, doc);
                } else {
                    this.resetModified(clearDPRoots);
                    doc = this.dpContext.getDPDocument(baseDN);
                    if (doc != null && doc.length() > 0) {
                        this.dpDocExists = true;
                    }
                    dpRoot = XMLDPFactory.getInstance().createRoot(this.dpContext, baseDN, this.dpRoots);
                    DPRootCacheManager.updateDPRootCache(this.portalId, this.dpRoots);
                }
                HashSet<String> DNs = new HashSet<String>();
                if (this.mergers != null) {
                    DNs.addAll(this.mergers);
                }
                DNs.add(baseDN);
                DPRootCacheManager.markDNAsRecentlyAccessed(this.portalId, DNs, this.context.getSessionID());
            }
        }
        catch (DPError dpe) {
            if (logger.isLoggable(Level.INFO)) {
                LogRecord record = new LogRecord(Level.INFO, "PSDT_CSPT0004");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{baseDN});
                record.setThrown(dpe);
                logger.log(record);
            }
            Object[] tokens = new Object[]{baseDN, dpe.getMessage()};
            throw new TaskAdminException(16, dpe.getMessage(), tokens);
        }
        return dpRoot;
    }

    public String getRoleName(String roleDN) {
        return this.context.DNToName(roleDN);
    }

    public Set getBaseDNs() {
        return this.context.getBaseDNs();
    }

    public ResourceBundle getResourceBundle() {
        Locale locale = this.context.getLocale();
        return ResourceBundle.getBundle("psTaskAdmin", locale, this.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createChannel(String channelName, String providerName) throws TaskAdminException {
        if (channelName == null || channelName.trim().length() == 0) {
            Object[] tokens = new Object[]{};
            throw new TaskAdminException(22, "channelName passed in is null", tokens);
        }
        logger.log(Level.FINEST, "PSDT_CSPT0005", new Object[]{channelName});
        Object object = dpLock;
        synchronized (object) {
            if (this.existsChannel(channelName)) {
                logger.log(Level.FINE, "PSDT_CSPT0006", new Object[]{channelName});
                Object[] tokens = new Object[]{channelName};
                throw new TaskAdminException(4, "Channel already exists", tokens);
            }
            if (!this.existsProvider(providerName)) {
                logger.log(Level.FINE, "PSDT_CSPT0007", new Object[]{providerName});
                Object[] tokens = new Object[]{providerName};
                throw new TaskAdminException(2, "Provider does not exist", tokens);
            }
            DPChannel newChannel = this.dpRoot.createChannel(channelName, providerName);
            newChannel.setMergeType((short)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createContainer(String channelName, String providerName) throws TaskAdminException {
        if (channelName == null || channelName.trim().length() == 0) {
            Object[] tokens = new Object[]{};
            throw new TaskAdminException(22, "ChannelName passed in is null", tokens);
        }
        logger.log(Level.FINEST, "PSDT_CSPT0011", channelName);
        Object object = dpLock;
        synchronized (object) {
            if (this.existsChannel(channelName)) {
                logger.log(Level.FINE, "PSDT_CSPT0012", channelName);
                Object[] tokens = new Object[]{channelName};
                throw new TaskAdminException(4, "Container already exists: " + channelName, tokens);
            }
            if (!this.existsProvider(providerName)) {
                logger.log(Level.FINE, "PSDT_CSPT0013", providerName);
                Object[] tokens = new Object[]{providerName};
                throw new TaskAdminException(2, "Provider does not exist: " + providerName, tokens);
            }
            logger.log(Level.FINEST, "PSDT_CSPT0014", providerName);
            DPContainerChannel newChannel = this.dpRoot.createContainerChannel(channelName, providerName);
            newChannel.setMergeType((short)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteChannel(String channelName, String parentcontainer) throws TaskAdminException {
        DPNode dpNode = null;
        String fQCN = null;
        logger.log(Level.FINEST, "PSDT_CSPT0015", channelName);
        if (parentcontainer != null && parentcontainer.length() != 0) {
            logger.log(Level.FINEST, "PSDT_CSPT0016", new Object[]{channelName, parentcontainer});
            dpNode = this.getDPContainerChannel(parentcontainer);
            fQCN = this.toFullyQualifiedName(dpNode, channelName);
        } else {
            dpNode = this.dpRoot;
            fQCN = channelName;
        }
        Object object = dpLock;
        synchronized (object) {
            if (!this.existsChannel(fQCN)) {
                logger.log(Level.FINE, "PSDT_CSPT0017", channelName);
                Object[] tokens = new Object[]{fQCN};
                throw new TaskAdminException(1, "Channel does not exists: " + channelName, tokens);
            }
            try {
                DPChannel channel = dpNode.removeChannel(channelName);
            }
            catch (DPError dpe) {
                if (logger.isLoggable(Level.FINE)) {
                    LogRecord record = new LogRecord(Level.FINE, "PSDT_CSPT0018");
                    record.setLoggerName(logger.getName());
                    record.setParameters(new Object[]{channelName});
                    record.setThrown(dpe);
                    logger.log(record);
                }
                Object[] tokens = new Object[]{fQCN};
                throw new TaskAdminException(35, dpe.getMessage(), tokens);
            }
        }
        this.removeReferences(this.dpRoot, fQCN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReferences(DPNode node, String channelName) throws TaskAdminException {
        Set channelNames = null;
        Object object = dpLock;
        synchronized (object) {
            channelNames = node.getChannelNames();
        }
        Iterator iterator = channelNames.iterator();
        while (iterator.hasNext()) {
            String channel = (String)iterator.next();
            DPChannel dpChannel = null;
            Object object2 = dpLock;
            synchronized (object2) {
                dpChannel = node.getChannel(channel);
            }
            if (!(dpChannel instanceof DPContainerChannel)) continue;
            DPContainerChannel container = (DPContainerChannel)dpChannel;
            this.removeReferences(container, channelName);
            Set available = null;
            Object object3 = dpLock;
            synchronized (object3) {
                available = container.getAvailable().getNames();
            }
            if (available.contains(channelName)) {
                available.remove(channelName);
                object3 = dpLock;
                synchronized (object3) {
                    container.setAvailable(new ArrayList(available));
                }
            }
            Set selected = null;
            Object object4 = dpLock;
            synchronized (object4) {
                selected = container.getSelected().getNames();
            }
            if (!selected.contains(channelName)) continue;
            selected.remove(channelName);
            object4 = dpLock;
            synchronized (object4) {
                container.setSelected(new ArrayList(selected));
            }
        }
    }

    public Set getExistingChannels(boolean all) throws TaskAdminException {
        DPRoot currentNode = this.dpRoot;
        TreeSet<String> result = new TreeSet<String>();
        Set channelNames = this.getChannelNames(currentNode);
        Iterator iterator = channelNames.iterator();
        while (iterator.hasNext()) {
            String channelName = (String)iterator.next();
            logger.log(Level.FINEST, "PSDT_CSPT0019", channelName);
            if (!this.isDisplayable(channelName) || !all && !this.canAccess(channelName)) continue;
            DPChannel channel = this.getDPChannel(channelName);
            if (channel instanceof DPContainerChannel) {
                result.addAll(this.getChannelsInContainer(channel, all, false));
                continue;
            }
            result.add(channelName);
        }
        return result;
    }

    public Set getExistingChannels(boolean all, String regExp) throws TaskAdminException {
        Set allChannels = this.getExistingChannels(all);
        logger.log(Level.FINEST, "PSDT_CSPT0020", regExp);
        if (regExp != null && regExp.equals(WILD_CARD)) {
            return allChannels;
        }
        Set filteredChannels = this.searchString(regExp, allChannels);
        return filteredChannels;
    }

    public Set getExistingContainers(boolean all) throws TaskAdminException {
        DPRoot currentNode = this.dpRoot;
        TreeSet<String> result = new TreeSet<String>();
        Set containerNames = this.getChannelNames(currentNode);
        Iterator iterator = containerNames.iterator();
        while (iterator.hasNext()) {
            DPChannel channel;
            String channelName = (String)iterator.next();
            logger.log(Level.FINEST, "PSDT_CSPT0021", channelName);
            if (!this.isDisplayable(channelName) || !all && !this.canAccess(channelName) || !((channel = this.getDPChannel(channelName)) instanceof DPContainerChannel)) continue;
            result.add(channelName);
            result.addAll(this.getChannelsInContainer(channel, all, true));
        }
        return result;
    }

    public Set getExistingContainers(boolean all, String regExp) throws TaskAdminException {
        Set allContainers = this.getExistingContainers(all);
        logger.log(Level.FINEST, "PSDT_CSPT0022", regExp);
        if (regExp != null && regExp.equals(WILD_CARD)) {
            return allContainers;
        }
        Set filteredChannels = this.searchString(regExp, allContainers);
        return filteredChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getChannelsInContainer(DPChannel container, boolean all, boolean onlyContainers) throws TaskAdminException {
        DPChannel currentNode = container;
        TreeSet<String> result = new TreeSet<String>();
        Set channelNames = this.getChannelNames(currentNode);
        Iterator iterator = channelNames.iterator();
        while (iterator.hasNext()) {
            String channelName = (String)iterator.next();
            logger.log(Level.FINEST, "PSDT_CSPT0023", channelName);
            String fQCN = this.toFullyQualifiedName(currentNode, channelName);
            if (!this.isDisplayable(fQCN) || !all && !this.canAccess(fQCN)) continue;
            DPChannel channel = null;
            Object object = dpLock;
            synchronized (object) {
                channel = currentNode.getChannel(channelName);
            }
            if (channel instanceof DPContainerChannel) {
                if (onlyContainers) {
                    result.add(fQCN);
                }
                result.addAll(this.getChannelsInContainer(channel, all, onlyContainers));
                continue;
            }
            if (onlyContainers) continue;
            result.add(fQCN);
        }
        return result;
    }

    public Set getExistingProviders() throws TaskAdminException {
        return this.getProviders(false);
    }

    public Set getExistingContainerProviders() throws TaskAdminException {
        return this.getProviders(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getProviders(boolean containerproviders) throws TaskAdminException {
        DPRoot currentNode = this.dpRoot;
        TreeSet<String> result = new TreeSet<String>();
        Set providerNames = this.getProviderNames(currentNode);
        Iterator iterator = providerNames.iterator();
        while (iterator.hasNext()) {
            String providerName = (String)iterator.next();
            logger.log(Level.FINEST, "PSDT_CSPT0024", providerName);
            DPProvider provider = null;
            Object object = dpLock;
            synchronized (object) {
                provider = currentNode.getProvider(providerName);
            }
            if (providerName.startsWith("_") || provider == null) continue;
            String className = null;
            Object object2 = dpLock;
            synchronized (object2) {
                className = provider.getClassName();
            }
            boolean isContainerProvider = false;
            if (this.context.getProviderClassLoader() != null) {
                try {
                    Class<?> providerClass = this.context.getProviderClassLoader().loadClass(className);
                    isContainerProvider = (class$com$sun$portal$providers$containers$ContainerProvider == null ? ChannelTaskAdmin.class$("com.sun.portal.providers.containers.ContainerProvider") : class$com$sun$portal$providers$containers$ContainerProvider).isAssignableFrom(providerClass);
                }
                catch (ClassNotFoundException cne) {
                    if (logger.isLoggable(Level.INFO)) {
                        LogRecord record = new LogRecord(Level.INFO, "PSDT_CSPT0025");
                        record.setLoggerName(logger.getName());
                        record.setThrown(cne);
                        record.setParameters(new Object[]{providerName});
                        logger.log(record);
                    }
                    if (provider.isContainer()) {
                        isContainerProvider = true;
                    }
                }
            } else if (provider.isContainer()) {
                isContainerProvider = true;
            }
            if ((!containerproviders || !isContainerProvider) && (containerproviders || isContainerProvider)) continue;
            result.add(providerName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassName(String channelname) throws TaskAdminException {
        DPChannel channel = this.getDPChannel(channelname);
        String classname = null;
        Object object = dpLock;
        synchronized (object) {
            DPProvider provider = channel.getProvider();
            if (provider != null) {
                classname = provider.getClassName();
            }
        }
        return classname;
    }

    public boolean isContainer(String channelName) throws TaskAdminException {
        DPChannel channel = this.getDPChannel(channelName);
        return channel instanceof DPContainerChannel;
    }

    public boolean isTabContainer(String channelName) throws TaskAdminException {
        boolean isTabContainer = false;
        String className = this.getClassName(channelName);
        if (className != null && className.equals("com.sun.portal.providers.containers.jsp.tab.JSPTabContainerProvider")) {
            isTabContainer = true;
        }
        return isTabContainer;
    }

    public Set getAssignableChannels(String container) throws TaskAdminException {
        DPChannel currentNode = this.getDPChannel(container);
        TreeSet<String> result = new TreeSet<String>();
        Set channelNames = this.getChannelNames(currentNode);
        Iterator iterator = channelNames.iterator();
        while (iterator.hasNext()) {
            String channelName = (String)iterator.next();
            logger.log(Level.FINEST, "PSDT_CSPT0026", channelName);
            String fQCN = this.toFullyQualifiedName(currentNode, channelName);
            if (!this.isDisplayable(fQCN)) continue;
            result.add(fQCN);
        }
        for (DPNode parentNode = currentNode.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            channelNames = this.getChannelNames(parentNode);
            iterator = channelNames.iterator();
            while (iterator.hasNext()) {
                String channelName = (String)iterator.next();
                logger.log(Level.FINEST, "PSDT_CSPT0026", channelName);
                String fQCN = this.toFullyQualifiedName(parentNode, channelName);
                if (!this.isDisplayable(fQCN)) continue;
                result.add(fQCN);
            }
        }
        result.remove(currentNode.getName());
        return result;
    }

    private Set searchString(String regExp, Set names) throws TaskAdminException {
        TreeSet<String> filteredNames = new TreeSet<String>();
        try {
            String modified_regExp = regExp.replaceAll("\\*", REPLACEMENT_STRING);
            logger.log(Level.FINEST, "PSDT_CSPT0020", modified_regExp);
            Pattern p = Pattern.compile(modified_regExp);
            Iterator iterator = names.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                logger.log(Level.FINEST, "PSDT_CSPT0027", name);
                Matcher m = p.matcher(name);
                if (!m.matches()) continue;
                filteredNames.add(name);
                logger.log(Level.FINEST, "PSDT_CSPT0028", name);
            }
        }
        catch (PatternSyntaxException pse) {
            logger.log(Level.FINE, "PSDT_CSPT0029", pse);
            Object[] tokens = new Object[]{regExp};
            throw new TaskAdminException(17, pse.getMessage(), tokens);
        }
        return filteredNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAvailableChannels(String containerName) throws TaskAdminException {
        DPContainerChannel channel = this.getDPContainerChannel(containerName);
        ArrayList availableChannels = null;
        Object object = dpLock;
        synchronized (object) {
            availableChannels = new ArrayList(channel.getAvailable().getCollectionValue().values());
        }
        return availableChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSelectedChannels(String containerName) throws TaskAdminException {
        DPContainerChannel channel = this.getDPContainerChannel(containerName);
        ArrayList selectedChannels = null;
        Object object = dpLock;
        synchronized (object) {
            selectedChannels = new ArrayList(channel.getSelected().getCollectionValue().values());
        }
        return selectedChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailableChannels(List available, String containerName) throws TaskAdminException {
        DPContainerChannel channel = this.getDPContainerChannel(containerName);
        Object object = dpLock;
        synchronized (object) {
            channel.setAvailable(available);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedChannels(List selected, String containerName) throws TaskAdminException {
        DPContainerChannel channel = this.getDPContainerChannel(containerName);
        Object object = dpLock;
        synchronized (object) {
            channel.setSelected(selected);
        }
    }

    private DPContainerChannel getDPContainerChannel(String containerName) throws TaskAdminException {
        DPChannel channel = this.getDPChannel(containerName);
        if (channel == null) {
            logger.log(Level.FINE, "PSDT_CSPT0030", containerName);
            Object[] tokens = new Object[]{containerName};
            throw new TaskAdminException(1, "Container is null: " + containerName, tokens);
        }
        if (channel.getType() != 5) {
            logger.log(Level.FINE, "PSDT_CSPT0031", containerName);
            Object[] tokens = new Object[]{containerName};
            throw new TaskAdminException(6, "Not a container: " + containerName, tokens);
        }
        return (DPContainerChannel)channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringProperty(String channelName, String key, String value, List pflist) throws TaskAdminException {
        DPChannel channel = null;
        if (channelName != null) {
            channel = this.getDPChannel(channelName);
        }
        try {
            Object object = dpLock;
            synchronized (object) {
                DPProperties props = null;
                props = channel == null ? this.dpRoot.getProperties() : channel.getProperties();
                DPString property = props.getString(key, pflist, false);
                if (property != null) {
                    boolean advanced = property.isAdvanced();
                    props.setString(key, value, pflist, true);
                    if (advanced) {
                        props.getString(key, pflist, true).setAdvanced(true);
                    }
                } else {
                    Object[] tokens = new Object[]{key};
                    throw new TaskAdminException(7, "Property doesn't exist", tokens);
                }
            }
        }
        catch (DPError dpe) {
            Object[] tokens = new Object[]{key};
            throw new TaskAdminException(7, dpe.getMessage(), tokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListProperty(String channelName, String key, List value, List pflist) throws TaskAdminException {
        DPChannel channel = null;
        if (channelName != null) {
            channel = this.getDPChannel(channelName);
        }
        try {
            Object object = dpLock;
            synchronized (object) {
                DPProperties props = null;
                props = channel == null ? this.dpRoot.getProperties() : channel.getProperties();
                DPCollection property = props.getCollection(key, pflist, false);
                if (property != null) {
                    boolean advanced = property.isAdvanced();
                    props.setCollection(key, value, pflist, true);
                    if (advanced) {
                        props.getCollection(key, pflist, true).setAdvanced(true);
                    }
                } else {
                    Object[] tokens = new Object[]{key};
                    throw new TaskAdminException(7, "Property doesn't exist", tokens);
                }
            }
        }
        catch (DPError dpe) {
            Object[] tokens = new Object[]{key};
            throw new TaskAdminException(7, dpe.getMessage(), tokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapProperty(String channelName, String key, Map value, List pflist) throws TaskAdminException {
        DPChannel channel = null;
        if (channelName != null) {
            channel = this.getDPChannel(channelName);
        }
        try {
            Object object = dpLock;
            synchronized (object) {
                DPProperties props = null;
                props = channel == null ? this.dpRoot.getProperties() : channel.getProperties();
                DPCollection property = props.getCollection(key, pflist, false);
                if (property != null) {
                    boolean advanced = property.isAdvanced();
                    props.setCollection(key, value, pflist, true);
                    if (advanced) {
                        props.getCollection(key, pflist, true).setAdvanced(true);
                    }
                } else {
                    Object[] tokens = new Object[]{key};
                    throw new TaskAdminException(7, "Property doesn't exist", tokens);
                }
            }
        }
        catch (DPError dpe) {
            Object[] tokens = new Object[]{key};
            throw new TaskAdminException(7, dpe.getMessage(), tokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntegerProperty(String channelName, String key, int value, List pflist) throws TaskAdminException {
        DPChannel channel = null;
        if (channelName != null) {
            channel = this.getDPChannel(channelName);
        }
        try {
            Object object = dpLock;
            synchronized (object) {
                DPProperties props = null;
                props = channel == null ? this.dpRoot.getProperties() : channel.getProperties();
                DPInteger property = props.getInteger(key, pflist, false);
                if (property != null) {
                    boolean advanced = property.isAdvanced();
                    props.setInteger(key, value, pflist, true);
                    if (advanced) {
                        props.getInteger(key, pflist, true).setAdvanced(true);
                    }
                } else {
                    Object[] tokens = new Object[]{key};
                    throw new TaskAdminException(7, "Property doesn't exist", tokens);
                }
            }
        }
        catch (DPError dpe) {
            Object[] tokens = new Object[]{key};
            throw new TaskAdminException(7, dpe.getMessage(), tokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBooleanProperty(String channelName, String key, boolean value, List pflist) throws TaskAdminException {
        DPChannel channel = null;
        if (channelName != null) {
            channel = this.getDPChannel(channelName);
        }
        try {
            Object object = dpLock;
            synchronized (object) {
                DPProperties props = null;
                props = channel == null ? this.dpRoot.getProperties() : channel.getProperties();
                DPBoolean property = props.getBoolean(key, pflist, false);
                if (property != null) {
                    boolean advanced = property.isAdvanced();
                    props.setBoolean(key, value, pflist, true);
                    if (advanced) {
                        props.getBoolean(key, pflist, true).setAdvanced(true);
                    }
                } else {
                    Object[] tokens = new Object[]{key};
                    throw new TaskAdminException(7, "Property doesn't exist", tokens);
                }
            }
        }
        catch (DPError dpe) {
            Object[] tokens = new Object[]{key};
            throw new TaskAdminException(7, dpe.getMessage(), tokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringProperty(String channelName, String key, List pflist) throws TaskAdminException {
        DPString val = null;
        if (channelName == null || channelName.trim().length() == 0) {
            Object object = dpLock;
            synchronized (object) {
                val = this.dpRoot.getProperties().getString(key, pflist, false);
            }
        }
        DPChannel channel = this.getDPChannel(channelName);
        Object object = dpLock;
        synchronized (object) {
            val = channel.getProperties().getString(key, pflist, false);
        }
        if (val == null) {
            Object[] tokens = new Object[]{key};
            throw new TaskAdminException(7, "property doesn't exist", tokens);
        }
        return val.getStringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntegerProperty(String channelName, String key, List pflist) throws TaskAdminException {
        DPInteger val = null;
        if (channelName == null || channelName.trim().length() == 0) {
            Object object = dpLock;
            synchronized (object) {
                val = this.dpRoot.getProperties().getInteger(key, pflist, false);
            }
        }
        DPChannel channel = this.getDPChannel(channelName);
        Object object = dpLock;
        synchronized (object) {
            val = channel.getProperties().getInteger(key, pflist, false);
        }
        if (val == null) {
            Object[] tokens = new Object[]{key};
            throw new TaskAdminException(7, "property doesn't exist", tokens);
        }
        return val.getIntValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBooleanProperty(String channelName, String key, List pflist) throws TaskAdminException {
        DPBoolean val = null;
        if (channelName == null || channelName.trim().length() == 0) {
            Object object = dpLock;
            synchronized (object) {
                val = this.dpRoot.getProperties().getBoolean(key, pflist, false);
            }
        }
        DPChannel channel = this.getDPChannel(channelName);
        Object object = dpLock;
        synchronized (object) {
            val = channel.getProperties().getBoolean(key, pflist, false);
        }
        if (val == null) {
            Object[] tokens = new Object[]{key};
            throw new TaskAdminException(7, "property doesn't exist", tokens);
        }
        return val.getBooleanValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMapProperty(String channelName, String key, List pflist) throws TaskAdminException {
        DPCollection val = null;
        if (channelName == null || channelName.trim().length() == 0) {
            Object object = dpLock;
            synchronized (object) {
                val = this.dpRoot.getProperties().getCollection(key, pflist, false);
            }
        }
        DPChannel channel = this.getDPChannel(channelName);
        Object object = dpLock;
        synchronized (object) {
            val = channel.getProperties().getCollection(key, pflist, false);
        }
        if (val == null) {
            Object[] tokens = new Object[]{key};
            throw new TaskAdminException(7, "property doesn't exist", tokens);
        }
        return val.getCollectionValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getListProperty(String channelName, String key, List pflist) throws TaskAdminException {
        DPCollection val = null;
        if (channelName == null || channelName.trim().length() == 0) {
            Object object = dpLock;
            synchronized (object) {
                val = this.dpRoot.getProperties().getCollection(key, pflist, false);
            }
        }
        DPChannel channel = this.getDPChannel(channelName);
        Object object = dpLock;
        synchronized (object) {
            val = channel.getProperties().getCollection(key, pflist, false);
        }
        if (val == null) {
            Object[] tokens = new Object[]{key};
            throw new TaskAdminException(7, "property doesn't exist", tokens);
        }
        return new ArrayList(val.getNames());
    }

    public Set getPropertyNames(String channelName, boolean advanced) throws TaskAdminException {
        Map propertyMap = this.getPropertyMap(channelName, null, advanced);
        return propertyMap.keySet();
    }

    public Set getPropertyNames(String channelName, String regExp, boolean advanced) throws TaskAdminException {
        Set filteredPropertySet = this.searchString(regExp, this.getPropertyNames(channelName, advanced));
        return filteredPropertySet;
    }

    public Set getPropertyNames(String channelName, List pflist, boolean advanced) throws TaskAdminException {
        logger.log(Level.FINEST, "PSDT_CSPT0032", pflist);
        Map propertyMap = this.getPropertyMap(channelName, pflist, advanced);
        return propertyMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getPropertyMap(String channelName, List pflist, boolean advanced) throws TaskAdminException {
        DPProperty property;
        String name;
        DPChannel channel = this.getDPChannel(channelName);
        logger.log(Level.FINEST, "PSDT_CSPT0033", channelName);
        HashMap<String, DPProperty> propertyMap = new HashMap<String, DPProperty>();
        HashMap<String, DPProperty> advancedMap = new HashMap<String, DPProperty>();
        DPProvider provider = null;
        Object object = dpLock;
        synchronized (object) {
            provider = channel.getProvider();
        }
        if (provider == null) {
            logger.log(Level.FINE, "PSDT_CSPT0034", channelName);
            Object[] tokens = new Object[]{channelName};
            throw new TaskAdminException(2, "Provider for the Channel passed in is invalid", tokens);
        }
        DPProperties channelProperties = null;
        DPProperties providerProperties = null;
        Set channelProps = null;
        Set providerProps = null;
        Iterator channelIter = null;
        Iterator providerIter = null;
        Object object2 = dpLock;
        synchronized (object2) {
            channelProperties = channel.getProperties();
            providerProperties = provider.getProperties();
            channelProps = channelProperties.getNames(false);
            providerProps = providerProperties.getNames(false);
            channelIter = channelProps.iterator();
            providerIter = providerProps.iterator();
        }
        while (channelIter.hasNext()) {
            name = (String)channelIter.next();
            property = null;
            property = pflist != null && pflist.size() != 0 ? channelProperties.get(name, pflist, false) : channelProperties.get(name);
            if (property == null || name.startsWith("_")) continue;
            if (property.isAdvanced()) {
                advancedMap.put(name, property);
                continue;
            }
            propertyMap.put(name, property);
        }
        while (providerIter.hasNext()) {
            name = (String)providerIter.next();
            property = null;
            property = pflist != null && pflist.size() != 0 ? providerProperties.get(name, pflist, false) : providerProperties.get(name);
            if (property == null || name.startsWith("_") || propertyMap.containsKey(name)) continue;
            if (property.isAdvanced()) {
                advancedMap.put(name, property);
                continue;
            }
            propertyMap.put(name, property);
        }
        if (advanced) {
            return advancedMap;
        }
        return propertyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getGlobalPropertyNames() throws TaskAdminException {
        TreeSet<String> globalProperties = new TreeSet<String>();
        DPProperties dpProperties = null;
        Set props = null;
        Iterator iter = null;
        Object object = dpLock;
        synchronized (object) {
            dpProperties = this.dpRoot.getProperties();
            props = dpProperties.getNames(false);
            iter = props.iterator();
        }
        while (iter.hasNext()) {
            String name = (String)iter.next();
            DPProperty property = dpProperties.get(name);
            if (property == null || property.isAdvanced() || name.startsWith("_")) continue;
            globalProperties.add(name);
        }
        return globalProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DPChannel getDPChannel(String channelName) throws TaskAdminException {
        DPChannel channel = null;
        Object object = dpLock;
        synchronized (object) {
            if (!this.existsChannel(channelName)) {
                logger.log(Level.FINE, "PSDT_CSPT0035", new Object[]{channelName, this.dpRoot.getName()});
                Object[] tokens = new Object[]{channelName};
                throw new TaskAdminException(1, "Channel does not exists: " + channelName, tokens);
            }
            channel = this.dpRoot.getChannel(channelName);
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getPropertyType(String channelName, String propertyName) throws TaskAdminException {
        Object object = dpLock;
        synchronized (object) {
            if (!this.existsChannel(channelName)) {
                logger.log(Level.FINE, "PSDT_CSPT0035", new Object[]{channelName, this.baseDN});
                Object[] tokens = new Object[]{channelName};
                throw new TaskAdminException(1, "Channel doesn't exist", tokens);
            }
        }
        if (propertyName.startsWith("_")) {
            logger.log(Level.FINE, "PSDT_CSPT0036", propertyName);
            Object[] tokens = new Object[]{propertyName};
            throw new TaskAdminException(3, "Invalid Property", tokens);
        }
        DPChannel channel = this.getDPChannel(channelName);
        DPProperty p = null;
        Object object2 = dpLock;
        synchronized (object2) {
            p = channel.getProperties().get(propertyName);
        }
        return p.getType();
    }

    public List getMergedDNs() {
        ArrayList mergedDNs = null;
        mergedDNs = this.mergers != null ? new ArrayList(this.mergers) : new ArrayList();
        return mergedDNs;
    }

    protected boolean existsChannel(String channel) {
        boolean exists = this.dpRoot.channelExists(channel);
        return exists;
    }

    protected boolean existsProvider(String provider) {
        boolean exists = this.dpRoot.providerExists(provider);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getChannelNames(DPNode node) {
        Set channelNames = null;
        Object object = dpLock;
        synchronized (object) {
            channelNames = node.getChannelNames();
        }
        return channelNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getProviderNames(DPNode node) {
        Set providerNames = null;
        Object object = dpLock;
        synchronized (object) {
            providerNames = node.getProviderNames();
        }
        return providerNames;
    }

    private String toFullyQualifiedName(DPNode container, String shortName) {
        return (container instanceof DPRoot ? "" : container.getName() + '/') + shortName;
    }

    protected boolean isDisplayable(String fqcn) {
        boolean isDisplayable = true;
        if (fqcn == null || fqcn.length() == 0) {
            isDisplayable = false;
            return isDisplayable;
        }
        DPChannel channel = null;
        try {
            channel = this.getDPChannel(fqcn);
        }
        catch (TaskAdminException tae) {
            isDisplayable = false;
            return isDisplayable;
        }
        String shortName = this.getTail(fqcn, CHANNEL_NAME_SEPARATOR);
        if (channel == null || channel.isAdvanced() || shortName.startsWith("_")) {
            isDisplayable = false;
        }
        return isDisplayable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canAccess(String channel) {
        boolean canAccess = true;
        boolean existChannel = false;
        Object object = dpLock;
        synchronized (object) {
            existChannel = this.existsChannel(channel);
        }
        if (!this.canViewDTAttributes) {
            boolean isInMergers = false;
            List mergers = null;
            Object object2 = dpLock;
            synchronized (object2) {
                mergers = this.dpRoot.getMergers();
            }
            if (mergers != null) {
                Iterator iterator = mergers.iterator();
                while (iterator.hasNext()) {
                    DPRoot merger = (DPRoot)iterator.next();
                    boolean exists = false;
                    Object object3 = dpLock;
                    synchronized (object3) {
                        exists = merger.channelExists(channel);
                    }
                    if (!exists) continue;
                    isInMergers = true;
                    break;
                }
            }
            canAccess = existChannel && !isInMergers;
        }
        return canAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws TaskAdminException {
        if (!this.dpRoot.isDirty()) {
            logger.log(Level.FINE, "PSDT_CSPT0037", new Object[]{this.baseDN});
            return;
        }
        this.dpRoot.setDirty(false);
        StringBuffer buff = new StringBuffer(100);
        this.dpRoot.toXML(buff, 0);
        String dpText = buff.toString();
        logger.log(Level.FINEST, "PSDT_CSPT0038", dpText);
        try {
            Object object = dpLock;
            synchronized (object) {
                this.context.store(this.baseDN, dpText);
            }
        }
        catch (ContextError e) {
            logger.log(Level.FINEST, "PSDT_CSPT0039", e);
            Object[] tokens = new Object[]{this.baseDN};
            throw new TaskAdminException(5, e.getMessage(), tokens);
        }
    }

    protected String getHead(String rpn, String nameSeparator) {
        String head = null;
        if (rpn != null && rpn.length() != 0) {
            int index = rpn.indexOf(nameSeparator);
            head = index == -1 ? rpn : rpn.substring(0, index);
        }
        return head;
    }

    private String getTail(String rpn, String nameSeparator) {
        String tail = null;
        if (rpn != null && rpn.length() != 0) {
            int index = rpn.lastIndexOf(nameSeparator);
            tail = index == -1 ? rpn : rpn.substring(index + 1, rpn.length());
        }
        return tail;
    }

    protected String getPreceding(String source, String substring, String nameSeparator) {
        String preceeding = null;
        int index = -1;
        if (source != null && substring != null && (index = source.indexOf(substring)) != -1) {
            preceeding = source.substring(0, index);
            if (preceeding.endsWith(nameSeparator)) {
                preceeding = preceeding.substring(0, preceeding.length() - 1);
            }
            preceeding = preceeding.length() == 0 ? null : preceeding;
        }
        return preceeding;
    }

    protected String getFollowing(String source, String substring, String nameSeparator) {
        String following = null;
        int index = -1;
        if (source != null && substring != null && (index = source.indexOf(substring)) != -1) {
            following = source.substring(index + substring.length());
            if (following.startsWith(nameSeparator)) {
                following = following.substring(1);
            }
            following = following.length() == 0 ? null : following;
        }
        return following;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDPPriority() throws TaskAdminException {
        String priority = null;
        if (!this.dpDocExists) {
            priority = DP_PRIORITY_NOT_SET;
        } else {
            Object object = dpLock;
            synchronized (object) {
                int p = this.dpRoot.getPriority();
                if (p == -1) {
                    priority = DP_PRIORITY_NOT_SET;
                }
                priority = p == Integer.MAX_VALUE ? DP_PRIORITY_USER : String.valueOf(p);
            }
        }
        return priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDPPriority(String priority) throws TaskAdminException {
        if (!this.dpDocExists) {
            Object[] tokens = new Object[]{this.baseDN};
            throw new TaskAdminException(36, "Priority cannot be set. DP Document Doesn't exist", tokens);
        }
        int p = -1;
        if (priority != null && this.dpDocExists) {
            p = priority.equals(DP_PRIORITY_USER) ? Integer.MAX_VALUE : new Integer(priority);
            Object object = dpLock;
            synchronized (object) {
                this.dpRoot.setPriority(p);
                this.dpRoot.setDirty(true);
                this.store();
            }
            this.dpRoot = this.getDPRootByDN(this.baseDN, true, true);
        }
    }

    public Map getNodeProperties(String fqcn, String rpn, String client, String locale) throws TaskAdminException {
        HashMap<String, List> propInfoMap = new HashMap<String, List>(5);
        List pfList = this.getFilterList(client, locale);
        if (fqcn != null && fqcn.equals("_root")) {
            DPProperties dpProperties = this.dpRoot.getProperties();
            Map dpPropertyMap = this.getNestedProperties(dpProperties, rpn, pfList);
            propInfoMap.put("mergedDNs", this.getMergedDNs());
            this.buildPropertyInfo(propInfoMap, dpPropertyMap, false);
        } else {
            DPChannel channel = null;
            if (this.existsChannel(fqcn)) {
                channel = this.getDPChannel(fqcn);
            }
            if (channel == null) {
                logger.log(Level.SEVERE, "Channel " + fqcn + " does not exist");
                Object[] tokens = new Object[]{fqcn};
                throw new TaskAdminException(1, "Channel is null", tokens);
            }
            DPProperties channelProperties = channel.getProperties();
            DPProvider provider = channel.getProvider();
            if (provider == null) {
                logger.log(Level.SEVERE, "Provider is null for " + fqcn + "channel");
                Object[] tokens = new Object[]{fqcn};
                throw new TaskAdminException(2, "Provider does not exist for channel " + fqcn, tokens);
            }
            String providerName = provider.getName();
            DPProperties providerProperties = provider.getProperties();
            Map channelPropertyMap = this.getNestedProperties(channelProperties, rpn, pfList);
            Map providerPropertyMap = this.getNestedProperties(providerProperties, rpn, pfList);
            Set channelPropertyNames = channelPropertyMap.keySet();
            Set providerPropertyNames = providerPropertyMap.keySet();
            Iterator iter = providerPropertyNames.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (!channelPropertyNames.contains(name)) continue;
                iter.remove();
            }
            if (rpn != null && (!channelPropertyNames.isEmpty() || this.isCustomizedCollection(channelProperties, this.getHead(rpn, COLLECTION_NAME_SEPARATOR)))) {
                providerPropertyMap.clear();
            }
            this.buildPropertyInfo(propInfoMap, channelPropertyMap, false);
            this.buildPropertyInfo(propInfoMap, providerPropertyMap, true);
            this.addExtraNodeInfo(propInfoMap, provider, channel);
            logger.log(Level.FINEST, "Number of channel properties = " + channelPropertyMap.size());
            logger.log(Level.FINEST, "Number of provider properties = " + providerPropertyMap.size());
            logger.log(Level.FINEST, "Total properties in info map = " + propInfoMap.size());
        }
        return propInfoMap;
    }

    private boolean isCustomizedCollection(DPProperties properties, String collectionName) {
        DPCollection dpp = properties.getCollection(collectionName);
        boolean customized = false;
        short type = dpp.getProperties().getPropertyHolder().getType();
        if (type == 6 || type == 5) {
            customized = true;
        }
        return customized;
    }

    private void addExtraNodeInfo(Map infoMap, DPProvider provider, DPChannel channel) {
        infoMap.put("provider", provider.getName());
        boolean container = channel instanceof DPContainerChannel;
        infoMap.put("isContainer", new Boolean(container));
        String cName = channel.getName();
        if (container) {
            boolean tc = false;
            try {
                tc = this.isTabContainer(cName);
            }
            catch (TaskAdminException tae) {
                // empty catch block
            }
            infoMap.put("isTabContainer", new Boolean(tc));
        } else {
            infoMap.put("isTabContainer", new Boolean(false));
        }
        if (container) {
            infoMap.put("isPortletChannel", new Boolean(false));
        } else {
            String classname = null;
            try {
                classname = this.getClassName(cName);
            }
            catch (TaskAdminException tae) {
                // empty catch block
            }
            if (classname != null && classname.endsWith(PORTLET_CLASS)) {
                infoMap.put("isPortletChannel", new Boolean(true));
            } else {
                infoMap.put("isPortletChannel", new Boolean(false));
            }
        }
        infoMap.put("mergedDNs", this.getMergedDNs());
    }

    private void buildPropertyInfo(Map infoMap, Map channelPropertyMap, boolean provider) {
        Iterator iter = channelPropertyMap.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            DPProperty dpProp = (DPProperty)channelPropertyMap.get(name);
            HashMap<String, Object> info = new HashMap<String, Object>(5);
            info.put("named", new Boolean(dpProp.isNamed()));
            short type = dpProp.getType();
            info.put("type", new Short(type));
            if (type == COLLECTION_DP) {
                Set names = ((DPCollection)dpProp).getNames();
                List valueList = this.getList((DPCollection)dpProp);
                boolean empty = valueList.isEmpty();
                if (!empty || names.isEmpty()) {
                    info.put("value", valueList);
                    info.put("type", new Short(20));
                } else {
                    info.put("value", "");
                }
            } else {
                info.put("value", dpProp.getValue());
            }
            info.put("isAdvanced", new Boolean(dpProp.isAdvanced()));
            if (provider) {
                info.put("state", "property.state.default");
            } else if (dpProp.isDummy()) {
                info.put("state", "property.state.inherited");
            } else {
                info.put("state", "property.state.customized");
            }
            infoMap.put(name, info);
        }
    }

    private List getList(DPCollection collection) {
        ArrayList<Object> unnamedList = new ArrayList<Object>();
        Iterator namesIter = collection.getNames().iterator();
        while (namesIter.hasNext()) {
            String name = (String)namesIter.next();
            DPProperty prop = collection.get(name);
            if (prop.isNamed()) {
                unnamedList.clear();
                logger.log(Level.FINEST, "Collection " + collection.getName() + " is not a List, it contains named property " + prop.getName());
                break;
            }
            short type = prop.getType();
            if (type != STRING_DP) {
                unnamedList.clear();
                logger.log(Level.FINEST, "Collection " + collection.getName() + " is not a List, it contains types other than Strings");
                break;
            }
            unnamedList.add(prop.getValue());
        }
        logger.log(Level.FINEST, "Collection " + collection.getName() + " is a List containing " + unnamedList.size() + " Strings");
        return unnamedList;
    }

    private Map getNestedProperties(DPCollection collection, String rpn, List pfList) {
        if (collection == null) {
            return Collections.EMPTY_MAP;
        }
        if (rpn == null) {
            logger.log(Level.FINEST, "Building property map for " + collection.getName());
            return this.buildPropertyMap(collection, pfList);
        }
        String name = this.getHead(rpn, COLLECTION_NAME_SEPARATOR);
        collection = collection instanceof DPProperties ? (DPCollection)((DPProperties)collection).get(name, pfList, false, false) : (DPCollection)collection.get(name);
        return this.getNestedProperties(collection, this.getFollowing(rpn, name, COLLECTION_NAME_SEPARATOR), pfList);
    }

    private Map buildPropertyMap(DPCollection collection, List pfList) {
        Set names = null;
        boolean dpPropertiesObject = collection instanceof DPProperties;
        names = dpPropertiesObject ? ((DPProperties)collection).getNames(true) : collection.getNames();
        names = names == null ? Collections.EMPTY_SET : names;
        HashMap<String, DPProperty> map = new HashMap<String, DPProperty>(names.size());
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            DPProperty prop = null;
            prop = dpPropertiesObject ? ((DPProperties)collection).get(name, pfList, false, false) : collection.get(name);
            if (prop == null || this.hideProperty(name, prop)) continue;
            map.put(name, prop);
        }
        logger.log(Level.FINEST, "Map contains " + map.size() + " properties.");
        return map;
    }

    private boolean hideProperty(String name, DPProperty property) {
        boolean hide = false;
        short type = property.getType();
        if (type == UNKNOWN_DP) {
            hide = true;
        } else if (type == LOCALE_DP || type == CONDITIONAL_DP || name.startsWith("_")) {
            hide = true;
        }
        if (hide) {
            logger.log(Level.FINEST, "Property " + name + " is hidden");
        }
        return hide;
    }

    private List getFilterList(String client, String locale) {
        List<PropertiesFilter> pfList = new ArrayList();
        try {
            int i;
            PropertiesFilter filter = null;
            if (client != null && client.length() != 0) {
                String[] clientFragments = client.split(CLIENT_SEPARATOR);
                for (i = 0; i < clientFragments.length; ++i) {
                    if (clientFragments[i] != null) {
                        clientFragments[i] = clientFragments[i].trim();
                    }
                    if (clientFragments[i] == null || clientFragments[i].length() == 0 || clientFragments[i].equals("null")) continue;
                    filter = PropertiesFilterFactory.get("com.sun.portal.providers.context.ClientPropertiesFilter", clientFragments[i]);
                    pfList.add(filter);
                    logger.log(Level.FINEST, "Added client=" + clientFragments[i] + " filter");
                }
            }
            if (locale != null && locale.length() != 0) {
                String[] localeFragments = locale.split("_");
                for (i = 0; i < localeFragments.length; ++i) {
                    if (localeFragments[i] == null || localeFragments[i].length() == 0 || localeFragments[i].equals("null")) continue;
                    filter = PropertiesFilterFactory.get("com.sun.portal.providers.context.LocalePropertiesFilter", localeFragments[i]);
                    pfList.add(filter);
                    logger.log(Level.FINEST, "Added locale=" + localeFragments[i] + " filter");
                }
            }
        }
        catch (PropertiesFilterException pfe) {
            logger.log(Level.SEVERE, "Unable to create properties filter: " + pfe.getMessage());
            pfList = Collections.EMPTY_LIST;
        }
        return pfList;
    }

    public void setNodeProperties(String fqcn, String rpn, String client, String locale, Object values) throws TaskAdminException {
        if (fqcn == null || values == null) {
            logger.log(Level.SEVERE, "fqcn or values can not be null");
            throw new TaskAdminException("fqcn or values can not be null");
        }
        logger.log(Level.FINEST, "Setting properties " + values + " for " + fqcn);
        List pfList = this.getFilterList(client, locale);
        logger.log(Level.FINEST, "Set properties using " + pfList.size() + " filters");
        if (rpn == null && values instanceof List) {
            logger.log(Level.SEVERE, "Can not set name-value pairs as values is a List and channel top level can not contain un-named properties");
            throw new TaskAdminException("Can not set name-value pairs for " + fqcn + "due to incorrect arguments");
        }
        if (rpn == null && values instanceof Map) {
            Map modifiedMap = (Map)values;
            Iterator iter = modifiedMap.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Object value = modifiedMap.get(name);
                if (fqcn != null && fqcn.equals("_root")) {
                    fqcn = null;
                }
                if (value instanceof Boolean) {
                    this.setBooleanProperty(fqcn, name, (Boolean)value, pfList);
                    continue;
                }
                if (value instanceof Integer) {
                    this.setIntegerProperty(fqcn, name, (Integer)value, pfList);
                    continue;
                }
                if (!(value instanceof String)) continue;
                this.setStringProperty(fqcn, name, (String)value, pfList);
            }
        } else {
            DPProperty property;
            Object value;
            boolean isDPRoot = fqcn != null && fqcn.equals("_root");
            DPProperties channelProperties = null;
            DPCollection c4 = null;
            List collectionList = new ArrayList();
            if (isDPRoot) {
                channelProperties = this.dpRoot.getProperties();
                c4 = this.getNestedCollection(channelProperties, rpn, pfList, null);
            } else {
                DPChannel channel = this.getDPChannel(fqcn);
                if (channel == null) {
                    logger.log(Level.SEVERE, "Channel " + fqcn + " does not exist");
                    Object[] tokens = new Object[]{fqcn};
                    throw new TaskAdminException(1, "Channel is null", tokens);
                }
                channelProperties = channel.getProperties();
                if (channelProperties == null) {
                    logger.log(Level.SEVERE, "Channel " + fqcn + " properties does not exist");
                    Object[] tokens = new Object[]{fqcn};
                    throw new TaskAdminException(1, "Channel properties null", tokens);
                }
                DPProvider provider = channel.getProvider();
                if (provider == null) {
                    logger.log(Level.SEVERE, "Provider is null for " + fqcn + "channel");
                    Object[] tokens = new Object[]{fqcn};
                    throw new TaskAdminException(2, "Provider does not exist for channel " + fqcn, tokens);
                }
                DPProperties providerProperties = provider.getProperties();
                collectionList = this.getNestedCollectionList(providerProperties, rpn, new ArrayList());
                HashMap<String, Boolean> collectionCategories = new HashMap<String, Boolean>();
                Iterator collsIter = collectionList.iterator();
                while (collsIter.hasNext()) {
                    DPCollection pc = (DPCollection)collsIter.next();
                    collectionCategories.put(pc.getName(), new Boolean(pc.isAdvanced()));
                }
                c4 = this.getNestedCollection(channelProperties, rpn, pfList, collectionCategories);
            }
            if (values instanceof Map) {
                Map modifiedMap = (Map)values;
                Iterator iter = modifiedMap.keySet().iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    value = modifiedMap.get(name);
                    property = c4.get(name);
                    if (property == null && !isDPRoot) {
                        property = XMLDPFactory.getInstance().createProperty(this.dpContext, this.dpRoot, ((XMLDPRoot)this.dpRoot).getDocument(), name, value);
                        property = c4.add(property);
                        int index = collectionList.size() - 1;
                        if (index >= 0) {
                            DPCollection pc = (DPCollection)collectionList.get(index);
                            DPProperty pProp = null;
                            if (pc.getName().equals(this.getTail(rpn, COLLECTION_NAME_SEPARATOR))) {
                                pProp = pc.get(name);
                            }
                            if (pProp != null && pProp.getName().equals(name) && pProp.isAdvanced()) {
                                property.setAdvanced(true);
                                logger.log(Level.FINEST, "Setting property " + name + " as advanced");
                            }
                        }
                        logger.log(Level.FINEST, "Property " + name + " added at channel inside collection " + rpn);
                    }
                    property.setValue(value);
                    logger.log(Level.FINEST, "Property value set for " + name);
                }
            } else if (values instanceof List) {
                List list = (List)values;
                Collection jc = c4.getCollectionValue().values();
                Iterator<Object> iter = list.iterator();
                while (iter.hasNext()) {
                    value = (String)iter.next();
                    if (jc.contains(value)) continue;
                    property = XMLDPFactory.getInstance().createProperty(this.dpContext, this.dpRoot, ((XMLDPRoot)this.dpRoot).getDocument(), value);
                    property = c4.add(property);
                    logger.log(Level.FINEST, "Property " + value + " added to " + c4.getName());
                }
                iter = c4.getCollectionValue().values().iterator();
                while (iter.hasNext()) {
                    value = (String)iter.next();
                    if (list.contains(value)) continue;
                    c4.remove((String)value);
                    logger.log(Level.FINEST, "Property " + value + " removed from " + c4.getName());
                }
            }
        }
        this.store();
    }

    private List getNestedCollectionList(DPCollection collection, String rpn, List hierarchy) {
        if (collection == null) {
            return hierarchy;
        }
        hierarchy.add(collection);
        if (rpn == null) {
            return hierarchy;
        }
        String name = this.getHead(rpn, COLLECTION_NAME_SEPARATOR);
        collection = collection instanceof DPProperties ? (DPCollection)((DPProperties)collection).get(name, false) : (DPCollection)collection.get(name);
        return this.getNestedCollectionList(collection, this.getFollowing(rpn, name, COLLECTION_NAME_SEPARATOR), hierarchy);
    }

    private DPCollection getNestedCollection(DPCollection collection, String rpn, List pfList, Map collectionCategories) throws TaskAdminException {
        if (collection == null) {
            return null;
        }
        if (rpn == null) {
            logger.log(Level.FINEST, "Got the last collection in hierarchy: " + collection.getName());
            return collection;
        }
        String name = this.getHead(rpn, COLLECTION_NAME_SEPARATOR);
        DPCollection c = null;
        if (collection instanceof DPProperties) {
            c = (DPCollection)((DPProperties)collection).get(name, pfList, true, false);
            if (c == null) {
                logger.log(Level.FINEST, "Collection " + name + " does not exist at the channel for given filter");
                ((DPProperties)collection).setCollection(name, Collections.EMPTY_MAP, pfList, true);
                c = (DPCollection)((DPProperties)collection).get(name, pfList, true, false);
            }
        } else {
            c = (DPCollection)collection.get(name);
            if (c == null) {
                c = (DPCollection)XMLDPFactory.getInstance().createProperty(this.dpContext, this.dpRoot, ((XMLDPRoot)this.dpRoot).getDocument(), name, Collections.EMPTY_MAP);
                c = (DPCollection)collection.add(c);
                Boolean advanced = (Boolean)collectionCategories.get(name);
                if (advanced != null && advanced.booleanValue()) {
                    c.setAdvanced(true);
                }
                logger.log(Level.FINEST, "Collection " + name + " does not exist at the channel, so creating it");
            }
        }
        if (c == null) {
            throw new TaskAdminException("Unable to customize collection hierarchy at the channel");
        }
        collection = c;
        return this.getNestedCollection(collection, this.getFollowing(rpn, name, COLLECTION_NAME_SEPARATOR), pfList, collectionCategories);
    }

    public void removeCustomization(String fqcn, String rpn, String client, String locale, List names) throws TaskAdminException {
        if (fqcn == null || names == null) {
            logger.log(Level.SEVERE, "fqcn or names can not be null");
            throw new TaskAdminException("fqcn or names can not be null");
        }
        if (this.dpRootMerged) {
            logger.log(Level.SEVERE, "Can not remove customization on a merged dpRoot");
            throw new TaskAdminException("Can not remove customization on a merged dpRoot");
        }
        if (names.isEmpty()) {
            logger.log(Level.FINEST, "The list for removing customization was empty");
            return;
        }
        List pfList = this.getFilterList(client, locale);
        DPProperties channelProperties = null;
        if (fqcn != null && fqcn.equals("_root")) {
            channelProperties = this.dpRoot.getProperties();
        } else {
            DPChannel channel = this.getDPChannel(fqcn);
            if (channel == null) {
                logger.log(Level.SEVERE, "Channel " + fqcn + " does not exist");
                Object[] tokens = new Object[]{fqcn};
                throw new TaskAdminException(1, "Channel is null", tokens);
            }
            channelProperties = channel.getProperties();
        }
        if (channelProperties == null) {
            logger.log(Level.SEVERE, "Channel " + fqcn + " properties does not exist");
            Object[] tokens = new Object[]{fqcn};
            throw new TaskAdminException(1, "Channel properties null", tokens);
        }
        DPCollection c4 = this.getNestedCollection(channelProperties, rpn, pfList, null);
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            DPProperty prop = c4.get(name);
            if (prop == null) {
                logger.log(Level.SEVERE, "Property is not customized here");
                throw new TaskAdminException("Property is not customized here");
            }
            if (c4 instanceof DPProperties) {
                ((DPProperties)c4).remove(name, pfList);
            } else {
                c4.remove(name);
            }
            logger.log(Level.FINEST, "Property removed from this dp doc");
            this.store();
            this.dpRoots.remove(this.baseDN);
            DPRootCacheManager.updateDPRootCache(this.portalId, this.dpRoots);
        }
    }

    public void createNodeProperty(String fqcn, String rpn, String client, String locale, String name, Object value, Boolean advanced) throws TaskAdminException {
        if (fqcn == null || name == null) {
            logger.log(Level.SEVERE, "fqcn or name can not be null");
            throw new TaskAdminException("fqcn or name can not be null");
        }
        List pfList = this.getFilterList(client, locale);
        DPProperties channelProperties = null;
        if (fqcn != null && fqcn.equals("_root")) {
            channelProperties = this.dpRoot.getProperties();
        } else {
            DPChannel channel = this.getDPChannel(fqcn);
            if (channel == null) {
                logger.log(Level.SEVERE, "Channel " + fqcn + " does not exist");
                Object[] tokens = new Object[]{fqcn};
                throw new TaskAdminException(1, "Channel is null", tokens);
            }
            channelProperties = channel.getProperties();
        }
        if (channelProperties == null) {
            logger.log(Level.SEVERE, "Channel " + fqcn + " properties does not exist");
            Object[] tokens = new Object[]{fqcn};
            throw new TaskAdminException(1, "Channel properties null", tokens);
        }
        DPCollection c4 = this.getNestedCollection(channelProperties, rpn, pfList, null);
        DPProperty property = XMLDPFactory.getInstance().createProperty(this.dpContext, this.dpRoot, ((XMLDPRoot)this.dpRoot).getDocument(), name, value);
        if (advanced.booleanValue()) {
            property.setAdvanced(true);
        }
        c4.add(property);
        this.store();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

