/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.window;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelURLFactory;
import com.sun.portal.container.Container;
import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContentException;
import com.sun.portal.container.ErrorCode;
import com.sun.portal.container.ExecuteActionRequest;
import com.sun.portal.container.ExecuteActionResponse;
import com.sun.portal.container.GetMarkupRequest;
import com.sun.portal.container.GetMarkupResponse;
import com.sun.portal.container.WindowState;
import com.sun.portal.container.impl.ContainerRequestImpl;
import com.sun.portal.container.impl.ContainerResponseImpl;
import com.sun.portal.container.impl.ExecuteActionRequestImpl;
import com.sun.portal.container.impl.ExecuteActionResponseImpl;
import com.sun.portal.container.impl.GetMarkupRequestImpl;
import com.sun.portal.container.impl.GetMarkupResponseImpl;
import com.sun.portal.desktop.DesktopPortletRequest;
import com.sun.portal.desktop.DesktopRequest;
import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.ContainerProvider;
import com.sun.portal.providers.containers.UnsupportedWindowStateException;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.jsp.JSPProvider;
import com.sun.portal.providers.window.WindowErrorCode;
import com.sun.portal.providers.window.WindowException;
import com.sun.portal.providers.window.WindowRequestReader;
import com.sun.portal.providers.window.util.ProviderRules;
import com.sun.portal.providers.window.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class WindowProvider
extends JSPProvider {
    public static final String KEYWORD_PREFIX = "dt.windowProvider.";
    public static final String CURRENT_CHANNEL_MODE_KEY = "dt.windowProvider.currentChannelMode";
    public static final String TARGET_PORTLET_CHANNEL_KEY = "dt.windowProvider.targetPortletChannel";
    public static final List _localParamKeyList = WindowProvider.initParamKeyList();
    public static final String RENDER_PARAM_PREFIX = "dt.windowProvider.renderParams.";
    private static final String PORTLET_PREFERENCE = "__Portlet__PreferenceProperties";
    private static final String PS_EXTERNAL_HELP_URL = "ps.externalHelpURL";
    private static final String ERROR_CODE = "_errorCode";
    private static final String TARGET_SUFFIX = ".isTarget";
    public static final String PROVIDER_CONTEXT = "provider_context";
    public static final String PORTAL_CONTEXT_PATH = "portalContext";
    private static final String PROCESS_CHANNEL = "PortletWindowProcessChannel";
    private String _title = "";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$providers$window$WindowProvider == null ? (class$com$sun$portal$providers$window$WindowProvider = WindowProvider.class$("com.sun.portal.providers.window.WindowProvider")) : class$com$sun$portal$providers$window$WindowProvider));
    public static final String SSO_TOKEN = "sso_token";
    static /* synthetic */ Class class$com$sun$portal$providers$window$WindowProvider;

    public abstract List getRoleList(HttpServletRequest var1) throws ProviderException;

    public abstract Map getUserInfoMap(HttpServletRequest var1) throws ProviderException;

    public abstract Container getContainer(HttpServletRequest var1);

    public abstract String getEntityID(HttpServletRequest var1) throws ProviderException;

    public abstract WindowRequestReader getWindowRequestReader() throws ProviderException;

    public abstract ChannelURLFactory getChannelURLFactory(String var1, HttpServletRequest var2) throws ProviderException;

    public abstract boolean isMarkupSupported(String var1, String var2, ChannelMode var3, WindowState var4) throws ProviderException;

    public abstract String getDefaultTitle() throws ProviderException;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        return this.getContentInternal(req, res);
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        return this.getContentInternal(req, res);
    }

    public StringBuffer getContentInternal(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer markupText = null;
        ErrorCode errorCode = this.readErrorCode(req);
        if (errorCode != null) {
            if (logger.isLoggable(Level.FINE)) {
                LogRecord record = new LogRecord(Level.FINE, "PSDT_CSPPW0001");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{this.getName(), errorCode});
                logger.log(record);
            }
            markupText = this.getErrorMessageContent(errorCode);
        } else {
            try {
                markupText = this.getPortletContent(req, res);
            }
            catch (WindowException ex) {
                if (logger.isLoggable(Level.INFO)) {
                    LogRecord record = new LogRecord(Level.INFO, "PSDT_CSPPW0002");
                    record.setLoggerName(logger.getName());
                    record.setParameters(new Object[]{this.getName()});
                    record.setThrown(ex);
                    logger.log(record);
                }
                markupText = this.getErrorMessageContent(ex.getErrorCode());
            }
        }
        ChannelMode mode = this.getCurrentChannelMode(req);
        return this.processMarkupBasedOnChannelMode(req, res, mode, markupText);
    }

    private StringBuffer getPortletContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException, WindowException {
        ProviderContext pc = this.getProviderContext();
        boolean authless = pc.isAuthless(req);
        String portletentityId = this.getEntityID(req);
        boolean isTarget = this.getIsTarget(portletentityId, authless);
        this.setIsTarget(portletentityId, authless, false);
        ChannelMode mode = this.getCurrentChannelMode(req);
        WindowState windowState = this.getCurrentWindowState(req);
        List allowableWindowStates = this.getAllowableWindowStates(req, mode);
        List allowableChannelModes = ProviderRules.getAllowableChannelModes(mode, authless);
        GetMarkupRequestImpl creq = (GetMarkupRequestImpl)this.assembleContainerRequest(req, this.getParentContainerName(req), portletentityId, mode, windowState, allowableWindowStates, allowableChannelModes, true);
        Map renderParams = this.getRenderParams(portletentityId, authless);
        creq.setRenderParameters(renderParams);
        creq.setIsTarget(isTarget);
        creq.setCharacterEncoding(req.getCharacterEncoding());
        GetMarkupResponseImpl cres = (GetMarkupResponseImpl)this.assembleContainerResponse(res, true);
        try {
            this.getContainer(req).getMarkup((GetMarkupRequest)creq, (GetMarkupResponse)cres);
        }
        catch (ContainerException ce) {
            throw new ProviderException("WindowProvider.getContent():container exception", ce);
        }
        catch (ContentException cte) {
            throw new WindowException(this.getErrorCode(cte), "Content Exception", cte);
        }
        this.setTitle(cres.getTitle());
        if (cres.getMarkup() == null && logger.isLoggable(Level.FINE)) {
            LogRecord record = new LogRecord(Level.FINE, "PSDT_CSPPW0003");
            record.setLoggerName(logger.getName());
            record.setParameters(new Object[]{this.getName()});
            logger.log(record);
        }
        return cres.getMarkup();
    }

    private StringBuffer processMarkupBasedOnChannelMode(HttpServletRequest req, HttpServletResponse res, ChannelMode mode, StringBuffer markupFromPortlet) throws ProviderException {
        ContainerProviderContext cpc = (ContainerProviderContext)this.getProviderContext();
        if (mode.equals((Object)ChannelMode.HELP)) {
            req.setAttribute("helpContent", (Object)markupFromPortlet);
            return super.getContent(req, res);
        }
        if (mode.equals((Object)ChannelMode.VIEW)) {
            return markupFromPortlet;
        }
        if (mode.equals((Object)ChannelMode.EDIT)) {
            req.setAttribute("editContent", (Object)markupFromPortlet);
            URL helpURL = null;
            String editContainerName = req.getParameter("provider");
            if (editContainerName != null && editContainerName.length() != 0) {
                Provider editProvider = cpc.getProvider(req, null, editContainerName);
                helpURL = editProvider.getHelp(req);
            }
            if (helpURL != null) {
                req.setAttribute("editContainerHelpURL", (Object)helpURL.toString());
            } else {
                req.setAttribute("editContainerHelpURL", (Object)"");
            }
            return super.getEdit(req, res);
        }
        return null;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        try {
            return this.processEditInternal(req, res);
        }
        catch (WindowException ex) {
            if (logger.isLoggable(Level.INFO)) {
                LogRecord record = new LogRecord(Level.INFO, "PSDT_CSPPW0004");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{this.getName()});
                record.setThrown(ex);
                logger.log(record);
            }
            return this.getErrorCodeURL(ex.getErrorCode(), req);
        }
    }

    public URL processEditInternal(HttpServletRequest req, HttpServletResponse res) throws ProviderException, WindowException {
        String urlType;
        ProviderContext pc = this.getProviderContext();
        ContainerProviderContext cpc = (ContainerProviderContext)pc;
        Map renderParameters = Collections.EMPTY_MAP;
        URL returnURL = null;
        ChannelMode currentChannelMode = null;
        ChannelMode newChannelMode = null;
        WindowState currentWindowState = null;
        WindowState newWindowState = null;
        DesktopPortletRequest dpreq = ((DesktopRequest)req).getDesktopPortletRequest();
        boolean authless = pc.isAuthless(req);
        String portletentityId = this.getEntityID(req);
        currentChannelMode = this.getCurrentChannelMode(req);
        currentWindowState = this.getCurrentWindowState(req);
        newWindowState = this.getWindowRequestReader().readNewWindowState(req);
        newChannelMode = this.getWindowRequestReader().readNewChannelMode(req);
        if (newChannelMode != null) {
            this.validateModeChange(currentChannelMode, newChannelMode, authless);
            currentChannelMode = newChannelMode;
        }
        if (newWindowState != null) {
            currentWindowState = this.processWindowStateChange(req, newWindowState, currentChannelMode, authless);
        }
        if ("RENDER".equals(urlType = this.getWindowRequestReader().readURLType(req))) {
            renderParameters = this.getWindowRequestReader().readParamsMap((DesktopRequest)req);
            this.setIsTarget(portletentityId, authless, true);
        } else if ("ACTION".equals(urlType)) {
            Map actionParams = this.getWindowRequestReader().readParamsMap((DesktopRequest)req);
            List allowableWindowStates = this.getAllowableWindowStates(req, currentChannelMode);
            List allowableChannelModes = ProviderRules.getAllowableChannelModes(currentChannelMode, authless);
            ExecuteActionRequestImpl creq = (ExecuteActionRequestImpl)this.assembleContainerRequest(req, this.getParentContainerName(req), portletentityId, currentChannelMode, currentWindowState, allowableWindowStates, allowableChannelModes, false);
            creq.setActionParameters(actionParams);
            creq.setCharacterEncoding(req.getCharacterEncoding());
            ExecuteActionResponseImpl cres = (ExecuteActionResponseImpl)this.assembleContainerResponse(res, false);
            try {
                this.getContainer(req).executeAction((ExecuteActionRequest)creq, (ExecuteActionResponse)cres);
            }
            catch (ContainerException ce) {
                ce.printStackTrace();
                throw new ProviderException("WindowProvider.processEdit():container exception", ce);
            }
            catch (ContentException cte) {
                throw new WindowException(this.getErrorCode(cte), "Content Exception", cte);
            }
            returnURL = cres.getRedirectURL();
            if (returnURL == null) {
                newChannelMode = cres.getNewChannelMode();
                if (newChannelMode != null) {
                    this.validateModeChange(currentChannelMode, newChannelMode, authless);
                    currentChannelMode = newChannelMode;
                }
                if ((newWindowState = cres.getNewWindowState()) != null) {
                    currentWindowState = this.processWindowStateChange(req, newWindowState, currentChannelMode, authless);
                }
                renderParameters = cres.getRenderParameters();
            }
        }
        if (returnURL == null) {
            this.setRenderParams(portletentityId, authless, renderParameters);
            if (currentChannelMode != null) {
                returnURL = this.processModeChange(currentChannelMode, req, pc);
            }
        }
        return returnURL;
    }

    public String getTitle() throws ProviderException {
        if (this._title != null && this._title.length() != 0) {
            return this._title;
        }
        return this.getDefaultTitle();
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public URL getHelp(HttpServletRequest req) throws ProviderException {
        boolean helpSupported = this.isMarkupSupported(this.getProviderContext().getContentType(), this.getProviderContext().getLocaleString(), ChannelMode.HELP, WindowState.MAXIMIZED);
        if (!helpSupported) {
            return null;
        }
        String desktopURL = this.getProviderContext().getDesktopURL(req);
        URL helpURL = null;
        try {
            helpURL = this.getHelpURL(req, this.getProviderContext());
        }
        catch (MalformedURLException mue) {
            throw new ProviderException("WindowProvider.getHelp():couldn't build helpURL", mue);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("WindowProvider.getHelp():couldn't build helpURL", pce);
        }
        return helpURL;
    }

    public boolean isPresentable(HttpServletRequest req) {
        boolean presentable = true;
        try {
            WindowState windowState = null;
            ContainerProvider parentcp = this.getParentContainerProvider(req);
            if (parentcp != null) {
                windowState = ProviderRules.mapToStandards(parentcp.getWindowState(this.getName()));
            }
            if (windowState == null) {
                windowState = ProviderRules.getDefaultWindowState(ChannelMode.VIEW);
            }
            presentable = this.isMarkupSupported(this.getProviderContext().getContentType(), this.getProviderContext().getLocaleString(), ChannelMode.VIEW, windowState);
        }
        catch (ProviderException pe) {
            if (logger.isLoggable(Level.INFO)) {
                LogRecord record = new LogRecord(Level.INFO, "PSDT_CSPPW0005");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{this.getName()});
                record.setThrown(pe);
                logger.log(record);
            }
            presentable = false;
        }
        if (logger.isLoggable(Level.FINER)) {
            LogRecord record = new LogRecord(Level.FINER, "PSDT_CSPPW0006");
            record.setLoggerName(logger.getName());
            record.setParameters(new Object[]{this.getName(), presentable + ""});
            logger.log(record);
        }
        return presentable;
    }

    public boolean isEditable() throws ProviderException {
        HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
        if (this.getProviderContext().isAuthless(req)) {
            return false;
        }
        return this.isMarkupSupported(this.getProviderContext().getContentType(), this.getProviderContext().getLocaleString(), ChannelMode.EDIT, WindowState.MAXIMIZED);
    }

    private ContainerRequestImpl assembleContainerRequest(HttpServletRequest req, String parent, String entityId, ChannelMode channelMode, WindowState winState, List allowableWinStates, List allowableChannelModes, boolean markup) throws ProviderException {
        Object creq = null;
        creq = markup ? new GetMarkupRequestImpl() : new ExecuteActionRequestImpl();
        HttpServletRequest origReq = RequestThreadLocalizer.getRequest();
        origReq.setAttribute("EVENT_PORTLET_MAP", req.getAttribute("EVENT_PORTLET_MAP"));
        creq.setHttpServletRequest(origReq);
        origReq.setAttribute(PROVIDER_CONTEXT, (Object)this.getProviderContext());
        origReq.setAttribute(PORTAL_CONTEXT_PATH, (Object)req.getContextPath());
        creq.setEntityID(entityId);
        creq.setAllowableWindowState(allowableWinStates);
        creq.setAllowableChannelMode(allowableChannelModes);
        String contentType = this.getProviderContext().getContentType();
        ArrayList<String> allowableContentTypes = new ArrayList<String>();
        allowableContentTypes.add(contentType);
        creq.setAllowableContentType(allowableContentTypes);
        creq.setWindowState(winState);
        creq.setChannelMode(channelMode);
        String userID = null;
        SSOToken token = null;
        if (!this.getProviderContext().isAuthless(req)) {
            userID = this.getProviderContext().getUserID();
            try {
                SSOTokenManager tokenManager = SSOTokenManager.getInstance();
                if (tokenManager == null) {
                    throw new ProviderException("PortletWindowProvider.assembleContainerRequest(): Failed to getSSOTokenmanager.");
                }
                token = tokenManager.createSSOToken(req);
            }
            catch (SSOException ssoe) {
                throw new ProviderException("PortletWindowProvider.assembleContainerRequest():", ssoe);
            }
        }
        creq.setUserID(userID);
        origReq.setAttribute(SSO_TOKEN, token);
        String processURL = this.getProcessURL(req, parent, channelMode);
        creq.setChannelURLFactory(this.getChannelURLFactory(processURL.toString(), req));
        creq.setRoles(this.getRoleList(req));
        creq.setUserInfo(this.getUserInfoMap(req));
        return creq;
    }

    private ContainerResponseImpl assembleContainerResponse(HttpServletResponse res, boolean markup) {
        Object cres = null;
        cres = markup ? new GetMarkupResponseImpl() : new ExecuteActionResponseImpl();
        HttpServletResponse origRes = RequestThreadLocalizer.getResponse();
        cres.setHttpServletResponse(origRes);
        return cres;
    }

    private Map getRenderParams(String entityId, boolean authless) {
        Map renderParams = null;
        ProviderContext pc = this.getProviderContext();
        if (authless) {
            String paramString = pc.getClientProperty(RENDER_PARAM_PREFIX + entityId);
            if (paramString != null) {
                renderParams = Util.getMapFromString(paramString);
            }
        } else {
            renderParams = (Map)pc.getSessionProperty(RENDER_PARAM_PREFIX + entityId);
        }
        if (renderParams == null) {
            renderParams = Collections.EMPTY_MAP;
        }
        return renderParams;
    }

    private void setRenderParams(String entityId, boolean authless, Map renderParams) {
        ProviderContext pc = this.getProviderContext();
        if (authless) {
            String paramString = "";
            if (!renderParams.isEmpty()) {
                paramString = Util.getStringFromMap(renderParams);
            }
            pc.setClientProperty(RENDER_PARAM_PREFIX + entityId, paramString);
        } else {
            pc.setSessionProperty(RENDER_PARAM_PREFIX + entityId, renderParams);
        }
    }

    private boolean getIsTarget(String entityId, boolean authless) {
        ProviderContext pc = this.getProviderContext();
        Boolean target = null;
        target = authless ? new Boolean(pc.getClientProperty(KEYWORD_PREFIX + entityId + TARGET_SUFFIX)) : new Boolean((String)pc.getSessionProperty(KEYWORD_PREFIX + entityId + TARGET_SUFFIX));
        return target;
    }

    private void setIsTarget(String entityId, boolean authless, boolean isTarget) {
        ProviderContext pc = this.getProviderContext();
        if (authless) {
            pc.setClientProperty(KEYWORD_PREFIX + entityId + TARGET_SUFFIX, String.valueOf(isTarget));
        } else {
            pc.setSessionProperty(KEYWORD_PREFIX + entityId + TARGET_SUFFIX, String.valueOf(isTarget));
        }
    }

    protected URL processModeChange(ChannelMode channelMode, HttpServletRequest req, ProviderContext pc) throws ProviderException {
        URL redirectURL = null;
        String parent = this.getParentContainerName(req);
        try {
            if (ChannelMode.EDIT.equals((Object)channelMode)) {
                redirectURL = this.getEditURL(req, parent, pc);
            } else if (ChannelMode.HELP.equals((Object)channelMode)) {
                redirectURL = this.getHelpURL(req, pc);
            }
        }
        catch (MalformedURLException mue) {
            throw new ProviderException("portletWindowProvider.processModeChange(): couldn't generate redirect URL to page for mode " + channelMode.toString(), mue);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("portletWindowProvider.processModeChange(): couldn't generate redirect URL to page for mode " + channelMode.toString(), pce);
        }
        return redirectURL;
    }

    protected WindowState processWindowStateChange(HttpServletRequest request, WindowState newWindowState, ChannelMode channelMode, boolean authless) throws ProviderException, WindowException {
        WindowState windowState = newWindowState;
        boolean validState = ProviderRules.validateWindowStateChange(channelMode, newWindowState);
        if (!validState || newWindowState == null) {
            windowState = ProviderRules.getDefaultWindowState(channelMode);
            if (logger.isLoggable(Level.FINER)) {
                LogRecord record = new LogRecord(Level.FINER, "PSDT_CSPPW0007");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{this.getName(), windowState, channelMode});
                logger.log(record);
            }
        }
        WindowState currentWindowState = this.getCurrentWindowState(request);
        if (authless) {
            if (!currentWindowState.equals((Object)windowState)) {
                throw new WindowException(WindowErrorCode.INVALID_WINDOW_STATE_CHANGE_REQUEST, "Anonymous is not allowed to change the window state");
            }
            return currentWindowState;
        }
        try {
            ContainerProvider parentcp = this.getParentContainerProvider(request);
            int providerWinState = ProviderRules.mapToProvider(windowState);
            if (parentcp != null) {
                parentcp.setWindowState(this.getName(), providerWinState);
            } else if (!windowState.equals((Object)WindowState.MAXIMIZED) && !windowState.equals((Object)WindowState.NORMAL)) {
                throw new ProviderException("portletWindowProvider.processEdit():  couldn't set the window state to " + providerWinState);
            }
        }
        catch (UnsupportedWindowStateException wse) {
            throw new WindowException(WindowErrorCode.INVALID_WINDOW_STATE_CHANGE_REQUEST, wse.getMessage(), wse);
        }
        return windowState;
    }

    private static List initParamKeyList() {
        ArrayList<String> localParamKeyList = new ArrayList<String>();
        localParamKeyList.add(TARGET_PORTLET_CHANNEL_KEY);
        localParamKeyList.add(CURRENT_CHANNEL_MODE_KEY);
        return localParamKeyList;
    }

    public static boolean isWindowProviderKey(String key) {
        return key != null && _localParamKeyList.contains(key);
    }

    public URL getErrorCodeURL(ErrorCode errorCode, HttpServletRequest req) throws ProviderException {
        String parent = this.getParentContainerName(req);
        ChannelMode currentChannelMode = this.getCurrentChannelMode(req);
        try {
            String startURL = ChannelMode.HELP.equals((Object)currentChannelMode) ? this.getHelpURL(req, this.getProviderContext()).toString() + "&" : (ChannelMode.EDIT.equals((Object)currentChannelMode) ? this.getEditURL(req, parent, this.getProviderContext()).toString() + "&" : this.getProviderContext().getDesktopURL(req) + "?");
            return new URL(startURL + "dt." + this.getName() + ERROR_CODE + "=" + errorCode.toString());
        }
        catch (MalformedURLException mue) {
            throw new ProviderException("WindowProvider.getErrorCodeURL():couldn't build errorURL", mue);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("WindowProvider.getErrorCodeURL(): couldn't generate error URL", pce);
        }
    }

    protected StringBuffer getErrorMessageContent(ErrorCode errorCode) throws ProviderException {
        try {
            return new StringBuffer(this.getResourceBundle("WindowProvider").getString(errorCode.toString()));
        }
        catch (MissingResourceException ex) {
            logger.log(Level.FINE, "PSDT_CSPPW0008", ex);
            return new StringBuffer(this.getResourceBundle("WindowProvider").getString(WindowErrorCode.GENERIC_ERROR.toString()));
        }
    }

    protected ErrorCode getErrorCode(ContentException ex) {
        ErrorCode code = ex.getErrorCode();
        if (code == null) {
            return WindowErrorCode.CONTENT_EXCEPTION;
        }
        return code;
    }

    protected ErrorCode readErrorCode(HttpServletRequest req) {
        String errorCodeStr = req.getParameter(this.getName() + ERROR_CODE);
        if (errorCodeStr != null && errorCodeStr.length() > 0) {
            return new ErrorCode(errorCodeStr);
        }
        return null;
    }

    protected ChannelMode getCurrentChannelMode(HttpServletRequest req) {
        String currentChannelMode = req.getParameter(CURRENT_CHANNEL_MODE_KEY);
        String action = req.getParameter("action");
        if (currentChannelMode != null) {
            return new ChannelMode(currentChannelMode);
        }
        if (action != null && action.equals("edit")) {
            return ChannelMode.EDIT;
        }
        return ChannelMode.VIEW;
    }

    protected String getParentContainerName(HttpServletRequest req) throws ProviderException {
        String parentName = null;
        ChannelMode mode = this.getCurrentChannelMode(req);
        if (ChannelMode.VIEW.equals((Object)mode)) {
            parentName = this.getProviderContext().getParentContainerName(this.getName());
        }
        if (parentName == null) {
            parentName = req.getParameter("containerName");
        }
        return parentName;
    }

    protected ContainerProvider getParentContainerProvider(HttpServletRequest req) throws ProviderException {
        ContainerProviderContext cpc = (ContainerProviderContext)this.getProviderContext();
        String parent = this.getParentContainerName(req);
        if (parent != null) {
            return (ContainerProvider)((Object)cpc.getProvider(req, null, parent));
        }
        return null;
    }

    protected WindowState getCurrentWindowState(HttpServletRequest req) throws ProviderException {
        WindowState windowState = null;
        ContainerProvider parentcp = this.getParentContainerProvider(req);
        if (parentcp != null) {
            windowState = ProviderRules.mapToStandards(parentcp.getWindowState(this.getName()));
        }
        if (windowState == null) {
            return ProviderRules.getDefaultWindowState(this.getCurrentChannelMode(req));
        }
        return windowState;
    }

    protected List getAllowableWindowStates(HttpServletRequest req, ChannelMode mode) throws ProviderException {
        Object parentName = null;
        List allowableWindowStates = null;
        ContainerProvider parentcp = this.getParentContainerProvider(req);
        allowableWindowStates = parentcp == null ? ProviderRules.getDefaultAllowableWindowStates(mode) : ProviderRules.mapToStandards(parentcp.getSupportedWindowStates());
        return allowableWindowStates;
    }

    protected String getProcessURL(HttpServletRequest req, String parent, ChannelMode channelMode) {
        StringBuffer processURL = new StringBuffer(this.getProviderContext().getDesktopURL(req));
        processURL.append("?").append("dt.isPortletRequest").append("=true").append("&").append("dt.").append("action=process").append("&").append("dt.").append("provider=").append(PROCESS_CHANNEL).append("&").append(TARGET_PORTLET_CHANNEL_KEY).append("=").append(this.getName()).append("&").append("dt.").append("containerName=").append(parent).append("&").append(CURRENT_CHANNEL_MODE_KEY).append("=").append(channelMode.toString());
        return processURL.toString();
    }

    protected URL getEditURL(HttpServletRequest req, String parent, ProviderContext pc) throws ProviderContextException, MalformedURLException {
        URL redirectURL = new URL(pc.getDesktopURL(req) + "?" + "dt.isPortletRequest" + "=true" + "&" + "dt." + "action=edit" + "&" + "dt." + "provider=" + pc.getStringProperty(parent, "editContainerName") + "&" + "dt." + "targetprovider=" + this.getName() + "&" + "dt." + "containerName=" + parent);
        return redirectURL;
    }

    protected URL getHelpURL(HttpServletRequest req, ProviderContext pc) throws ProviderContextException, MalformedURLException {
        block7: {
            try {
                String externalHelp;
                Map defaultMap;
                Map portletPref = pc.getCollectionProperty(this.getName(), PORTLET_PREFERENCE);
                if (portletPref != null && portletPref.size() > 0 && (defaultMap = (Map)portletPref.get("default")) != null && defaultMap.size() > 0 && (externalHelp = (String)defaultMap.get(PS_EXTERNAL_HELP_URL)) != null && externalHelp.length() > 0) {
                    if ("http://".equalsIgnoreCase((externalHelp = externalHelp.substring(1)).substring(0, 7)) || "https://".equalsIgnoreCase(externalHelp.substring(0, 8))) {
                        return new URL(externalHelp);
                    }
                    if (externalHelp.charAt(0) == '/') {
                        int serverPort = req.getServerPort();
                        String serverHost = req.getServerName();
                        String entityID = this.getEntityID(req);
                        String appName = entityID.substring(0, entityID.indexOf(124));
                        String protocol = req.getScheme();
                        return new URL(protocol + "://" + serverHost + ":" + Integer.toString(serverPort) + "/" + appName + externalHelp);
                    }
                    throw new MalformedURLException("URL must either start with http:// or https:// or /");
                }
            }
            catch (ProviderContextException pce) {
                if (logger.isLoggable(Level.INFO)) {
                    LogRecord record = new LogRecord(Level.INFO, "PSDT_CSPPW0005");
                    record.setLoggerName(logger.getName());
                    record.setParameters(new Object[]{this.getName()});
                    record.setThrown(pce);
                    logger.log(record);
                }
            }
            catch (ProviderException pe) {
                if (!logger.isLoggable(Level.INFO)) break block7;
                LogRecord record = new LogRecord(Level.INFO, "PSDT_CSPPW0005");
                record.setLoggerName(logger.getName());
                record.setParameters(new Object[]{this.getName()});
                record.setThrown(pe);
                logger.log(record);
            }
        }
        URL helpURL = new URL(pc.getDesktopURL(req) + "?" + "dt.isPortletRequest" + "=true" + "&" + "dt." + "action=content" + "&" + "dt." + "provider=" + this.getName() + "&" + CURRENT_CHANNEL_MODE_KEY + "=" + ChannelMode.HELP + "&" + "dt." + "last=false");
        return helpURL;
    }

    private void validateModeChange(ChannelMode currentMode, ChannelMode newMode, boolean authless) throws WindowException {
        List allowedList = ProviderRules.getAllowableChannelModes(currentMode, authless);
        if (!allowedList.contains(newMode)) {
            throw new WindowException(WindowErrorCode.INVALID_MODE_CHANGE_REQUEST, "Portal doesn't allow changing mode  from " + currentMode + " to " + newMode);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

