/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.portletwindow;

import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class PortletWindowProviderUtils {
    public static String getEntityID(HttpServletRequest request, String channelName, ProviderContext pc) throws ProviderException {
        try {
            String entityIdPrefix = pc.getStringProperty(channelName, "entityIDPrefix");
            return entityIdPrefix + "|" + channelName;
        }
        catch (ProviderContextException pe) {
            throw new ProviderException("PortletWindowProviderUtils.getEntityID(): couldn't get entityIDPrefix for chanel " + channelName, pe);
        }
    }

    public static Set getEntityIDs() {
        TreeSet<String> entityIDs = new TreeSet<String>();
        DPRoot dpRoot = DesktopContextThreadLocalizer.get().getDPRoot();
        Set channels = dpRoot.getChannelNames();
        Iterator iter = channels.iterator();
        while (iter.hasNext()) {
            String clPr;
            String chName = (String)iter.next();
            DPChannel dpc = dpRoot.getChannel(chName);
            DPProvider dpro = dpc.getProvider();
            if (dpro == null || !(clPr = dpro.getClassName()).equals("com.sun.portal.providers.portletwindow.PortletWindowProvider")) continue;
            String entityIDPrefix = (String)dpc.getProperties().getString("entityIDPrefix").getValue();
            entityIDs.add(entityIDPrefix + "|" + chName);
        }
        return entityIDs;
    }

    public static Map getRoleMap(HttpServletRequest req, String channelName, ProviderContext pc) throws ProviderContextException, ProviderException {
        if (pc.existsCollectionProperty(channelName, "roleMap")) {
            return pc.getCollectionProperty(channelName, "roleMap");
        }
        return null;
    }

    public static Map getUserInfoMap(HttpServletRequest req, String channelName, ProviderContext pc) throws ProviderContextException, ProviderException {
        if (pc.existsCollectionProperty(channelName, "userInfoMap")) {
            return pc.getCollectionProperty(channelName, "userInfoMap");
        }
        return null;
    }

    public static String getTitle(ProviderContext pc, String channel) throws ProviderException {
        String title = null;
        try {
            title = pc.getStringProperty(channel, "title");
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("PortletWindowProviderUtils.getTitle(): couldn't get title for chanel " + channel, pce);
        }
        return title;
    }
}

